package App::Manoc::Controller::MngUrlFormat;
#ABSTRACT: MngUrlFormat controller

use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

use App::Manoc::Form::MngUrlFormat;

BEGIN { extends 'Catalyst::Controller'; }
with "App::Manoc::ControllerRole::CommonCRUD" => { -excludes => [ 'view', 'view_js' ] };

__PACKAGE__->config(
    # define PathPart
    action => {
        setup => {
            PathPart => 'mngurlformat',
        }
    },
    class            => 'ManocDB::MngUrlFormat',
    form_class       => 'App::Manoc::Form::MngUrlFormat',
    view_object_perm => undef,
);


sub delete_object {
    my ( $self, $c ) = @_;

    my $id = $c->stash->{object_pk};
    if ( $c->model('ManocDB::Device')->search( { mng_url_format => $id } )->count ) {
        $c->flash( error_msg => 'Format is in use. Cannot be deleted.' );
        return;
    }

    return $c->stash->{'object'}->delete;
}


sub get_delete_failure_url {
    my ( $self, $c ) = @_;

    my $action = $c->namespace . "/list";
    return $c->uri_for_action($action);
}


sub get_form_success_url {
    my ( $self, $c ) = @_;

    my $action = $c->namespace . "/list";
    return $c->uri_for_action($action);
}

1;

__END__

=pod

=head1 NAME

App::Manoc::Controller::MngUrlFormat - MngUrlFormat controller

=head1 VERSION

version 2.99.4

=head1 ACTIONS

=head2 get_form_success_url

=head1 METHODS

=head2 delete_object

=head2 get_delete_failure_url

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
