package App::Manoc::Controller::SoftwarePkg;
#ABSTRACT: SoftwarePkg controller

use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

use App::Manoc::Form::Building;

BEGIN { extends 'Catalyst::Controller'; }

with
    'App::Manoc::ControllerRole::ResultSet',
    'App::Manoc::ControllerRole::Object',
    'App::Manoc::ControllerRole::JQDatatable';

__PACKAGE__->config(
    # define PathPart
    action => {
        setup => {
            PathPart => 'softwarepkg',
        }
    },
    class            => 'ManocDB::SoftwarePkg',
    view_object_perm => undef,

    datatable_columns        => [ 'name', 'n_servers' ],
    datatable_row_callback   => 'datatable_row',
    datatable_search_columns => ['name'],
    datatable_search_options => {
        '+select' => [
            {
                count => 'server_swpkg.server_id',
                -as   => 'n_servers',
            }
        ],
        group_by => ['id'],
        join     => 'server_swpkg',
    },
    # datatable_search_callback => 'datatable_search_cb',
);


sub datatable_row {
    my ( $self, $c, $row ) = @_;

    my $action = 'softwarepkg/view';

    return {
        name      => $row->name,
        n_servers => $row->get_column('n_servers'),
        link      => $c->uri_for_action( $action, [ $row->id ] ),
    };
}


sub view : Chained('object') : PathPart('') : Args(0) {
    my ( $self, $c ) = @_;

    $c->require_permission( $c->stash->{resultset}, 'view' );

    my $object = $c->stash->{object};

}


sub list : Chained('base') : PathPart('') : Args(0) {
    my ( $self, $c ) = @_;

    $c->require_permission( $c->stash->{resultset}, 'list' );
}

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Controller::SoftwarePkg - SoftwarePkg controller

=head1 VERSION

version 2.99.4

=head1 ACTIONS

=head2 view

Display a single items.

=head2 list

Display a list of items. Chained to base since the table is AJAX based

=head1 METHODS

=head2 datatable_row

Callback to create datatable row. Generates link and extracts n_servers.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
