/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.Throw;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public class ExceptionMethod
implements Implementation,
ByteCodeAppender {
    private final TypeDescription throwableType;
    private final ConstructionDelegate constructionDelegate;

    public ExceptionMethod(TypeDescription throwableType, ConstructionDelegate constructionDelegate) {
        this.throwableType = throwableType;
        this.constructionDelegate = constructionDelegate;
    }

    public static Implementation throwing(Class<? extends Throwable> exceptionType) {
        return ExceptionMethod.throwing(new TypeDescription.ForLoadedType(exceptionType));
    }

    public static Implementation throwing(TypeDescription exceptionType) {
        if (!exceptionType.isAssignableTo(Throwable.class)) {
            throw new IllegalArgumentException(exceptionType + " does not extend throwable");
        }
        return new ExceptionMethod(exceptionType, new ConstructionDelegate.ForDefaultConstructor(exceptionType));
    }

    public static Implementation throwing(Class<? extends Throwable> exceptionType, String message) {
        return ExceptionMethod.throwing(new TypeDescription.ForLoadedType(exceptionType), message);
    }

    public static Implementation throwing(TypeDescription exceptionType, String message) {
        if (!exceptionType.isAssignableTo(Throwable.class)) {
            throw new IllegalArgumentException(exceptionType + " does not extend throwable");
        }
        return new ExceptionMethod(exceptionType, new ConstructionDelegate.ForStringConstructor(exceptionType, message));
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return this;
    }

    @Override
    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
        StackManipulation.Size stackSize = new StackManipulation.Compound(this.constructionDelegate.make(), Throw.INSTANCE).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionMethod)) {
            return false;
        }
        ExceptionMethod other = (ExceptionMethod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TypeDescription this$throwableType = this.throwableType;
        TypeDescription other$throwableType = other.throwableType;
        if (this$throwableType == null ? other$throwableType != null : !this$throwableType.equals(other$throwableType)) {
            return false;
        }
        ConstructionDelegate this$constructionDelegate = this.constructionDelegate;
        ConstructionDelegate other$constructionDelegate = other.constructionDelegate;
        return !(this$constructionDelegate == null ? other$constructionDelegate != null : !this$constructionDelegate.equals(other$constructionDelegate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExceptionMethod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeDescription $throwableType = this.throwableType;
        result = result * 59 + ($throwableType == null ? 43 : $throwableType.hashCode());
        ConstructionDelegate $constructionDelegate = this.constructionDelegate;
        result = result * 59 + ($constructionDelegate == null ? 43 : $constructionDelegate.hashCode());
        return result;
    }

    public static interface ConstructionDelegate {
        public StackManipulation make();

        public static class ForStringConstructor
        implements ConstructionDelegate {
            private final TypeDescription exceptionType;
            private final MethodDescription targetConstructor;
            private final String message;

            public ForStringConstructor(TypeDescription exceptionType, String message) {
                this.exceptionType = exceptionType;
                this.targetConstructor = (MethodDescription)((MethodList)exceptionType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(String.class)))).getOnly();
                this.message = message;
            }

            @Override
            public StackManipulation make() {
                return new StackManipulation.Compound(TypeCreation.of(this.exceptionType), Duplication.SINGLE, new TextConstant(this.message), MethodInvocation.invoke(this.targetConstructor));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForStringConstructor)) {
                    return false;
                }
                ForStringConstructor other = (ForStringConstructor)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$exceptionType = this.exceptionType;
                TypeDescription other$exceptionType = other.exceptionType;
                if (this$exceptionType == null ? other$exceptionType != null : !this$exceptionType.equals(other$exceptionType)) {
                    return false;
                }
                MethodDescription this$targetConstructor = this.targetConstructor;
                MethodDescription other$targetConstructor = other.targetConstructor;
                if (this$targetConstructor == null ? other$targetConstructor != null : !this$targetConstructor.equals(other$targetConstructor)) {
                    return false;
                }
                String this$message = this.message;
                String other$message = other.message;
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForStringConstructor;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $exceptionType = this.exceptionType;
                result = result * 59 + ($exceptionType == null ? 43 : $exceptionType.hashCode());
                MethodDescription $targetConstructor = this.targetConstructor;
                result = result * 59 + ($targetConstructor == null ? 43 : $targetConstructor.hashCode());
                String $message = this.message;
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }
        }

        public static class ForDefaultConstructor
        implements ConstructionDelegate {
            private final TypeDescription exceptionType;
            private final MethodDescription targetConstructor;

            public ForDefaultConstructor(TypeDescription exceptionType) {
                this.exceptionType = exceptionType;
                this.targetConstructor = (MethodDescription)((MethodList)exceptionType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly();
            }

            @Override
            public StackManipulation make() {
                return new StackManipulation.Compound(TypeCreation.of(this.exceptionType), Duplication.SINGLE, MethodInvocation.invoke(this.targetConstructor));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForDefaultConstructor)) {
                    return false;
                }
                ForDefaultConstructor other = (ForDefaultConstructor)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$exceptionType = this.exceptionType;
                TypeDescription other$exceptionType = other.exceptionType;
                if (this$exceptionType == null ? other$exceptionType != null : !this$exceptionType.equals(other$exceptionType)) {
                    return false;
                }
                MethodDescription this$targetConstructor = this.targetConstructor;
                MethodDescription other$targetConstructor = other.targetConstructor;
                return !(this$targetConstructor == null ? other$targetConstructor != null : !this$targetConstructor.equals(other$targetConstructor));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForDefaultConstructor;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $exceptionType = this.exceptionType;
                result = result * 59 + ($exceptionType == null ? 43 : $exceptionType.hashCode());
                MethodDescription $targetConstructor = this.targetConstructor;
                result = result * 59 + ($targetConstructor == null ? 43 : $targetConstructor.hashCode());
                return result;
            }
        }
    }
}

