/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.Origin;

public abstract class MultiplexHttpDestination
extends HttpDestination {
    protected MultiplexHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
    }

    @Override
    protected ConnectionPool newConnectionPool(HttpClient client) {
        return new MultiplexConnectionPool(this, client.getMaxConnectionsPerDestination(), this, client.getMaxRequestsQueuedPerDestination());
    }

    public int getMaxRequestsPerConnection() {
        ConnectionPool connectionPool = this.getConnectionPool();
        if (connectionPool instanceof MultiplexConnectionPool) {
            return ((MultiplexConnectionPool)connectionPool).getMaxMultiplex();
        }
        return 1;
    }

    public void setMaxRequestsPerConnection(int maxRequestsPerConnection) {
        ConnectionPool connectionPool = this.getConnectionPool();
        if (connectionPool instanceof MultiplexConnectionPool) {
            ((MultiplexConnectionPool)connectionPool).setMaxMultiplex(maxRequestsPerConnection);
        }
    }
}

