#!/usr/bin/perl -w
use strict;

# Tested on Latin: OK except: in LAYOUT: SPACE: ends on the 6th column (patched before); no aliases to (NON)CONVERT (patched before)
#    (probably OK): no SHIFTSTATES for mixes synthetic/real: flags Ctrl|Alt|Kana (=C-lA), Ctrl|Alt|Loya (=lC-A) - and Shift. 

#     TODO:
# The current code producing SGCAPS lines cannot work with dead keys.  (NOTE: dead keys are not permitted in the first two columns
#  of a non-CAPSLOCK'ed row.  If dead keys are present (in the first two columns of) a CAPSLOCK'ed row, one needs to emit the 3rd
#  line.)  In fact, one can have a dead key on the non-CAPSLOCK'ed row - but the CAPSLOCK'ed valiant should be non-a-dead-key (which
#  should be duplicated as an identical dead key.
# The current code producing SGCAPS lines does not warn that dead keys in columns of bitmaps 0 and 1 need duplication of DEADKEY
#    sections in .klc file.
# Does not generate extra C file (which should depend on $w), headers, resource file and definition file.  Does not auto-compile.
# Current version does not allow reassignment of scancodes of VK keys (but supports the whole repertoir of VK of standard layouts)
#   Only DIVIDE is handled as an extra E0-scan-VK_.
# Maybe reorder keys more for Cech-like keyboards with duplication of output VK?  Or have an option of no-reorder (except NUMPAD)?
# Currently ATTRIBUTES  (prepend KLLF_; ALTGR is on in kbdutool if there are more than 4 "states") and MODIFIERS is not supported
#   LRM_RLM    SHIFTLOCK   ALTGR
# Need to fill the defaults Ctrl-bindings on BACK, CANCEL, ESCAPE, RETURN, SPACE
# We only allow ;-comments after names of long-sections.
# (Implement more than one entry for a SHIFTSTATE row???  Duplication of VC_codes (Needed?  Do during generation of .klc?)???)
# Need also to support duplication of VK to several other VKs (can be done in .klc???) (and separate CAPSLOCK modification-bits-bindings)
# For SGCAPS we assume that the first two columns have bitmaps 0, 1.
# For LIGATURE we hardwire max-length=3 (since we do not yet generate ancillary .c and .h files).

# is not processed (the difference between msklc_altgr_r2l.c and msklc_altgr.c).
# Likewise, many sections are used for generation of the .RC/.DEF files (and .H).

# Currently we hardwire the SHIFTSTATE massaging data %massage_shiftstate.

# FIXED: Does not allow VKs of the form 0x11 (fix s2c()!!!).

##  kbdutool does not link aVkToWch3 with an empty LAYOUT is empty  (confusing description??? of really appearing situation)

### Enhancements w.r.t. functionality of kbdutool (we do not list fixed bugs of kbdutool here):

# We do not restrict functionality of SGCAPS w.r.t. dead keys.

my $v = 0.74;

# Hardwired aliasing of shiftstates: due to: applications may synthesize non-chiral keypresses (such as VK_SHIFT) and KBDALT stripping
my(@mods) = qw(S C A K R L T Z);		# @BM: Shortcuts for bits
my %BM = map {($mods[$_], 1<<$_)} 0..$#mods;	# "simple 'synthetic' bit" => "bitmaps generated by actual left/right modifier keys"
my %massage_shiftstate = ( $BM{S} => [$BM{S}], $BM{C} => [$BM{C}|$BM{L}, $BM{C}|$BM{A}|$BM{R}], $BM{A} => [$BM{A}|$BM{K}]);  # , $BM{C}|$BM{A}|$BM{L}|$BM{Z}
my(@MSS, %trSS, $kn, $knA) = keys %massage_shiftstate;	# Need to combine only the modifiers apps know about: S C A
for my $subset (0..(1<<@MSS)-1) {		# Loop over subsets of %massage_shiftstate
  my($from, @TO, @bits, $factor) = (0, 0);	# Calculate OR-combinations of bitmaps, one per element of the factors indexed by this subset
  $subset & (1<<$_) and $from |= $MSS[$_], push @bits, $massage_shiftstate{$MSS[$_]} for 0..$#MSS;	# map $combos to the bitmap $from of non-chiral keys
  $factor = shift @bits, @TO = map {my $t= $_; map $t|$_, @$factor } @TO while @bits;	# OR sets @TO and @$factor, put result to @TO
  $kn++  if not $kn  and grep +($_&~$BM{S}) == $BM{K}, @TO;
  $knA++ if not $knA and grep +($_&~$BM{S}) == $BM{K}|$BM{A}, @TO;
  next unless @TO = grep $_ != $from, @TO;
  warn "from $subset ($from) to @TO\n";
  push @{$trSS{$from}}, @TO;			# Allow the table to match a column to a real shiftstate
  push @{$trSS{$_}}, $from for @TO;		# Allow the table to match a column to an (abstract) base shiftstate
}
if ($knA and not $kn) {				# compensate stripping A from K|A
  push @{$trSS{$_|$BM{K}}}, $_ for 0, $BM{S};	# Bind KBDKANA and KBDKANA | KBDSHIFT columns
}

sub get_file ($) {
  my $fn = shift;
  open my $F, '<', $fn or die "open <$fn> for read: $!, $^E";
  do {local $/; <$F>};
}

sub clean_extra ($) {
  my($in) = (shift);
  $in =~ s([^\S\n]*//.*)()g;		# remove comments
  $in =~ s([^\S\n]+$)()gm;		# remove trailing whitespace (including \r!)
  $in
}

sub clean_end ($) {
  my($in) = (shift);
  $in =~ s/^\s*ENDKBD\s*(?:$).*//sm;
  $in
}

sub extract_section_1line ($$) {
  my($in, $sec) = (shift, shift);
  $in =~ /^\s*$sec\b\s*(.*)$/m or die "Cannot find $sec inside the KLC file";
  $1
}

sub extract_section ($$;$) {	# may return what remains
  my($in, $sec, $strip, $rest) = (shift, shift, shift);
  $in =~ s/(\A.*?)^\s*$sec([ \t]*;[^\n]*)?\n//sm or die "Cannot find $sec inside the KLC file";
  $rest = $1;
  $in =~ s/(^[^\S\n]*(KEYNAME|LIGATURE|COPYRIGHT|COMPANY|LOCALENAME|LOCALEID|VERSION|SHIFTSTATE|LAYOUT|ATTRIBUTES|MODIFIERS|KEYNAME_EXT|KEYNAME_DEAD|DESCRIPTIONS|LANGUAGENAMES|DEADKEY|ENDKBD)\b.*)//ms
     or die "Cannot find end of $sec inside the KLC file";
  $rest .= $1;
  $in =~ s/^\n//gm if $strip;			# remove empty lines
  $in =~ s/^\s+//;
  return $in unless wantarray;
  ($in, $rest)
}

my $fn = shift or die;
# my $ofn_base = shift or die;

########### Parse the file roughly

my $IN = get_file $fn;
my $in = clean_extra $IN;
my %IN;
my @names_long = qw(LAYOUT SHIFTSTATE LIGATURE KEYNAME KEYNAME_EXT KEYNAME_DEAD DESCRIPTIONS LANGUAGENAMES MODIFIERS);
for my $sn (@names_long) {
 eval { ($IN{$sn}, $in) = extract_section $in, $sn, 'strip' };
}
$in = clean_end $in;

my @names_short = qw(KBD COPYRIGHT COMPANY LOCALENAME LOCALEID VERSION);
for my $sn (@names_short) {
 eval { $IN{$sn} = extract_section_1line $in, $sn };
}
my @missing = grep !exists $IN{$_}, @names_short, @names_long;
warn "Sections @missing not found in file '$fn'" if @missing;

my $rx = join '|', @names_short, @names_long;
my @unrecognized = grep {!/^\s*$/ and !/^\s*($rx)\b/} split /\n/, $in;

##################################### Parse Deadkeys

my($rest, %DK, @DK) = '';
for my $dk (split /(?!\A)^(?=\s*DEADKEY\b)/m , join "\n", @unrecognized) {
  $rest .= $dk, next unless $dk =~ s/^\s*DEADKEY\b\s+(\S+)\s*\n//;
  push @DK, uc $1 unless $DK{uc $1};
  $DK{uc $1} = [map {s/^\s+//; [split /\s+/, $_]} split /\n/, $dk];
}

warn join "\n", "Unrecognized lines in file '$fn':", $rest if length $rest;

##################################### Refine and translate the parsed data

############################# Name
my %REPL;
($REPL{mod_name}) = ($IN{KBD} =~ /^(\S+)/);
$REPL{myversion} = "$0 v$v - Created  " . localtime;

############################# Shiftstate

my($tot, $moddefs, $defModCombs, @column2state) = (0, '', '', split /\s+/, $IN{SHIFTSTATE});
warn join(' ', map "$_,$column2state[$_]", 0..$#column2state), "\n";
my(%state2column, %addSS) = map {($column2state[$_],$_)} grep $_ != 15, 0..$#column2state;	# 15 is INVALID
for my $st (keys %trSS) {	# states aliased to one of the defined states (via chiral/non-chiral match and KBDALT stripping)
  my @all = grep defined, $state2column{$st}, map $state2column{$_}, @{$trSS{$st}};	# starts with the prescribed value if present
  warn "from $st to @all | @{$trSS{$st}}\n" if @all and $all[0] != ($state2column{$st} || -1);
  $addSS{$st} = $all[0] if @all;
}
%state2column = (%state2column, %addSS);	# the prescribed value wins
$tot |= (0+$_) for @column2state;
($tot >> $_->[0])&0x1 and $moddefs .= "#define KBD_$_->[1]\n"	# #define KBD_Z  0x40; our KBD_T duplicates KBDGRPCHGTAT 
  for [6, "Z\t0x40"], [7, "T\t0x80"];				#   (which is a remnant of abandoned attempt in MS)

my @names = qw(Shift	Ctrl	Alt	Kana	Roya	Loya	Z	T);
sub bitmap2comment($) {my($in, $o) = (shift, ''); $o .= "\t" . ( $in & (1<<$_) ? $names[$_] : '') for 0..7; $o}

my $maxbitmap = $tot & 0x80 ? 255 : ($tot & 0x40 ? 128 : 63);
$defModCombs .= "\t" . (defined $state2column{$_} ? "$state2column{$_},\t\t" : "SHFT_INVALID,\t")
  . '// ' . bitmap2comment($_) . "\n" for 0..$maxbitmap;
$REPL{pre_column_descr} = $moddefs;
$REPL{num_column_descr} = $maxbitmap;
$REPL{column_descr} = $defModCombs;

############################# Layout default
my $L_default = <<'EOD';
  0F  TAB       0      '\t'     '\t'
  4E  ADD       0      '+'      '+'
 e035 DIVIDE    0      '/'      '/'
  37  MULTIPLY  0      '*'      '*'
  4A  SUBTRACT  0      '-'      '-'
  0E  BACK      0      '\b'     '\b'     0x007f
  01  ESCAPE    0      0x001b   0x001b   0x001b
  1C  RETURN    0      '\r'     '\r'     '\n'
  39  SPACE     0      0020     0020     0020
 e046 CANCEL    0      0x0003   0x0003   0x0003
  0 NUMPAD0   0        '0'
  0 NUMPAD1   0        '1'
  0 NUMPAD2   0        '2'
  0 NUMPAD3   0        '3'
  0 NUMPAD4   0        '4'
  0 NUMPAD5   0        '5'
  0 NUMPAD6   0        '6'
  0 NUMPAD7   0        '7'
  0 NUMPAD8   0        '8'
  0 NUMPAD9   0        '9'
EOD

############################# Parse Layout (with defaults)

my $rxX = qr(^(?:NUMPAD\d|ADD|DIVIDE|MULTIPLY|SUBTRACT|SEPARATOR|DECIMAL|OEM_(8|102)|ABNT_C[12])$); # VK_RETURN on both Return's
my $capsFl = [qw(CAPLOK SGCAPS CAPLOKALTGR KANALOK)];	# up to 0xF; kbdutool reads in decimal (does not matter without KANALOK!)
my($len,$lenX,%len_seen) = ([2,3], [], 2,1,3,1);	# sections of length 2, 3 are put first by kbdutool

sub scan_layout($$$;$$) {
  my($in, $VK2binds, $VK2bindsX, $oldVK, $oldScan, %VK2bind, %scan2VK, $prev, @x) = (shift, shift, shift, shift || {}, shift || {});
  for my $l (split /\n/, $in) {
    $l =~ s/^\s+//;
    my($scan, $VK, $caps, @binds) = split /\s+/, $l;
    $scan2VK{uc $scan} ||= uc $VK if $scan and not $scan =~ /-1/ and not $VK =~ /-1/ and not exists $oldScan->{uc $scan};
    $caps = 0x2 if uc $caps eq 'SGCAP';	# No S at end!!!
    if ($caps & 0x2) {			# SGCAPS has an extra line, usually of different length; cannot separate them
      $prev = [$scan, $VK, $caps, @binds];
      next;
    } elsif ($prev) {
      @x = @binds;
      ($scan, $VK, $caps, @binds) = @$prev;
      undef $prev;
    }
    next if exists $oldVK->{uc $VK};
#    warn "Repeated VK=$VK on different scan codes (saw $VK2scan{$VK}), unsupported" if $VK2scan{$VK};
#    $VK2scan{$VK} = $scan;
    $VK2bind{uc $VK} = [$caps, [@binds], [@x]];
    my($postf, $b) = (scalar @binds, $VK =~ $rxX ? $VK2bindsX : $VK2binds);
    $postf = "X$postf" if $VK =~ $rxX;
    push @{$VK =~ $rxX ? $lenX : $len}, $postf unless $len_seen{$postf}++;
    push @{$b->[scalar @binds]}, [uc $VK, $caps, [@binds], [@x]]; # the defaults will be put at end, where they have less chance to ruit the reverse lookup
    @x = ();
  }
  (\%VK2bind, \%scan2VK);
}

my(@VK2binds, @VK2bindsX);
my($VK2bind, $scan2VK) = scan_layout $IN{LAYOUT}, \@VK2binds, \@VK2bindsX;
my %VK2bind = %$VK2bind;
my %scan2VK = %$scan2VK;

($VK2bind, $scan2VK) = scan_layout $L_default, \@VK2binds, \@VK2bindsX, $VK2bind, $scan2VK;
%VK2bind = (%VK2bind, %$VK2bind);
%scan2VK = (%scan2VK, %$scan2VK);

############################# Output SC_ part of the Layout (XXXX unfinished; very early only ???)

my @lay_lens  = grep defined $VK2binds[$_],  0..$#VK2binds;
my @lay_lensX = grep defined $VK2bindsX[$_], 0..$#VK2bindsX;
warn "Existing lengths of bindings: [@lay_lens], [@lay_lensX]";
my @extralendefs = map "TYPEDEF_VK_TO_WCHARS($_)\n", grep $_>10, @lay_lens;   # std definition file defines up to 10
$REPL{extralendefs} = join '', @extralendefs;

my(%scan, @xtrascans, $ext) = reverse %scan2VK;
if ($VK2bind{DIVIDE} and ($ext = (~0xff & hex $scan{DIVIDE}))) {
  warn "Unknown extended modifier for the scancode for VK_DIVIDE: $scan{DIVIDE} -> $ext, expect " . 0xe000
    unless 0xe000 == $ext;
  push @xtrascans, "        { 0x35, X35 | KBDEXT              },  // Numpad Divide\n"
}
$REPL{xtrascans} = join '', @xtrascans;

############################# Output VK part of the Layout

my $prevVK;
my %compatTR = qw( 0008 '\b' 000a '\n' 000d '\r' 005c '\\\\' 0027 '\'' 0022 '\"' );
my $compatRx = qr/^00(0[8ad]|2[27]|5c)$/i;	# these frivolous conversions simplify comparison with kbdutool; may be removed!
sub s2c($;$) {my($i,$o) = shift; return $prevVK if $i eq '-1';
              $o = ($i =~ /^[''""\\]$/ ? "'\\$i'" : ($i =~ /^.$/ ? "'$i'" : ($i =~ /^0x[\da-z]+$/i ? $i : "VK_$i"))); $prevVK = $o if shift; $o}
sub hex2c($$) {my($i,$h) = (shift,shift); my $n = hex $i; return "0x\L$i" if !$h or $n<0x20 or $n > 0x7e; "L" . s2c chr $n }
sub ch2c($;$)  {my($i,$h) = (shift,shift); return $compatTR{lc $i} if $h and $i =~ $compatRx;
                $i =~ /^[\da-f]{2,}$/i ? hex2c($i,$h) : ($i =~ /^.$/ ? s2c($i) : ($i =~ /^-1$/ ? 'WCH_NONE'
			: ($i =~ /\@$/ ? 'WCH_DEAD' : ($i eq '%%' ? 'WCH_LGTR' : $i))))}

sub mx($$) {my($i,$j)=(shift, shift); $i<$j? $j : $i}
sub fmt_st($$$) {my($i,$j,$l) = (shift, shift, shift); "$i" . (' ' x mx(1, $l - 3 - length "$i$j")) . ",$j ,"}

my($sublayouts, @sublayouts) = '';
sub emit_layout_line ($$$$) {	# XXXX Need to take into account required length too ???
  my($vk, $caps, $bind, $x, @xx) = (shift, shift, shift, shift || []);
  (my $ss, $caps) = (hex($caps) & 0xF, hex($caps) & ~0xF);
  $caps ||= '';
  $caps .= '|' if $caps;
  $caps .= join ' | ', map {$ss&(1<<$_) ? $capsFl->[$_] : ()} 0..$#$capsFl; # [1,'CAPLOK'], [2,'SGCAPS'], [4,'CAPLOKALTGR'], [8,'KANALOK'];
  my @bind = map ch2c($_,'unhex'), @$bind;
  $sublayouts .= fmt_st("  {" . s2c($vk, 'prev'), $caps||"0", 28) . join(" ,", map {sprintf "%-8s", $_} @bind) . " },\n";
  return unless grep /^WCH_DEAD$/, @bind or @$x;
  if (@$x) {
    $#$x = 1 if $#$x > 1;
    shift @$bind for 0..$#$x;	 # XXXX actually, not shift, but splice, and not 0,1, but columns of bitmaps 0,1???
    @xx = map ch2c($_,'unhex'), @$x;
  }
  $sublayouts .= fmt_st('  {' . (@$x? s2c($vk, 'prev') : '0xff'), 0, 28)
     . join(" ,", @xx, map {sprintf "%-8s", (/^(.*)\@$/ ? "0x$1" : 'WCH_NONE')} @$bind) . " },\n";
  return unless "@$x" =~ /\@/;	# Emit short initializer, as kbdutool does with the preceding row:
  $sublayouts .= fmt_st('  {0xff', 0, 28) . join(" ,", map {sprintf "%-8s", (/^(.*)\@$/ ? "0x$1" : 'WCH_NONE')} @$x) . " },\n";
}

for my $X ('', 'X') {
  my $L =  ($X ? $lenX : $len);
  my @tbl =  ($X ? @VK2bindsX : @VK2binds);
  $sublayouts .= <<'EOS' if $X;
// The following keys are put last so that VkKeyScan interprets
// (e.g.) number characters
// as coming from the main section of the kbd (aVkToWch2 and
// aVkToWch5) before considering the numpad (aVkToWch1).

EOS
  for my $_len (@$L) {
    (my $len = $_len) =~ s/^X//;
    my $lst = $tbl[$len] or next;
    push @sublayouts, [$len, "aVkToWch$_len"];
    $sublayouts .= <<EOP;
static ALLOC_SECTION_LDATA VK_TO_WCHARS$len aVkToWch$_len\[] = {
//                         |         |  Shift  |  Ctrl   |S+Ctrl   |  C+  X1 |  C+  X1 |
//                         |=========|=========|=========|=========|=========|=========|
EOP
  emit_layout_line $_->[0], $_->[1], $_->[2], $_->[3] for @$lst;
  $sublayouts .= "  {\t" . join(",\t", (0) x ($len+2)) . "}\n" . <<'EOP';
};

EOP
  }
}
$REPL{sublayouts} = $sublayouts;

my $LL = '';
for my $sub (@sublayouts) {
#  warn "[<<<$sub>>>]";
#  warn "<<@$sub>>";
  $LL .= <<EOS;
    {  (PVK_TO_WCHARS1)$sub->[1],	$sub->[0],	sizeof($sub->[1]\[0]) },
EOS
}
$REPL{join_sublayouts} = $LL;

############################# Scan Ligatures
my($lig, $w, @lig) = ('', -1);
if (exists $IN{LIGATURE}) {{
  for my $l (split /\n/m , $IN{LIGATURE}) {
    $l =~ s/^\s+//;
    my ($vk, $col, @c) = split /\s+/, $l;
    $w = @c if $w < @c;
    push @lig, [$vk, $col, @c]
  }

############################# Output Ligatures

  last unless @lig;
  $lig .= "TYPEDEF_LIGATURE($w) // LIGATURE5, *PLIGATURE5;\n\n" if $w > 5;	# only up to 5 predefined; the limit is 126???
  $lig .= <<EOS;
ALLOC_SECTION_LDATA LIGATURE$w aLigature$w\[] = {
EOS
  for my $e (@lig) {
    my ($vk, $col, @e) = (@$e, ('WCH_NONE') x ($w + 2 - @$e));
    $lig .=  '  {' . fmt_st(s2c($vk), $col, 23) . ' ' . join(",\t", map ch2c($_), @e) . "},\n";
  }
  $lig .= '  {' . join(",\t", (0) x ($w+2)) . "}\n};\n\n";
}}
$REPL{ligatures} = $lig;

############################# Output deadkeys

my $deadk = '';
for my $pref (@DK) {
  $deadk .= "\n" if $deadk;
  for my $b (@{$DK{$pref}}) {
    warn("Ignore misformed dead key descriptor for dk=$pref: @$b"), next unless @$b == 2;
    my($k, $res, $dead) = @$b;
    $dead = ($res =~ s/\@$//) + 0;
    $deadk .= '    DEADTRANS( ' . join(" ,\t", ch2c($k,'dehex'), ch2c($pref), ch2c($res,'dehex'), "0x000$dead") . "),\n";
  }
}
$REPL{deadkeys} = $deadk;

#################################### Keynames

for my $how (qw(KEYNAME KEYNAME_EXT KEYNAME_DEAD)) {
  my($kn, $dd) = ('', $how =~ /DEAD/);
  my($sep) = ($dd ? '' : ',');	# No comma for KEYNAME_DEAD!
  if (exists $IN{$how}) {{
    for my $l (split /\n/m , $IN{$how}) {
      $l =~ s/^\s+//;
      my ($vk, $rest) = split /\s+/, $l, 2;
      $rest = qq("$rest") unless $rest =~ /^[""]/;
      $rest =~ s/^"(.+)"$/$1/;
      $rest =~ s/([\\""''])/\\$1/g;
      $rest =~ s/[^\x01-\x7f]//g;	# Same as MSKLC
      $vk = ch2c($vk);
      if (!$dd) {
        $vk = "L$vk" if $vk =~ /^['']/;
      } elsif ($vk =~ s/^0x/\\x/) {
        $vk = qq(L"$vk") 
      } else {
        die "Unsupported format of the key: $vk from <<$l>>";
      }
die 131 unless defined $sep;
      $kn .= qq(  $vk$sep\tL"$rest",\n);
    }
  }
  $REPL{$how} = $kn;
}}

#################################### Do actual emit with substitutions
my $rxrepl = join '|', keys %REPL;

my $data = do {local $/, <DATA>};
$data =~ s/^__END__\s*(?:$).*//sm;

$data =~ s/\@{3}($rxrepl)\@{3}/$REPL{$1}/g;
/\@{3}(\w+)\@{3}/ and warn "unrecognized replacement $1 in <<<$_>>>" for split /\n/m , $data;

print $data;

__DATA__
/***************************************************************************\
* Module Name: @@@mod_name@@@.C
*
* keyboard layout
*
* Copyright (c) 1985-2001, Microsoft Corporation, 2024 Ilya Zakharevich
*
* History:
* @@@myversion@@@
\***************************************************************************/

#include <windows.h>
#include "kbd.h"
#include "@@@mod_name@@@.h"

#if defined(_M_IA64)
#pragma section(".data")
#define ALLOC_SECTION_LDATA __declspec(allocate(".data"))
#else
#pragma data_seg(".data")
#define ALLOC_SECTION_LDATA
#endif

// Some scanners of keyboard fail if the main table is not near the start of the loaded DLL.
// To move it forward, we need to make the data extern:
#include "msklc_lig4.h"

/***************************************************************************\
* ausVK[] - Virtual Scan Code to Virtual Key conversion table
\***************************************************************************/

ALLOC_SECTION_LDATA USHORT ausVK[] = {
    T00, T01, T02, T03, T04, T05, T06, T07,
    T08, T09, T0A, T0B, T0C, T0D, T0E, T0F,
    T10, T11, T12, T13, T14, T15, T16, T17,
    T18, T19, T1A, T1B, T1C, T1D, T1E, T1F,
    T20, T21, T22, T23, T24, T25, T26, T27,
    T28, T29, T2A, T2B, T2C, T2D, T2E, T2F,
    T30, T31, T32, T33, T34, T35,

    /*
     * Right-hand Shift key must have KBDEXT bit set.
     */
    T36 | KBDEXT,

    T37 | KBDMULTIVK,               // numpad_* + Shift/Alt -> SnapShot

    T38, T39, T3A, T3B, T3C, T3D, T3E,
    T3F, T40, T41, T42, T43, T44,

    /*
     * NumLock Key:
     *     KBDEXT     - VK_NUMLOCK is an Extended key
     *     KBDMULTIVK - VK_NUMLOCK or VK_PAUSE (without or with CTRL)
     */
    T45 | KBDEXT | KBDMULTIVK,

    T46 | KBDMULTIVK,

    /*
     * Number Pad keys:
     *     KBDNUMPAD  - digits 0-9 and decimal point.
     *     KBDSPECIAL - require special processing by Windows
     */
    T47 | KBDNUMPAD | KBDSPECIAL,   // Numpad 7 (Home)
    T48 | KBDNUMPAD | KBDSPECIAL,   // Numpad 8 (Up),
    T49 | KBDNUMPAD | KBDSPECIAL,   // Numpad 9 (PgUp),
    T4A,
    T4B | KBDNUMPAD | KBDSPECIAL,   // Numpad 4 (Left),
    T4C | KBDNUMPAD | KBDSPECIAL,   // Numpad 5 (Clear),
    T4D | KBDNUMPAD | KBDSPECIAL,   // Numpad 6 (Right),
    T4E,
    T4F | KBDNUMPAD | KBDSPECIAL,   // Numpad 1 (End),
    T50 | KBDNUMPAD | KBDSPECIAL,   // Numpad 2 (Down),
    T51 | KBDNUMPAD | KBDSPECIAL,   // Numpad 3 (PgDn),
    T52 | KBDNUMPAD | KBDSPECIAL,   // Numpad 0 (Ins),
    T53 | KBDNUMPAD | KBDSPECIAL,   // Numpad . (Del),

    T54, T55, T56, T57, T58, T59, T5A, T5B,
    T5C, T5D, T5E, T5F, T60, T61, T62, T63,
    T64, T65, T66, T67, T68, T69, T6A, T6B,
    T6C, T6D, T6E, T6F, T70, T71, T72, T73,
    T74, T75, T76, T77, T78, T79, T7A, T7B,
    T7C, T7D, T7E

};

ALLOC_SECTION_LDATA VSC_VK aE0VscToVk[] = {
        { 0x53, X53 | KBDEXT              },  // Delete
        { 0x10, X10 | KBDEXT              },  // Speedracer: Previous Track
        { 0x19, X19 | KBDEXT              },  // Speedracer: Next Track
        { 0x1D, X1D | KBDEXT              },  // RControl
        { 0x20, X20 | KBDEXT              },  // Speedracer: Volume Mute
        { 0x21, X21 | KBDEXT              },  // Speedracer: Launch App 2
        { 0x22, X22 | KBDEXT              },  // Speedracer: Media Play/Pause
        { 0x24, X24 | KBDEXT              },  // Speedracer: Media Stop
        { 0x2E, X2E | KBDEXT              },  // Speedracer: Volume Down
        { 0x30, X30 | KBDEXT              },  // Speedracer: Volume Up
        { 0x32, X32 | KBDEXT              },  // Speedracer: Browser Home
@@@xtrascans@@@        { 0x37, X37 | KBDEXT              },  // Snapshot
        { 0x38, X38 | KBDEXT              },  // RMenu
        { 0x47, X47 | KBDEXT              },  // Home
        { 0x48, X48 | KBDEXT              },  // Up
        { 0x49, X49 | KBDEXT              },  // Prior
        { 0x4B, X4B | KBDEXT              },  // Left
        { 0x4D, X4D | KBDEXT              },  // Right
        { 0x4F, X4F | KBDEXT              },  // End
        { 0x50, X50 | KBDEXT              },  // Down
        { 0x51, X51 | KBDEXT              },  // Next
        { 0x52, X52 | KBDEXT              },  // Insert
        { 0x5B, X5B | KBDEXT              },  // Left Win
        { 0x5C, X5C | KBDEXT              },  // Right Win
        { 0x5D, X5D | KBDEXT              },  // Application
        { 0x5F, X5F | KBDEXT              },  // Speedracer: Sleep
        { 0x65, X65 | KBDEXT              },  // Speedracer: Browser Search
        { 0x66, X66 | KBDEXT              },  // Speedracer: Browser Favorites
        { 0x67, X67 | KBDEXT              },  // Speedracer: Browser Refresh
        { 0x68, X68 | KBDEXT              },  // Speedracer: Browser Stop
        { 0x69, X69 | KBDEXT              },  // Speedracer: Browser Forward
        { 0x6A, X6A | KBDEXT              },  // Speedracer: Browser Back
        { 0x6B, X6B | KBDEXT              },  // Speedracer: Launch App 1
        { 0x6C, X6C | KBDEXT              },  // Speedracer: Launch Mail
        { 0x6D, X6D | KBDEXT              },  // Speedracer: Launch Media Selector
        { 0x1C, X1C | KBDEXT              },  // Numpad Enter
        { 0x46, X46 | KBDEXT              },  // Break (Ctrl + Pause)
        { 0,      0                       }
};

ALLOC_SECTION_LDATA VSC_VK aE1VscToVk[] = {
        { 0x1D, Y1D                       },  // Pause
        { 0   ,   0                       }
};

/***************************************************************************\
* aVkToBits[]  - map Virtual Keys to Modifier Bits
*
* See kbd.h for a full description.
*
* The keyboard has only three shifter keys:
*     SHIFT (L & R) affects alphabnumeric keys,
*     CTRL  (L & R) is used to generate control characters
*     ALT   (L & R) used for generating characters by number with numpad
\***************************************************************************/

@@@pre_column_descr@@@
static ALLOC_SECTION_LDATA VK_TO_BIT aVkToBits[] = {
    { VK_SHIFT    ,   KBDSHIFT     },
  /* CONTROL and MENU may appear only when an application creates a configuration of keys for ToUnicode() ``by hand''.
     CONTROL may be combined with MENU and LMENU; MENU may also be combined with LCONTROL:
	C+A, C+A+K, C+A+L
     We can freely choose to which configuration columns to resolve these combinations. */
    { VK_CONTROL  ,   KBDCTRL      },
    { VK_MENU     ,   KBDALT       },
    { VK_LCONTROL ,   KBDCTRL + KBDLOYA      },
    { VK_RCONTROL ,   KBDCTRL + KBDALT + KBDROYA      },
    { VK_LMENU    ,   KBDALT + KBDKANA       },
    { VK_RMENU    ,   KBDALT + KBDCTRL + KBDLOYA + KBD_Z       },
    { VK_OEM_AX   ,   KBDALT + KBDCTRL + KBD_T      },
    { 0           ,   0           }
};

/***************************************************************************\
* aModification[]  - map character modifier bits to modification number
*
* See kbd.h for a full description.
*
\***************************************************************************/

ALLOC_SECTION_LDATA MODIFIERS CharModifiers = {
    &aVkToBits[0],
    @@@num_column_descr@@@,
    {
    //  Modification#	// ORed bitmap for pressed modifiers
    //  =============	// =================================
@@@column_descr@@@    }
};

/***************************************************************************\
*
* aVkToWch2[]  - Virtual Key to WCHAR translation for 2 shift states
* aVkToWch3[]  - Virtual Key to WCHAR translation for 3 shift states
*   ...
*
* Table attributes: Unordered Scan, null-terminated
*
* Search this table for an entry with a matching Virtual Key to find the
* corresponding unshifted and shifted WCHAR characters.
*
* Special values for VirtualKey (column 1)
*     0xff          - dead chars for the previous entry
*     0             - terminate the list
*
* Special values for Attributes (column 2)
*     CAPLOK bit      - CAPS-LOCK affect this key like SHIFT
*     CAPLOKALTGR bit - Same with (only) AltGr modifier.
*
* Special values for wch[*] (column 3 & 4)
*     WCH_NONE      - No character
*     WCH_DEAD      - Dead Key (prefix key); the next line has the id of this deadkey.
*     WCH_LGTR      - Ligature (generates multiple codepoints).  This VK + modifiers_position_id
*                     should be looked up in the ligature table.
*
\***************************************************************************/

@@@extralendefs@@@

@@@sublayouts@@@

ALLOC_SECTION_LDATA VK_TO_WCHAR_TABLE aVkToWcharTable[] = {
@@@join_sublayouts@@@    {                       NULL, 0, 0                    },
};

/***************************************************************************\
* aKeyNames[], aKeyNamesExt[]  - Virtual Scancode to Key Name tables
*
* Table attributes: Ordered Scan (by scancode), null-terminated
*
* Only the names of Extended, NumPad, Dead and Non-Printable keys are here.
* (Keys producing printable characters are named by that character)
\***************************************************************************/

ALLOC_SECTION_LDATA VSC_LPWSTR aKeyNames[] = {
@@@KEYNAME@@@    0   ,    NULL
};

ALLOC_SECTION_LDATA VSC_LPWSTR aKeyNamesExt[] = {
@@@KEYNAME_EXT@@@    0   ,    NULL
};

ALLOC_SECTION_LDATA DEADKEY_LPWSTR aKeyNamesDead[] = {
@@@KEYNAME_DEAD@@@    NULL
};

ALLOC_SECTION_LDATA DEADKEY aDeadKey[] = {
@@@deadkeys@@@  0, 0
};

@@@ligatures@@@

PKBDTABLES KbdLayerDescriptor(VOID)
{
    return &KbdTables;
}
__END__
