package Business::EDI::CodeList::TextSubjectCodeQualifier;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 4451;
my $usage       = 'C';

# 4451  Text subject code qualifier                             [C]
# Desc: Code qualifying the subject of the text.
# Repr: an..3

my %code_hash = (
'AAA' => [ 'Goods item description',
    '[7002] Plain language description of the nature of a goods item sufficient to identify it for customs, statistical or transport purposes.' ],
'AAB' => [ 'Payment term',
    '[4276] Free form description of the conditions of payment between the parties to a transaction.' ],
'AAC' => [ 'Dangerous goods additional information',
    '[7488] Additional information concerning dangerous substances and/or article in a consignment.' ],
'AAD' => [ 'Dangerous goods technical name',
    '[7254] Proper shipping name, supplemented as necessary with the correct technical name, by which a dangerous substance or article may be correctly identified, or which is sufficiently informative to permit identification by reference to generally available literature.' ],
'AAE' => [ 'Acknowledgement description',
    'The content of an acknowledgement.' ],
'AAF' => [ 'Rate additional information',
    'Specific details applying to rates.' ],
'AAG' => [ 'Party instructions',
    'Indicates that the segment contains instructions to be passed on to the identified party.' ],
'AAI' => [ 'General information',
    'The text contains general information.' ],
'AAJ' => [ 'Additional conditions of sale/purchase',
    'Additional conditions specific to this order or project.' ],
'AAK' => [ 'Price conditions',
    'Information on the price conditions that are expected or given.' ],
'AAL' => [ 'Goods dimensions in characters',
    'Expression of a number in characters as length of ten meters.' ],
'AAM' => [ 'Equipment re-usage restrictions',
    'Technical or commercial reasons why a piece of equipment may not be re-used after the current transport terminates.' ],
'AAN' => [ 'Handling restriction',
    'Restrictions in handling depending on the technical characteristics of the piece of equipment or on the nature of the goods.' ],
'AAO' => [ 'Error description (free text)',
    'Error described by a free text.' ],
'AAP' => [ 'Response (free text)',
    'Free text of the response to a communication.' ],
'AAQ' => [ "Package content's description",
    'A description of the contents of a package.' ],
'AAR' => [ 'Terms of delivery',
    '(4053) Free text of the non Incoterms terms of delivery. For Incoterms, use: 4053.' ],
'AAS' => [ 'Bill of lading remarks',
    'The remarks printed or to be printed on a bill of lading.' ],
'AAT' => [ 'Mode of settlement information',
    'Free text information on an IATA Air Waybill to indicate means by which account is to be settled.' ],
'AAU' => [ 'Consignment invoice information',
    'Information pertaining to the invoice covering the consignment.' ],
'AAV' => [ 'Clearance invoice information',
    'Information pertaining to the invoice covering clearance of the cargo.' ],
'AAW' => [ 'Letter of credit information',
    'Information pertaining to the letter of credit.' ],
'AAX' => [ 'License information',
    'Information pertaining to a license.' ],
'AAY' => [ 'Certification statements',
    'The text contains certification statements.' ],
'AAZ' => [ 'Additional export information',
    'The text contains additional export information.' ],
'ABA' => [ 'Tariff statements',
    'Description of parameters relating to a tariff.' ],
'ABB' => [ 'Medical history',
    'Historical details of a patients medical events.' ],
'ABC' => [ 'Conditions of sale or purchase',
    '(4490) Additional information regarding terms and conditions which apply to the transaction.' ],
'ABD' => [ 'Contract document type',
    '[4422] Textual representation of the type of contract.' ],
'ABE' => [ 'Additional terms and/or conditions (documentary credit)',
    '(4260) Additional terms and/or conditions to the documentary credit.' ],
'ABF' => [ 'Instructions or information about standby documentary',
    'credit Instruction or information about a standby documentary credit.' ],
'ABG' => [ 'Instructions or information about partial shipment(s)',
    'Instructions or information about partial shipment(s).' ],
'ABH' => [ 'Instructions or information about transhipment(s)',
    'Instructions or information about transhipment(s).' ],
'ABI' => [ 'Additional handling instructions documentary credit',
    'Additional handling instructions for a documentary credit.' ],
'ABJ' => [ 'Domestic routing information',
    'Information regarding the domestic routing.' ],
'ABK' => [ 'Chargeable category of equipment',
    'Equipment types are coded by category for financial purposes.' ],
'ABL' => [ 'Government information',
    'Information pertaining to government.' ],
'ABM' => [ 'Onward routing information',
    'The text contains onward routing information.' ],
'ABN' => [ 'Accounting information',
    'The text contains information related to accounting.' ],
'ABO' => [ 'Discrepancy information',
    'Free text or coded information to indicate a specific discrepancy.' ],
'ABP' => [ 'Confirmation instructions',
    'Documentary credit confirmation instructions.' ],
'ABQ' => [ 'Method of issuance',
    'Method of issuance of documentary credit.' ],
'ABR' => [ 'Documents delivery instructions',
    'Delivery instructions for documents required under a documentary credit.' ],
'ABS' => [ 'Additional conditions',
    'Additional conditions to the issuance of a documentary credit.' ],
'ABT' => [ 'Information/instructions about additional amounts covered',
    'Additional amounts information/instruction.' ],
'ABU' => [ 'Deferred payment termed additional',
    'Additional terms concerning deferred payment.' ],
'ABV' => [ 'Acceptance terms additional',
    'Additional terms concerning acceptance.' ],
'ABW' => [ 'Negotiation terms additional',
    'Additional terms concerning negotiation.' ],
'ABX' => [ 'Document name and documentary requirements',
    'Document name and documentary requirements.' ],
'ABZ' => [ 'Instructions/information about revolving documentary credit',
    'Instructions/information about a revolving documentary credit.' ],
'ACA' => [ 'Documentary requirements',
    'Specification of the documentary requirements.' ],
'ACB' => [ 'Additional information',
    'The text contains additional information.' ],
'ACC' => [ 'Factor assignment clause',
    'Assignment based on an agreement between seller and factor.' ],
'ACD' => [ 'Reason',
    'Reason for a request or response.' ],
'ACE' => [ 'Dispute',
    'A notice, usually from buyer to seller, that something was found wrong with goods delivered or the services rendered, or with the related invoice.' ],
'ACF' => [ 'Additional attribute information',
    'The text refers to information about an additional attribute not otherwise specified.' ],
'ACG' => [ 'Absence declaration',
    'A declaration on the reason of the absence.' ],
'ACH' => [ 'Aggregation statement',
    'A statement on the way a specific variable or set of variables has been aggregated.' ],
'ACI' => [ 'Compilation statement',
    'A statement on the compilation status of an array or other set of figures or calculations.' ],
'ACJ' => [ 'Definitional exception',
    'An exception to the agreed definition of a term, concept, formula or other object.' ],
'ACK' => [ 'Privacy statement',
    'A statement on the privacy or confidential nature of an object.' ],
'ACL' => [ 'Quality statement',
    'A statement on the quality of an object.' ],
'ACM' => [ 'Statistical description',
    'The description of a statistical object such as a value list, concept, or structure definition.' ],
'ACN' => [ 'Statistical definition',
    'The definition of a statistical object such as a value list, concept, or structure definition.' ],
'ACO' => [ 'Statistical name',
    'The name of a statistical object such as a value list, concept or structure definition.' ],
'ACP' => [ 'Statistical title',
    'The title of a statistical object such as a value list, concept, or structure definition.' ],
'ACQ' => [ 'Off-dimension information',
    'Information relating to differences between the actual transport dimensions and the normally applicable dimensions.' ],
'ACR' => [ 'Unexpected stops information',
    'Information relating to unexpected stops during a conveyance.' ],
'ACS' => [ 'Principles',
    'Text subject is principles section of the UN/EDIFACT rules for presentation of standardized message and directories documentation.' ],
'ACT' => [ 'Terms and definition',
    'Text subject is terms and definition section of the UN/EDIFACT rules for presentation of standardized message and directories documentation.' ],
'ACU' => [ 'Segment name',
    'Text subject is segment name.' ],
'ACV' => [ 'Simple data element name',
    'Text subject is name of simple data element.' ],
'ACW' => [ 'Scope',
    'Text subject is scope section of the UN/EDIFACT rules for presentation of standardized message and directories documentation.' ],
'ACX' => [ 'Message type name',
    'Text subject is name of message type.' ],
'ACY' => [ 'Introduction',
    'Text subject is introduction section of the UN/EDIFACT rules for presentation of standardized message and directories documentation.' ],
'ACZ' => [ 'Glossary',
    'Text subject is glossary section of the UN/EDIFACT rules for presentation of standardized message and directories documentation.' ],
'ADA' => [ 'Functional definition',
    'Text subject is functional definition section of the UN/EDIFACT rules for presentation of standardized message and directories documentation.' ],
'ADB' => [ 'Examples',
    'Text subject is examples as given in the example(s) section of the UN/EDIFACT rules for presentation of standardized message and directories documentation.' ],
'ADC' => [ 'Cover page',
    'Text subject is cover page of the UN/EDIFACT rules for presentation of standardized message and directories documentation.' ],
'ADD' => [ 'Dependency (syntax) notes',
    'Denotes that the associated text is a dependency (syntax) note.' ],
'ADE' => [ 'Code value name',
    'Text subject is name of code value.' ],
'ADF' => [ 'Code list name',
    'Text subject is name of code list.' ],
'ADG' => [ 'Clarification of usage',
    'Text subject is an explanation of the intended usage of a segment or segment group.' ],
'ADH' => [ 'Composite data element name',
    'Text subject is name of composite data element.' ],
'ADI' => [ 'Field of application',
    'Text subject is field of application of the UN/EDIFACT rules for presentation of standardized message and directories documentation.' ],
'ADJ' => [ 'Type of assets and liabilities',
    'Information describing the type of assets and liabilities.' ],
'ADK' => [ 'Promotion information',
    'The text contains information about a promotion.' ],
'ADL' => [ 'Meter condition',
    'Description of the condition of a meter.' ],
'ADM' => [ 'Meter reading information',
    'Information related to a particular reading of a meter.' ],
'ADN' => [ 'Type of transaction reason',
    'Information describing the type of the reason of transaction.' ],
'ADO' => [ 'Type of survey question',
    'Type of survey question.' ],
'ADP' => [ "Carrier's agent counter information",
    "Information for use at the counter of the carrier's agent." ],
'ADQ' => [ 'Description of work item on equipment',
    'Description or code for the operation to be executed on the equipment.' ],
'ADR' => [ 'Message definition',
    'Text subject is message definition.' ],
'ADS' => [ 'Booked item information',
    'Information pertaining to a booked item.' ],
'ADT' => [ 'Source of document',
    'Text subject is source of document.' ],
'ADU' => [ 'Note',
    'Text subject is note.' ],
'ADV' => [ 'Fixed part of segment clarification text',
    'Text subject is fixed part of segment clarification text.' ],
'ADW' => [ 'Characteristics of goods',
    'Description of the characteristic of goods in addition to the description of the goods.' ],
'ADX' => [ 'Additional discharge instructions',
    'Special discharge instructions concerning the goods.' ],
'ADY' => [ 'Container stripping instructions',
    'Instructions regarding the stripping of container(s).' ],
'ADZ' => [ 'CSC (Container Safety Convention) plate information',
    'Information on the CSC (Container Safety Convention) plate that is attached to the container.' ],
'AEA' => [ 'Cargo remarks',
    'Additional remarks concerning the cargo.' ],
'AEB' => [ 'Temperature control instructions',
    'Instruction regarding the temperature control of the cargo.' ],
'AEC' => [ 'Text refers to expected data',
    'Remarks refer to data that was expected.' ],
'AED' => [ 'Text refers to received data',
    'Remarks refer to data that was received.' ],
'AEE' => [ 'Section clarification text',
    'Text subject is section clarification text.' ],
'AEF' => [ 'Information to the beneficiary',
    'Information given to the beneficiary.' ],
'AEG' => [ 'Information to the applicant',
    'Information given to the applicant.' ],
'AEH' => [ 'Instructions to the beneficiary',
    'Instructions made to the beneficiary.' ],
'AEI' => [ 'Instructions to the applicant',
    'Instructions given to the applicant.' ],
'AEJ' => [ 'Controlled atmosphere',
    'Information about the controlled atmosphere.' ],
'AEK' => [ 'Take off annotation',
    'Additional information in plain text to support a take off annotation. Taking off is the process of assessing the quantity work from extracting the measurement from construction documentation.' ],
'AEL' => [ 'Price variation narrative',
    'Additional information in plain language to support a price variation.' ],
'AEM' => [ 'Documentary credit amendment instructions',
    'Documentary credit amendment instructions.' ],
'AEN' => [ 'Standard method narrative',
    'Additional information in plain language to support a standard method.' ],
'AEO' => [ 'Project narrative',
    'Additional information in plain language to support the project.' ],
'AEP' => [ 'Radioactive goods, additional information',
    'Additional information related to radioactive goods.' ],
'AEQ' => [ 'Bank-to-bank information',
    'Information given from one bank to another.' ],
'AER' => [ 'Reimbursement instructions',
    'Instructions given for reimbursement purposes.' ],
'AES' => [ 'Reason for amending a message',
    'Identification of the reason for amending a message.' ],
'AET' => [ 'Instructions to the paying and/or accepting and/or',
    'negotiating bank Instructions to the paying and/or accepting and/or negotiating bank.' ],
'AEU' => [ 'Interest instructions',
    'Instructions given about the interest.' ],
'AEV' => [ 'Agent commission',
    'Instructions about agent commission.' ],
'AEW' => [ 'Remitting bank instructions',
    'Instructions to the remitting bank.' ],
'AEX' => [ 'Instructions to the collecting bank',
    'Instructions to the bank, other than the remitting bank, involved in processing the collection.' ],
'AEY' => [ 'Collection amount instructions',
    'Instructions about the collection amount.' ],
'AEZ' => [ 'Internal auditing information',
    'Text relating to internal auditing information.' ],
'AFA' => [ 'Constraint',
    'Denotes that the associated text is a constraint.' ],
'AFB' => [ 'Comment',
    'Denotes that the associated text is a comment.' ],
'AFC' => [ 'Semantic note',
    'Denotes that the associated text is a semantic note.' ],
'AFD' => [ 'Help text',
    'Denotes that the associated text is an item of help text.' ],
'AFE' => [ 'Legend',
    'Denotes that the associated text is a legend.' ],
'AFF' => [ 'Batch code structure',
    'A description of the structure of a batch code.' ],
'AFG' => [ 'Product application',
    'A general description of the application of a product.' ],
'AFH' => [ 'Customer complaint',
    'Complaint of customer.' ],
'AFI' => [ 'Probable cause of fault',
    'The probable cause of fault.' ],
'AFJ' => [ 'Defect description',
    'Description of the defect.' ],
'AFK' => [ 'Repair description',
    'The description of the work performed during the repair.' ],
'AFL' => [ 'Review comments',
    'Comments relevant to a review.' ],
'AFM' => [ 'Title',
    'Denotes that the associated text is a title.' ],
'AFN' => [ 'Description of amount',
    'An amount description in clear text.' ],
'AFO' => [ 'Responsibilities',
    'Information describing the responsibilities.' ],
'AFP' => [ 'Supplier',
    'Information concerning suppliers.' ],
'AFQ' => [ 'Purchase region',
    'Information concerning the region(s) where purchases are made.' ],
'AFR' => [ 'Affiliation',
    'Information concerning an association of one party with another party(ies).' ],
'AFS' => [ 'Borrower',
    'Information concerning the borrower.' ],
'AFT' => [ 'Line of business',
    "Information concerning an entity's line of business." ],
'AFU' => [ 'Financial institution',
    'Description of financial institution(s) used by an entity.' ],
'AFV' => [ 'Business founder',
    'Information about the business founder.' ],
'AFW' => [ 'Business history',
    'Description of the business history.' ],
'AFX' => [ 'Banking arrangements',
    'Information concerning the general banking arrangements.' ],
'AFY' => [ 'Business origin',
    'Description of the business origin.' ],
'AFZ' => [ "Brand names' description",
    "Description of the entity's brands." ],
'AGA' => [ 'Business financing details',
    'Details about the financing of the business.' ],
'AGB' => [ 'Competition',
    "Information concerning an entity's competition." ],
'AGC' => [ 'Construction process details',
    'Details about the construction process.' ],
'AGD' => [ 'Construction specialty',
    'Information concerning the line of business of a construction entity.' ],
'AGE' => [ 'Contract information',
    'Details about contract(s).' ],
'AGF' => [ 'Corporate filing',
    'Details about a corporate filing.' ],
'AGG' => [ 'Customer information',
    'Description of customers.' ],
'AGH' => [ 'Copyright notice',
    'Information concerning the copyright notice.' ],
'AGI' => [ 'Contingent debt',
    'Details about the contingent debt.' ],
'AGJ' => [ 'Conviction details',
    'Details about the law or penal codes that resulted in conviction.' ],
'AGK' => [ 'Equipment',
    'Description of equipment.' ],
'AGL' => [ 'Workforce description',
    'Comments about the workforce.' ],
'AGM' => [ 'Exemption',
    'Description about exemptions.' ],
'AGN' => [ 'Future plans',
    'Information on future plans.' ],
'AGO' => [ 'Interviewee conversation information',
    'Information concerning the interviewee conversation.' ],
'AGP' => [ 'Intangible asset',
    'Description of intangible asset(s).' ],
'AGQ' => [ 'Inventory',
    'Description of the inventory.' ],
'AGR' => [ 'Investment',
    'Description of the investments.' ],
'AGS' => [ 'Intercompany relations information',
    'Description of the intercompany relations.' ],
'AGT' => [ 'Joint venture',
    'Description of the joint venture.' ],
'AGU' => [ 'Loan',
    'Description of a loan.' ],
'AGV' => [ 'Long term debt',
    'Description of the long term debt.' ],
'AGW' => [ 'Location',
    'Description of a location.' ],
'AGX' => [ 'Current legal structure',
    'Details on the current legal structure.' ],
'AGY' => [ 'Marital contract',
    'Details on a marital contract.' ],
'AGZ' => [ 'Marketing activities',
    'Information concerning marketing activities.' ],
'AHA' => [ 'Merger',
    'Description of a merger.' ],
'AHB' => [ 'Marketable securities',
    'Description of the marketable securities.' ],
'AHC' => [ 'Business debt',
    'Description of the business debt(s).' ],
'AHD' => [ 'Original legal structure',
    'Information concerning the original legal structure.' ],
'AHE' => [ 'Employee sharing arrangements',
    'Information describing how a company uses employees from another company.' ],
'AHF' => [ 'Organization details',
    'Description about the organization of a company.' ],
'AHG' => [ 'Public record details',
    'Information concerning public records.' ],
'AHH' => [ 'Price range',
    'Information concerning the price range of products made or sold.' ],
'AHI' => [ 'Qualifications',
    'Information on the accomplishments fitting a party for a position.' ],
'AHJ' => [ 'Registered activity',
    'Information concerning the registered activity.' ],
'AHK' => [ 'Criminal sentence',
    'Description of the sentence imposed in a criminal proceeding.' ],
'AHL' => [ 'Sales method',
    'Description of the selling means.' ],
'AHM' => [ 'Educational institution information',
    'Free form description relating to the school(s) attended.' ],
'AHN' => [ 'Status details',
    'Describes the status details.' ],
'AHO' => [ 'Sales',
    'Description of the sales.' ],
'AHP' => [ 'Spouse information',
    'Information about the spouse.' ],
'AHQ' => [ 'Educational degree information',
    'Details about the educational degree received from a school.' ],
'AHR' => [ 'Shareholding information',
    'General description of shareholding.' ],
'AHS' => [ 'Sales territory',
    'Information on the sales territory.' ],
'AHT' => [ "Accountant's comments",
    'Comments made by an accountant regarding a financial statement.' ],
'AHU' => [ 'Exemption law location',
    'Description of the exemption provided to a location by a law.' ],
'AHV' => [ 'Share classifications',
    'Information about the classes or categories of shares.' ],
'AHW' => [ 'Forecast',
    'Description of a prediction.' ],
'AHX' => [ 'Event location',
    'Description of the location of an event.' ],
'AHY' => [ 'Facility occupancy',
    'Information related to occupancy of a facility.' ],
'AHZ' => [ 'Import and export details',
    'Specific information provided about the importation and exportation of goods.' ],
'AIA' => [ 'Additional facility information',
    'Additional information about a facility.' ],
'AIB' => [ 'Inventory value',
    'Description of the value of inventory.' ],
'AIC' => [ 'Education',
    'Description of the education of a person.' ],
'AID' => [ 'Event',
    'Description of a thing that happens or takes place.' ],
'AIE' => [ 'Agent',
    'Information about agents the entity uses.' ],
'AIF' => [ 'Domestically agreed financial statement details',
    'Details of domestically agreed financial statement.' ],
'AIG' => [ 'Other current asset description',
    'Description of other current asset.' ],
'AIH' => [ 'Other current liability description',
    'Description of other current liability.' ],
'AII' => [ 'Former business activity',
    'Description of the former line of business.' ],
'AIJ' => [ 'Trade name use',
    'Description of how a trading name is used.' ],
'AIK' => [ 'Signing authority',
    'Description of the authorized signatory.' ],
'AIL' => [ 'Guarantee',
    'Description of guarantee.' ],
'AIM' => [ 'Holding company operation',
    'Description of the operation of a holding company.' ],
'AIN' => [ 'Consignment routing',
    'Information on routing of the consignment.' ],
'AIO' => [ 'Letter of protest',
    'A letter citing any condition in dispute.' ],
'AIP' => [ 'Question',
    'A free text question.' ],
'AIQ' => [ 'Party information',
    'Free text information related to a party.' ],
'AIR' => [ 'Area boundaries description',
    'Description of the boundaries of a geographical area.' ],
'AIS' => [ 'Advertisement information',
    'The free text contains advertisement information.' ],
'AIT' => [ 'Financial statement details',
    'Details regarding the financial statement in free text.' ],
'AIU' => [ 'Access instructions',
    'Description of how to access an entity.' ],
'AIV' => [ 'Liquidity',
    "Description of an entity's liquidity." ],
'AIW' => [ 'Credit line',
    'Description of the line of credit available to an entity.' ],
'AIX' => [ 'Warranty terms',
    'Text describing the terms of warranty which apply to a product or service.' ],
'AIY' => [ 'Division description',
    'Plain language description of a division of an entity.' ],
'AIZ' => [ 'Reporting instruction',
    'Instruction on how to report.' ],
'AJA' => [ 'Examination result',
    'The result of an examination.' ],
'AJB' => [ 'Laboratory result',
    'The result of a laboratory investigation.' ],
'ALC' => [ 'Allowance/charge information',
    'Information referring to allowance/charge.' ],
'ALD' => [ 'X-ray result',
    'The result of an X-ray examination.' ],
'ALE' => [ 'Pathology result',
    'The result of a pathology investigation.' ],
'ALF' => [ 'Intervention description',
    'Details of an intervention.' ],
'ALG' => [ 'Summary of admittance',
    'Summary description of admittance.' ],
'ALH' => [ 'Medical treatment course detail',
    'Details of a course of medical treatment.' ],
'ALI' => [ 'Prognosis',
    'Details of a prognosis.' ],
'ALJ' => [ 'Instruction to patient',
    'Instruction given to a patient.' ],
'ALK' => [ 'Instruction to physician',
    'Instruction given to a physician.' ],
'ALL' => [ 'All documents',
    'The note implies to all documents.' ],
'ALM' => [ 'Medicine treatment',
    'Details of medicine treatment.' ],
'ALN' => [ 'Medicine dosage and administration',
    'Details of medicine dosage and method of administration.' ],
'ALO' => [ 'Availability of patient',
    'Details of when and/or where the patient is available.' ],
'ALP' => [ 'Reason for service request',
    'Details of the reason for a requested service.' ],
'ALQ' => [ 'Purpose of service',
    'Details of the purpose of a service.' ],
'ARR' => [ 'Arrival conditions',
    'Conditions under which arrival takes place.' ],
'ARS' => [ "Service requester's comment",
    'Comment by the requester of a service.' ],
'AUT' => [ 'Authentication',
    'Name, code, password etc. given for authentication purposes.' ],
'AUU' => [ 'Requested location description',
    'The description of the location requested.' ],
'AUV' => [ 'Medicine administration condition',
    'The event or condition that initiates the administration of a single dose of medicine or a period of treatment.' ],
'AUW' => [ 'Patient information',
    'Information concerning a patient.' ],
'AUX' => [ 'Precautionary measure',
    'Action to be taken to avert possible harmful affects.' ],
'AUY' => [ 'Service characteristic',
    'Free text description is related to a service characteristic.' ],
'AUZ' => [ 'Planned event comment',
    'Comment about an event that is planned.' ],
'AVA' => [ 'Expected delay comment',
    'Comment about the expected delay.' ],
'AVB' => [ 'Transport requirements comment',
    'Comment about the requirements for transport.' ],
'BLC' => [ 'Transport contract document clause',
    '[4180] Clause on a transport document regarding the cargo being consigned. Synonym: Bill of Lading clause.' ],
'BLD' => [ 'Instruction to prepare the patient',
    'Instruction with the purpose of preparing the patient.' ],
'BLE' => [ 'Medicine treatment comment',
    'Comment about treatment with medicine.' ],
'BLF' => [ 'Examination result comment',
    'Comment about the result of an examination.' ],
'BLG' => [ 'Service request comment',
    'Comment about the requested service.' ],
'BLH' => [ 'Prescription reason',
    'Details of the reason for a prescription.' ],
'BLI' => [ 'Prescription comment',
    'Comment concerning a specified prescription.' ],
'BLJ' => [ 'Clinical investigation comment',
    'Comment concerning a clinical investigation.' ],
'BLK' => [ 'Medicinal specification comment',
    'Comment concerning the specification of a medicinal product.' ],
'BLL' => [ 'Economic contribution comment',
    'Comment concerning economic contribution.' ],
'BLM' => [ 'Status of a plan',
    'Comment about the status of a plan.' ],
'BLN' => [ 'Random sample test information',
    'Information regarding a random sample test.' ],
'BLO' => [ 'Period of time',
    'Text subject is a period of time.' ],
'BLP' => [ 'Legislation',
    'Information about legislation.' ],
'BLQ' => [ 'Security measures requested',
    "Text describing security measures that are requested to be executed (e.g. access controls, supervision of ship's stores)." ],
'BLR' => [ 'Transport contract document remark',
    '[4244] Remarks concerning the complete consignment to be printed on the transport document. Synonym: Bill of Lading remark.' ],
'BLS' => [ 'Previous port of call security information',
    'Text describing the security information as applicable at the port facility in the previous port where a ship/port interface was conducted.' ],
'BLT' => [ 'Security information',
    'Text describing security related information (e.g security measures currently in force on a vessel).' ],
'BLU' => [ 'Waste information',
    'Text describing waste related information.' ],
'BLV' => [ 'B2C marketing information, short description',
    'Consumer marketing information, short description.' ],
'BLW' => [ 'B2B marketing information, long description',
    'Trading partner marketing information, long description.' ],
'BLX' => [ 'B2C marketing information, long description',
    'Consumer marketing information, long description.' ],
'BLY' => [ 'Product ingredients',
    'Information on the ingredient make up of the product.' ],
'BLZ' => [ 'Location short name',
    'Short name of a location e.g. for display or printing purposes.' ],
'BMA' => [ 'Packaging material information',
    'The text contains a description of the material used for packaging.' ],
'BMB' => [ 'Filler material information',
    'Text contains information on the material used for stuffing.' ],
'BMC' => [ 'Ship-to-ship activity information',
    'Text contains information on ship-to-ship activities.' ],
'BMD' => [ 'Package material description',
    'A description of the type of material for packaging beyond the level covered by standards such as UN Recommendation 21.' ],
'BME' => [ 'Consumer level package marking',
    'Textual representation of the markings on a consumer level package.' ],
'CCI' => [ 'Customs clearance instructions',
    'Any coded or clear instruction agreed by customer and carrier regarding the declaration of the goods.' ],
'CEX' => [ 'Customs clearance instructions export',
    'Any coded or clear instruction agreed by customer and carrier regarding the export declaration of the goods.' ],
'CHG' => [ 'Change information',
    'Note contains change information.' ],
'CIP' => [ 'Customs clearance instruction import',
    'Any coded or clear instruction agreed by customer and carrier regarding the import declaration of the goods.' ],
'CLP' => [ 'Clearance place requested',
    'Name of the place where Customs clearance is asked to be executed as requested by the consignee/consignor.' ],
'CLR' => [ 'Loading remarks',
    'Instructions concerning the loading of the container.' ],
'COI' => [ 'Order information',
    'Additional information related to an order.' ],
'CUR' => [ 'Customer remarks',
    'Remarks from or for a supplier of goods or services.' ],
'CUS' => [ 'Customs declaration information',
    'Note contains customs declaration information.' ],
'DAR' => [ 'Damage remarks',
    'Remarks concerning damage on the cargo.' ],
'DCL' => [ 'Document issuer declaration',
    '[4020] Text of a declaration made by the issuer of a document.' ],
'DEL' => [ 'Delivery information',
    'Information about delivery.' ],
'DIN' => [ 'Delivery instructions',
    'Instructions regarding the delivery of the cargo.' ],
'DOC' => [ 'Documentation instructions',
    'Instructions pertaining to the documentation.' ],
'DUT' => [ 'Duty declaration',
    'The text contains a statement constituting a duty declaration.' ],
'EUR' => [ 'Effective used routing',
    'Physical route effectively used for the movement of the means of transport.' ],
'FBC' => [ 'First block to be printed on the transport contract',
    'The first block of text to be printed on the transport contract.' ],
'GBL' => [ 'Government bill of lading information',
    'Free text information on a transport document to indicate payment information by Government Bill of Lading.' ],
'GEN' => [ 'Entire transaction set',
    'Note is general in nature, applies to entire transaction segment.' ],
'GS7' => [ 'Further information concerning GGVS par. 7',
    'Special permission for road transport of certain goods in the German dangerous goods regulation for road transport.' ],
'HAN' => [ 'Consignment handling instruction',
    '[4078] Free form description of a set of handling instructions. For example how specified goods, packages or transport equipment (container) should be handled.' ],
'HAZ' => [ 'Hazard information',
    'Information pertaining to a hazard.' ],
'ICN' => [ 'Consignment information for consignee',
    '[4070] Any remarks given for the information of the consignee.' ],
'IIN' => [ 'Insurance instructions',
    'Instructions regarding the cargo insurance.' ],
'IMI' => [ 'Invoice mailing instructions',
    'Instructions as to which freight and charges components have to be mailed to whom.' ],
'IND' => [ 'Commercial invoice item description',
    'Free text describing goods on a commercial invoice line.' ],
'INS' => [ 'Insurance information',
    'Specific note contains insurance information.' ],
'INV' => [ 'Invoice instruction',
    'Note contains invoice instructions.' ],
'IRP' => [ 'Information for railway purpose',
    'Data entered by railway stations when required, e.g. specified trains, additional sheets for freight calculations, special measures, etc.' ],
'ITR' => [ 'Inland transport details',
    'Information concerning the pre-carriage to the port of discharge if by other means than a vessel.' ],
'ITS' => [ 'Testing instructions',
    'Instructions regarding the testing that is required to be carried out on the items in the transaction.' ],
'LAN' => [ 'Location Alias',
    'Alternative name for a location.' ],
'LIN' => [ 'Line item',
    'Note contains line item information.' ],
'LOI' => [ 'Loading instruction',
    'Instructions where specified packages or containers are to be loaded on a means of transport.' ],
'MCO' => [ 'Miscellaneous charge order',
    'Free text accounting information on an IATA Air Waybill to indicate payment information by Miscellaneous charge order.' ],
'MKS' => [ 'Additional marks/numbers information',
    'Additional information regarding the marks and numbers.' ],
'ORI' => [ 'Order instruction',
    'Free text contains order instructions.' ],
'OSI' => [ 'Other service information',
    'General information created by the sender of general or specific value.' ],
'PAC' => [ 'Packing/marking information',
    'Information regarding the packaging and/or marking of goods.' ],
'PAI' => [ 'Payment instructions information',
    'The free text contains payment instructions information relevant to the message.' ],
'PAY' => [ 'Payables information',
    'Note contains payables information.' ],
'PKG' => [ 'Packaging information',
    'Note contains packaging information.' ],
'PKT' => [ 'Packaging terms information',
    'The text contains packaging terms information.' ],
'PMD' => [ 'Payment detail/remittance information',
    'The free text contains payment details.' ],
'PMT' => [ 'Payment information',
    'Note contains payments information.' ],
'PRD' => [ 'Product information',
    'The text contains product information.' ],
'PRF' => [ 'Price calculation formula',
    'Additional information regarding the price formula used for calculating the item price.' ],
'PRI' => [ 'Priority information',
    'Note contains priority information.' ],
'PUR' => [ 'Purchasing information',
    'Note contains purchasing information.' ],
'QIN' => [ 'Quarantine instructions',
    'Instructions regarding quarantine, i.e. the period during which an arriving vessel, including its equipment, cargo, crew or passengers, suspected to carry or carrying a contagious disease is detained in strict isolation to prevent the spread of such a disease.' ],
'QQD' => [ 'Quality demands/requirements',
    'Specification of the quality/performance expectations or standards to which the items must conform.' ],
'QUT' => [ 'Quotation instruction/information',
    'Note contains quotation information.' ],
'RAH' => [ 'Risk and handling information',
    'Information concerning risks induced by the goods and/or handling instruction.' ],
'REG' => [ 'Regulatory information',
    'The free text contains information for regulatory authority.' ],
'RET' => [ 'Return to origin information',
    'Free text information on an IATA Air Waybill to indicate consignment returned because of non delivery.' ],
'REV' => [ 'Receivables',
    'The text contains receivables information.' ],
'RQR' => [ 'Consignment route',
    '[3050] Description of a route to be used for the transport of goods.' ],
'SAF' => [ 'Safety information',
    'The text contains safety information.' ],
'SIC' => [ 'Consignment documentary instruction',
    '[4284] Instructions given and declarations made by the sender to the carrier concerning Customs, insurance, and other formalities.' ],
'SIN' => [ 'Special instructions',
    'Special instructions like licence no, high value, handle with care, glass.' ],
'SLR' => [ 'Ship line requested',
    'Shipping line requested to be used for traffic between European continent and U.K. for Ireland.' ],
'SPA' => [ 'Special permission for transport, generally',
    'Statement that a special permission has been obtained for the transport (and/or routing) in general, and reference to such permission.' ],
'SPG' => [ 'Special permission concerning the goods to be transported',
    'Statement that a special permission has been obtained for the transport (and/or routing) of the goods specified, and reference to such permission.' ],
'SPH' => [ 'Special handling',
    'Note contains special handling information.' ],
'SPP' => [ 'Special permission concerning package',
    'Statement that a special permission has been obtained for the packaging, and reference to such permission.' ],
'SPT' => [ 'Special permission concerning transport means',
    'Statement that a special permission has been obtained for the use of the means transport, and reference to such permission.' ],
'SRN' => [ 'Subsidiary risk number (IATA/DGR)',
    'Number(s) of subsidiary risks, induced by the goods, according to the valid classification.' ],
'SSR' => [ 'Special service request',
    'Request for a special service concerning the transport of the goods.' ],
'SUR' => [ 'Supplier remarks',
    'Remarks from or for a supplier of goods or services.' ],
'TCA' => [ 'Consignment tariff',
    '[5430] Free text specification of tariff applied to a consignment.' ],
'TDT' => [ 'Consignment transport',
    '[8012] Transport information for commercial purposes (generic term).' ],
'TRA' => [ 'Transportation information',
    'General information regarding the transport of the cargo.' ],
'TRR' => [ 'Requested tariff',
    'Stipulation of the tariffs to be applied showing, where applicable, special agreement numbers or references.' ],
'TXD' => [ 'Tax declaration',
    'The text contains a statement constituting a tax declaration.' ],
'WHI' => [ 'Warehouse instruction/information',
    'Note contains warehouse information.' ],
'ZZZ' => [ 'Mutually defined',
    'Note contains information mutually defined by trading partners.' ],
);
sub get_codes { return \%code_hash; }

1;
