/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Mention
implements CoreAnnotation<Mention>,
Serializable {
    private static final long serialVersionUID = -7524485803945717057L;
    public Dictionaries.MentionType mentionType;
    public Dictionaries.Number number;
    public Dictionaries.Gender gender;
    public Dictionaries.Animacy animacy;
    public Dictionaries.Person person;
    public String headString;
    public String nerString;
    public int startIndex;
    public int endIndex;
    public int headIndex;
    public int mentionID = -1;
    public int originalRef = -1;
    public int goldCorefClusterID = -1;
    public int corefClusterID = -1;
    public int sentNum = -1;
    public int utter = -1;
    public int paragraph = -1;
    public boolean isSubject;
    public boolean isDirectObject;
    public boolean isIndirectObject;
    public boolean isPrepositionObject;
    public IndexedWord dependingVerb;
    public boolean twinless = true;
    public boolean generic = false;
    public List<CoreLabel> sentenceWords;
    public List<CoreLabel> originalSpan;
    public Tree mentionSubTree;
    public Tree contextParseTree;
    public CoreLabel headWord;
    public SemanticGraph dependency;
    public Set<String> dependents = new HashSet<String>();
    public List<String> preprocessedTerms;
    public Object synsets;
    public Set<Mention> appositions = null;
    public Set<Mention> predicateNominatives = null;
    public Set<Mention> relativePronouns = null;
    private static final String[] commonNESuffixes = new String[]{"Corp", "Co", "Inc", "Ltd"};

    public Mention() {
    }

    public Mention(int mentionID, int startIndex, int endIndex, SemanticGraph dependency) {
        this.mentionID = mentionID;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.dependency = dependency;
    }

    public Mention(int mentionID, int startIndex, int endIndex, SemanticGraph dependency, List<CoreLabel> mentionSpan) {
        this.mentionID = mentionID;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.dependency = dependency;
        this.originalSpan = mentionSpan;
    }

    public Mention(int mentionID, int startIndex, int endIndex, SemanticGraph dependency, List<CoreLabel> mentionSpan, Tree mentionTree) {
        this.mentionID = mentionID;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.dependency = dependency;
        this.originalSpan = mentionSpan;
        this.mentionSubTree = mentionTree;
    }

    @Override
    public Class<Mention> getType() {
        return Mention.class;
    }

    public boolean isPronominal() {
        return this.mentionType == Dictionaries.MentionType.PRONOMINAL;
    }

    public String toString() {
        return this.spanToString();
    }

    public String spanToString() {
        StringBuilder os = new StringBuilder();
        for (int i = 0; i < this.originalSpan.size(); ++i) {
            if (i > 0) {
                os.append(" ");
            }
            os.append((String)this.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class));
        }
        return os.toString();
    }

    public void process(Dictionaries dict, Semantics semantics, MentionExtractor mentionExtractor) throws Exception {
        this.setHeadString();
        this.setType(dict);
        this.setNERString();
        List<String> mStr = this.getMentionString();
        this.setNumber(dict, this.getNumberCount(dict, mStr));
        this.setGender(dict, this.getGenderCount(dict, mStr));
        this.setAnimacy(dict);
        this.setPerson(dict);
        this.setDiscourse();
        if (semantics != null) {
            this.setSemantics(dict, semantics, mentionExtractor);
        }
    }

    private List<String> getMentionString() {
        ArrayList<String> mStr = new ArrayList<String>();
        for (CoreLabel l : this.originalSpan) {
            mStr.add(((String)l.get(CoreAnnotations.TextAnnotation.class)).toLowerCase());
            if (l != this.headWord) continue;
            break;
        }
        return mStr;
    }

    private int[] getNumberCount(Dictionaries dict, List<String> mStr) {
        int len = mStr.size();
        if (len > 1) {
            for (int i = 0; i < len - 1; ++i) {
                if (!dict.genderNumber.containsKey(mStr.subList(i, len))) continue;
                return dict.genderNumber.get(mStr.subList(i, len));
            }
            ArrayList<String> convertedStr = new ArrayList<String>();
            convertedStr.add("!");
            convertedStr.add(mStr.get(len - 1));
            if (dict.genderNumber.containsKey(convertedStr)) {
                return dict.genderNumber.get(convertedStr);
            }
        }
        if (dict.genderNumber.containsKey(mStr.subList(len - 1, len))) {
            return dict.genderNumber.get(mStr.subList(len - 1, len));
        }
        return null;
    }

    private int[] getGenderCount(Dictionaries dict, List<String> mStr) {
        int len = mStr.size();
        char firstLetter = ((String)this.headWord.get(CoreAnnotations.TextAnnotation.class)).charAt(0);
        if (len > 1 && Character.isUpperCase(firstLetter) && this.nerString.startsWith("PER")) {
            int firstNameIdx = len - 2;
            String secondToLast = mStr.get(firstNameIdx);
            if (firstNameIdx > 1 && (secondToLast.length() == 1 || secondToLast.length() == 2 && secondToLast.endsWith("."))) {
                --firstNameIdx;
            }
            for (int i = 0; i <= firstNameIdx; ++i) {
                if (!dict.genderNumber.containsKey(mStr.subList(i, len))) continue;
                return dict.genderNumber.get(mStr.subList(i, len));
            }
            ArrayList<String> convertedStr = new ArrayList<String>();
            convertedStr.add(mStr.get(firstNameIdx));
            convertedStr.add("!");
            if (dict.genderNumber.containsKey(convertedStr)) {
                return dict.genderNumber.get(convertedStr);
            }
            if (dict.genderNumber.containsKey(mStr.subList(firstNameIdx, firstNameIdx + 1))) {
                return dict.genderNumber.get(mStr.subList(firstNameIdx, firstNameIdx + 1));
            }
        }
        if (dict.genderNumber.containsKey(mStr.subList(len - 1, len))) {
            return dict.genderNumber.get(mStr.subList(len - 1, len));
        }
        return null;
    }

    private void setDiscourse() {
        this.utter = (Integer)this.headWord.get(CoreAnnotations.UtteranceAnnotation.class);
        Pair<IndexedWord, String> verbDependency = Mention.findDependentVerb(this);
        String dep = verbDependency.second();
        this.dependingVerb = verbDependency.first();
        this.isSubject = false;
        this.isDirectObject = false;
        this.isIndirectObject = false;
        this.isPrepositionObject = false;
        if (dep == null) {
            return;
        }
        if (dep.equals("nsubj") || dep.equals("csubj")) {
            this.isSubject = true;
        } else if (dep.equals("dobj")) {
            this.isDirectObject = true;
        } else if (dep.equals("iobj")) {
            this.isIndirectObject = true;
        } else if (dep.equals("pobj")) {
            this.isPrepositionObject = true;
        }
    }

    private void setPerson(Dictionaries dict) {
        String spanToString;
        if (!this.isPronominal()) {
            this.person = Dictionaries.Person.UNKNOWN;
        }
        this.person = dict.firstPersonPronouns.contains(spanToString = this.spanToString().toLowerCase()) ? (this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.I : (this.number == Dictionaries.Number.PLURAL ? Dictionaries.Person.WE : Dictionaries.Person.UNKNOWN)) : (dict.secondPersonPronouns.contains(spanToString) ? Dictionaries.Person.YOU : (dict.thirdPersonPronouns.contains(spanToString) ? (this.gender == Dictionaries.Gender.MALE && this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.HE : (this.gender == Dictionaries.Gender.FEMALE && this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.SHE : ((this.gender == Dictionaries.Gender.NEUTRAL || this.animacy == Dictionaries.Animacy.INANIMATE) && this.number == Dictionaries.Number.SINGULAR ? Dictionaries.Person.IT : (this.number == Dictionaries.Number.PLURAL ? Dictionaries.Person.THEY : Dictionaries.Person.UNKNOWN)))) : Dictionaries.Person.UNKNOWN));
    }

    private void setSemantics(Dictionaries dict, Semantics semantics, MentionExtractor mentionExtractor) throws Exception {
        this.preprocessedTerms = this.preprocessSearchTerm();
        if (dict.statesAbbreviation.containsKey(this.spanToString())) {
            this.preprocessedTerms = new ArrayList<String>();
            this.preprocessedTerms.add(dict.statesAbbreviation.get(this.spanToString()));
        }
        Method meth = semantics.wordnet.getClass().getDeclaredMethod("findSynset", List.class);
        this.synsets = meth.invoke(semantics.wordnet, this.preprocessedTerms);
        if (this.isPronominal()) {
            return;
        }
    }

    private void setType(Dictionaries dict) {
        if (this.headWord.has(CoreAnnotations.EntityTypeAnnotation.class)) {
            this.mentionType = ((String)this.headWord.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("PRO") ? Dictionaries.MentionType.PRONOMINAL : (((String)this.headWord.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("NAM") ? Dictionaries.MentionType.PROPER : Dictionaries.MentionType.NOMINAL);
        } else if (!this.headWord.has(CoreAnnotations.NamedEntityTagAnnotation.class)) {
            this.mentionType = Dictionaries.MentionType.NOMINAL;
            SieveCoreferenceSystem.logger.finest("no NamedEntityTagAnnotation: " + this.headWord);
        } else {
            this.mentionType = ((String)this.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("PRP") || this.originalSpan.size() == 1 && ((String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("O") && (dict.allPronouns.contains(this.headString) || dict.relativePronouns.contains(this.headString)) ? Dictionaries.MentionType.PRONOMINAL : (!((String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("O") || ((String)this.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP") ? Dictionaries.MentionType.PROPER : Dictionaries.MentionType.NOMINAL);
        }
    }

    private void setGender(Dictionaries dict, int[] genderNumberCount) {
        this.gender = Dictionaries.Gender.UNKNOWN;
        if (this.mentionType == Dictionaries.MentionType.PRONOMINAL) {
            if (dict.malePronouns.contains(this.headString)) {
                this.gender = Dictionaries.Gender.MALE;
            } else if (dict.femalePronouns.contains(this.headString)) {
                this.gender = Dictionaries.Gender.FEMALE;
            }
        } else {
            if (this.gender == Dictionaries.Gender.UNKNOWN) {
                if (dict.maleWords.contains(this.headString)) {
                    this.gender = Dictionaries.Gender.MALE;
                    SieveCoreferenceSystem.logger.finest("[Bergsma List] New gender assigned:\tMale:\t" + this.headString);
                } else if (dict.femaleWords.contains(this.headString)) {
                    this.gender = Dictionaries.Gender.FEMALE;
                    SieveCoreferenceSystem.logger.finest("[Bergsma List] New gender assigned:\tFemale:\t" + this.headString);
                } else if (dict.neutralWords.contains(this.headString)) {
                    this.gender = Dictionaries.Gender.NEUTRAL;
                    SieveCoreferenceSystem.logger.finest("[Bergsma List] New gender assigned:\tNeutral:\t" + this.headString);
                }
            }
            if (genderNumberCount != null && this.number != Dictionaries.Number.PLURAL) {
                double male = genderNumberCount[0];
                double female = genderNumberCount[1];
                double neutral = genderNumberCount[2];
                if (male * 0.5 > female + neutral && male > 2.0) {
                    this.gender = Dictionaries.Gender.MALE;
                } else if (female * 0.5 > male + neutral && female > 2.0) {
                    this.gender = Dictionaries.Gender.FEMALE;
                } else if (neutral * 0.5 > male + female && neutral > 2.0) {
                    this.gender = Dictionaries.Gender.NEUTRAL;
                }
            }
        }
    }

    private void setNumber(Dictionaries dict, int[] genderNumberCount) {
        String tag;
        this.number = this.mentionType == Dictionaries.MentionType.PRONOMINAL ? (dict.pluralPronouns.contains(this.headString) ? Dictionaries.Number.PLURAL : (dict.singularPronouns.contains(this.headString) ? Dictionaries.Number.SINGULAR : Dictionaries.Number.UNKNOWN)) : (!this.nerString.equals("O") && this.mentionType != Dictionaries.MentionType.NOMINAL ? (!this.nerString.equals("ORGANIZATION") && !this.nerString.startsWith("ORG") ? Dictionaries.Number.SINGULAR : Dictionaries.Number.UNKNOWN) : ((tag = (String)this.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("N") && tag.endsWith("S") ? Dictionaries.Number.PLURAL : (tag.startsWith("N") ? Dictionaries.Number.SINGULAR : Dictionaries.Number.UNKNOWN)));
        if (this.mentionType != Dictionaries.MentionType.PRONOMINAL) {
            if (this.number == Dictionaries.Number.UNKNOWN) {
                if (dict.singularWords.contains(this.headString)) {
                    this.number = Dictionaries.Number.SINGULAR;
                    SieveCoreferenceSystem.logger.finest("[Bergsma] Number set to:\tSINGULAR:\t" + this.headString);
                } else if (dict.pluralWords.contains(this.headString)) {
                    this.number = Dictionaries.Number.PLURAL;
                    SieveCoreferenceSystem.logger.finest("[Bergsma] Number set to:\tPLURAL:\t" + this.headString);
                }
            }
            String enumerationPattern = "NP < (NP=tmp $.. (/,|CC/ $.. NP))";
            TregexPattern tgrepPattern = TregexPattern.compile(enumerationPattern);
            TregexMatcher m = tgrepPattern.matcher(this.mentionSubTree);
            while (m.find()) {
                if (this.mentionSubTree != m.getNode("tmp") || !this.spanToString().toLowerCase().contains(" and ")) continue;
                this.number = Dictionaries.Number.PLURAL;
            }
        }
    }

    private void setAnimacy(Dictionaries dict) {
        this.animacy = this.mentionType == Dictionaries.MentionType.PRONOMINAL ? (dict.animatePronouns.contains(this.headString) ? Dictionaries.Animacy.ANIMATE : (dict.inanimatePronouns.contains(this.headString) ? Dictionaries.Animacy.INANIMATE : Dictionaries.Animacy.UNKNOWN)) : (this.nerString.equals("PERSON") || this.nerString.startsWith("PER") ? Dictionaries.Animacy.ANIMATE : (this.nerString.equals("LOCATION") || this.nerString.startsWith("LOC") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("MONEY") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("NUMBER") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("PERCENT") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("DATE") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("TIME") ? Dictionaries.Animacy.INANIMATE : (this.nerString.equals("MISC") ? Dictionaries.Animacy.UNKNOWN : (this.nerString.startsWith("VEH") ? Dictionaries.Animacy.UNKNOWN : (this.nerString.startsWith("FAC") ? Dictionaries.Animacy.INANIMATE : (this.nerString.startsWith("GPE") ? Dictionaries.Animacy.INANIMATE : (this.nerString.startsWith("WEA") ? Dictionaries.Animacy.INANIMATE : (this.nerString.startsWith("ORG") ? Dictionaries.Animacy.INANIMATE : Dictionaries.Animacy.UNKNOWN)))))))))))));
        if (this.mentionType != Dictionaries.MentionType.PRONOMINAL && this.animacy == Dictionaries.Animacy.UNKNOWN) {
            if (dict.animateWords.contains(this.headString)) {
                this.animacy = Dictionaries.Animacy.ANIMATE;
                SieveCoreferenceSystem.logger.finest("Assigned Dekang Lin animacy:\tANIMATE:\t" + this.headString);
            } else if (dict.inanimateWords.contains(this.headString)) {
                this.animacy = Dictionaries.Animacy.INANIMATE;
                SieveCoreferenceSystem.logger.finest("Assigned Dekang Lin animacy:\tINANIMATE:\t" + this.headString);
            }
        }
    }

    private static boolean knownSuffix(String s) {
        if (s.endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        for (String suff : commonNESuffixes) {
            if (!suff.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private void setHeadString() {
        this.headString = ((String)this.headWord.get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
        if (this.headWord.has(CoreAnnotations.NamedEntityTagAnnotation.class)) {
            int start = this.headIndex - this.startIndex;
            if (start >= this.originalSpan.size()) {
                throw new RuntimeException("Invalid start index " + start + "=" + this.headIndex + "-" + this.startIndex + ": originalSpan=[" + StringUtils.joinWords(this.originalSpan, " ") + "], head=" + this.headWord);
            }
            while (start >= 0) {
                String head = ((String)this.originalSpan.get(start).get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
                if (!Mention.knownSuffix(head)) {
                    this.headString = head;
                    break;
                }
                --start;
            }
        }
    }

    private void setNERString() {
        this.nerString = this.headWord.has(CoreAnnotations.EntityTypeAnnotation.class) ? (this.headWord.has(CoreAnnotations.NamedEntityTagAnnotation.class) && ((String)this.headWord.get(CoreAnnotations.EntityTypeAnnotation.class)).equals("NAM") ? (String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class) : "O") : (this.headWord.has(CoreAnnotations.NamedEntityTagAnnotation.class) ? (String)this.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class) : "O");
    }

    public boolean sameSentence(Mention m) {
        return m.sentenceWords == this.sentenceWords;
    }

    private static boolean included(CoreLabel small, List<CoreLabel> big) {
        if (small.tag().equals("NNP")) {
            for (CoreLabel w : big) {
                if (!small.word().equals(w.word()) && (small.word().length() <= 2 || !w.word().startsWith(small.word()))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean headsAgree(Mention m) {
        if (!this.nerString.equals("O") && !m.nerString.equals("O") && this.nerString.equals(m.nerString) && (Mention.included(this.headWord, m.originalSpan) || Mention.included(m.headWord, this.originalSpan))) {
            return true;
        }
        return this.headString.equals(m.headString);
    }

    public boolean numbersAgree(Mention m) {
        return this.numbersAgree(m, false);
    }

    private boolean numbersAgree(Mention m, boolean strict) {
        if (strict) {
            return this.number == m.number;
        }
        return this.number == Dictionaries.Number.UNKNOWN || m.number == Dictionaries.Number.UNKNOWN || this.number == m.number;
    }

    public boolean gendersAgree(Mention m) {
        return this.gendersAgree(m, false);
    }

    public boolean gendersAgree(Mention m, boolean strict) {
        if (strict) {
            return this.gender == m.gender;
        }
        return this.gender == Dictionaries.Gender.UNKNOWN || m.gender == Dictionaries.Gender.UNKNOWN || this.gender == m.gender;
    }

    public boolean animaciesAgree(Mention m) {
        return this.animaciesAgree(m, false);
    }

    public boolean animaciesAgree(Mention m, boolean strict) {
        if (strict) {
            return this.animacy == m.animacy;
        }
        return this.animacy == Dictionaries.Animacy.UNKNOWN || m.animacy == Dictionaries.Animacy.UNKNOWN || this.animacy == m.animacy;
    }

    public boolean entityTypesAgree(Mention m, Dictionaries dict) {
        return this.entityTypesAgree(m, dict, false);
    }

    public boolean entityTypesAgree(Mention m, Dictionaries dict, boolean strict) {
        if (strict) {
            return this.nerString.equals(m.nerString);
        }
        if (this.isPronominal()) {
            if (this.nerString.contains("-") || m.nerString.contains("-")) {
                if (m.nerString.equals("O")) {
                    return true;
                }
                if (m.nerString.startsWith("ORG")) {
                    return dict.organizationPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("PER")) {
                    return dict.personPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("LOC")) {
                    return dict.locationPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("GPE")) {
                    return dict.GPEPronouns.contains(this.headString);
                }
                if (m.nerString.startsWith("VEH") || m.nerString.startsWith("FAC") || m.nerString.startsWith("WEA")) {
                    return dict.facilityVehicleWeaponPronouns.contains(this.headString);
                }
                return false;
            }
            if (m.nerString.equals("O")) {
                return true;
            }
            if (m.nerString.equals("MISC")) {
                return true;
            }
            if (m.nerString.equals("ORGANIZATION")) {
                return dict.organizationPronouns.contains(this.headString);
            }
            if (m.nerString.equals("PERSON")) {
                return dict.personPronouns.contains(this.headString);
            }
            if (m.nerString.equals("LOCATION")) {
                return dict.locationPronouns.contains(this.headString);
            }
            if (m.nerString.equals("DATE") || m.nerString.equals("TIME")) {
                return dict.dateTimePronouns.contains(this.headString);
            }
            if (m.nerString.equals("MONEY") || m.nerString.equals("PERCENT") || m.nerString.equals("NUMBER")) {
                return dict.moneyPercentNumberPronouns.contains(this.headString);
            }
            return false;
        }
        return this.nerString.equals("O") || m.nerString.equals("O") || this.nerString.equals(m.nerString);
    }

    public boolean includedIn(Mention m) {
        if (!m.sameSentence(this)) {
            return false;
        }
        if (this.startIndex < m.startIndex || this.endIndex > m.endIndex) {
            return false;
        }
        for (Tree t : m.mentionSubTree.subTrees()) {
            if (t != this.mentionSubTree) continue;
            return true;
        }
        return false;
    }

    public boolean attributesAgree(Mention potentialAntecedent, Dictionaries dict) {
        return this.animaciesAgree(potentialAntecedent) && this.entityTypesAgree(potentialAntecedent, dict) && this.gendersAgree(potentialAntecedent) && this.numbersAgree(potentialAntecedent);
    }

    public void addApposition(Mention m) {
        if (this.appositions == null) {
            this.appositions = new HashSet<Mention>();
        }
        this.appositions.add(m);
    }

    public boolean isApposition(Mention m) {
        return this.appositions != null && this.appositions.contains(m);
    }

    public void addPredicateNominatives(Mention m) {
        if (this.predicateNominatives == null) {
            this.predicateNominatives = new HashSet<Mention>();
        }
        this.predicateNominatives.add(m);
    }

    public boolean isPredicateNominatives(Mention m) {
        return this.predicateNominatives != null && this.predicateNominatives.contains(m);
    }

    public void addRelativePronoun(Mention m) {
        if (this.relativePronouns == null) {
            this.relativePronouns = new HashSet<Mention>();
        }
        this.relativePronouns.add(m);
    }

    public boolean isRelativePronoun(Mention m) {
        return this.relativePronouns != null && this.relativePronouns.contains(m);
    }

    public boolean isAcronym(Mention m) {
        String s1 = this.spanToString();
        String s2 = m.spanToString();
        String acronym = "";
        if (s1.length() > s2.length()) {
            String temp = s1;
            s1 = s2;
            s2 = temp;
        }
        for (int i = 0; i < s2.length(); ++i) {
            if (s2.charAt(i) < 'A' || s2.charAt(i) > 'Z') continue;
            acronym = acronym + s2.charAt(i);
        }
        return acronym.equals(s1) && !s2.contains(s1);
    }

    public boolean isRoleAppositive(Mention m, Dictionaries dict) {
        String thisString = this.spanToString();
        if (this.isPronominal() || dict.allPronouns.contains(thisString.toLowerCase())) {
            return false;
        }
        if (!m.nerString.startsWith("PER") && !m.nerString.equals("O")) {
            return false;
        }
        if (!this.nerString.startsWith("PER") && !this.nerString.equals("O")) {
            return false;
        }
        if (!this.sameSentence(m) || !m.spanToString().startsWith(thisString)) {
            return false;
        }
        if (m.spanToString().contains("'") || m.spanToString().contains(" and ")) {
            return false;
        }
        if (!this.animaciesAgree(m) || this.animacy == Dictionaries.Animacy.INANIMATE || this.gender == Dictionaries.Gender.NEUTRAL || m.gender == Dictionaries.Gender.NEUTRAL || !this.numbersAgree(m)) {
            return false;
        }
        return !dict.demonymSet.contains(thisString.toLowerCase()) && !dict.demonymSet.contains(m.spanToString().toLowerCase());
    }

    public boolean isDemonym(Mention m, Dictionaries dict) {
        String thisString = this.spanToString().toLowerCase();
        String antString = m.spanToString().toLowerCase();
        if (thisString.startsWith("the ") || thisString.startsWith("The ")) {
            thisString = thisString.substring(4);
        }
        if (antString.startsWith("the ") || antString.startsWith("The ")) {
            antString = antString.substring(4);
        }
        if (dict.statesAbbreviation.containsKey(m.spanToString()) && dict.statesAbbreviation.get(m.spanToString()).equals(this.spanToString()) || dict.statesAbbreviation.containsKey(this.spanToString()) && dict.statesAbbreviation.get(this.spanToString()).equals(m.spanToString())) {
            return true;
        }
        return dict.demonyms.get(thisString) != null ? dict.demonyms.get(thisString).contains(antString) : dict.demonyms.get(antString) != null && dict.demonyms.get(antString).contains(thisString);
    }

    public static boolean iWithini(Mention m1, Mention m2, Dictionaries dict) {
        return !m1.isApposition(m2) && !m2.isApposition(m1) && !m1.isRelativePronoun(m2) && !m2.isRelativePronoun(m1) && !m1.isRoleAppositive(m2, dict) && !m2.isRoleAppositive(m1, dict) && (m1.includedIn(m2) || m2.includedIn(m1));
    }

    public boolean haveIncompatibleModifier(Mention ant) {
        if (!ant.headString.equalsIgnoreCase(this.headString)) {
            return false;
        }
        boolean thisHasExtra = false;
        int lengthThis = this.originalSpan.size();
        int lengthM = ant.originalSpan.size();
        HashSet<String> thisWordSet = new HashSet<String>();
        HashSet<String> antWordSet = new HashSet<String>();
        HashSet<String> locationModifier = new HashSet<String>(Arrays.asList("east", "west", "north", "south", "eastern", "western", "northern", "southern", "upper", "lower"));
        for (int i = 0; i < lengthThis; ++i) {
            String w1 = ((String)this.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
            String pos1 = (String)this.originalSpan.get(i).get(CoreAnnotations.PartOfSpeechAnnotation.class);
            if (!pos1.startsWith("N") && !pos1.startsWith("JJ") && !pos1.equals("CD") && !pos1.startsWith("V") || w1.equalsIgnoreCase(this.headString)) continue;
            thisWordSet.add(w1);
        }
        for (int j = 0; j < lengthM; ++j) {
            String w2 = ((String)ant.originalSpan.get(j).get(CoreAnnotations.TextAnnotation.class)).toLowerCase();
            antWordSet.add(w2);
        }
        for (String w : thisWordSet) {
            if (antWordSet.contains(w)) continue;
            thisHasExtra = true;
        }
        boolean hasLocationModifier = false;
        for (String l : locationModifier) {
            if (!antWordSet.contains(l) || thisWordSet.contains(l)) continue;
            hasLocationModifier = true;
        }
        return thisHasExtra || hasLocationModifier;
    }

    public boolean appearEarlierThan(Mention m) {
        if (this.sentNum < m.sentNum) {
            return true;
        }
        if (this.sentNum > m.sentNum) {
            return false;
        }
        if (this.startIndex < m.startIndex) {
            return true;
        }
        if (this.startIndex > m.startIndex) {
            return false;
        }
        return this.endIndex > m.endIndex;
    }

    public static boolean haveDifferentLocation(Mention m, Mention a, Dictionaries dict) {
        String loc;
        if ((dict.statesAbbreviation.containsKey(a.spanToString()) || dict.statesAbbreviation.containsValue(a.spanToString())) && (m.headString.equalsIgnoreCase("country") || m.headString.equalsIgnoreCase("nation"))) {
            return true;
        }
        HashSet<String> locationM = new HashSet<String>();
        HashSet<String> locationA = new HashSet<String>();
        String mString = m.spanToString().toLowerCase();
        String aString = a.spanToString().toLowerCase();
        HashSet<String> locationModifier = new HashSet<String>(Arrays.asList("east", "west", "north", "south", "eastern", "western", "northern", "southern", "northwestern", "southwestern", "northeastern", "southeastern", "upper", "lower"));
        for (CoreLabel w : m.originalSpan) {
            if (locationModifier.contains(((String)w.get(CoreAnnotations.TextAnnotation.class)).toLowerCase())) {
                return true;
            }
            if (!((String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("LOCATION")) continue;
            loc = (String)w.get(CoreAnnotations.TextAnnotation.class);
            if (dict.statesAbbreviation.containsKey(loc)) {
                loc = dict.statesAbbreviation.get(loc);
            }
            locationM.add(loc);
        }
        for (CoreLabel w : a.originalSpan) {
            if (locationModifier.contains(((String)w.get(CoreAnnotations.TextAnnotation.class)).toLowerCase())) {
                return true;
            }
            if (!((String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("LOCATION")) continue;
            loc = (String)w.get(CoreAnnotations.TextAnnotation.class);
            if (dict.statesAbbreviation.containsKey(loc)) {
                loc = dict.statesAbbreviation.get(loc);
            }
            locationA.add(loc);
        }
        boolean mHasExtra = false;
        boolean aHasExtra = false;
        for (String s : locationM) {
            if (aString.contains(s.toLowerCase())) continue;
            mHasExtra = true;
        }
        for (String s : locationA) {
            if (mString.contains(s.toLowerCase())) continue;
            aHasExtra = true;
        }
        return mHasExtra && aHasExtra;
    }

    public static boolean sameProperHeadLastWord(Mention m, Mention a) {
        if (!(m.headString.equalsIgnoreCase(a.headString) && ((String)m.sentenceWords.get(m.headIndex).get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP") && ((String)a.sentenceWords.get(a.headIndex).get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP"))) {
            return false;
        }
        if (!m.removePhraseAfterHead().toLowerCase().endsWith(m.headString) || !a.removePhraseAfterHead().toLowerCase().endsWith(a.headString)) {
            return false;
        }
        HashSet mProperNouns = new HashSet();
        HashSet aProperNouns = new HashSet();
        for (CoreLabel w : m.sentenceWords.subList(m.startIndex, m.headIndex)) {
            if (!((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP")) continue;
            mProperNouns.add(w.get(CoreAnnotations.TextAnnotation.class));
        }
        for (CoreLabel w : a.sentenceWords.subList(a.startIndex, a.headIndex)) {
            if (!((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP")) continue;
            aProperNouns.add(w.get(CoreAnnotations.TextAnnotation.class));
        }
        boolean mHasExtra = false;
        boolean aHasExtra = false;
        for (String s : mProperNouns) {
            if (aProperNouns.contains(s)) continue;
            mHasExtra = true;
        }
        for (String s : aProperNouns) {
            if (mProperNouns.contains(s)) continue;
            aHasExtra = true;
        }
        return !mHasExtra || !aHasExtra;
    }

    public String removePhraseAfterHead() {
        String removed = "";
        int posComma = -1;
        int posWH = -1;
        for (int i = 0; i < this.originalSpan.size(); ++i) {
            CoreLabel w = this.originalSpan.get(i);
            if (posComma == -1 && ((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals(",")) {
                posComma = this.startIndex + i;
            }
            if (posWH != -1 || !((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("W")) continue;
            posWH = this.startIndex + i;
        }
        if (posComma != -1 && this.headIndex < posComma) {
            StringBuilder os = new StringBuilder();
            for (int i = 0; i < posComma - this.startIndex; ++i) {
                if (i > 0) {
                    os.append(" ");
                }
                os.append((String)this.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class));
            }
            removed = os.toString();
        }
        if (posComma == -1 && posWH != -1 && this.headIndex < posWH) {
            StringBuilder os = new StringBuilder();
            for (int i = 0; i < posWH - this.startIndex; ++i) {
                if (i > 0) {
                    os.append(" ");
                }
                os.append((String)this.originalSpan.get(i).get(CoreAnnotations.TextAnnotation.class));
            }
            removed = os.toString();
        }
        if (posComma == -1 && posWH == -1) {
            removed = this.spanToString();
        }
        return removed;
    }

    public static boolean numberInLaterMention(Mention mention, Mention ant) {
        HashSet antecedentWords = new HashSet();
        HashSet<String> numbers = new HashSet<String>(Arrays.asList("one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "hundred", "thousand", "million", "billion"));
        for (CoreLabel w : ant.originalSpan) {
            antecedentWords.add(w.get(CoreAnnotations.TextAnnotation.class));
        }
        for (CoreLabel w : mention.originalSpan) {
            String word = (String)w.get(CoreAnnotations.TextAnnotation.class);
            try {
                Double.parseDouble(word);
                if (antecedentWords.contains(word)) continue;
                return true;
            }
            catch (NumberFormatException e) {
                if (!numbers.contains(word.toLowerCase()) || antecedentWords.contains(word)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean haveExtraProperNoun(Mention m, Mention a, Set<String> exceptWords) {
        HashSet mProper = new HashSet();
        HashSet aProper = new HashSet();
        String mString = m.spanToString();
        String aString = a.spanToString();
        for (CoreLabel w : m.originalSpan) {
            if (!((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP")) continue;
            mProper.add(w.get(CoreAnnotations.TextAnnotation.class));
        }
        for (CoreLabel w : a.originalSpan) {
            if (!((String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP")) continue;
            aProper.add(w.get(CoreAnnotations.TextAnnotation.class));
        }
        boolean mHasExtra = false;
        boolean aHasExtra = false;
        for (String s : mProper) {
            if (aString.contains(s) || exceptWords.contains(s.toLowerCase())) continue;
            mHasExtra = true;
        }
        for (String s : aProper) {
            if (mString.contains(s) || exceptWords.contains(s.toLowerCase())) continue;
            aHasExtra = true;
        }
        return mHasExtra && aHasExtra;
    }

    public String longestNNPEndsWithHead() {
        String pos;
        String ret = "";
        for (int i = this.headIndex; i >= this.startIndex && (pos = (String)this.sentenceWords.get(i).get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP"); --i) {
            if (!ret.equals("")) {
                ret = " " + ret;
            }
            ret = (String)this.sentenceWords.get(i).get(CoreAnnotations.TextAnnotation.class) + ret;
        }
        return ret;
    }

    public String lowestNPIncludesHead() {
        String s;
        Tree head;
        String ret = "";
        Tree lowestNP = head = (Tree)this.contextParseTree.getLeaves().get(this.headIndex);
        while (true) {
            if (lowestNP == null) {
                return ret;
            }
            s = (String)((CoreLabel)lowestNP.label()).get(CoreAnnotations.ValueAnnotation.class);
            if (s.equals("NP") || s.equals("ROOT")) break;
            lowestNP = lowestNP.ancestor(1, this.contextParseTree);
        }
        if (s.equals("ROOT")) {
            lowestNP = head;
        }
        for (Tree t : lowestNP.getLeaves()) {
            if (!ret.equals("")) {
                ret = ret + " ";
            }
            ret = ret + (String)((CoreLabel)t.label()).get(CoreAnnotations.TextAnnotation.class);
        }
        if (!this.spanToString().contains(ret)) {
            return (String)this.sentenceWords.get(this.headIndex).get(CoreAnnotations.TextAnnotation.class);
        }
        return ret;
    }

    public String stringWithoutArticle(String str) {
        String ret;
        String string = ret = str == null ? this.spanToString() : str;
        if (ret.startsWith("a ") || ret.startsWith("A ")) {
            return ret.substring(2);
        }
        if (ret.startsWith("an ") || ret.startsWith("An ")) {
            return ret.substring(3);
        }
        if (ret.startsWith("the ") || ret.startsWith("The ")) {
            return ret.substring(4);
        }
        return ret;
    }

    public List<String> preprocessSearchTerm() {
        ArrayList<String> searchTerms = new ArrayList<String>();
        String[] terms = new String[]{this.stringWithoutArticle(this.removePhraseAfterHead()), this.stringWithoutArticle(this.lowestNPIncludesHead()), this.stringWithoutArticle(this.longestNNPEndsWithHead()), this.headString};
        for (String term : terms) {
            if (term.contains("\"")) {
                term = term.replace("\"", "\\\"");
            }
            if (term.contains("(")) {
                term = term.replace("(", "\\(");
            }
            if (term.contains(")")) {
                term = term.replace(")", "\\)");
            }
            if (term.contains("!")) {
                term = term.replace("!", "\\!");
            }
            if (term.contains(":")) {
                term = term.replace(":", "\\:");
            }
            if (term.contains("+")) {
                term = term.replace("+", "\\+");
            }
            if (term.contains("-")) {
                term = term.replace("-", "\\-");
            }
            if (term.contains("~")) {
                term = term.replace("~", "\\~");
            }
            if (term.contains("*")) {
                term = term.replace("*", "\\*");
            }
            if (term.contains("[")) {
                term = term.replace("[", "\\[");
            }
            if (term.contains("]")) {
                term = term.replace("]", "\\]");
            }
            if (term.contains("^")) {
                term = term.replace("^", "\\^");
            }
            if (term.equals("") || term.equals("") || searchTerms.contains(term) || term.equals(terms[3]) && !terms[2].equals("")) continue;
            searchTerms.add(term);
        }
        return searchTerms;
    }

    public String buildQueryText(List<String> terms) {
        String query = "";
        for (String t : terms) {
            query = query + t + " ";
        }
        return query.trim();
    }

    public static String removeParenthesis(String text) {
        if (text.split("\\(").length > 0) {
            return text.split("\\(")[0].trim();
        }
        return "";
    }

    protected boolean isTheCommonNoun() {
        return this.mentionType == Dictionaries.MentionType.NOMINAL && this.spanToString().toLowerCase().startsWith("the ") && this.spanToString().split(" ").length == 2;
    }

    public static boolean isSpeaker(Document document, Mention mention, Mention ant, Dictionaries dict) {
        if (document.speakerPairs.contains(new Pair<Integer, Integer>(mention.mentionID, ant.mentionID)) || document.speakerPairs.contains(new Pair<Integer, Integer>(ant.mentionID, mention.mentionID))) {
            return true;
        }
        if (mention.headWord.containsKey(CoreAnnotations.SpeakerAnnotation.class)) {
            for (String s : ((String)mention.headWord.get(CoreAnnotations.SpeakerAnnotation.class)).split(" ")) {
                if (!ant.headString.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        if (ant.headWord.containsKey(CoreAnnotations.SpeakerAnnotation.class)) {
            for (String s : ((String)ant.headWord.get(CoreAnnotations.SpeakerAnnotation.class)).split(" ")) {
                if (!mention.headString.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean personDisagree(Document document, Mention m, Mention ant, Dictionaries dict) {
        int previousSpeakerID;
        boolean sameSpeaker = Mention.sameSpeaker(document, m, ant);
        if (sameSpeaker && m.person != ant.person) {
            if (m.person == Dictionaries.Person.IT && ant.person == Dictionaries.Person.THEY || m.person == Dictionaries.Person.THEY && ant.person == Dictionaries.Person.IT || m.person == Dictionaries.Person.THEY && ant.person == Dictionaries.Person.THEY) {
                return false;
            }
            if (m.person != Dictionaries.Person.UNKNOWN && ant.person != Dictionaries.Person.UNKNOWN) {
                return true;
            }
        }
        if (sameSpeaker && (!ant.isPronominal() ? m.person == Dictionaries.Person.I || m.person == Dictionaries.Person.WE || m.person == Dictionaries.Person.YOU : !m.isPronominal() && (ant.person == Dictionaries.Person.I || ant.person == Dictionaries.Person.WE || ant.person == Dictionaries.Person.YOU))) {
            return true;
        }
        if (m.person == Dictionaries.Person.YOU && ant.appearEarlierThan(m)) {
            int previousSpeakerID2;
            int mUtter = (Integer)m.headWord.get(CoreAnnotations.UtteranceAnnotation.class);
            if (!document.speakers.containsKey(mUtter - 1)) return true;
            String previousSpeaker = document.speakers.get(mUtter - 1);
            try {
                previousSpeakerID2 = Integer.parseInt(previousSpeaker);
            }
            catch (Exception e) {
                return true;
            }
            if (ant.corefClusterID == document.allPredictedMentions.get((Object)Integer.valueOf((int)previousSpeakerID2)).corefClusterID || ant.person == Dictionaries.Person.I) return false;
            return true;
        }
        if (ant.person != Dictionaries.Person.YOU || !m.appearEarlierThan(ant)) return false;
        int aUtter = (Integer)ant.headWord.get(CoreAnnotations.UtteranceAnnotation.class);
        if (!document.speakers.containsKey(aUtter - 1)) return true;
        String previousSpeaker = document.speakers.get(aUtter - 1);
        try {
            previousSpeakerID = Integer.parseInt(previousSpeaker);
        }
        catch (Exception e) {
            return true;
        }
        if (m.corefClusterID == document.allPredictedMentions.get((Object)Integer.valueOf((int)previousSpeakerID)).corefClusterID || m.person == Dictionaries.Person.I) return false;
        return true;
    }

    public static boolean sameSpeaker(Document document, Mention m, Mention ant) {
        int antSpeakerID;
        int mSpeakerID;
        if (!m.headWord.containsKey(CoreAnnotations.SpeakerAnnotation.class) || !ant.headWord.containsKey(CoreAnnotations.SpeakerAnnotation.class)) {
            return false;
        }
        try {
            mSpeakerID = Integer.parseInt((String)m.headWord.get(CoreAnnotations.SpeakerAnnotation.class));
            antSpeakerID = Integer.parseInt((String)ant.headWord.get(CoreAnnotations.SpeakerAnnotation.class));
        }
        catch (Exception e) {
            return ((String)m.headWord.get(CoreAnnotations.SpeakerAnnotation.class)).equals(ant.headWord.get(CoreAnnotations.SpeakerAnnotation.class));
        }
        int mSpeakerClusterID = document.allPredictedMentions.get((Object)Integer.valueOf((int)mSpeakerID)).corefClusterID;
        int antSpeakerClusterID = document.allPredictedMentions.get((Object)Integer.valueOf((int)antSpeakerID)).corefClusterID;
        return mSpeakerClusterID == antSpeakerClusterID;
    }

    public static boolean subjectObject(Mention m1, Mention m2) {
        if (m1.sentNum != m2.sentNum) {
            return false;
        }
        if (m1.dependingVerb == null || m2.dependingVerb == null) {
            return false;
        }
        return m1.dependingVerb == m2.dependingVerb && (m1.isSubject && (m2.isDirectObject || m2.isIndirectObject || m2.isPrepositionObject) || m2.isSubject && (m1.isDirectObject || m1.isIndirectObject || m1.isPrepositionObject));
    }

    private static Pair<IndexedWord, String> findDependentVerb(Mention m) {
        Pair<IndexedWord, String> ret = new Pair<IndexedWord, String>();
        int headIndex = m.headIndex + 1;
        try {
            ArrayCoreMap w = m.dependency.getNodeByIndex(headIndex);
            if (w == null) {
                return ret;
            }
            while (true) {
                ArrayCoreMap p = null;
                for (Pair<GrammaticalRelation, IndexedWord> parent : m.dependency.parentPairs((IndexedWord)w)) {
                    if (ret.second() == null) {
                        String relation = parent.first().getShortName();
                        ret.setSecond(relation);
                    }
                    p = parent.second();
                }
                if (p == null || ((String)p.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("V")) {
                    ret.setFirst((IndexedWord)p);
                    break;
                }
                if (w == p) {
                    return ret;
                }
                w = p;
            }
        }
        catch (Exception e) {
            return ret;
        }
        return ret;
    }

    public boolean insideIn(Mention m) {
        return this.sentNum == m.sentNum && m.startIndex <= this.startIndex && this.endIndex <= m.endIndex;
    }

    protected boolean moreRepresentativeThan(Mention m) {
        if (m == null) {
            return true;
        }
        if (this.mentionType != m.mentionType) {
            return this.mentionType == Dictionaries.MentionType.PROPER && m.mentionType != Dictionaries.MentionType.PROPER || this.mentionType == Dictionaries.MentionType.NOMINAL && m.mentionType == Dictionaries.MentionType.PRONOMINAL;
        }
        if (this.headIndex - this.startIndex > m.headIndex - m.startIndex) {
            return true;
        }
        return this.sentNum < m.sentNum || this.sentNum == m.sentNum && this.headIndex < m.headIndex;
    }
}

