/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorFactory;
import java.util.HashMap;
import java.util.Map;

public class AnnotatorPool {
    private final Map<String, Annotator> annotators = new HashMap<String, Annotator>();
    private final Map<String, AnnotatorFactory> factories = new HashMap<String, AnnotatorFactory>();

    public boolean register(String name, AnnotatorFactory factory) {
        boolean newAnnotator = false;
        if (this.factories.containsKey(name)) {
            String newSig;
            AnnotatorFactory oldFactory = this.factories.get(name);
            String oldSig = oldFactory.signature();
            if (!oldSig.equals(newSig = factory.signature())) {
                System.err.println("Replacing old annotator \"" + name + "\" with signature [" + oldSig + "] with new annotator with signature [" + newSig + "]");
                this.factories.put(name, factory);
                newAnnotator = true;
                this.annotators.remove(name);
            }
        } else {
            this.factories.put(name, factory);
        }
        return newAnnotator;
    }

    public synchronized Annotator get(String name) {
        if (!this.annotators.containsKey(name)) {
            AnnotatorFactory factory = this.factories.get(name);
            if (factory == null) {
                throw new IllegalArgumentException("No annotator named " + name);
            }
            this.annotators.put(name, factory.create());
        }
        return this.annotators.get(name);
    }
}

