/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Characters;
import java.util.Arrays;

public class EditDistance {
    final boolean allowTranspose;
    protected double[][] score = null;

    public EditDistance() {
        this.allowTranspose = true;
    }

    public EditDistance(boolean allowTranspose) {
        this.allowTranspose = allowTranspose;
    }

    protected void clear(int sourceLength, int targetLength) {
        if (this.score == null || this.score.length < sourceLength + 1 || this.score[0].length < targetLength + 1) {
            this.score = new double[sourceLength + 1][targetLength + 1];
        }
        for (int i = 0; i < this.score.length; ++i) {
            Arrays.fill(this.score[i], this.worst());
        }
    }

    protected double best() {
        return 0.0;
    }

    protected double worst() {
        return Double.POSITIVE_INFINITY;
    }

    protected double unit() {
        return 1.0;
    }

    protected double better(double x, double y) {
        if (x < y) {
            return x;
        }
        return y;
    }

    protected double combine(double x, double y) {
        return x + y;
    }

    protected double insertCost(Object o) {
        return this.unit();
    }

    protected double deleteCost(Object o) {
        return this.unit();
    }

    protected double substituteCost(Object source, Object target) {
        if (source.equals(target)) {
            return this.best();
        }
        return this.unit();
    }

    double transposeCost(Object s1, Object s2, Object t1, Object t2) {
        if (s1.equals(t2) && s2.equals(t1)) {
            if (this.allowTranspose) {
                return this.unit();
            }
            return 2.0 * this.unit();
        }
        return this.worst();
    }

    double score(Object[] source, int sPos, Object[] target, int tPos) {
        for (int i = 0; i <= sPos; ++i) {
            for (int j = 0; j <= tPos; ++j) {
                double bscore = this.score[i][j];
                if (bscore != this.worst()) continue;
                if (i == 0 && j == 0) {
                    bscore = this.best();
                } else {
                    if (i > 0) {
                        bscore = this.better(bscore, this.combine(this.score[i - 1][j], this.deleteCost(source[i - 1])));
                    }
                    if (j > 0) {
                        bscore = this.better(bscore, this.combine(this.score[i][j - 1], this.insertCost(target[j - 1])));
                    }
                    if (i > 0 && j > 0) {
                        bscore = this.better(bscore, this.combine(this.score[i - 1][j - 1], this.substituteCost(source[i - 1], target[j - 1])));
                    }
                    if (i > 1 && j > 1) {
                        bscore = this.better(bscore, this.combine(this.score[i - 2][j - 2], this.transposeCost(source[i - 2], source[i - 1], target[j - 2], target[j - 1])));
                    }
                }
                this.score[i][j] = bscore;
            }
        }
        return this.score[sPos][tPos];
    }

    public double score(Object[] source, Object[] target) {
        this.clear(source.length, target.length);
        return this.score(source, source.length, target, target.length);
    }

    public double score(String sourceStr, String targetStr) {
        Object[] source = Characters.asCharacterArray(sourceStr);
        Object[] target = Characters.asCharacterArray(targetStr);
        this.clear(source.length, target.length);
        return this.score(source, source.length, target, target.length);
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            EditDistance d = new EditDistance();
            System.out.println(d.score(args[0], args[1]));
        } else {
            System.err.println("usage: java EditDistance str1 str2");
        }
    }
}

