/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.function;

import java.util.Iterator;
import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.Function;
import nu.xom.jaxen.FunctionCallException;
import nu.xom.jaxen.Navigator;
import nu.xom.jaxen.function.StringFunction;

public class NumberFunction
implements Function {
    private static final Double NaN = new Double(Double.NaN);

    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() == 1) {
            return NumberFunction.evaluate(list.get(0), context.getNavigator());
        }
        if (list.size() == 0) {
            return NumberFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        throw new FunctionCallException("number() takes at most one argument.");
    }

    public static Double evaluate(Object object, Navigator navigator) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                Double d = new Double(string);
                return d;
            }
            catch (NumberFormatException numberFormatException) {
                return NaN;
            }
        }
        if (object instanceof List || object instanceof Iterator) {
            return NumberFunction.evaluate(StringFunction.evaluate(object, navigator), navigator);
        }
        if (navigator.isElement(object) || navigator.isAttribute(object) || navigator.isText(object) || navigator.isComment(object) || navigator.isProcessingInstruction(object) || navigator.isDocument(object) || navigator.isNamespace(object)) {
            return NumberFunction.evaluate(StringFunction.evaluate(object, navigator), navigator);
        }
        if (object instanceof Boolean) {
            if (object == Boolean.TRUE) {
                return new Double(1.0);
            }
            return new Double(0.0);
        }
        return NaN;
    }

    public static boolean isNaN(double d) {
        return Double.isNaN(d);
    }

    public static boolean isNaN(Double d) {
        return d.equals(NaN);
    }
}

