
package Google::Ads::AdWords::v201206::BulkMutateJobService::mutate;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201206' }

__PACKAGE__->__set_name('mutate');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    Google::Ads::SOAP::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %operation_of :ATTR(:get<operation>);

__PACKAGE__->_factory(
    [ qw(        operation

    ) ],
    {
        'operation' => \%operation_of,
    },
    {
        'operation' => 'Google::Ads::AdWords::v201206::JobOperation',
    },
    {

        'operation' => 'operation',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

Google::Ads::AdWords::v201206::BulkMutateJobService::mutate

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
mutate from the namespace https://adwords.google.com/api/adwords/cm/v201206.

Adds or updates a bulk mutate job. <p>Use the &laquo;ADD&raquo; operator to submit a new job, and the &laquo;SET&raquo; operator to add additional {@linkplain BulkMutateRequest request parts} to an existing job. The &laquo;DELETE&raquo; operator is not supported. From v201008 and later, use the &laquo;REMOVE&raquo; operator to cancel a job. Only jobs that still have pending additions of request parts may be canceled.</p> <p class="note"><b>Note:</b> In the current implementation, the check for duplicate job keys is only "best effort", and may not prevent jobs with the same keys from being accepted if they are submitted around the same instant.</p> @param operation The operation to perform. @throws ApiException if problems occurred while creating or updating jobs @return The added or updated bulk mutate job. 





=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * operation

 $element->set_operation($data);
 $element->get_operation();





=back


=head1 METHODS

=head2 new

 my $element = Google::Ads::AdWords::v201206::BulkMutateJobService::mutate->new($data);

Constructor. The following data structure may be passed to new():

 {
   operation =>  $a_reference_to, # see Google::Ads::AdWords::v201206::JobOperation
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

