## This file was generated by the Great and Powerful Trixie
use NativeCall;
unit module Gumbo::Binding;
sub GenMyLibName {
  use NativeCall :TEST;
  %*ENV<PERL6_GUMBOLIB> || guess_library_name(("gumbo", Version.new('1')))}
constant LIB = &GenMyLibName;

our $GUMBO_LIB is export = LIB;
## Enumerations

# == /usr/local/include/gumbo.h ==

enum GumboAttributeNamespaceEnum is export (
   GUMBO_ATTR_NAMESPACE_NONE => 0,
   GUMBO_ATTR_NAMESPACE_XLINK => 1,
   GUMBO_ATTR_NAMESPACE_XML => 2,
   GUMBO_ATTR_NAMESPACE_XMLNS => 3
);
enum GumboNodeType is export (
   GUMBO_NODE_DOCUMENT => 0,
   GUMBO_NODE_ELEMENT => 1,
   GUMBO_NODE_TEXT => 2,
   GUMBO_NODE_CDATA => 3,
   GUMBO_NODE_COMMENT => 4,
   GUMBO_NODE_WHITESPACE => 5,
   GUMBO_NODE_TEMPLATE => 6
);
enum GumboQuirksModeEnum is export (
   GUMBO_DOCTYPE_NO_QUIRKS => 0,
   GUMBO_DOCTYPE_QUIRKS => 1,
   GUMBO_DOCTYPE_LIMITED_QUIRKS => 2
);
enum GumboNamespaceEnum is export (
   GUMBO_NAMESPACE_HTML => 0,
   GUMBO_NAMESPACE_SVG => 1,
   GUMBO_NAMESPACE_MATHML => 2
);
enum GumboParseFlags is export (
   GUMBO_INSERTION_NORMAL => 0,
   GUMBO_INSERTION_BY_PARSER => 1,
   GUMBO_INSERTION_IMPLICIT_END_TAG => 2,
   GUMBO_INSERTION_IMPLIED => 8,
   GUMBO_INSERTION_CONVERTED_FROM_END_TAG => 16,
   GUMBO_INSERTION_FROM_ISINDEX => 32,
   GUMBO_INSERTION_FROM_IMAGE => 64,
   GUMBO_INSERTION_RECONSTRUCTED_FORMATTING_ELEMENT => 128,
   GUMBO_INSERTION_ADOPTION_AGENCY_CLONED => 256,
   GUMBO_INSERTION_ADOPTION_AGENCY_MOVED => 512,
   GUMBO_INSERTION_FOSTER_PARENTED => 1024
);

## Structures


# == /usr/local/include/gumbo.h ==

class GumboSourcePosition is repr('CStruct') is export {
	has uint32                        $.line; # unsigned int line
	has uint32                        $.column; # unsigned int column
	has uint32                        $.offset; # unsigned int offset
}
class GumboStringPiece is repr('CStruct') is export {
	has Str                           $.data; # const char* data
	has size_t                        $.length; # Typedef<size_t>->|unsigned int| length
}
class GumboVector is repr('CStruct') is export {
	has Pointer[Pointer]              $.data; # void** data
	has uint32                        $.length; # unsigned int length
	has uint32                        $.capacity; # unsigned int capacity
}
class GumboAttribute is repr('CStruct') is export {
	has int32                         $.attr_namespace; # GumboAttributeNamespaceEnum attr_namespace
	has Str                           $.name; # const char* name
	HAS GumboStringPiece              $.original_name; # GumboStringPiece original_name
	has Str                           $.value; # const char* value
	HAS GumboStringPiece              $.original_value; # GumboStringPiece original_value
	HAS GumboSourcePosition           $.name_start; # GumboSourcePosition name_start
	HAS GumboSourcePosition           $.name_end; # GumboSourcePosition name_end
	HAS GumboSourcePosition           $.value_start; # GumboSourcePosition value_start
	HAS GumboSourcePosition           $.value_end; # GumboSourcePosition value_end
}
class GumboDocument is repr('CStruct') is export {
	HAS GumboVector                   $.children; # GumboVector children
	has bool                          $.has_doctype; # bool has_doctype
	has Str                           $.name; # const char* name
	has Str                           $.public_identifier; # const char* public_identifier
	has Str                           $.system_identifier; # const char* system_identifier
	has int32                         $.doc_type_quirks_mode; # GumboQuirksModeEnum doc_type_quirks_mode
}
class GumboText is repr('CStruct') is export {
	has Str                           $.text; # const char* text
	HAS GumboStringPiece              $.original_text; # GumboStringPiece original_text
	HAS GumboSourcePosition           $.start_pos; # GumboSourcePosition start_pos
}
class GumboElement is repr('CStruct') is export {
	HAS GumboVector                   $.children; # GumboVector children
	has int32                         $.tag; # GumboTag tag
	has int32                         $.tag_namespace; # GumboNamespaceEnum tag_namespace
	HAS GumboStringPiece              $.original_tag; # GumboStringPiece original_tag
	HAS GumboStringPiece              $.original_end_tag; # GumboStringPiece original_end_tag
	HAS GumboSourcePosition           $.start_pos; # GumboSourcePosition start_pos
	HAS GumboSourcePosition           $.end_pos; # GumboSourcePosition end_pos
	HAS GumboVector                   $.attributes; # GumboVector attributes
}
class GumboNode_v_Union is repr('CUnion') is export {
	HAS GumboDocument                 $.document; # GumboDocument document
	HAS GumboElement                  $.element; # GumboElement element
	HAS GumboText                     $.text; # GumboText text
}
class GumboNode is repr('CStruct') is export {
	has int32                         $.type; # GumboNodeType type
	has GumboNode                     $.parent; # Typedef<GumboNode>->|GumboNode|* parent
	has size_t                        $.index_within_parent; # Typedef<size_t>->|unsigned int| index_within_parent
	has int32                         $.parse_flags; # GumboParseFlags parse_flags
	HAS GumboNode_v_Union             $.v; # Union v
}
class GumboOptions is repr('CStruct') is export {
	has Pointer                       $.allocator; # Typedef<GumboAllocatorFunction>->|F:void* ( void*, Typedef<size_t>->|unsigned int|)*| allocator
	has Pointer                       $.deallocator; # Typedef<GumboDeallocatorFunction>->|F:void ( void*, void*)*| deallocator
	has Pointer                       $.userdata; # void* userdata
	has int32                         $.tab_stop; # int tab_stop
	has bool                          $.stop_on_first_error; # bool stop_on_first_error
	has int32                         $.max_errors; # int max_errors
	has int32                         $.fragment_context; # GumboTag fragment_context
	has int32                         $.fragment_namespace; # GumboNamespaceEnum fragment_namespace
}
class GumboOutput is repr('CStruct') is export {
	has GumboNode                     $.document; # Typedef<GumboNode>->|GumboNode|* document
	has GumboNode                     $.root; # Typedef<GumboNode>->|GumboNode|* root
	HAS GumboVector                   $.errors; # GumboVector errors
}

## Extras stuff

## Functions


# == /usr/local/include/gumbo.h ==

#-From /usr/local/include/gumbo.h:104
#/**
# * Compares two GumboStringPieces, and returns true if they're equal or false
# * otherwise.
# */
#bool gumbo_string_equals(
#    const GumboStringPiece* str1, const GumboStringPiece* str2);
sub gumbo_string_equals(GumboStringPiece              $str1 # const GumboStringPiece*
                       ,GumboStringPiece              $str2 # const GumboStringPiece*
                        ) is native(LIB) returns bool is export { * }

#-From /usr/local/include/gumbo.h:111
#/**
# * Compares two GumboStringPieces ignoring case, and returns true if they're
# * equal or false otherwise.
# */
#bool gumbo_string_equals_ignore_case(
#    const GumboStringPiece* str1, const GumboStringPiece* str2);
sub gumbo_string_equals_ignore_case(GumboStringPiece              $str1 # const GumboStringPiece*
                                   ,GumboStringPiece              $str2 # const GumboStringPiece*
                                    ) is native(LIB) returns bool is export { * }

#-From /usr/local/include/gumbo.h:142
#/**
# * Returns the first index at which an element appears in this vector (testing
# * by pointer equality), or -1 if it never does.
# */
#int gumbo_vector_index_of(GumboVector* vector, const void* element);
sub gumbo_vector_index_of(GumboVector                   $vector # GumboVector*
                         ,Pointer                       $element # const void*
                          ) is native(LIB) returns int32 is export { * }

#-From /usr/local/include/gumbo.h:172
#/**
# * Returns the normalized (usually all-lowercased, except for foreign content)
# * tag name for an GumboTag enum.  Return value is static data owned by the
# * library.
# */
#const char* gumbo_normalized_tagname(GumboTag tag);
sub gumbo_normalized_tagname(int32 $tag # GumboTag
                             ) is native(LIB) returns Str is export { * }

#-From /usr/local/include/gumbo.h:184
#/**
# * Extracts the tag name from the original_text field of an element or token by
# * stripping off </> characters and attributes and adjusting the passed-in
# * GumboStringPiece appropriately.  The tag name is in the original case and
# * shares a buffer with the original text, to simplify memory management.
# * Behavior is undefined if a string-piece that doesn't represent an HTML tag
# * (<tagname> or </tagname>) is passed in.  If the string piece is completely
# * empty (NULL data pointer), then this function will exit successfully as a
# * no-op.
# */
#void gumbo_tag_from_original_text(GumboStringPiece* text);
sub gumbo_tag_from_original_text(GumboStringPiece $text # GumboStringPiece*
                                 ) is native(LIB)  is export { * }

#-From /usr/local/include/gumbo.h:198
#/**
# * Fixes the case of SVG elements that are not all lowercase.
# * http://www.whatwg.org/specs/web-apps/current-work/multipage/tree-construction.html#parsing-main-inforeign
# * This is not done at parse time because there's no place to store a mutated
# * tag name.  tag_name is an enum (which will be TAG_UNKNOWN for most SVG tags
# * without special handling), while original_tag_name is a pointer into the
# * original buffer.  Instead, we provide this helper function that clients can
# * use to rename SVG tags as appropriate.
# * Returns the case-normalized SVG tagname if a replacement is found, or NULL if
# * no normalization is called for.  The return value is static data and owned by
# * the library.
# */
#const char* gumbo_normalize_svg_tagname(const GumboStringPiece* tagname);
sub gumbo_normalize_svg_tagname(GumboStringPiece $tagname # const GumboStringPiece*
                                ) is native(LIB) returns Str is export { * }

#-From /usr/local/include/gumbo.h:204
#/**
# * Converts a tag name string (which may be in upper or mixed case) to a tag
# * enum. The `tag` version expects `tagname` to be NULL-terminated
# */
#GumboTag gumbo_tag_enum(const char* tagname);
sub gumbo_tag_enum(Str $tagname # const char*
                   ) is native(LIB) returns int32 is export { * }

#-From /usr/local/include/gumbo.h:205
#GumboTag gumbo_tagn_enum(const char* tagname, unsigned int length);
sub gumbo_tagn_enum(Str                           $tagname # const char*
                   ,uint32                        $length # unsigned int
                    ) is native(LIB) returns int32 is export { * }

#-From /usr/local/include/gumbo.h:285
#/**
# * Given a vector of GumboAttributes, look up the one with the specified name
# * and return it, or NULL if no such attribute exists.  This uses a
# * case-insensitive match, as HTML is case-insensitive.
# */
#GumboAttribute* gumbo_get_attribute(const GumboVector* attrs, const char* name);
sub gumbo_get_attribute(GumboVector                   $attrs # const GumboVector*
                       ,Str                           $name # const char*
                        ) is native(LIB) returns GumboAttribute is export { * }

#-From /usr/local/include/gumbo.h:655
#/**
# * Parses a buffer of UTF8 text into an GumboNode parse tree.  The buffer must
# * live at least as long as the parse tree, as some fields (eg. original_text)
# * point directly into the original buffer.
# *
# * This doesn't support buffers longer than 4 gigabytes.
# */
#GumboOutput* gumbo_parse(const char* buffer);
sub gumbo_parse(Str $buffer # const char*
                ) is native(LIB) returns GumboOutput is export { * }

#-From /usr/local/include/gumbo.h:662
#/**
# * Extended version of gumbo_parse that takes an explicit options structure,
# * buffer, and length.
# */
#GumboOutput* gumbo_parse_with_options(
#    const GumboOptions* options, const char* buffer, size_t buffer_length);
sub gumbo_parse_with_options(GumboOptions                  $options # const Typedef<GumboOptions>->|GumboOptions|*
                            ,Str                           $buffer # const char*
                            ,size_t                        $buffer_length # Typedef<size_t>->|unsigned int|
                             ) is native(LIB) returns GumboOutput is export { * }

#-From /usr/local/include/gumbo.h:665
#/** Release the memory used for the parse tree & parse errors. */
#void gumbo_destroy_output(const GumboOptions* options, GumboOutput* output);
sub gumbo_destroy_output(GumboOptions                  $options # const Typedef<GumboOptions>->|GumboOptions|*
                        ,GumboOutput                   $output # Typedef<GumboOutput>->|GumboOutput|*
                         ) is native(LIB)  is export { * }


## Externs


# == /usr/local/include/gumbo.h ==

our $kGumboEmptySourcePosition is export := cglobal(LIB, "kGumboEmptySourcePosition", GumboSourcePosition);
our $kGumboEmptyString is export := cglobal(LIB, "kGumboEmptyString", GumboStringPiece);
our $kGumboEmptyVector is export := cglobal(LIB, "kGumboEmptyVector", GumboVector);
our $kGumboDefaultOptions is export := cglobal(LIB, "kGumboDefaultOptions", GumboOptions);
