/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class OrderedDitherOpImage
extends PointOpImage {
    private static final int TYPE_OD_GENERAL = 0;
    private static final int TYPE_OD_BYTE_LUT_3BAND = 1;
    private static final int TYPE_OD_BYTE_LUT_NBAND = 2;
    private static final int DITHER_LUT_LENGTH_MAX = 262144;
    private static final int DITHER_LUT_CACHE_LENGTH_MAX = 4;
    private static Vector ditherLUTCache = new Vector(0, 4);
    private int odType = 0;
    protected int numBands;
    protected int[] dims;
    protected int[] mults;
    protected int adjustedOffset;
    protected int maskWidth;
    protected int maskHeight;
    protected byte[][] maskDataByte;
    protected int[][] maskDataInt;
    protected long[][] maskDataLong;
    protected float[][] maskDataFloat;
    protected DitherLUT odLUT = null;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, ColorCube colorCube) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout(renderedImage) : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (colorCube.getNumBands() == 1 && colorCube.getNumEntries() == 2 && !ImageUtil.isBinary(imageLayout2.getSampleModel(renderedImage))) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
            colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        if ((imageLayout == null || !imageLayout2.isValid(512)) && renderedImage.getSampleModel().getDataType() == 0 && imageLayout2.getSampleModel(null).getDataType() == 0 && colorCube.getDataType() == 0 && colorCube.getNumBands() == 3 && ((colorModel = renderedImage.getColorModel()) == null || colorModel != null && colorModel.getColorSpace().isCS_sRGB())) {
            int n = colorCube.getNumEntries();
            byte[][] byArray = new byte[3][256];
            int n2 = 0;
            while (n2 < 3) {
                byte[] byArray2 = byArray[n2];
                byte[] byArray3 = colorCube.getByteData(n2);
                int n3 = colorCube.getOffset(n2);
                int n4 = n3 + n;
                int n5 = 0;
                while (n5 < n3) {
                    byArray2[n5] = 0;
                    ++n5;
                }
                int n6 = n3;
                while (n6 < n4) {
                    byArray2[n6] = byArray3[n6 - n3];
                    ++n6;
                }
                int n7 = n4;
                while (n7 < 256) {
                    byArray2[n7] = -1;
                    ++n7;
                }
                ++n2;
            }
            imageLayout2.setColorModel(new IndexColorModel(8, 256, byArray[0], byArray[1], byArray[2]));
        }
        return imageLayout2;
    }

    public OrderedDitherOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, ColorCube colorCube, KernelJAI[] kernelJAIArray) {
        super(renderedImage, OrderedDitherOpImage.layoutHelper(imageLayout, renderedImage, colorCube), map, true);
        this.numBands = colorCube.getNumBands();
        this.mults = (int[])colorCube.getMultipliers().clone();
        this.dims = (int[])colorCube.getDimsLessOne().clone();
        this.adjustedOffset = colorCube.getAdjustedOffset();
        this.maskWidth = kernelJAIArray[0].getWidth();
        this.maskHeight = kernelJAIArray[0].getHeight();
        this.initializeDitherData(this.sampleModel.getTransferType(), kernelJAIArray);
        this.permitInPlaceOperation();
    }

    private void initializeDitherData(int n, KernelJAI[] kernelJAIArray) {
        switch (n) {
            case 0: {
                this.maskDataByte = new byte[kernelJAIArray.length][];
                int n2 = 0;
                while (n2 < this.maskDataByte.length) {
                    float[] fArray = kernelJAIArray[n2].getKernelData();
                    this.maskDataByte[n2] = new byte[fArray.length];
                    int n3 = 0;
                    while (n3 < fArray.length) {
                        this.maskDataByte[n2][n3] = (byte)((int)(fArray[n3] * 255.0f) & 0xFF);
                        ++n3;
                    }
                    ++n2;
                }
                this.initializeDitherLUT();
                break;
            }
            case 1: 
            case 2: {
                int n4 = 65535;
                this.maskDataInt = new int[kernelJAIArray.length][];
                int n5 = 0;
                while (n5 < this.maskDataInt.length) {
                    float[] fArray = kernelJAIArray[n5].getKernelData();
                    this.maskDataInt[n5] = new int[fArray.length];
                    int n6 = 0;
                    while (n6 < fArray.length) {
                        this.maskDataInt[n5][n6] = (int)(fArray[n6] * (float)n4);
                        ++n6;
                    }
                    ++n5;
                }
                break;
            }
            case 3: {
                long l = 0xFFFFFFFFL;
                this.maskDataLong = new long[kernelJAIArray.length][];
                int n7 = 0;
                while (n7 < this.maskDataLong.length) {
                    float[] fArray = kernelJAIArray[n7].getKernelData();
                    this.maskDataLong[n7] = new long[fArray.length];
                    int n8 = 0;
                    while (n8 < fArray.length) {
                        this.maskDataLong[n7][n8] = (long)(fArray[n8] * (float)l);
                        ++n8;
                    }
                    ++n7;
                }
                break;
            }
            case 4: 
            case 5: {
                this.maskDataFloat = new float[kernelJAIArray.length][];
                int n9 = 0;
                while (n9 < this.maskDataFloat.length) {
                    this.maskDataFloat[n9] = kernelJAIArray[n9].getKernelData();
                    ++n9;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
    }

    private synchronized void initializeDitherLUT() {
        if (this.numBands * this.maskHeight * this.maskWidth * 256 > 262144) {
            this.odType = 0;
            return;
        }
        this.odType = this.numBands == 3 ? 1 : 2;
        int n = 0;
        while (n < ditherLUTCache.size()) {
            SoftReference softReference = (SoftReference)ditherLUTCache.get(n);
            DitherLUT ditherLUT = (DitherLUT)softReference.get();
            if (ditherLUT == null) {
                ditherLUTCache.remove(n);
                continue;
            }
            if (ditherLUT.equals(this.dims, this.mults, this.maskDataByte)) {
                this.odLUT = ditherLUT;
                break;
            }
            ++n;
        }
        if (this.odLUT == null) {
            this.odLUT = new DitherLUT(this.dims, this.mults, this.maskDataByte);
            if (ditherLUTCache.size() < 4) {
                ditherLUTCache.add(new SoftReference<DitherLUT>(this.odLUT));
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Object object;
        RenderedImage[] renderedImageArray;
        RasterFormatTag[] rasterFormatTagArray = null;
        if (ImageUtil.isBinary(this.getSampleModel()) && !ImageUtil.isBinary(this.getSourceImage(0).getSampleModel())) {
            renderedImageArray = new RenderedImage[]{this.getSourceImage(0)};
            object = RasterAccessor.findCompatibleTags(renderedImageArray, renderedImageArray[0]);
            RasterFormatTag[] rasterFormatTagArray2 = RasterAccessor.findCompatibleTags(renderedImageArray, this);
            rasterFormatTagArray = new RasterFormatTag[]{object[0], rasterFormatTagArray2[1]};
        } else {
            rasterFormatTagArray = this.getFormatTags();
        }
        renderedImageArray = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        object = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (renderedImageArray.getDataType()) {
            case 0: {
                this.computeRectByte((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 2: {
                this.computeRectShort((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 1: {
                this.computeRectUShort((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 3: {
                this.computeRectInt((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 4: {
                this.computeRectFloat((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 5: {
                this.computeRectDouble((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage1"));
            }
        }
        ((RasterAccessor)object).copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        byte[] byArray2 = rasterAccessor2.getByteDataArray(0);
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        switch (this.odType) {
            case 1: 
            case 2: {
                int[] nArray2 = (int[])nArray.clone();
                int[] nArray3 = (int[])nArray2.clone();
                int n11 = n8;
                int n12 = 0;
                while (n12 < n5) {
                    int n13 = (n10 + n12) % this.maskHeight;
                    if (this.odType == 1) {
                        this.computeLineByteLUT3(byArray, nArray3, n3, byArray2, n11, n7, n4, n9, n13);
                    } else {
                        this.computeLineByteLUTN(byArray, nArray3, n3, byArray2, n11, n7, n4, n9, n13);
                    }
                    int n14 = 0;
                    while (n14 < n) {
                        int n15 = n14;
                        nArray2[n15] = nArray2[n15] + n2;
                        nArray3[n14] = nArray2[n14];
                        ++n14;
                    }
                    n11 += n6;
                    ++n12;
                }
                break;
            }
            default: {
                this.computeRectByteGeneral(byArray, nArray, n2, n3, byArray2, n8, n6, n7, n4, n5, n9, n10);
            }
        }
    }

    private void computeLineByteLUT3(byte[][] byArray, int[] nArray, int n, byte[] byArray2, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.odLUT.ditherLUTBandStride;
        int n8 = this.odLUT.ditherLUTRowStride;
        int n9 = this.odLUT.ditherLUTColStride;
        byte[] byArray3 = this.odLUT.ditherLUT;
        int n10 = this.adjustedOffset;
        int n11 = n6 * n8;
        int n12 = n11 + n7;
        int n13 = n12 + n7;
        int n14 = n11 + n8;
        int n15 = n5 * n9;
        int n16 = n11 + n15;
        int n17 = n12 + n15;
        int n18 = n13 + n15;
        byte[] byArray4 = byArray[0];
        byte[] byArray5 = byArray[1];
        byte[] byArray6 = byArray[2];
        int n19 = n4;
        while (n19 > 0) {
            int n20 = (byArray3[n16 + (byArray4[nArray[0]] & 0xFF)] & 0xFF) + (byArray3[n17 + (byArray5[nArray[1]] & 0xFF)] & 0xFF) + (byArray3[n18 + (byArray6[nArray[2]] & 0xFF)] & 0xFF);
            byArray2[n2] = (byte)(n20 + n10 & 0xFF);
            nArray[0] = nArray[0] + n;
            nArray[1] = nArray[1] + n;
            nArray[2] = nArray[2] + n;
            n2 += n3;
            if ((n16 += n9) >= n14) {
                n16 = n11;
                n17 = n12;
                n18 = n13;
            } else {
                n17 += n9;
                n18 += n9;
            }
            --n19;
        }
    }

    private void computeLineByteLUTN(byte[][] byArray, int[] nArray, int n, byte[] byArray2, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.odLUT.ditherLUTBandStride;
        int n8 = this.odLUT.ditherLUTRowStride;
        int n9 = this.odLUT.ditherLUTColStride;
        byte[] byArray3 = this.odLUT.ditherLUT;
        int n10 = this.adjustedOffset;
        int n11 = n6 * n8;
        int n12 = n11 + n5 * n9;
        int n13 = n11 + n8;
        int n14 = n4;
        while (n14 > 0) {
            int n15 = n12;
            int n16 = n10;
            int n17 = 0;
            while (n17 < this.numBands) {
                n16 += byArray3[n15 + (byArray[n17][nArray[n17]] & 0xFF)] & 0xFF;
                n15 += n7;
                int n18 = n17++;
                nArray[n18] = nArray[n18] + n;
            }
            byArray2[n2] = (byte)(n16 & 0xFF);
            n2 += n3;
            if ((n12 += n9) >= n13) {
                n12 = n11;
            }
            --n14;
        }
    }

    private void computeRectByteGeneral(byte[][] byArray, int[] nArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.adjustedOffset > 0) {
            Arrays.fill(byArray2, (byte)(this.adjustedOffset & 0xFF));
        }
        int n10 = nArray.length;
        int n11 = 0;
        while (n11 < n10) {
            byte[] byArray3 = byArray[n11];
            byte[] byArray4 = byArray2;
            byte[] byArray5 = this.maskDataByte[n11];
            int n12 = nArray[n11];
            int n13 = n3;
            int n14 = 0;
            while (n14 < n7) {
                int n15 = (n9 + n14) % this.maskHeight;
                int n16 = n15 * this.maskWidth;
                int n17 = n16 + this.maskWidth;
                int n18 = n16 + n8;
                int n19 = n12;
                int n20 = n13;
                int n21 = 0;
                while (n21 < n6) {
                    int n22 = (byArray3[n19] & 0xFF) * this.dims[n11];
                    int n23 = n22 & 0xFF;
                    n22 >>= 8;
                    if (n23 > (byArray5[n18] & 0xFF)) {
                        ++n22;
                    }
                    int n24 = (byArray4[n20] & 0xFF) + n22 * this.mults[n11];
                    byArray4[n20] = (byte)(n24 & 0xFF);
                    n19 += n2;
                    n20 += n5;
                    if (++n18 >= n17) {
                        n18 = n16;
                    }
                    ++n21;
                }
                n12 += n;
                n13 += n4;
                ++n14;
            }
            ++n11;
        }
        if (this.adjustedOffset < 0) {
            int n25 = byArray2.length;
            int n26 = 0;
            while (n26 < n25) {
                byArray2[n26] = (byte)((byArray2[n26] & 0xFF) + this.adjustedOffset);
                ++n26;
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        short[] sArray2 = rasterAccessor2.getShortDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(sArray2, (short)(this.adjustedOffset & 0xFFFF));
        }
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        int n11 = 0;
        while (n11 < n) {
            short[] sArray3 = sArray[n11];
            short[] sArray4 = sArray2;
            int[] nArray2 = this.maskDataInt[n11];
            int n12 = nArray[n11];
            int n13 = n8;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = n12;
                int n16 = n13;
                n12 += n2;
                n13 += n6;
                int n17 = (n10 + n14) % this.maskHeight * this.maskWidth;
                int n18 = n17 + this.maskWidth;
                int n19 = n17 + n9;
                int n20 = 0;
                while (n20 < n4) {
                    int n21 = (sArray3[n15] - Short.MIN_VALUE) * this.dims[n11];
                    int n22 = n21 & 0xFFFF;
                    int n23 = (sArray4[n16] & 0xFFFF) + (n21 >> 16) * this.mults[n11];
                    if (n22 > nArray2[n19]) {
                        n23 += this.mults[n11];
                    }
                    sArray4[n16] = (short)(n23 & 0xFFFF);
                    n15 += n3;
                    n16 += n7;
                    if (++n19 >= n18) {
                        n19 = n17;
                    }
                    ++n20;
                }
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        short[] sArray2 = rasterAccessor2.getShortDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(sArray2, (short)(this.adjustedOffset & 0xFFFF));
        }
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        int n11 = 0;
        while (n11 < n) {
            short[] sArray3 = sArray[n11];
            short[] sArray4 = sArray2;
            int[] nArray2 = this.maskDataInt[n11];
            int n12 = nArray[n11];
            int n13 = n8;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = n12;
                int n16 = n13;
                n12 += n2;
                n13 += n6;
                int n17 = (n10 + n14) % this.maskHeight * this.maskWidth;
                int n18 = n17 + this.maskWidth;
                int n19 = n17 + n9;
                int n20 = 0;
                while (n20 < n4) {
                    int n21 = (sArray3[n15] & 0xFFFF) * this.dims[n11];
                    int n22 = n21 & 0xFFFF;
                    int n23 = (sArray4[n16] & 0xFFFF) + (n21 >> 16) * this.mults[n11];
                    if (n22 > nArray2[n19]) {
                        n23 += this.mults[n11];
                    }
                    sArray4[n16] = (short)(n23 & 0xFFFF);
                    n15 += n3;
                    n16 += n7;
                    if (++n19 >= n18) {
                        n19 = n17;
                    }
                    ++n20;
                }
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        int[] nArray3 = rasterAccessor2.getIntDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(nArray3, this.adjustedOffset);
        }
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        int n11 = 0;
        while (n11 < n) {
            int[] nArray4 = nArray2[n11];
            int[] nArray5 = nArray3;
            long[] lArray = this.maskDataLong[n11];
            int n12 = nArray[n11];
            int n13 = n8;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = n12;
                int n16 = n13;
                n12 += n2;
                n13 += n6;
                int n17 = (n10 + n14) % this.maskHeight * this.maskWidth;
                int n18 = n17 + this.maskWidth;
                int n19 = n17 + n9;
                int n20 = 0;
                while (n20 < n4) {
                    long l = ((long)nArray4[n15] - Integer.MIN_VALUE) * (long)this.dims[n11];
                    long l2 = l & 0xFFFFFFFFFFFFFFFFL;
                    int n21 = nArray5[n16] + (int)(l >> 32) * this.mults[n11];
                    if (l2 > lArray[n19]) {
                        n21 += this.mults[n11];
                    }
                    nArray5[n16] = n21;
                    n15 += n3;
                    n16 += n7;
                    if (++n19 >= n18) {
                        n19 = n17;
                    }
                    ++n20;
                }
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        float[] fArray2 = rasterAccessor2.getFloatDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(fArray2, (float)this.adjustedOffset);
        }
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        int n11 = 0;
        while (n11 < n) {
            float[] fArray3 = fArray[n11];
            float[] fArray4 = fArray2;
            float[] fArray5 = this.maskDataFloat[n11];
            int n12 = nArray[n11];
            int n13 = n8;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = n12;
                int n16 = n13;
                n12 += n2;
                n13 += n6;
                int n17 = (n10 + n14) % this.maskHeight * this.maskWidth;
                int n18 = n17 + this.maskWidth;
                int n19 = n17 + n9;
                int n20 = 0;
                while (n20 < n4) {
                    int n21 = (int)(fArray3[n15] * (float)this.dims[n11]);
                    float f = fArray3[n15] * (float)this.dims[n11] - (float)n21;
                    float f2 = fArray4[n16] + (float)(n21 * this.mults[n11]);
                    if (f > fArray5[n19]) {
                        f2 += (float)this.mults[n11];
                    }
                    fArray4[n16] = f2;
                    n15 += n3;
                    n16 += n7;
                    if (++n19 >= n18) {
                        n19 = n17;
                    }
                    ++n20;
                }
                ++n14;
            }
            ++n11;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        double[] dArray2 = rasterAccessor2.getDoubleDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(dArray2, (double)this.adjustedOffset);
        }
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        int n11 = 0;
        while (n11 < n) {
            double[] dArray3 = dArray[n11];
            double[] dArray4 = dArray2;
            float[] fArray = this.maskDataFloat[n11];
            int n12 = nArray[n11];
            int n13 = n8;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = n12;
                int n16 = n13;
                n12 += n2;
                n13 += n6;
                int n17 = (n10 + n14) % this.maskHeight * this.maskWidth;
                int n18 = n17 + this.maskWidth;
                int n19 = n17 + n9;
                int n20 = 0;
                while (n20 < n4) {
                    int n21 = (int)(dArray3[n15] * (double)this.dims[n11]);
                    float f = (float)(dArray3[n15] * (double)this.dims[n11] - (double)n21);
                    double d = dArray4[n16] + (double)(n21 * this.mults[n11]);
                    if (f > fArray[n19]) {
                        d += (double)this.mults[n11];
                    }
                    dArray4[n16] = d;
                    n15 += n3;
                    n16 += n7;
                    if (++n19 >= n18) {
                        n19 = n17;
                    }
                    ++n20;
                }
                ++n14;
            }
            ++n11;
        }
    }

    private class DitherLUT {
        private int[] dimsCache;
        private int[] multsCache;
        private byte[][] maskDataCache;
        public int ditherLUTBandStride;
        public int ditherLUTRowStride;
        public int ditherLUTColStride;
        public byte[] ditherLUT;

        DitherLUT(int[] nArray, int[] nArray2, byte[][] byArray) {
            this.dimsCache = (int[])nArray.clone();
            this.multsCache = (int[])nArray2.clone();
            this.maskDataCache = new byte[byArray.length][];
            int n = 0;
            while (n < byArray.length) {
                this.maskDataCache[n] = (byte[])byArray[n].clone();
                ++n;
            }
            this.ditherLUTColStride = 256;
            this.ditherLUTRowStride = OrderedDitherOpImage.this.maskWidth * this.ditherLUTColStride;
            this.ditherLUTBandStride = OrderedDitherOpImage.this.maskHeight * this.ditherLUTRowStride;
            this.ditherLUT = new byte[OrderedDitherOpImage.this.numBands * this.ditherLUTBandStride];
            int n2 = 0;
            int n3 = OrderedDitherOpImage.this.maskWidth * OrderedDitherOpImage.this.maskHeight;
            int n4 = 0;
            while (n4 < OrderedDitherOpImage.this.numBands) {
                int n5 = nArray[n4];
                int n6 = nArray2[n4];
                byte[] byArray2 = byArray[n4];
                int n7 = 0;
                int n8 = 0;
                while (n8 < 256) {
                    int n9 = n7;
                    int n10 = n9 & 0xFF;
                    int n11 = n9 >> 8;
                    int n12 = n11 * n6;
                    int n13 = n12 + n6;
                    int n14 = n2 + n8;
                    int n15 = 0;
                    while (n15 < n3) {
                        int n16 = byArray2[n15] & 0xFF;
                        this.ditherLUT[n14] = n10 > n16 ? (byte)(n13 & 0xFF) : (byte)(n12 & 0xFF);
                        n14 += 256;
                        ++n15;
                    }
                    n7 += n5;
                    ++n8;
                }
                n2 += this.ditherLUTBandStride;
                ++n4;
            }
        }

        public boolean equals(int[] nArray, int[] nArray2, byte[][] byArray) {
            if (nArray.length != this.dimsCache.length) {
                return false;
            }
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != this.dimsCache[n]) {
                    return false;
                }
                ++n;
            }
            if (nArray2.length != this.multsCache.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < nArray2.length) {
                if (nArray2[n2] != this.multsCache[n2]) {
                    return false;
                }
                ++n2;
            }
            if (byArray.length != OrderedDitherOpImage.this.maskDataByte.length) {
                return false;
            }
            int n3 = 0;
            while (n3 < byArray.length) {
                if (byArray[n3].length != this.maskDataCache[n3].length) {
                    return false;
                }
                byte[] byArray2 = this.maskDataCache[n3];
                byte[] byArray3 = byArray[n3];
                int n4 = 0;
                while (n4 < byArray[n3].length) {
                    if (byArray3[n4] != byArray2[n4]) {
                        return false;
                    }
                    ++n4;
                }
                ++n3;
            }
            return true;
        }
    }
}

