/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.registry;

import java.awt.Point;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoder;
import javax.media.jai.tilecodec.TileDecoderFactory;

public final class TileDecoderRegistry {
    private static final String MODE_NAME = "tileDecoder";

    public static void register(OperationRegistry operationRegistry, String string, String string2, TileDecoderFactory tileDecoderFactory) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.registerFactory(MODE_NAME, string, string2, tileDecoderFactory);
    }

    public static void unregister(OperationRegistry operationRegistry, String string, String string2, TileDecoderFactory tileDecoderFactory) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.unregisterFactory(MODE_NAME, string, string2, tileDecoderFactory);
    }

    public static void setPreference(OperationRegistry operationRegistry, String string, String string2, TileDecoderFactory tileDecoderFactory, TileDecoderFactory tileDecoderFactory2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.setFactoryPreference(MODE_NAME, string, string2, tileDecoderFactory, tileDecoderFactory2);
    }

    public static void unsetPreference(OperationRegistry operationRegistry, String string, String string2, TileDecoderFactory tileDecoderFactory, TileDecoderFactory tileDecoderFactory2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.unsetFactoryPreference(MODE_NAME, string, string2, tileDecoderFactory, tileDecoderFactory2);
    }

    public static void clearPreferences(OperationRegistry operationRegistry, String string, String string2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.clearFactoryPreferences(MODE_NAME, string, string2);
    }

    public static List getOrderedList(OperationRegistry operationRegistry, String string, String string2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return operationRegistry.getOrderedFactoryList(MODE_NAME, string, string2);
    }

    public static Iterator getIterator(OperationRegistry operationRegistry, String string) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return operationRegistry.getFactoryIterator(MODE_NAME, string);
    }

    public static TileDecoderFactory get(OperationRegistry operationRegistry, String string) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return (TileDecoderFactory)operationRegistry.getFactory(MODE_NAME, string);
    }

    public static TileDecoder create(OperationRegistry operationRegistry, String string, InputStream inputStream, TileCodecParameterList tileCodecParameterList) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        Object[] objectArray = new Object[]{inputStream, tileCodecParameterList};
        return (TileDecoder)operationRegistry.invokeFactory(MODE_NAME, string, objectArray);
    }

    public static Raster decode(OperationRegistry operationRegistry, String string, InputStream inputStream, TileCodecParameterList tileCodecParameterList) throws IOException {
        TileDecoder tileDecoder = TileDecoderRegistry.create(operationRegistry, string, inputStream, tileCodecParameterList);
        if (tileDecoder == null) {
            return null;
        }
        return tileDecoder.decode();
    }

    public static Raster decode(OperationRegistry operationRegistry, String string, InputStream inputStream, TileCodecParameterList tileCodecParameterList, Point point) throws IOException {
        TileDecoder tileDecoder = TileDecoderRegistry.create(operationRegistry, string, inputStream, tileCodecParameterList);
        if (tileDecoder == null) {
            return null;
        }
        return tileDecoder.decode(point);
    }
}

