#!/usr/bin/perl

package eBay::API::XML::DataType::ApiAccessRuleType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ApiAccessRuleType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ApiAccessRuleType

=head1 DESCRIPTION

Contains the definition of a rule that governs the number of times your
application can access the eBay API (invoke a call) on an hourly, daily, or
periodic basis.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ApiAccessRuleType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::AccessRuleCurrentStatusCodeType;
use eBay::API::XML::DataType::Enum::AccessRuleStatusCodeType;


my @gaProperties = ( [ 'CallName', 'xs:string', '', '', '' ]
	, [ 'CountsTowardAggregate', 'xs:boolean', '', '', '' ]
	, [ 'DailyHardLimit', 'xs:long', '', '', '' ]
	, [ 'DailySoftLimit', 'xs:long', '', '', '' ]
	, [ 'DailyUsage', 'xs:long', '', '', '' ]
	, [ 'HourlyHardLimit', 'xs:long', '', '', '' ]
	, [ 'HourlySoftLimit', 'xs:long', '', '', '' ]
	, [ 'HourlyUsage', 'xs:long', '', '', '' ]
	, [ 'ModTime', 'xs:dateTime', '', '', '' ]
	, [ 'Period', 'xs:int', '', '', '' ]
	, [ 'PeriodicHardLimit', 'xs:long', '', '', '' ]
	, [ 'PeriodicSoftLimit', 'xs:long', '', '', '' ]
	, [ 'PeriodicStartDate', 'xs:dateTime', '', '', '' ]
	, [ 'PeriodicUsage', 'xs:long', '', '', '' ]
	, [ 'RuleCurrentStatus', 'ns:AccessRuleCurrentStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AccessRuleCurrentStatusCodeType', '' ]
	, [ 'RuleStatus', 'ns:AccessRuleStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AccessRuleStatusCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCallName()

The name of the call that has an access rule. Can be a call name (e.g.,
AddItem), ApplicationAggregate (returns totals for all calls),
PasswordAuthenticationLimiter (dummy call), or NonUTF8UsageLimiter.

#    Argument: 'xs:string'

=cut

sub setCallName {
  my $self = shift;
  $self->{'CallName'} = shift
}

=head2 getCallName()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getCallName {
  my $self = shift;
  return $self->{'CallName'};
}


=head2 setCountsTowardAggregate()

Whether use of this call counts toward the application's
aggregate limit for all calls.

#    Argument: 'xs:boolean'

=cut

sub setCountsTowardAggregate {
  my $self = shift;
  $self->{'CountsTowardAggregate'} = shift
}

=head2 isCountsTowardAggregate()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:boolean'

=cut

sub isCountsTowardAggregate {
  my $self = shift;
  return $self->{'CountsTowardAggregate'};
}


=head2 setDailyHardLimit()

The number of calls per day that your application can make to this call before
being refused.
The day starts at midnight, 00:00:00 PST (not GMT).

#    Argument: 'xs:long'

=cut

sub setDailyHardLimit {
  my $self = shift;
  $self->{'DailyHardLimit'} = shift
}

=head2 getDailyHardLimit()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:long'

=cut

sub getDailyHardLimit {
  my $self = shift;
  return $self->{'DailyHardLimit'};
}


=head2 setDailySoftLimit()

The number of calls per day that your application can make to this call
before you receive a warning.
The day starts at midnight, 00:00:00 PST.

#    Argument: 'xs:long'

=cut

sub setDailySoftLimit {
  my $self = shift;
  $self->{'DailySoftLimit'} = shift
}

=head2 getDailySoftLimit()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:long'

=cut

sub getDailySoftLimit {
  my $self = shift;
  return $self->{'DailySoftLimit'};
}


=head2 setDailyUsage()

The number of times your application has used this
call today.

#    Argument: 'xs:long'

=cut

sub setDailyUsage {
  my $self = shift;
  $self->{'DailyUsage'} = shift
}

=head2 getDailyUsage()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:long'

=cut

sub getDailyUsage {
  my $self = shift;
  return $self->{'DailyUsage'};
}


=head2 setHourlyHardLimit()

The number of calls that your application can make per hour to this call
before being refused. Each count begins on the hour (e.g. 1:00:00).

#    Argument: 'xs:long'

=cut

sub setHourlyHardLimit {
  my $self = shift;
  $self->{'HourlyHardLimit'} = shift
}

=head2 getHourlyHardLimit()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:long'

=cut

sub getHourlyHardLimit {
  my $self = shift;
  return $self->{'HourlyHardLimit'};
}


=head2 setHourlySoftLimit()

The number of calls that your application can make to this call per hour
before you receive a warning. Each count begins on the hour (e.g. 1:00:00).

#    Argument: 'xs:long'

=cut

sub setHourlySoftLimit {
  my $self = shift;
  $self->{'HourlySoftLimit'} = shift
}

=head2 getHourlySoftLimit()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:long'

=cut

sub getHourlySoftLimit {
  my $self = shift;
  return $self->{'HourlySoftLimit'};
}


=head2 setHourlyUsage()

The number of times your application has executed this call during this hour.

#    Argument: 'xs:long'

=cut

sub setHourlyUsage {
  my $self = shift;
  $self->{'HourlyUsage'} = shift
}

=head2 getHourlyUsage()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:long'

=cut

sub getHourlyUsage {
  my $self = shift;
  return $self->{'HourlyUsage'};
}


=head2 setModTime()

The date and time this access rule was last modified by eBay.

#    Argument: 'xs:dateTime'

=cut

sub setModTime {
  my $self = shift;
  $self->{'ModTime'} = shift
}

=head2 getModTime()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:dateTime'

=cut

sub getModTime {
  my $self = shift;
  return $self->{'ModTime'};
}


=head2 setPeriod()

The length of time before your application's perodic usage counter restarts
for this call. If the number of calls you make exceeds the periodic hard limit
before the current period ends, further calls will be refused until the next
period starts. Possible values: -1 (Periodic limit not enforced, could be any
negative integer), 0 (Calendar month), 30 (Number of days, could be any
positive integer). If the period is based on the calendar month, the usage
counters restart on the same day of every month, regardless of the number of
days in the month.

#    Argument: 'xs:int'

=cut

sub setPeriod {
  my $self = shift;
  $self->{'Period'} = shift
}

=head2 getPeriod()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getPeriod {
  my $self = shift;
  return $self->{'Period'};
}


=head2 setPeriodicHardLimit()

Number of calls per period that your application may make before a call is
refused, if the periodic limit is enforced. The length of the period is
specified in Period.

#    Argument: 'xs:long'

=cut

sub setPeriodicHardLimit {
  my $self = shift;
  $self->{'PeriodicHardLimit'} = shift
}

=head2 getPeriodicHardLimit()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:long'

=cut

sub getPeriodicHardLimit {
  my $self = shift;
  return $self->{'PeriodicHardLimit'};
}


=head2 setPeriodicSoftLimit()

Number of calls per period that your application may make before you receive a
warning, if the periodic limit is enforced. The length of the period is
specified in Period.

#    Argument: 'xs:long'

=cut

sub setPeriodicSoftLimit {
  my $self = shift;
  $self->{'PeriodicSoftLimit'} = shift
}

=head2 getPeriodicSoftLimit()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:long'

=cut

sub getPeriodicSoftLimit {
  my $self = shift;
  return $self->{'PeriodicSoftLimit'};
}


=head2 setPeriodicStartDate()

The time (in GMT) when this access rule's period started. The period starts at
midnight Pacific time. For example, if the period begins on June 29 in 2005
when California is on Pacific Daylight Time, the GMT value returned would be
2005-06-29T07:00:00.000Z If the period begins on December 29 in 2005 when
California is on Pacific Standard Time, the GMT value returned would be
2005-12-29T08:00:00.000Z. Only returned when the eBay Developers Program has
configured the start date for the access rule. The start date can vary per
application and per call name (i.e., per access rule).

#    Argument: 'xs:dateTime'

=cut

sub setPeriodicStartDate {
  my $self = shift;
  $self->{'PeriodicStartDate'} = shift
}

=head2 getPeriodicStartDate()

  Calls: GetApiAccessRules
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getPeriodicStartDate {
  my $self = shift;
  return $self->{'PeriodicStartDate'};
}


=head2 setPeriodicUsage()

Number of calls that your application has already made this period. Returns 0
if the periodic access rule has not been configured for the application. The
length of the period is specified in Period. The start date of the period is
specified in PeriodicStartDate.

#    Argument: 'xs:long'

=cut

sub setPeriodicUsage {
  my $self = shift;
  $self->{'PeriodicUsage'} = shift
}

=head2 getPeriodicUsage()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'xs:long'

=cut

sub getPeriodicUsage {
  my $self = shift;
  return $self->{'PeriodicUsage'};
}


=head2 setRuleCurrentStatus()

Your application's current status for this rule, including whether the rule is
set for your application and whether the application has exceeded its daily or
hourly limit.

#    Argument: 'ns:AccessRuleCurrentStatusCodeType'

=cut

sub setRuleCurrentStatus {
  my $self = shift;
  $self->{'RuleCurrentStatus'} = shift
}

=head2 getRuleCurrentStatus()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'ns:AccessRuleCurrentStatusCodeType'

=cut

sub getRuleCurrentStatus {
  my $self = shift;
  return $self->{'RuleCurrentStatus'};
}


=head2 setRuleStatus()

The status of the access rule, including whether the rule is turned on or off
and whether the application is currently blocked from using this call. No
effect if RuleCurrentStatus is set to NotSet.

#    Argument: 'ns:AccessRuleStatusCodeType'

=cut

sub setRuleStatus {
  my $self = shift;
  $self->{'RuleStatus'} = shift
}

=head2 getRuleStatus()

  Calls: GetApiAccessRules
  Returned: Always

#    Returns: 'ns:AccessRuleStatusCodeType'

=cut

sub getRuleStatus {
  my $self = shift;
  return $self->{'RuleStatus'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
