#!/usr/bin/perl

package eBay::API::XML::DataType::MemberMessageType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. MemberMessageType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::MemberMessageType

=head1 DESCRIPTION

Container for individual message information.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::MemberMessageType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::MessageTypeCodeType;
use eBay::API::XML::DataType::Enum::QuestionTypeCodeType;


my @gaProperties = ( [ 'Body', 'xs:string', '', '', '' ]
	, [ 'DisplayToPublic', 'xs:boolean', '', '', '' ]
	, [ 'EmailCopyToSender', 'xs:boolean', '', '', '' ]
	, [ 'HideSendersEmailAddress', 'xs:boolean', '', '', '' ]
	, [ 'MessageID', 'xs:string', '', '', '' ]
	, [ 'MessageType', 'ns:MessageTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::MessageTypeCodeType', '' ]
	, [ 'ParentMessageID', 'xs:string', '', '', '' ]
	, [ 'QuestionType', 'ns:QuestionTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::QuestionTypeCodeType', '' ]
	, [ 'RecipientID', 'xs:string', '1', '', '' ]
	, [ 'SenderEmail', 'xs:string', '', '', '' ]
	, [ 'SenderID', 'xs:string', '', '', '' ]
	, [ 'Subject', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBody()

Message content.

MaxLength: 1000

  Calls: AddMemberMessageAAQToPartner
         AddMemberMessageRTQ
         AddMemberMessagesAAQToBidder
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setBody {
  my $self = shift;
  $self->{'Body'} = shift
}

=head2 getBody()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getBody {
  my $self = shift;
  return $self->{'Body'};
}


=head2 setDisplayToPublic()

Specifies if the body should be displayed to the public.

  Calls: AddMemberMessageRTQ
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setDisplayToPublic {
  my $self = shift;
  $self->{'DisplayToPublic'} = shift
}

=head2 isDisplayToPublic()

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isDisplayToPublic {
  my $self = shift;
  return $self->{'DisplayToPublic'};
}


=head2 setEmailCopyToSender()

Specifies whether or not to email a copy of the
message to the sender. If omitted, this defaults to whatever
the user set in preferences.

Default: omitted

  Calls: AddMemberMessageAAQToPartner
         AddMemberMessageRTQ
         AddMemberMessagesAAQToBidder
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setEmailCopyToSender {
  my $self = shift;
  $self->{'EmailCopyToSender'} = shift
}

=head2 isEmailCopyToSender()

#    Returns: 'xs:boolean'

=cut

sub isEmailCopyToSender {
  my $self = shift;
  return $self->{'EmailCopyToSender'};
}


=head2 setHideSendersEmailAddress()

Specifies whether or not to hide sender's email address
from the recipient. If omitted, this defaults to whatever
the user set in preferences--or on site policy, which
determines whether or not this field is recognized.
<br><br> <span class="tablenote"><b>Note:</b>
Starting Mid-July 2008 this tag is not operational in the Sandbox environment
and is not operational in the Production environment beginning late August 2008.
</span>

Default: omitted
DeprecationDetails: NoOp
DeprecationVersion: 579
UseInstead: 
  Calls: AddMemberMessageAAQToPartner
         AddMemberMessageRTQ
         AddMemberMessagesAAQToBidder
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setHideSendersEmailAddress {
  my $self = shift;
  $self->{'HideSendersEmailAddress'} = shift
}

=head2 isHideSendersEmailAddress()

#    Returns: 'xs:boolean'

=cut

sub isHideSendersEmailAddress {
  my $self = shift;
  return $self->{'HideSendersEmailAddress'};
}


=head2 setMessageID()

An ID that uniquely identifies a message for a given
user.
<br /><br />
This value is not the same as the value used for the
GetMyMessages MessageID. However, this MessageID value can be
used as the GetMyMessages ExternalID.

#    Argument: 'xs:string'

=cut

sub setMessageID {
  my $self = shift;
  $self->{'MessageID'} = shift
}

=head2 getMessageID()

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getMessageID {
  my $self = shift;
  return $self->{'MessageID'};
}


=head2 setMessageType()

The type of message being retrieved. Note that some message
types can only be created via the eBay Web site.

  Calls: AddMemberMessagesAAQToBidder
  RequiredInput: Yes

#    Argument: 'ns:MessageTypeCodeType'

=cut

sub setMessageType {
  my $self = shift;
  $self->{'MessageType'} = shift
}

=head2 getMessageType()

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'ns:MessageTypeCodeType'

=cut

sub getMessageType {
  my $self = shift;
  return $self->{'MessageType'};
}


=head2 setParentMessageID()

ID number of the question this message is responding to.

  Calls: AddMemberMessageRTQ
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setParentMessageID {
  my $self = shift;
  $self->{'ParentMessageID'} = shift
}

=head2 getParentMessageID()

#    Returns: 'xs:string'

=cut

sub getParentMessageID {
  my $self = shift;
  return $self->{'ParentMessageID'};
}


=head2 setQuestionType()

The context of the question (e.g. Shipping, General).

  Calls: AddMemberMessageAAQToPartner
  RequiredInput: Yes

#    Argument: 'ns:QuestionTypeCodeType'

=cut

sub setQuestionType {
  my $self = shift;
  $self->{'QuestionType'} = shift
}

=head2 getQuestionType()

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'ns:QuestionTypeCodeType'

=cut

sub getQuestionType {
  my $self = shift;
  return $self->{'QuestionType'};
}


=head2 setRecipientID()

Recipient's eBay user ID. For
AddMemberMessagesAAQToBidder, must be the seller of an
item, that item's bidder, or a user who has made an
offer on that item via Best Offer. Note: maxOccurs is a shared schema
element and needs to be unbounded for AddMemberMessagesAAQToBidder. For all other
uses, there can only be one RecipientID.

  Calls: AddMemberMessageAAQToPartner
         AddMemberMessageRTQ
         AddMemberMessagesAAQToBidder
  RequiredInput: Yes

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setRecipientID {
  my $self = shift;
  $self->{'RecipientID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getRecipientID()

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getRecipientID {
  my $self = shift;
  return $self->_getDataTypeArray('RecipientID');
}


=head2 setSenderEmail()

The email address of the person who asked the question or sent
the message. Returned for MessageType = AskSellerQuestion and by the AskSellerQuestion notification.

#    Argument: 'xs:string'

=cut

sub setSenderEmail {
  my $self = shift;
  $self->{'SenderEmail'} = shift
}

=head2 getSenderEmail()

  Calls: GetMemberMessages
  Returned: Conditionally
  DeprecationVersion: 573

#    Returns: 'xs:string'

=cut

sub getSenderEmail {
  my $self = shift;
  return $self->{'SenderEmail'};
}


=head2 setSenderID()

The eBay user ID of the person who asked the question or sent
the message.

#    Argument: 'xs:string'

=cut

sub setSenderID {
  my $self = shift;
  $self->{'SenderID'} = shift
}

=head2 getSenderID()

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getSenderID {
  my $self = shift;
  return $self->{'SenderID'};
}


=head2 setSubject()

Subject of this email message.

  Calls: AddMemberMessageAAQToPartner
  RequiredInput: Yes

#    Argument: 'xs:string'

=cut

sub setSubject {
  my $self = shift;
  $self->{'Subject'} = shift
}

=head2 getSubject()

  Calls: GetMemberMessages
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getSubject {
  my $self = shift;
  return $self->{'Subject'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
