# Copyright 2020, Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package Google::Ads::GoogleAds::V7::Enums::ResourceLimitTypeEnum;

use strict;
use warnings;

use Const::Exporter enums => [
  UNSPECIFIED                           => "UNSPECIFIED",
  UNKNOWN                               => "UNKNOWN",
  CAMPAIGNS_PER_CUSTOMER                => "CAMPAIGNS_PER_CUSTOMER",
  BASE_CAMPAIGNS_PER_CUSTOMER           => "BASE_CAMPAIGNS_PER_CUSTOMER",
  EXPERIMENT_CAMPAIGNS_PER_CUSTOMER     => "EXPERIMENT_CAMPAIGNS_PER_CUSTOMER",
  HOTEL_CAMPAIGNS_PER_CUSTOMER          => "HOTEL_CAMPAIGNS_PER_CUSTOMER",
  SMART_SHOPPING_CAMPAIGNS_PER_CUSTOMER =>
    "SMART_SHOPPING_CAMPAIGNS_PER_CUSTOMER",
  AD_GROUPS_PER_CAMPAIGN                 => "AD_GROUPS_PER_CAMPAIGN",
  AD_GROUPS_PER_SHOPPING_CAMPAIGN        => "AD_GROUPS_PER_SHOPPING_CAMPAIGN",
  AD_GROUPS_PER_HOTEL_CAMPAIGN           => "AD_GROUPS_PER_HOTEL_CAMPAIGN",
  REPORTING_AD_GROUPS_PER_LOCAL_CAMPAIGN =>
    "REPORTING_AD_GROUPS_PER_LOCAL_CAMPAIGN",
  REPORTING_AD_GROUPS_PER_APP_CAMPAIGN =>
    "REPORTING_AD_GROUPS_PER_APP_CAMPAIGN",
  MANAGED_AD_GROUPS_PER_SMART_CAMPAIGN =>
    "MANAGED_AD_GROUPS_PER_SMART_CAMPAIGN",
  AD_GROUP_CRITERIA_PER_CUSTOMER      => "AD_GROUP_CRITERIA_PER_CUSTOMER",
  BASE_AD_GROUP_CRITERIA_PER_CUSTOMER => "BASE_AD_GROUP_CRITERIA_PER_CUSTOMER",
  EXPERIMENT_AD_GROUP_CRITERIA_PER_CUSTOMER =>
    "EXPERIMENT_AD_GROUP_CRITERIA_PER_CUSTOMER",
  AD_GROUP_CRITERIA_PER_CAMPAIGN      => "AD_GROUP_CRITERIA_PER_CAMPAIGN",
  CAMPAIGN_CRITERIA_PER_CUSTOMER      => "CAMPAIGN_CRITERIA_PER_CUSTOMER",
  BASE_CAMPAIGN_CRITERIA_PER_CUSTOMER => "BASE_CAMPAIGN_CRITERIA_PER_CUSTOMER",
  EXPERIMENT_CAMPAIGN_CRITERIA_PER_CUSTOMER =>
    "EXPERIMENT_CAMPAIGN_CRITERIA_PER_CUSTOMER",
  WEBPAGE_CRITERIA_PER_CUSTOMER      => "WEBPAGE_CRITERIA_PER_CUSTOMER",
  BASE_WEBPAGE_CRITERIA_PER_CUSTOMER => "BASE_WEBPAGE_CRITERIA_PER_CUSTOMER",
  EXPERIMENT_WEBPAGE_CRITERIA_PER_CUSTOMER =>
    "EXPERIMENT_WEBPAGE_CRITERIA_PER_CUSTOMER",
  COMBINED_AUDIENCE_CRITERIA_PER_AD_GROUP =>
    "COMBINED_AUDIENCE_CRITERIA_PER_AD_GROUP",
  CUSTOMER_NEGATIVE_PLACEMENT_CRITERIA_PER_CUSTOMER =>
    "CUSTOMER_NEGATIVE_PLACEMENT_CRITERIA_PER_CUSTOMER",
  CUSTOMER_NEGATIVE_YOUTUBE_CHANNEL_CRITERIA_PER_CUSTOMER =>
    "CUSTOMER_NEGATIVE_YOUTUBE_CHANNEL_CRITERIA_PER_CUSTOMER",
  CRITERIA_PER_AD_GROUP                  => "CRITERIA_PER_AD_GROUP",
  LISTING_GROUPS_PER_AD_GROUP            => "LISTING_GROUPS_PER_AD_GROUP",
  EXPLICITLY_SHARED_BUDGETS_PER_CUSTOMER =>
    "EXPLICITLY_SHARED_BUDGETS_PER_CUSTOMER",
  IMPLICITLY_SHARED_BUDGETS_PER_CUSTOMER =>
    "IMPLICITLY_SHARED_BUDGETS_PER_CUSTOMER",
  COMBINED_AUDIENCE_CRITERIA_PER_CAMPAIGN =>
    "COMBINED_AUDIENCE_CRITERIA_PER_CAMPAIGN",
  NEGATIVE_KEYWORDS_PER_CAMPAIGN       => "NEGATIVE_KEYWORDS_PER_CAMPAIGN",
  NEGATIVE_PLACEMENTS_PER_CAMPAIGN     => "NEGATIVE_PLACEMENTS_PER_CAMPAIGN",
  GEO_TARGETS_PER_CAMPAIGN             => "GEO_TARGETS_PER_CAMPAIGN",
  NEGATIVE_IP_BLOCKS_PER_CAMPAIGN      => "NEGATIVE_IP_BLOCKS_PER_CAMPAIGN",
  PROXIMITIES_PER_CAMPAIGN             => "PROXIMITIES_PER_CAMPAIGN",
  LISTING_SCOPES_PER_SHOPPING_CAMPAIGN =>
    "LISTING_SCOPES_PER_SHOPPING_CAMPAIGN",
  LISTING_SCOPES_PER_NON_SHOPPING_CAMPAIGN =>
    "LISTING_SCOPES_PER_NON_SHOPPING_CAMPAIGN",
  NEGATIVE_KEYWORDS_PER_SHARED_SET   => "NEGATIVE_KEYWORDS_PER_SHARED_SET",
  NEGATIVE_PLACEMENTS_PER_SHARED_SET => "NEGATIVE_PLACEMENTS_PER_SHARED_SET",
  SHARED_SETS_PER_CUSTOMER_FOR_TYPE_DEFAULT =>
    "SHARED_SETS_PER_CUSTOMER_FOR_TYPE_DEFAULT",
  SHARED_SETS_PER_CUSTOMER_FOR_NEGATIVE_PLACEMENT_LIST_LOWER =>
    "SHARED_SETS_PER_CUSTOMER_FOR_NEGATIVE_PLACEMENT_LIST_LOWER",
  HOTEL_ADVANCE_BOOKING_WINDOW_BID_MODIFIERS_PER_AD_GROUP =>
    "HOTEL_ADVANCE_BOOKING_WINDOW_BID_MODIFIERS_PER_AD_GROUP",
  BIDDING_STRATEGIES_PER_CUSTOMER      => "BIDDING_STRATEGIES_PER_CUSTOMER",
  BASIC_USER_LISTS_PER_CUSTOMER        => "BASIC_USER_LISTS_PER_CUSTOMER",
  LOGICAL_USER_LISTS_PER_CUSTOMER      => "LOGICAL_USER_LISTS_PER_CUSTOMER",
  BASE_AD_GROUP_ADS_PER_CUSTOMER       => "BASE_AD_GROUP_ADS_PER_CUSTOMER",
  EXPERIMENT_AD_GROUP_ADS_PER_CUSTOMER =>
    "EXPERIMENT_AD_GROUP_ADS_PER_CUSTOMER",
  AD_GROUP_ADS_PER_CAMPAIGN          => "AD_GROUP_ADS_PER_CAMPAIGN",
  TEXT_AND_OTHER_ADS_PER_AD_GROUP    => "TEXT_AND_OTHER_ADS_PER_AD_GROUP",
  IMAGE_ADS_PER_AD_GROUP             => "IMAGE_ADS_PER_AD_GROUP",
  SHOPPING_SMART_ADS_PER_AD_GROUP    => "SHOPPING_SMART_ADS_PER_AD_GROUP",
  RESPONSIVE_SEARCH_ADS_PER_AD_GROUP => "RESPONSIVE_SEARCH_ADS_PER_AD_GROUP",
  APP_ADS_PER_AD_GROUP               => "APP_ADS_PER_AD_GROUP",
  APP_ENGAGEMENT_ADS_PER_AD_GROUP    => "APP_ENGAGEMENT_ADS_PER_AD_GROUP",
  LOCAL_ADS_PER_AD_GROUP             => "LOCAL_ADS_PER_AD_GROUP",
  VIDEO_ADS_PER_AD_GROUP             => "VIDEO_ADS_PER_AD_GROUP",
  LEAD_FORM_ASSET_LINKS_PER_CAMPAIGN => "LEAD_FORM_ASSET_LINKS_PER_CAMPAIGN",
  VERSIONS_PER_AD                    => "VERSIONS_PER_AD",
  USER_FEEDS_PER_CUSTOMER            => "USER_FEEDS_PER_CUSTOMER",
  SYSTEM_FEEDS_PER_CUSTOMER          => "SYSTEM_FEEDS_PER_CUSTOMER",
  FEED_ATTRIBUTES_PER_FEED           => "FEED_ATTRIBUTES_PER_FEED",
  FEED_ITEMS_PER_CUSTOMER            => "FEED_ITEMS_PER_CUSTOMER",
  CAMPAIGN_FEEDS_PER_CUSTOMER        => "CAMPAIGN_FEEDS_PER_CUSTOMER",
  BASE_CAMPAIGN_FEEDS_PER_CUSTOMER   => "BASE_CAMPAIGN_FEEDS_PER_CUSTOMER",
  EXPERIMENT_CAMPAIGN_FEEDS_PER_CUSTOMER =>
    "EXPERIMENT_CAMPAIGN_FEEDS_PER_CUSTOMER",
  AD_GROUP_FEEDS_PER_CUSTOMER            => "AD_GROUP_FEEDS_PER_CUSTOMER",
  BASE_AD_GROUP_FEEDS_PER_CUSTOMER       => "BASE_AD_GROUP_FEEDS_PER_CUSTOMER",
  EXPERIMENT_AD_GROUP_FEEDS_PER_CUSTOMER =>
    "EXPERIMENT_AD_GROUP_FEEDS_PER_CUSTOMER",
  AD_GROUP_FEEDS_PER_CAMPAIGN          => "AD_GROUP_FEEDS_PER_CAMPAIGN",
  FEED_ITEM_SETS_PER_CUSTOMER          => "FEED_ITEM_SETS_PER_CUSTOMER",
  FEED_ITEMS_PER_FEED_ITEM_SET         => "FEED_ITEMS_PER_FEED_ITEM_SET",
  CAMPAIGN_EXPERIMENTS_PER_CUSTOMER    => "CAMPAIGN_EXPERIMENTS_PER_CUSTOMER",
  EXPERIMENT_ARMS_PER_VIDEO_EXPERIMENT =>
    "EXPERIMENT_ARMS_PER_VIDEO_EXPERIMENT",
  OWNED_LABELS_PER_CUSTOMER           => "OWNED_LABELS_PER_CUSTOMER",
  LABELS_PER_CAMPAIGN                 => "LABELS_PER_CAMPAIGN",
  LABELS_PER_AD_GROUP                 => "LABELS_PER_AD_GROUP",
  LABELS_PER_AD_GROUP_AD              => "LABELS_PER_AD_GROUP_AD",
  LABELS_PER_AD_GROUP_CRITERION       => "LABELS_PER_AD_GROUP_CRITERION",
  TARGET_CUSTOMERS_PER_LABEL          => "TARGET_CUSTOMERS_PER_LABEL",
  KEYWORD_PLANS_PER_USER_PER_CUSTOMER => "KEYWORD_PLANS_PER_USER_PER_CUSTOMER",
  KEYWORD_PLAN_AD_GROUP_KEYWORDS_PER_KEYWORD_PLAN =>
    "KEYWORD_PLAN_AD_GROUP_KEYWORDS_PER_KEYWORD_PLAN",
  KEYWORD_PLAN_AD_GROUPS_PER_KEYWORD_PLAN =>
    "KEYWORD_PLAN_AD_GROUPS_PER_KEYWORD_PLAN",
  KEYWORD_PLAN_NEGATIVE_KEYWORDS_PER_KEYWORD_PLAN =>
    "KEYWORD_PLAN_NEGATIVE_KEYWORDS_PER_KEYWORD_PLAN",
  KEYWORD_PLAN_CAMPAIGNS_PER_KEYWORD_PLAN =>
    "KEYWORD_PLAN_CAMPAIGNS_PER_KEYWORD_PLAN",
  CONVERSION_ACTIONS_PER_CUSTOMER => "CONVERSION_ACTIONS_PER_CUSTOMER",
  BATCH_JOB_OPERATIONS_PER_JOB    => "BATCH_JOB_OPERATIONS_PER_JOB",
  BATCH_JOBS_PER_CUSTOMER         => "BATCH_JOBS_PER_CUSTOMER",
  HOTEL_CHECK_IN_DATE_RANGE_BID_MODIFIERS_PER_AD_GROUP =>
    "HOTEL_CHECK_IN_DATE_RANGE_BID_MODIFIERS_PER_AD_GROUP"
];

1;
