NAME
    RISCOS::ALF -- manipulate Acorn Library Format files

SYNOPSIS
        use RISCOS::ALF;

        $library = new RISCOS::ALF $file;
        print "Library file '$file':\n";
        print '  ALF version ', $library->Version, "\n";


DESCRIPTION
    `RISCOS::ALF' provides a class derived from `RISCOS::Chunkfile'
    to manipulate the contents of Acorn Library Format files. It
    provides a classes `RISCOS::ALF::Time' to manipulate 8 byte
    `ALF' microsecond timestamps and `RISCOS::ALF::DirEntry' to
    store details of each directory entry in an `ALF' file.

    Currently the implementation does not decode the library's
    symbol table.

  Methods

    new <array_ref>

    new <file>
        If passed a reference to an array it is assumed to be an
        array of `RISCOS::Chunk' objects to use as the file
        contents. Otherwise calls `RISCOS::File::load' to loads the
        file specified using and checks that it is `ALF'. Hence
        *file* can be a filename, a reference to a filehandle, or a
        reference to a scalar which is used as the file's contents.

        If passed an array reference then this is used internally in
        the object, so should be created with the anonymous array
        constructor `[]' rather than a reference to a named array
        variable (see the "Common Mistakes" entry in the perldsc
        manpage).

        Returns undefined if there was an error, or the file
        contents are corrupt.

    Dir Returns a reference to the hash of `RISCOS::ALF::DirEntry'
        objects describing the `ALF' file's directory. The keys are
        member names, the values the objects.

    Dir_Lookup <name>
        Returns the `RISCOS::ALF::DirEntry' object for *name* in the
        `ALF' file's directory.

    Time
        Returns the `RISCOS::ALF::Time' object that gives the
        library timestamp - the time when the library was last
        modified.

    Sym_Time
        Returns the `RISCOS::ALF::Time' object that gives the
        library symbol table timestamp (or undefined if there is no
        symbol table) - the time when the symbol table was last
        modified.

    Version
        Returns the version number of the `ALF' library. The current
        version is 1.


RISCOS::ALF::Time
    The `RISCOS::ALF::Time' class is used to hold 8 byte microsecond
    timestamps as used in `ALF' libraries. It provides the following
    methods:

    new <packed_timestamp>
        Creates a new `RISCOS::ALF::Time' object from the 8 byte
        packed timestamp in an `ALF' library.

    Time
        Returns the 6 byte timestamp as centiseconds from the start
        of 1900. Assuming little endian byte order the last
        character should be `"\0"' - chop this to get a standard 5
        byte RISCOS timestamp. Note that `RISCOS::Time' functions
        will perform this conversion automatically.

    Micro
        Returns the microseconds field of the timestamp. This is
        usually 0.

    TimeValid
        Performs a sanity check on the time stored in the object.
        Returns:

    0 if the date is outside the range (roughly) 1980 - 2238

    1 if the date is in this range but the microseconds field is non-zero

    2 if the date is in this range and the microseconds field is zero


RISCOS::ALF::DirEntry
    The `RISCOS::ALF::DirEntry' class is used to hold details of
    directory entries in `ALF' libraries. It provides the following
    methods:

    new <scalar_reference>, <chunkfile>, undef, <offset>

    new <file_data>, <chunkfile> ,<length>]
        Creates a new `RISCOS::ALF::DirEntry' from the supplied
        data. If passed a scalar this will be treated as being a
        single '`DATA'' item from a '`LIB_DIRY'' chunk in an `ALF'
        file. *length*, if defined, is used to verify the length
        recorded in the '`DATA'' item.

        If passed a reference to a scalar, then this is dereferenced
        and the *offset* parameter used to locate the '`DATA''
        within this scalar. This allows an entire '`LIB_DIRY'' chunk
        to be converted with minimal string copying. (Remember that
        the length of a '`DATA'' item is unknown until decoding
        commences, so it is not possible to pass a substring to
        `new' without *a priori* knowledge of the length.)

        *chunkfile* is the `RISCOS::Chunkfile' object that contains
        the chunk that this directory entry referes to.

        In scalar context returns the object. In array context
        returns `(object, length, name)'. *length* is added to the
        current *offset* to calculate the offset of the next
        '`DATA'' item.

    Name
        Returns the name of this object, usually the file name whose
        contents form the data for this library member.

    Index
        Returns the index of the chunk which holds the data for this
        member.

    Time
        Returns the `RISCOS::ALF::Time' object that gives the
        timestamp for this member. This is the last-modified time of
        the file whose contents form the data for this library
        member.

    Chunk
        Returns the `RISCOS::Chunk' object for this entry.


BUGS
    As noted, methods to manipulate the library symbol table are
    currently unimplemented. Wildcard matching on library members is
    not implemented.

AUTHOR
    Nicholas Clark <nick@unfortu.net>

