// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gio_sys;
use glib;
use glib::translate::*;
use glib::GString;
use std;
use std::ptr;
use SettingsSchema;

glib_wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct SettingsSchemaSource(Shared<gio_sys::GSettingsSchemaSource>);

    match fn {
        ref => |ptr| gio_sys::g_settings_schema_source_ref(ptr),
        unref => |ptr| gio_sys::g_settings_schema_source_unref(ptr),
        get_type => || gio_sys::g_settings_schema_source_get_type(),
    }
}

impl SettingsSchemaSource {
    pub fn new_from_directory<P: AsRef<std::path::Path>>(
        directory: P,
        parent: Option<&SettingsSchemaSource>,
        trusted: bool,
    ) -> Result<SettingsSchemaSource, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = gio_sys::g_settings_schema_source_new_from_directory(
                directory.as_ref().to_glib_none().0,
                parent.to_glib_none().0,
                trusted.to_glib(),
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    pub fn list_schemas(&self, recursive: bool) -> (Vec<GString>, Vec<GString>) {
        unsafe {
            let mut non_relocatable = ptr::null_mut();
            let mut relocatable = ptr::null_mut();
            gio_sys::g_settings_schema_source_list_schemas(
                self.to_glib_none().0,
                recursive.to_glib(),
                &mut non_relocatable,
                &mut relocatable,
            );
            (
                FromGlibPtrContainer::from_glib_full(non_relocatable),
                FromGlibPtrContainer::from_glib_full(relocatable),
            )
        }
    }

    pub fn lookup(&self, schema_id: &str, recursive: bool) -> Option<SettingsSchema> {
        unsafe {
            from_glib_full(gio_sys::g_settings_schema_source_lookup(
                self.to_glib_none().0,
                schema_id.to_glib_none().0,
                recursive.to_glib(),
            ))
        }
    }

    pub fn get_default() -> Option<SettingsSchemaSource> {
        unsafe { from_glib_none(gio_sys::g_settings_schema_source_get_default()) }
    }
}
