/*
 *  KCemu -- The emulator for the KC85 homecomputer series and much more.
 *  Copyright (C) 1997-2010 Torsten Paul
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __kc_keyb3k_h
#define __kc_keyb3k_h

/*
 *  the lower 8 bits (0-7) of the value in the following array are
 *  the value specified in the system manual
 *  they should be defined by the hardware of the keyboard that
 *  uses an U807 remote control circuit
 *
 *  if bit 8 is set the shift state must be applied to the key value
 *  before it is send
 */
static unsigned int __keys[] = {
  /*  0x00 [.] */ 0xffff,
  /*  0x01 [.] */ 0x0018,
  /*  0x02 [.] */ 0x0029,
  /*  0x03 [.] */ 0x003c,
  /*  0x04 [.] */ 0xffff,
  /*  0x05 [.] */ 0xffff,
  /*  0x06 [.] */ 0xffff,
  /*  0x07 [.] */ 0xffff,
  /*  0x08 [.] */ 0x0018,
  /*  0x09 [.] */ 0x007a,
  /*  0x0a [.] */ 0x0076,
  /*  0x0b [.] */ 0x0078,
  /*  0x0c [.] */ 0x0009,
  /*  0x0d [.] */ 0x007e, /* ENTER */
  /*  0x0e [.] */ 0xffff,
  /*  0x0f [.] */ 0x0019,
  /*  0x10 [.] */ 0x0008,
  /*  0x11 [.] */ 0x0079,
  /*  0x12 [.] */ 0x0077,
  /*  0x13 [.] */ 0x004c,
  /*  0x14 [.] */ 0x0039,
  /*  0x15 [.] */ 0xffff,
  /*  0x16 [.] */ 0x0073,
  /*  0x17 [.] */ 0xffff,
  /*  0x18 [.] */ 0x007b,
  /*  0x19 [.] */ 0x0007,
  /*  0x1a [.] */ 0x0038,
  /*  0x1b [.] */ 0x004d, /* ESC */
  /*  0x1c [.] */ 0xffff,
  /*  0x1d [.] */ 0xffff,
  /*  0x1e [.] */ 0xffff,
  /*  0x1f [.] */ 0x0028,
  /*  0x20 [ ] */ 0x0046, /* SPACE */
  /*  0x21 [!] */ 0x0075,
  /*  0x22 ["] */ 0x0005,
  /*  0x23 [#] */ 0x0015,
  /*  0x24 [$] */ 0x0065,
  /*  0x25 [%] */ 0x0025,
  /*  0x26 [&] */ 0x0055,
  /*  0x27 ['] */ 0x0035,
  /*  0x28 [(] */ 0x0045,
  /*  0x29 [)] */ 0x003b,
  /*  0x2a [*] */ 0x001b,
  /*  0x2b [+] */ 0x0068,
  /*  0x2c [,] */ 0x004a,
  /*  0x2d [-] */ 0x000a,
  /*  0x2e [.] */ 0x005a,
  /*  0x2f [/] */ 0x106a,
  /*  0x30 [0] */ 0x002a,
  /*  0x31 [1] */ 0x0074,
  /*  0x32 [2] */ 0x0004,
  /*  0x33 [3] */ 0x0014,
  /*  0x34 [4] */ 0x0064,
  /*  0x35 [5] */ 0x0024,
  /*  0x36 [6] */ 0x0054,
  /*  0x37 [7] */ 0x0034,
  /*  0x38 [8] */ 0x0044,
  /*  0x39 [9] */ 0x003a,
  /*  0x3a [:] */ 0x101a,
  /*  0x3b [;] */ 0x0069,
  /*  0x3c [<] */ 0x004b,
  /*  0x3d [=] */ 0x000b,
  /*  0x3e [>] */ 0x005b,
  /*  0x3f [?] */ 0x006b,
  /*  0x40 [@] */ 0x002b,
  /*  0x41 [A] */ 0x0003,
  /*  0x42 [B] */ 0x005f,
  /*  0x43 [C] */ 0x006f,
  /*  0x44 [D] */ 0x0063,
  /*  0x45 [E] */ 0x0011,
  /*  0x46 [F] */ 0x0023,
  /*  0x47 [G] */ 0x0053,
  /*  0x48 [H] */ 0x0033,
  /*  0x49 [I] */ 0x0041,
  /*  0x4a [J] */ 0x0043,
  /*  0x4b [K] */ 0x0049,
  /*  0x4c [L] */ 0x0059,
  /*  0x4d [M] */ 0x004f,
  /*  0x4e [N] */ 0x003f,
  /*  0x4f [O] */ 0x0037,
  /*  0x50 [P] */ 0x0027,
  /*  0x51 [Q] */ 0x0071,
  /*  0x52 [R] */ 0x0061,
  /*  0x53 [S] */ 0x0013,
  /*  0x54 [T] */ 0x0021,
  /*  0x55 [U] */ 0x0031,
  /*  0x56 [V] */ 0x002f,
  /*  0x57 [W] */ 0x0001,
  /*  0x58 [X] */ 0x001f,
  /*  0x59 [Y] */ 0x000f,
  /*  0x5a [Z] */ 0x0051,
  /*  0x5b [[] */ 0x0047,
  /*  0x5c [\] */ 0xffff,
  /*  0x5d []] */ 0xffff,
  /*  0x5e [^] */ 0x0016,
  /*  0x5f [_] */ 0x1066,
  /*  0x60 [`] */ 0x002a,
  /*  0x61 [a] */ 0x0002,
  /*  0x62 [b] */ 0x005e,
  /*  0x63 [c] */ 0x006e,
  /*  0x64 [d] */ 0x0062,
  /*  0x65 [e] */ 0x0010,
  /*  0x66 [f] */ 0x0022,
  /*  0x67 [g] */ 0x0052,
  /*  0x68 [h] */ 0x0032,
  /*  0x69 [i] */ 0x0040,
  /*  0x6a [j] */ 0x0042,
  /*  0x6b [k] */ 0x0048,
  /*  0x6c [l] */ 0x0058,
  /*  0x6d [m] */ 0x004e,
  /*  0x6e [n] */ 0x003e,
  /*  0x6f [o] */ 0x0036,
  /*  0x70 [p] */ 0x0026,
  /*  0x71 [q] */ 0x0070,
  /*  0x72 [r] */ 0x0060,
  /*  0x73 [s] */ 0x0012,
  /*  0x74 [t] */ 0x0020,
  /*  0x75 [u] */ 0x0030,
  /*  0x76 [v] */ 0x002e,
  /*  0x77 [w] */ 0x0000,
  /*  0x78 [x] */ 0x001e,
  /*  0x79 [y] */ 0x000e,
  /*  0x7a [z] */ 0x0050,
  /*  0x7b [{] */ 0xffff,
  /*  0x7c [|] */ 0x0067,
  /*  0x7d [}] */ 0xffff,
  /*  0x7e [~] */ 0x0017,
  /*  0x7f [.] */ 0x0028,
  /*  0x80 [.] */ 0xffff,
  /*  0x81 [.] */ 0xffff,
  /*  0x82 [.] */ 0xffff,
  /*  0x83 [.] */ 0xffff,
  /*  0x84 [.] */ 0xffff,
  /*  0x85 [.] */ 0xffff,
  /*  0x86 [.] */ 0xffff,
  /*  0x87 [.] */ 0xffff,
  /*  0x88 [.] */ 0xffff,
  /*  0x89 [.] */ 0xffff,
  /*  0x8a [.] */ 0xffff,
  /*  0x8b [.] */ 0xffff,
  /*  0x8c [.] */ 0xffff,
  /*  0x8d [.] */ 0xffff,
  /*  0x8e [.] */ 0xffff,
  /*  0x8f [.] */ 0xffff,
  /*  0x90 [.] */ 0xffff,
  /*  0x91 [.] */ 0xffff,
  /*  0x92 [.] */ 0xffff,
  /*  0x93 [.] */ 0xffff,
  /*  0x94 [.] */ 0xffff,
  /*  0x95 [.] */ 0xffff,
  /*  0x96 [.] */ 0xffff,
  /*  0x97 [.] */ 0xffff,
  /*  0x98 [.] */ 0xffff,
  /*  0x99 [.] */ 0xffff,
  /*  0x9a [.] */ 0xffff,
  /*  0x9b [.] */ 0xffff,
  /*  0x9c [.] */ 0xffff,
  /*  0x9d [.] */ 0xffff,
  /*  0x9e [.] */ 0xffff,
  /*  0x9f [.] */ 0xffff,
  /*  0xa0 [.] */ 0xffff,
  /*  0xa1 [.] */ 0xffff,
  /*  0xa2 [.] */ 0xffff,
  /*  0xa3 [.] */ 0xffff,
  /*  0xa4 [.] */ 0xffff,
  /*  0xa5 [.] */ 0xffff,
  /*  0xa6 [.] */ 0xffff,
  /*  0xa7 [.] */ 0xffff,
  /*  0xa8 [.] */ 0xffff,
  /*  0xa9 [.] */ 0xffff,
  /*  0xaa [.] */ 0xffff,
  /*  0xab [.] */ 0xffff,
  /*  0xac [.] */ 0xffff,
  /*  0xad [.] */ 0xffff,
  /*  0xae [.] */ 0xffff,
  /*  0xaf [.] */ 0xffff,
  /*  0xb0 [�] */ 0x0017,
  /*  0xb1 [.] */ 0xffff,
  /*  0xb2 [.] */ 0xffff,
  /*  0xb3 [.] */ 0xffff,
  /*  0xb4 [.] */ 0xffff,
  /*  0xb5 [.] */ 0xffff,
  /*  0xb6 [.] */ 0xffff,
  /*  0xb7 [.] */ 0xffff,
  /*  0xb8 [.] */ 0xffff,
  /*  0xb9 [.] */ 0xffff,
  /*  0xba [.] */ 0xffff,
  /*  0xbb [.] */ 0xffff,
  /*  0xbc [.] */ 0xffff,
  /*  0xbd [.] */ 0xffff,
  /*  0xbe [.] */ 0xffff,
  /*  0xbf [.] */ 0xffff,
  /*  0xc0 [.] */ 0xffff,
  /*  0xc1 [.] */ 0xffff,
  /*  0xc2 [.] */ 0xffff,
  /*  0xc3 [.] */ 0xffff,
  /*  0xc4 [.] */ 0xffff,
  /*  0xc5 [.] */ 0xffff,
  /*  0xc6 [.] */ 0xffff,
  /*  0xc7 [.] */ 0xffff,
  /*  0xc8 [.] */ 0xffff,
  /*  0xc9 [.] */ 0xffff,
  /*  0xca [.] */ 0xffff,
  /*  0xcb [.] */ 0xffff,
  /*  0xcc [.] */ 0xffff,
  /*  0xcd [.] */ 0xffff,
  /*  0xce [.] */ 0xffff,
  /*  0xcf [.] */ 0xffff,
  /*  0xd0 [.] */ 0xffff,
  /*  0xd1 [.] */ 0xffff,
  /*  0xd2 [.] */ 0xffff,
  /*  0xd3 [.] */ 0xffff,
  /*  0xd4 [.] */ 0xffff,
  /*  0xd5 [.] */ 0xffff,
  /*  0xd6 [.] */ 0xffff,
  /*  0xd7 [.] */ 0xffff,
  /*  0xd8 [.] */ 0xffff,
  /*  0xd9 [.] */ 0xffff,
  /*  0xda [.] */ 0xffff,
  /*  0xdb [.] */ 0xffff,
  /*  0xdc [.] */ 0xffff,
  /*  0xdd [.] */ 0xffff,
  /*  0xde [.] */ 0xffff,
  /*  0xdf [.] */ 0xffff,
  /*  0xe0 [.] */ 0xffff,
  /*  0xe1 [.] */ 0xffff,
  /*  0xe2 [.] */ 0xffff,
  /*  0xe3 [.] */ 0xffff,
  /*  0xe4 [.] */ 0xffff,
  /*  0xe5 [.] */ 0xffff,
  /*  0xe6 [.] */ 0xffff,
  /*  0xe7 [.] */ 0xffff,
  /*  0xe8 [.] */ 0xffff,
  /*  0xe9 [.] */ 0xffff,
  /*  0xea [.] */ 0xffff,
  /*  0xeb [.] */ 0xffff,
  /*  0xec [.] */ 0xffff,
  /*  0xed [.] */ 0xffff,
  /*  0xee [.] */ 0xffff,
  /*  0xef [.] */ 0xffff,
  /*  0xf0 [.] */ 0xffff,
  /*  0xf1 [.] */ 0xffff,
  /*  0xf2 [.] */ 0xffff,
  /*  0xf3 [.] */ 0xffff,
  /*  0xf4 [.] */ 0xffff,
  /*  0xf5 [.] */ 0xffff,
  /*  0xf6 [.] */ 0xffff,
  /*  0xf7 [.] */ 0xffff,
  /*  0xf8 [.] */ 0xffff,
  /*  0xf9 [.] */ 0xffff,
  /*  0xfa [.] */ 0xffff,
  /*  0xfb [.] */ 0xffff,
  /*  0xfc [.] */ 0xffff,
  /*  0xfd [.] */ 0xffff,
  /*  0xfe [.] */ 0xffff,
  /*  0xff [.] */ 0xffff,

  /* 0x100 */ 0xffff,
  /* 0x101 */ 0x007c, /* F1 */
  /* 0x102 */ 0x000c, /* F2 */
  /* 0x103 */ 0x001c, /* F3 */
  /* 0x104 */ 0x006c, /* F4 */
  /* 0x105 */ 0x002c, /* F5 */
  /* 0x106 */ 0x005c, /* F6 */
  /* 0x107 */ 0x007d, /* F7 */
  /* 0x108 */ 0x000d, /* F8 */
  /* 0x109 */ 0x001d, /* F9 */
  /* 0x10a */ 0x006d, /* F10 */
  /* 0x10b */ 0x002d, /* F11 */
  /* 0x10c */ 0x005d, /* F12 */
  /* 0x10d */ 0xffff, /* F13 */
  /* 0x10e */ 0xffff, /* F14 */
  /* 0x10f */ 0xffff, /* F15 */
  /* 0x110 */ 0xffff, /* SHIFT */
  /* 0x111 */ 0xffff, /* CONTROL */
  /* 0x112 */ 0xffff, /* ALT */
  /* 0x113 */ 0xffff, /* ALT_GR */
  /* 0x114 */ 0x0006, /* LEFT */
  /* 0x115 */ 0x007a, /* RIGHT */
  /* 0x116 */ 0x0076, /* DOWN */
  /* 0x117 */ 0x0078, /* UP */
  /* 0x118 */ 0x0008, /* HOME */
  /* 0x119 */ 0x007b, /* END */
  /* 0x11a */ 0x0028, /* DEL */
  /* 0x11b */ 0x0038, /* INSERT */
  /* 0x11c */ 0x007b, /* PAGE_UP */
  /* 0x11d */ 0x0007, /* PAGE_DOWN */
  /* 0x11e */ 0x004c, /* PAUSE */
  /* 0x11f */ 0x003c, /* PRINT */
  /* 0x120 */ 0xffff, /* COLOR */
  /* 0x121 */ 0xffff, /* GRAPHIC */
  /* 0x122 */ 0xffff, /* LIST */
  /* 0x123 */ 0xffff, /* RUN */
  /* 0x124 */ 0x004c, /* STOP */
  /* 0x125 */ 0x0072, /* SHIFT_LOCK */
  /* 0x126 */ 0xffff, /* RESET */
  /* 0x127 */ 0xffff, /* NMI */
  /* 0x128 */ 0x003c, /* BREAK */
  /* 0x129 */ 0x0018, /* CLEAR */
  
  /* 0x12a */ 0xffff,
  /* 0x12b */ 0xffff,
  /* 0x12c */ 0xffff,
  /* 0x12d */ 0xffff,
  /* 0x12e */ 0xffff,
  /* 0x12f */ 0xffff,
};

#endif /* __kc_keyb3k_h */
