/*
 * Copyright (c) 2007, intarsys consulting GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of intarsys nor the names of its contributors may be used
 *   to endorse or promote products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package de.intarsys.tools.event;

/**
 * An object indicating an event.
 * 
 */
public interface IEvent {
	/**
	 * Indicate that this event does not need to be propagated any further as it
	 * is already processed by some listener.
	 */
	public void consume();

	/**
	 * A name for this event.
	 * 
	 * @return A name for this event.
	 */
	public String getName();

	/**
	 * The object originating the event instance.
	 * 
	 * @return The object originating the event instance.
	 */
	public Object getSource();

	/**
	 * A type for this event.
	 * 
	 * @return A type for this event.
	 */
	public EventType getEventType();

	/**
	 * <code>true</code> if this event is already consumed by some listener.
	 * 
	 * @return <code>true</code> if this event is already consumed by some
	 *         listener.
	 */
	public boolean isConsumed();

	/**
	 * <code>true</code> if this event is already vetoed by some listener.
	 * 
	 * @return <code>true</code> if this event is already vetoed by some
	 *         listener.
	 */
	public boolean isVetoed();

	/**
	 * Indicate that the behavior associated with this event should not be
	 * performed by the source.
	 */
	public void veto();
}
