/* $Id: Cit_gen.cpp 498027 2016-04-12 18:56:44Z grichenk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'biblio.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/biblio/Cit_gen.hpp>
#include <objects/general/Date.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CCit_gen::~CCit_gen(void)
{
}


bool CCit_gen::GetLabelV1(string* label, TLabelFlags flags) const
{
    bool unique = (flags & fLabel_Unique) != 0;

    if (IsSetSerial_number()) {
        *label += "[" + NStr::IntToString(GetSerial_number()) + "]";
    }
    if (IsSetMuid()) {
        *label += "NLM" + NStr::NumericToString(GetMuid());
    }

    string date;
    string* date_ptr = 0;
    if ( IsSetDate() ) {
        date_ptr = &date;
        GetDate().GetDate(date_ptr, true);
    }

    const string* title2 = 0;
    const string* titleunique = 0;
    bool unpublished = false;
    const CTitle* title = IsSetJournal() ? &GetJournal() : 0;
    const CAuth_list* authors = IsSetAuthors() ? &GetAuthors() : 0;
    const string* volume = IsSetVolume() ? &GetVolume() : 0;
    const string* issue = IsSetIssue() ? &GetIssue() : 0;
    const string* pages = IsSetPages() ? &GetPages() : 0;

    if (IsSetCit()) {
        if ( NStr::EqualNocase( GetCit(), "Unpublished") ) {
            unpublished = true;
        } else if (!title) {
            title2 = &GetCit();
        }
    }
    if (IsSetTitle()) {
        titleunique = &GetTitle();
    } else if (title2) {
        titleunique = title2;
    } else if (!title && IsSetCit()) {
        titleunique = &GetCit();
    }
    if (!title && !authors && !IsSetTitle() && !volume &&
        !pages && !issue) {
        titleunique = 0;
        if (IsSetCit()) {
            string cit(GetCit());
            if (!unique) {
                try {
                    cit.resize(cit.find_last_of('|'));
                } catch(length_error&) {}
            }   
            *label += cit;
        }
        return true;
    }

    return x_GetLabelV1(label, unique,
        authors, 0, title, 0, 0, 0, title2, titleunique,
        date_ptr, volume, issue, pages, unpublished);
}


// Based on FormatCitGen from the C Toolkit's api/asn2gnb5.c.
bool CCit_gen::GetLabelV2(string* label, TLabelFlags flags) const
{
    if ( !CanGetCit()  &&  !CanGetJournal()  &&  !CanGetDate()
        &&  CanGetSerial_number() ) {
        return false;
    }

    if ( !CanGetJournal()  &&  CanGetCit()  &&  SWNC(GetCit(), "unpublished")) {
        if ((flags & fLabel_NoUnpubAffil) != 0) {
            MaybeAddSpace(label);
            *label += "Unpublished";
            return true;
        }

        if (CanGetAuthors()  &&  GetAuthors().CanGetAffil()) {
            MaybeAddSpace(label);
            *label += "Unpublished ";
            GetAuthors().GetAffil().GetLabel(label, flags, eLabel_V2);
            NStr::TruncateSpacesInPlace(*label, NStr::eTrunc_End);
            return true;
        }

        if (CanGetCit()  &&  HasText(GetCit())) {
            MaybeAddSpace(label);
            *label += NStr::TruncateSpaces(GetCit());
            return true;
        } else {
            return false;
        }
    }

    string year  = CanGetDate()  ? GetParenthesizedYear(GetDate()) : kEmptyStr;
    string pages = CanGetPages() ? FixPages(GetPages())            : kEmptyStr;
    string journal, inpress;
    SIZE_TYPE pos;

    if (CanGetJournal()) {
        journal = GetJournal().GetTitle();
    }

    if (CanGetCit()) {
        pos = GetCit().find("Journal=\"");
        if (pos != NPOS) {
            journal = GetCit().substr(pos + 9);
        } else if (SWNC(GetCit(), "submitted")
                   ||  SWNC(GetCit(), "unpublished")) {
            if ((flags & fLabel_NoBadCitGen) == 0  ||  !journal.empty()) {
                inpress = GetCit();
            } else {
                inpress = "Unpublished";
            }
        } else if (SWNC(GetCit(), "Online Publication")
                   ||  SWNC(GetCit(), "Published Only in DataBase")
                   ||  SWNC(GetCit(), "In press")) {
            inpress = GetCit();
        } else if (SWNC(GetCit(), "(er) ")) {
            journal = GetCit();
        } else if ((flags & fLabel_NoBadCitGen) == 0  &&  journal.empty()) {
            journal = GetCit();
        }
    }

    if ((!HasText(pages) || (flags & (fLabel_FlatNCBI | fLabel_FlatEMBL)) == 0)
        &&  journal.empty()  &&  !HasText(inpress)  &&  !HasText(year)
        &&  (!CanGetVolume() || !HasText(GetVolume()))) {
        return false;
    }

    string prefix;
    MaybeAddSpace(label);

    if ( !journal.empty() ) {
        pos = journal.find_first_of("=\"");
        if (pos != NPOS) {
            journal.resize(pos);
        }
        *label += journal;
        prefix = " ";
    }

    if (HasText(inpress)) {
        *label += prefix + inpress;
        prefix = " ";
    }

    if (CanGetVolume()  &&  HasText(GetVolume())) {
        *label += prefix + GetVolume();
    }

    if (HasText(pages)) {
        if ((flags & fLabel_FlatNCBI) != 0) {
            *label += ", " + pages;
        } else if ((flags & fLabel_FlatEMBL) != 0) {
            *label += ':' + pages;
        }
    }

    if (HasText(year)) {
        *label += ' ' + year;
    }

    return true;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1875, CRC32: 5ca91cd9 */
