/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include "stdlib/blas/base/snrm2.h"
#include "stdlib/blas/base/snrm2_cblas.h"

/**
* Computes the L2-norm of a single-precision floating-point vector.
*
* @param N       number of values over which to compute the norm
* @param X       input array
* @param stride  stride length
* @return        output value
*/
float c_snrm2( const int N, const float *X, const int stride ) {
	return cblas_snrm2( N, X, stride );
}
