/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_INSTRUMENT_H__
#define __BSE_INSTRUMENT_H__

#include	<bse/bsesong.h>
#include	<bse/bsesample.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



struct _BseInstrument
{
  BseInstrumentType  type;
  BseSong	    *song;
  
  gchar		    *name;
  gchar		    *blurb;
  
  /* sample specific fields */
  gchar		*deferred_sample_name;
  gchar		*deferred_sample_path;
  BseSample	*sample;
  
  /* the following are public fields, see bse_instrument_modified()
   */
  guint		 interpolation : 1;
  
  /* common fields
   */
  guint polyphony : 1;
  guint volume;
  gint	balance;
  gint	transpose;
  gint	fine_tune;
  
  /* envelope
   */
  guint delay_time;
  guint attack_time;
  guint attack_level;
  guint decay_time;
  guint sustain_level;
  guint sustain_time;
  guint release_level;
  guint release_time;
};


/* --- prototypes -- */
guint	bse_instrument_get_guid		(BseInstrument	*instrument);
void	bse_instrument_set_name		(BseInstrument	*instrument,
					 const gchar	*name);
gchar*	bse_instrument_get_name		(BseInstrument	*instrument);
void	bse_instrument_set_blurb	(BseInstrument	*instrument,
					 const gchar	*blurb);
gchar*	bse_instrument_get_blurb	(BseInstrument	*instrument);
void	bse_instrument_set_sample	(BseInstrument	*instrument,
					 BseSample	*sample);





#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_INSTRUMENT_H__ */
