/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_PATTERN_H__
#define __BSE_PATTERN_H__

#include	<bse/bsebase.h>
#include	<bse/bseinstrument.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


struct	_BsePattern
{
  BseSong *song;
  
  gchar *name;
  gchar *blurb;
  
  guint n_channels		/* mirrored from BseSong */;
  guint n_rows			/* mirrored from BseSong.pattern_length */;
  
  BseNote *notes		/* ->notes [ channel_idx * n_channels + row] */;
};

struct	_BseNote
{
  guint	note;
  BseInstrument *instrument;
  BseEffect *next_effect;
};

struct	_BseEffect
{
  BseEffectType	type;
  gint32	value;
  BseEffect	*next;
};


/* --- prototypes --- */
void		bse_pattern_set_note	    (BsePattern		*pattern,
					     guint		 channel,
					     guint		 row,
					     guint		 note,
					     BseInstrument	*instrument);
guint		bse_pattern_get_guid	    (BsePattern		*pattern);
BseNote*	bse_pattern_get_note	    (BsePattern		*pattern,
					     guint		 channel,
					     guint		 row);
void		bse_pattern_set_name	    (BsePattern		*pattern,
					     const gchar	*name);
gchar*		bse_pattern_get_name	    (BsePattern		*pattern);
void		bse_pattern_set_blurb	    (BsePattern		*pattern,
					     const gchar	*blurb);
gchar*		bse_pattern_get_blurb	    (BsePattern		*pattern);




#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_PATTERN_H__ */
