/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_UTILS_H__
#define __BSE_UTILS_H__

#include	<bse/bsedefs.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* return the number of bits that are required to store the number `n'.
 */
extern inline guint	bse_bit_storage		(guint		n);
extern inline guint	bse_bit_storage		(guint		n)
{ register guint bits = 0; do { bits++; n = n >> 1; } while (n); return bits; }

/* this functions mutates special characters to conform to
 * internal rules about sample names. operation is performed
 * on the source string.
 */
gchar*		bse_sample_name_make_valid	(gchar		*string);
gchar*		bse_song_name_make_valid	(gchar		*string);

/* return a newly allocated string which describes `note' literally.
 */
gchar*		bse_note_2_string		(guint		note);

/* return the numeric value of the note in `note_string'.
 * this function will return BSE_NOTE_VOID if the conversation failed.
 */
guint		bse_string_2_note		(const gchar	*note_string);

/* figure out the specific characteristics of `note'.
 */
void		bse_note_examine		(guint		note,
						 gint		*octave_p,
						 guint		*half_tone_p,
						 gboolean	*half_tone_flag_p,
						 gchar		*letter_p);


/* --- the following stuff is preserved for internal use only! --- */
#define	_BSE_STRUCT_SET_STRING(type,key,pointer,string)	G_STMT_START { \
  register type* _bse_intern_var_ ## type ## _1; \
  _bse_intern_var_ ## type ## _1 = (pointer); \
  _bse_struct_set_string ((gpointer) _bse_intern_var_ ## type ## _1, \
			  "bse-" # key, (string)); \
} G_STMT_END
#define	_BSE_STRUCT_GET_STRING(type,key,pointer) \
  (_bse_struct_get_string ((gpointer) (pointer), "bse-" # key))

#define	_BSE_STRUCT_SET_LONG(type,key,v_long,string)	G_STMT_START { \
  register type* _bse_intern_var_ ## type ## _1; \
  _bse_intern_var_ ## type ## _1 = (pointer); \
  _bse_struct_set_long ((gpointer) _bse_intern_var_ ## type ## _1, \
			"bse-" # key, (v_long)); \
} G_STMT_END
#define	_BSE_STRUCT_GET_LONG(type,key,pointer) \
  (_bse_struct_get_long ((gpointer) (pointer), "bse-" # key))

#define	_BSE_STRUCT_SET_ULONG		_BSE_STRUCT_SET_LONG
#define	_BSE_STRUCT_GET_ULONG(t,k,p)	((gulong) _BSE_STRUCT_GET_LONG (t,k,p))

/* internal functions
 */
void	_bse_struct_set_string	(gpointer	bse_struct,
				 const gchar	*key,
				 const gchar	*string);
gchar*	_bse_struct_get_string	(gpointer	*bse_struct,
				 const gchar	*key);
void	_bse_struct_set_long	(gpointer	bse_struct,
				 const gchar	*key,
				 glong		 v_long);
glong	_bse_struct_get_long	(gpointer	*bse_struct,
				 const gchar	*key);
void	_bse_struct_set_blurb	(gpointer	bse_struct,
				 const gchar	*blurb);
gchar*	_bse_struct_get_blurb	(gpointer	*bse_struct);

void		 bse_struct_add_cb	(gpointer	  bse_struct,
					 guint		  key_id,
					 BseGenericCB	  callback,
					 gpointer	  callback_data);
void		 bse_struct_remove_cb	(gpointer	  bse_struct,
					 guint		  key_id,
					 BseGenericCB	  callback,
					 gpointer	  callback_data);
BseCallbackNode* bse_struct_detach_cbs	(gpointer	  bse_struct,
					 guint		  key_id);
void		 bse_struct_delete_cbs	(BseCallbackNode *nodes);
void		 bse_struct_attach_cbs	(gpointer	  bse_struct,
					 guint		  key_id,
					 BseCallbackNode *nodes);
void		 bse_struct_remove_cbs	(gpointer	  bse_struct,
					 guint		  key_id);








#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_UTILS_H__ */
