/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef	__BSE_VALUE_BLOCK_H__
#define	__BSE_VALUE_BLOCK_H__

#include	<bse/bsebase.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


struct _BseValueBlock
{
  guint ref_count;

  /* zero blocks are identified by identifier == NULL
   */
  const gchar *identifier;
  guint n_values;

  /* loop_end == 0 indicates no loop,
   * loops are ignored for zero blocks
   */
  guint loop_begin;
  guint loop_end;

  BseSampleValue *values;
};


BseValueBlock*	bse_value_block_new		(const gchar	*identifier,
						 guint		 n_values,
						 BseSampleValue	*values,
						 guint           loop_begin,
						 guint           loop_end);
BseValueBlock*	bse_value_block_zero		(guint		 n_values);
void		bse_value_block_ref		(BseValueBlock	*block);
void		bse_value_block_unref		(BseValueBlock	*block);
BseValueBlock*	bse_value_block_get		(const gchar    *identifier,
						 guint           n_values,
						 guint           loop_begin,
						 guint           loop_end);
BseValueBlock*	bse_value_block_get_closest	(const gchar    *identifier,
						 guint           n_values,
						 guint           loop_begin,
						 guint           loop_end);


/* bse_value_block_alloc() has to be immediately followed by a call to
 * either bse_value_block_setup() or bse_value_block_free() since the
 * value block isn't really valid after bse_value_block_alloc().
 * these functions are meant for internal use only.
 */
BseValueBlock*	bse_value_block_alloc		(guint		 n_values);
BseValueBlock*	bse_value_block_setup		(BseValueBlock	*block_mem,
						 const gchar	*identifier,
						 guint		 loop_begin,
						 guint		 loop_end);
void		bse_value_block_free		(BseValueBlock	*block_mem);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_VALUE_BLOCK_H__ */
