
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsesource.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsesource.h>


#line 29 "bsesource.proc"


/* --- set-input-by-id --- */
static GType type_id_set_input_by_id = 0;
static void
set_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 31 "bsesource.proc"
 {
#line 33 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("imodule", "Input Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("omodule", "Output Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("output-channel", "Output Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 32 "bsesource.proc"
  proc->help = "Connect a module input to another module's output.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 45 "bsesource.proc"
 }
static BseErrorType
#line 45 "bsesource.proc"
set_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 48 "bsesource.proc"
{
#line 49 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);
  guint ichannel     = g_value_get_uint (in_values++);
  BseSource *osource = g_value_get_object (in_values++);
  guint ochannel     = g_value_get_uint (in_values++);
  BseErrorType error;

#line 56 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 61 "bsesource.proc"
  
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  
#line 64 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- set-input --- */
static GType type_id_set_input = 0;
static void
set_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 70 "bsesource.proc"
 {
#line 72 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("imodule", "Input Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("input-channel", "Input Channel", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("omodule", "Output Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("output-channel", "Output Channel", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 71 "bsesource.proc"
  proc->help = "Connect a module input to another module's output.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 84 "bsesource.proc"
 }
static BseErrorType
#line 84 "bsesource.proc"
set_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 87 "bsesource.proc"
{
#line 88 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);
  gchar *ichannel    = g_value_get_string (in_values++);
  BseSource *osource = g_value_get_object (in_values++);
  gchar *ochannel    = g_value_get_string (in_values++);
  BseErrorType error;

#line 95 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent ||
      !ichannel || !ochannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 101 "bsesource.proc"
  
  error = bse_source_set_input (isource, bse_source_find_ichannel (isource, ichannel),
				osource, bse_source_find_ochannel (osource, ochannel));
  
#line 105 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input-by-id --- */
static GType type_id_unset_input_by_id = 0;
static void
unset_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 111 "bsesource.proc"
 {
#line 113 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("omodule", "Output Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("output-channel", "Output Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 112 "bsesource.proc"
  proc->help = "Disconnect a module input.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 125 "bsesource.proc"
 }
static BseErrorType
#line 125 "bsesource.proc"
unset_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 128 "bsesource.proc"
{
#line 129 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);
  guint ichannel     = g_value_get_uint (in_values++);
  BseSource *osource = g_value_get_object (in_values++);
  guint ochannel     = g_value_get_uint (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 136 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 141 "bsesource.proc"
  
  error = bse_source_unset_input (isource, ichannel, osource, ochannel);

#line 144 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input --- */
static GType type_id_unset_input = 0;
static void
unset_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 150 "bsesource.proc"
 {
#line 152 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("input-channel", "Input Channel", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("omodule", "Output Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("output-channel", "Output Channel", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 151 "bsesource.proc"
  proc->help = "Disconnect a module input.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 164 "bsesource.proc"
 }
static BseErrorType
#line 164 "bsesource.proc"
unset_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 167 "bsesource.proc"
{
#line 168 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);
  gchar *ichannel    = g_value_get_string (in_values++);
  BseSource *osource = g_value_get_object (in_values++);
  gchar *ochannel    = g_value_get_string (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 175 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent ||
      !ichannel || !ochannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 181 "bsesource.proc"
  
  error = bse_source_unset_input (isource, bse_source_find_ichannel (isource, ichannel),
				  osource, bse_source_find_ochannel (osource, ochannel));

#line 185 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- clear-inputs --- */
static GType type_id_clear_inputs = 0;
static void
clear_inputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 191 "bsesource.proc"
 {
#line 193 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
}
#line 192 "bsesource.proc"
  proc->help = "Disconnect all module inputs.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 196 "bsesource.proc"
 }
static BseErrorType
#line 196 "bsesource.proc"
clear_inputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 199 "bsesource.proc"
{
#line 200 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);

#line 203 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 207 "bsesource.proc"
  
  bse_source_clear_ichannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- clear-outputs --- */
static GType type_id_clear_outputs = 0;
static void
clear_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 213 "bsesource.proc"
 {
#line 215 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
}
#line 214 "bsesource.proc"
  proc->help = "Disconnect all module outputs.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 218 "bsesource.proc"
 }
static BseErrorType
#line 218 "bsesource.proc"
clear_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 221 "bsesource.proc"
{
#line 222 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);

#line 225 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 229 "bsesource.proc"
  
  bse_source_clear_ochannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- n-ichannels --- */
static GType type_id_n_ichannels = 0;
static void
n_ichannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 235 "bsesource.proc"
 {
#line 237 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_uint ("n_channels", "Number of Channels", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
}
#line 236 "bsesource.proc"
  proc->help = "Get the number of input channels of a module.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 242 "bsesource.proc"
 }
static BseErrorType
#line 242 "bsesource.proc"
n_ichannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 245 "bsesource.proc"
{
#line 246 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);

#line 249 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 253 "bsesource.proc"
  
  g_value_set_uint (out_values++, BSE_SOURCE_N_ICHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-name --- */
static GType type_id_ichannel_name = 0;
static void
ichannel_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 259 "bsesource.proc"
 {
#line 261 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_name", "Channel Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 260 "bsesource.proc"
  proc->help = "Get input channel name.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 268 "bsesource.proc"
 }
static BseErrorType
#line 268 "bsesource.proc"
ichannel_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 271 "bsesource.proc"
{
#line 272 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);

#line 276 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 280 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_NAME (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-cname --- */
static GType type_id_ichannel_cname = 0;
static void
ichannel_cname_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 286 "bsesource.proc"
 {
#line 288 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_name", "Channel Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 287 "bsesource.proc"
  proc->help = "Get canonical input channel name.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 295 "bsesource.proc"
 }
static BseErrorType
#line 295 "bsesource.proc"
ichannel_cname_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 298 "bsesource.proc"
{
#line 299 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);

#line 303 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 307 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_CNAME (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-blurb --- */
static GType type_id_ichannel_blurb = 0;
static void
ichannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 313 "bsesource.proc"
 {
#line 315 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_blurb", "Channel Blurb", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 314 "bsesource.proc"
  proc->help = "Get input channel description.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 322 "bsesource.proc"
 }
static BseErrorType
#line 322 "bsesource.proc"
ichannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 325 "bsesource.proc"
{
#line 326 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);

#line 330 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 334 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_BLURB (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel-by-id --- */
static GType type_id_is_joint_ichannel_by_id = 0;
static void
is_joint_ichannel_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 340 "bsesource.proc"
 {
#line 342 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boolean ("is_jchannel", "Is Joint Channel", NULL,
				FALSE, BSE_PARAM_DEFAULT);
}
#line 341 "bsesource.proc"
  proc->help = "Check if an input channel is a joint (multi-connect) channel.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 349 "bsesource.proc"
 }
static BseErrorType
#line 349 "bsesource.proc"
is_joint_ichannel_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 352 "bsesource.proc"
{
#line 353 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);

#line 357 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 361 "bsesource.proc"
  
  g_value_set_boolean (out_values++, BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel --- */
static GType type_id_is_joint_ichannel = 0;
static void
is_joint_ichannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 367 "bsesource.proc"
 {
#line 369 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("input-channel", "Input Channel", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boolean ("is_jchannel", "Is Joint Channel", NULL,
				FALSE, BSE_PARAM_DEFAULT);
}
#line 368 "bsesource.proc"
  proc->help = "Check if an input channel is a joint (multi-connect) channel.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 376 "bsesource.proc"
 }
static BseErrorType
#line 376 "bsesource.proc"
is_joint_ichannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 379 "bsesource.proc"
{
#line 380 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  gchar *ichannel   = g_value_get_string (in_values++);
  guint id;

#line 385 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !ichannel)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 389 "bsesource.proc"
  
  id = bse_source_find_ichannel (source, ichannel);
  g_value_set_boolean (out_values++,
		       id < BSE_SOURCE_N_ICHANNELS (source) ? BSE_SOURCE_IS_JOINT_ICHANNEL (source, id) : FALSE);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-n-joints --- */
static GType type_id_ichannel_get_n_joints = 0;
static void
ichannel_get_n_joints_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 397 "bsesource.proc"
 {
#line 399 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_uint ("n_joints", "Number of Connections", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
}
#line 398 "bsesource.proc"
  proc->help = "Retrive the number of inputs connected to an input channel.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 406 "bsesource.proc"
 }
static BseErrorType
#line 406 "bsesource.proc"
ichannel_get_n_joints_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 409 "bsesource.proc"
{
#line 410 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);
  BseSourceInput *input;

#line 415 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 419 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel))
    g_value_set_uint (out_values++, input->jdata.n_joints);
  else
    g_value_set_uint (out_values++, input->idata.osource ? 1 : 0);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-osource --- */
static GType type_id_ichannel_get_osource = 0;
static void
ichannel_get_osource_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 429 "bsesource.proc"
 {
#line 431 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-joint", "Input Joint", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_object ("osource", "Output Source", NULL,
			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
}
#line 430 "bsesource.proc"
  proc->help = "Retrive output module connected to a specific joint of an input channel";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 440 "bsesource.proc"
 }
static BseErrorType
#line 440 "bsesource.proc"
ichannel_get_osource_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 443 "bsesource.proc"
{
#line 444 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);
  guint joint       = g_value_get_uint (in_values++);
  BseSourceInput *input;

#line 450 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 454 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    g_value_set_object (out_values++, input->jdata.joints[joint].osource);
  else if (joint < 1)
    g_value_set_object (out_values++, input->idata.osource);
  else
    g_value_set_object (out_values++, NULL);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-ochannel --- */
static GType type_id_ichannel_get_ochannel = 0;
static void
ichannel_get_ochannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 466 "bsesource.proc"
 {
#line 468 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-joint", "Input Joint", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_uint ("ochannel", "Output Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
}
#line 467 "bsesource.proc"
  proc->help = "Retrive output channel of the module connected to a specific joint of an input channel.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 477 "bsesource.proc"
 }
static BseErrorType
#line 477 "bsesource.proc"
ichannel_get_ochannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 480 "bsesource.proc"
{
#line 481 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);
  guint joint       = g_value_get_uint (in_values++);
  BseSourceInput *input;

#line 487 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 491 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    g_value_set_uint (out_values++, input->jdata.joints[joint].ochannel);
  else if (joint < 1)
    g_value_set_uint (out_values++, input->idata.ochannel);
  else
    g_value_set_uint (out_values++, G_MAXINT);
  
  return BSE_ERROR_NONE;
}

/* --- n-ochannels --- */
static GType type_id_n_ochannels = 0;
static void
n_ochannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 503 "bsesource.proc"
 {
#line 505 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_uint ("n_channels", "Number of Channels", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
}
#line 504 "bsesource.proc"
  proc->help = "Get the number of output channels of a module.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 510 "bsesource.proc"
 }
static BseErrorType
#line 510 "bsesource.proc"
n_ochannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 513 "bsesource.proc"
{
#line 514 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);

#line 517 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 521 "bsesource.proc"
  
  g_value_set_uint (out_values++, BSE_SOURCE_N_OCHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-name --- */
static GType type_id_ochannel_name = 0;
static void
ochannel_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 527 "bsesource.proc"
 {
#line 529 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_name", "Channel Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 528 "bsesource.proc"
  proc->help = "Get output channel name.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 536 "bsesource.proc"
 }
static BseErrorType
#line 536 "bsesource.proc"
ochannel_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 539 "bsesource.proc"
{
#line 540 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ochannel    = g_value_get_uint (in_values++);

#line 544 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 548 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_NAME (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-cname --- */
static GType type_id_ochannel_cname = 0;
static void
ochannel_cname_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 554 "bsesource.proc"
 {
#line 556 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_name", "Channel Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 555 "bsesource.proc"
  proc->help = "Get canonical output channel name.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 563 "bsesource.proc"
 }
static BseErrorType
#line 563 "bsesource.proc"
ochannel_cname_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 566 "bsesource.proc"
{
#line 567 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ochannel    = g_value_get_uint (in_values++);

#line 571 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 575 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_CNAME (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-blurb --- */
static GType type_id_ochannel_blurb = 0;
static void
ochannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 581 "bsesource.proc"
 {
#line 583 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_blurb", "Channel Blurb", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 582 "bsesource.proc"
  proc->help = "Get output channel description.";
#line 26 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 27 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 28 "bsesource.proc"
  proc->date = "2001";
#line 590 "bsesource.proc"
 }
static BseErrorType
#line 590 "bsesource.proc"
ochannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 593 "bsesource.proc"
{
#line 594 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ochannel    = g_value_get_uint (in_values++);

#line 598 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 602 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_BLURB (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_set_input_by_id, "BseSource+set-input-by-id", NULL, 0, set_input_by_id_setup, set_input_by_id_exec, NULL, "/Method/BseSource/General/Set Input By Id", { 0, }, },
  { &type_id_set_input, "BseSource+set-input", NULL, 0, set_input_setup, set_input_exec, NULL, "/Method/BseSource/General/Set Input", { 0, }, },
  { &type_id_unset_input_by_id, "BseSource+unset-input-by-id", NULL, 0, unset_input_by_id_setup, unset_input_by_id_exec, NULL, "/Method/BseSource/General/Unset Input By Id", { 0, }, },
  { &type_id_unset_input, "BseSource+unset-input", NULL, 0, unset_input_setup, unset_input_exec, NULL, "/Method/BseSource/General/Unset Input", { 0, }, },
  { &type_id_clear_inputs, "BseSource+clear-inputs", NULL, 0, clear_inputs_setup, clear_inputs_exec, NULL, "/Method/BseSource/General/Clear Inputs", { 0, }, },
  { &type_id_clear_outputs, "BseSource+clear-outputs", NULL, 0, clear_outputs_setup, clear_outputs_exec, NULL, "/Method/BseSource/General/Clear Outputs", { 0, }, },
  { &type_id_n_ichannels, "BseSource+n-ichannels", NULL, 0, n_ichannels_setup, n_ichannels_exec, NULL, "/Method/BseSource/General/N Ichannels", { 0, }, },
  { &type_id_ichannel_name, "BseSource+ichannel-name", NULL, 0, ichannel_name_setup, ichannel_name_exec, NULL, "/Method/BseSource/General/Ichannel Name", { 0, }, },
  { &type_id_ichannel_cname, "BseSource+ichannel-cname", NULL, 0, ichannel_cname_setup, ichannel_cname_exec, NULL, "/Method/BseSource/General/Ichannel Cname", { 0, }, },
  { &type_id_ichannel_blurb, "BseSource+ichannel-blurb", NULL, 0, ichannel_blurb_setup, ichannel_blurb_exec, NULL, "/Method/BseSource/General/Ichannel Blurb", { 0, }, },
  { &type_id_is_joint_ichannel_by_id, "BseSource+is-joint-ichannel-by-id", NULL, 0, is_joint_ichannel_by_id_setup, is_joint_ichannel_by_id_exec, NULL, "/Method/BseSource/General/Is Joint Ichannel By Id", { 0, }, },
  { &type_id_is_joint_ichannel, "BseSource+is-joint-ichannel", NULL, 0, is_joint_ichannel_setup, is_joint_ichannel_exec, NULL, "/Method/BseSource/General/Is Joint Ichannel", { 0, }, },
  { &type_id_ichannel_get_n_joints, "BseSource+ichannel-get-n-joints", NULL, 0, ichannel_get_n_joints_setup, ichannel_get_n_joints_exec, NULL, "/Method/BseSource/General/Ichannel Get N Joints", { 0, }, },
  { &type_id_ichannel_get_osource, "BseSource+ichannel-get-osource", NULL, 0, ichannel_get_osource_setup, ichannel_get_osource_exec, NULL, "/Method/BseSource/General/Ichannel Get Osource", { 0, }, },
  { &type_id_ichannel_get_ochannel, "BseSource+ichannel-get-ochannel", NULL, 0, ichannel_get_ochannel_setup, ichannel_get_ochannel_exec, NULL, "/Method/BseSource/General/Ichannel Get Ochannel", { 0, }, },
  { &type_id_n_ochannels, "BseSource+n-ochannels", NULL, 0, n_ochannels_setup, n_ochannels_exec, NULL, "/Method/BseSource/General/N Ochannels", { 0, }, },
  { &type_id_ochannel_name, "BseSource+ochannel-name", NULL, 0, ochannel_name_setup, ochannel_name_exec, NULL, "/Method/BseSource/General/Ochannel Name", { 0, }, },
  { &type_id_ochannel_cname, "BseSource+ochannel-cname", NULL, 0, ochannel_cname_setup, ochannel_cname_exec, NULL, "/Method/BseSource/General/Ochannel Cname", { 0, }, },
  { &type_id_ochannel_blurb, "BseSource+ochannel-blurb", NULL, 0, ochannel_blurb_setup, ochannel_blurb_exec, NULL, "/Method/BseSource/General/Ochannel Blurb", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
