
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseserver.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bseserver.h>
#include <bse/bseproject.h>
#include <bse/gslloader.h>
#include <bse/bswprivate.h>
#include <bse/bsemidinotifier.h>
#include <bse/bsemidievent.h>
#include <bse/bsescriptcontrol.h>
#include <string.h>


#line 33 "bseserver.proc"


/* --- use-new-project --- */
static GType type_id_use_new_project = 0;
static void
use_new_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 35 "bseserver.proc"
 {
#line 37 "bseserver.proc"
  *(in_pspecs++) = g_param_spec_object ("server", "Server", NULL,
 			       BSE_TYPE_SERVER, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("name", "Project Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("project", "Project", NULL,
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
}
#line 36 "bseserver.proc"
  proc->help = "Create a new project, owned by the caller (name is modified to be unique if necessary)";
#line 30 "bseserver.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseserver.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseserver.proc"
  proc->date = "2001";
#line 44 "bseserver.proc"
 }
static BseErrorType
#line 44 "bseserver.proc"
use_new_project_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 47 "bseserver.proc"
{
#line 48 "bseserver.proc"
  
  BseServer *server     = (BseServer*) g_value_get_object (in_values++);
  gchar *name           = g_value_get_string (in_values++);
  gchar *uname;
  guint num = 1;
  BseProject *project;
  
#line 55 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 59 "bseserver.proc"
  
  uname = g_strdup (name);
  while (bse_server_find_project (server, uname))
    {
      g_free (uname);
      uname = g_strdup_printf ("%s-%u", name, num++);
    }

#line 67 "bseserver.proc"
  
  project = bse_server_create_project (server, uname);
  g_free (uname);
  bse_item_exec_void_proc (project, "use");
  bse_object_unref (project);
  
#line 73 "bseserver.proc"
  
  g_value_set_object (out_values++, G_OBJECT (project));
  
  return BSE_ERROR_NONE;
}

/* --- get-midi-notifier --- */
static GType type_id_get_midi_notifier = 0;
static void
get_midi_notifier_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 79 "bseserver.proc"
 {
#line 81 "bseserver.proc"
  *(in_pspecs++) = g_param_spec_object ("server", "Server", NULL,
 			       BSE_TYPE_SERVER, BSE_PARAM_DEFAULT);
  *(out_pspecs++) = g_param_spec_object ("midi_notifier", "Midi Notifier", NULL,
			       BSE_TYPE_MIDI_NOTIFIER, BSE_PARAM_DEFAULT);
}
#line 80 "bseserver.proc"
  proc->help = "Retrive the global midi notifier object.";
#line 30 "bseserver.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseserver.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseserver.proc"
  proc->date = "2001";
#line 86 "bseserver.proc"
 }
static BseErrorType
#line 86 "bseserver.proc"
get_midi_notifier_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 89 "bseserver.proc"
{
#line 90 "bseserver.proc"
  
  BseServer *self = g_value_get_object (in_values++);
  BseMidiReceiver *midi_receiver;
  BseMidiNotifier *notifier;

#line 95 "bseserver.proc"
  
  if (!BSE_IS_SERVER (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  midi_receiver = bse_server_get_midi_receiver (self, "default");
  notifier = bse_midi_receiver_get_notifier (midi_receiver);
  if (!notifier)
    {
      notifier = g_object_new (BSE_TYPE_MIDI_NOTIFIER, NULL);
      bse_midi_receiver_set_notifier (midi_receiver, notifier);
      g_object_unref (notifier);
    }

#line 108 "bseserver.proc"
  
  g_value_set_object (out_values++, G_OBJECT (notifier));
  
  return BSE_ERROR_NONE;
}

/* --- run-project --- */
static GType type_id_run_project = 0;
static void
run_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 114 "bseserver.proc"
 {
#line 116 "bseserver.proc"
  *(in_pspecs++) = g_param_spec_object ("server", "Server", NULL,
 			       BSE_TYPE_SERVER, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("project", "Project", NULL,
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 115 "bseserver.proc"
  proc->help = "Process a project to generate sound";
#line 30 "bseserver.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseserver.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseserver.proc"
  proc->date = "2001";
#line 124 "bseserver.proc"
 }
static BseErrorType
#line 124 "bseserver.proc"
run_project_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 127 "bseserver.proc"
{
#line 128 "bseserver.proc"
  
  BseServer *server	= (BseServer*) g_value_get_object (in_values++);
  BseProject *project	= (BseProject*) g_value_get_object (in_values++);
  BseErrorType error = 0;
  
#line 133 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 137 "bseserver.proc"
  
  if (!server->dev_use_count)
    error = bse_server_activate_devices (server);
  
#line 141 "bseserver.proc"
  
  if (!error && BSE_SOURCE_PREPARED (project))
    {
      bse_project_stop_playback (project);
      g_return_val_if_fail (server->dev_use_count > 0, BSE_ERROR_INTERNAL);
      server->dev_use_count--;
    }

#line 149 "bseserver.proc"
  
  if (!error)
    {
      bse_project_start_playback (project);
      server->dev_use_count++;
    }

#line 156 "bseserver.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- halt-project --- */
static GType type_id_halt_project = 0;
static void
halt_project_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 162 "bseserver.proc"
 {
#line 164 "bseserver.proc"
  *(in_pspecs++) = g_param_spec_object ("server", "Server", NULL,
 			       BSE_TYPE_SERVER, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("project", "Project", NULL,
			       BSE_TYPE_PROJECT, BSE_PARAM_DEFAULT);
}
#line 163 "bseserver.proc"
  proc->help = "Stop processing a project generating sound";
#line 30 "bseserver.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseserver.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseserver.proc"
  proc->date = "2001";
#line 169 "bseserver.proc"
 }
static BseErrorType
#line 169 "bseserver.proc"
halt_project_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 172 "bseserver.proc"
{
#line 173 "bseserver.proc"
  
  BseServer *server	= g_value_get_object (in_values++);
  BseProject *project	= g_value_get_object (in_values++);
  
#line 177 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 181 "bseserver.proc"
  
  if (BSE_SOURCE_PREPARED (project))
    {
      bse_project_stop_playback (project);
      g_return_val_if_fail (server->dev_use_count > 0, BSE_ERROR_INTERNAL);
      server->dev_use_count--;
      if (!server->dev_use_count)
	bse_server_suspend_devices (server);
    }
  
  return BSE_ERROR_NONE;
}

/* --- can-load --- */
static GType type_id_can_load = 0;
static void
can_load_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 194 "bseserver.proc"
 {
#line 196 "bseserver.proc"
  *(in_pspecs++) = g_param_spec_object ("server", "Server", NULL,
 			       BSE_TYPE_SERVER, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("file_name", "File Name", "The file to find a loader for",
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boolean ("can-load", NULL, NULL,
				FALSE, BSE_PARAM_DEFAULT);
}
#line 195 "bseserver.proc"
  proc->help = "Check whether a loader can be found for a wave file";
#line 30 "bseserver.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseserver.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseserver.proc"
  proc->date = "2001";
#line 203 "bseserver.proc"
 }
static BseErrorType
#line 203 "bseserver.proc"
can_load_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 206 "bseserver.proc"
{
#line 207 "bseserver.proc"
  
  BseServer *server	= g_value_get_object (in_values++);
  gchar *file_name	= g_value_get_string (in_values++);
  GslWaveFileInfo *finfo;

#line 212 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 216 "bseserver.proc"
  
  finfo = gsl_wave_file_info_load (file_name, NULL);
  g_value_set_boolean (out_values++, finfo != NULL);
  if (finfo)
    gsl_wave_file_info_unref (finfo);
  
  return BSE_ERROR_NONE;
}

/* --- describe-note --- */
static GType type_id_describe_note = 0;
static void
describe_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 225 "bseserver.proc"
 {
#line 227 "bseserver.proc"
  *(in_pspecs++) = g_param_spec_object ("server", "Server", NULL,
 			       BSE_TYPE_SERVER, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_uint ("note", "Note", NULL,
			       BSE_MIN_NOTE, BSE_MAX_NOTE,
			       BSE_KAMMER_NOTE, 1,
			       BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_int ("fine_tune", "Fine Tune", NULL,
			      BSE_MIN_FINE_TUNE, BSE_MAX_FINE_TUNE,
			      0, 1, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boxed ("note-description", NULL, NULL,
			      BSW_TYPE_NOTE_DESCRIPTION, BSE_PARAM_DEFAULT);
}
#line 226 "bseserver.proc"
  proc->help = "Describe a note, providing information about its octave, semitone, frequency, etc.";
#line 30 "bseserver.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseserver.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseserver.proc"
  proc->date = "2001";
#line 239 "bseserver.proc"
 }
static BseErrorType
#line 239 "bseserver.proc"
describe_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 242 "bseserver.proc"
{
#line 243 "bseserver.proc"
  
  BseServer *server	= g_value_get_object (in_values++);
  gint       note	= g_value_get_uint (in_values++);
  gint       fine_tune	= g_value_get_int (in_values++);
  BswNoteDescription *info;

#line 249 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 253 "bseserver.proc"
  
  info = bsw_note_description (note, fine_tune);

#line 256 "bseserver.proc"
  
  g_value_set_boxed_take_ownership (out_values++, info);
  
  return BSE_ERROR_NONE;
}

/* --- note-from-freq --- */
static GType type_id_note_from_freq = 0;
static void
note_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 262 "bseserver.proc"
 {
#line 264 "bseserver.proc"
  *(in_pspecs++) = g_param_spec_object ("server", "Server", NULL,
 			       BSE_TYPE_SERVER, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_float ("freq", "Frequency", NULL,
				0, BSE_MAX_FREQUENCY_f,
				BSE_KAMMER_FREQUENCY_f, 10.0,
				BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boxed ("note-description", NULL, NULL,
			      BSW_TYPE_NOTE_DESCRIPTION, BSE_PARAM_DEFAULT);
}
#line 263 "bseserver.proc"
  proc->help = "Describe a note, given its frequency.";
#line 30 "bseserver.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseserver.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseserver.proc"
  proc->date = "2001";
#line 273 "bseserver.proc"
 }
static BseErrorType
#line 273 "bseserver.proc"
note_from_freq_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 276 "bseserver.proc"
{
#line 277 "bseserver.proc"
  
  BseServer *server	= g_value_get_object (in_values++);
  gfloat     freq	= g_value_get_float (in_values++);
  BswNoteDescription *info;
  gint note;

#line 283 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 287 "bseserver.proc"
  
  note = bse_note_from_freq (freq);
  info = bsw_note_description (note, 0);

#line 291 "bseserver.proc"
  
  g_value_set_boxed_take_ownership (out_values++, info);
  
  return BSE_ERROR_NONE;
}

/* --- note-from-string --- */
static GType type_id_note_from_string = 0;
static void
note_from_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 297 "bseserver.proc"
 {
#line 299 "bseserver.proc"
  *(in_pspecs++) = g_param_spec_object ("server", "Server", NULL,
 			       BSE_TYPE_SERVER, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_string ("name", "Name", NULL,
				 "", BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boxed ("note-description", NULL, NULL,
			      BSW_TYPE_NOTE_DESCRIPTION, BSE_PARAM_DEFAULT);
}
#line 298 "bseserver.proc"
  proc->help = "Describe a note, given its name and octave offset.";
#line 30 "bseserver.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseserver.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseserver.proc"
  proc->date = "2001";
#line 306 "bseserver.proc"
 }
static BseErrorType
#line 306 "bseserver.proc"
note_from_string_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 309 "bseserver.proc"
{
#line 310 "bseserver.proc"
  
  BseServer *server	= g_value_get_object (in_values++);
  gchar     *name     	= g_value_get_string (in_values++);
  BswNoteDescription *info;
  gint note;

#line 316 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 320 "bseserver.proc"
  
  note = bse_note_from_string (name);
  info = bsw_note_description (note, 0);

#line 324 "bseserver.proc"
  
  g_value_set_boxed_take_ownership (out_values++, info);
  
  return BSE_ERROR_NONE;
}

/* --- construct-note --- */
static GType type_id_construct_note = 0;
static void
construct_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 330 "bseserver.proc"
 {
#line 332 "bseserver.proc"
  *(in_pspecs++) = g_param_spec_object ("server", "Server", NULL,
 			       BSE_TYPE_SERVER, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_uint ("semitone", NULL, NULL,
			       0, 11,
			       9, 1, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_int ("octave", NULL, NULL,
			      BSE_MIN_OCTAVE, BSE_MAX_OCTAVE,
			      BSE_KAMMER_OCTAVE, 1, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_int ("fine_tune", "Fine Tune", NULL,
			      BSE_MIN_FINE_TUNE, BSE_MAX_FINE_TUNE,
			      0, 1, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boxed ("note-description", NULL, NULL,
			      BSW_TYPE_NOTE_DESCRIPTION, BSE_PARAM_DEFAULT);
}
#line 331 "bseserver.proc"
  proc->help = "Describe a note, given its semitone, octave and fine tune.";
#line 30 "bseserver.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseserver.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseserver.proc"
  proc->date = "2001";
#line 346 "bseserver.proc"
 }
static BseErrorType
#line 346 "bseserver.proc"
construct_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 349 "bseserver.proc"
{
#line 350 "bseserver.proc"
  
  BseServer *server	= g_value_get_object (in_values++);
  guint      semitone	= g_value_get_uint (in_values++);
  gint       octave	= g_value_get_int (in_values++);
  gint       fine_tune	= g_value_get_int (in_values++);
  BswNoteDescription *info;
  gint note;

#line 358 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 362 "bseserver.proc"
  
  note = BSE_NOTE_GENERIC (octave, semitone);
  info = bsw_note_description (note, fine_tune);

#line 366 "bseserver.proc"
  
  g_value_set_boxed_take_ownership (out_values++, info);
  
  return BSE_ERROR_NONE;
}

/* --- n-scripts --- */
static GType type_id_n_scripts = 0;
static void
n_scripts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 372 "bseserver.proc"
 {
#line 374 "bseserver.proc"
  *(in_pspecs++) = g_param_spec_object ("server", "Server", NULL,
 			       BSE_TYPE_SERVER, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_uint ("n_connections", NULL, "Number of Connections",
			       0, G_MAXINT, 0, 1,
			       BSE_PARAM_DEFAULT);
}
#line 373 "bseserver.proc"
  proc->help = "Return the number of scripts currently running on this server.";
#line 30 "bseserver.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 31 "bseserver.proc"
  proc->copyright = "Tim Janik";
#line 32 "bseserver.proc"
  proc->date = "2001";
#line 380 "bseserver.proc"
 }
static BseErrorType
#line 380 "bseserver.proc"
n_scripts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 383 "bseserver.proc"
{
#line 384 "bseserver.proc"
  
  BseServer *server	= g_value_get_object (in_values++);
  GSList *slist;
  guint n_scripts = 0;

#line 389 "bseserver.proc"
  
  if (!BSE_IS_SERVER (server))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 393 "bseserver.proc"
  
  for (slist = server->children; slist; slist = slist->next)
    if (BSE_IS_SCRIPT_CONTROL (slist->data))
      n_scripts++;

#line 398 "bseserver.proc"
  
  g_value_set_uint (out_values++, n_scripts);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_use_new_project, "BseServer+use-new-project", NULL, 0, use_new_project_setup, use_new_project_exec, NULL, "/Method/BseServer/General/Use New Project", { 0, }, },
  { &type_id_get_midi_notifier, "BseServer+get-midi-notifier", NULL, 0, get_midi_notifier_setup, get_midi_notifier_exec, NULL, "/Method/BseServer/General/Get Midi Notifier", { 0, }, },
  { &type_id_run_project, "BseServer+run-project", NULL, 0, run_project_setup, run_project_exec, NULL, "/Method/BseServer/General/Run Project", { 0, }, },
  { &type_id_halt_project, "BseServer+halt-project", NULL, 0, halt_project_setup, halt_project_exec, NULL, "/Method/BseServer/General/Halt Project", { 0, }, },
  { &type_id_can_load, "BseServer+can-load", NULL, 0, can_load_setup, can_load_exec, NULL, "/Method/BseServer/General/Can Load", { 0, }, },
  { &type_id_describe_note, "BseServer+describe-note", NULL, 0, describe_note_setup, describe_note_exec, NULL, "/Method/BseServer/General/Describe Note", { 0, }, },
  { &type_id_note_from_freq, "BseServer+note-from-freq", NULL, 0, note_from_freq_setup, note_from_freq_exec, NULL, "/Method/BseServer/General/Note From Freq", { 0, }, },
  { &type_id_note_from_string, "BseServer+note-from-string", NULL, 0, note_from_string_setup, note_from_string_exec, NULL, "/Method/BseServer/General/Note From String", { 0, }, },
  { &type_id_construct_note, "BseServer+construct-note", NULL, 0, construct_note_setup, construct_note_exec, NULL, "/Method/BseServer/General/Construct Note", { 0, }, },
  { &type_id_n_scripts, "BseServer+n-scripts", NULL, 0, n_scripts_setup, n_scripts_exec, NULL, "/Method/BseServer/General/N Scripts", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
