
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsesnet.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsesnet.h>
#include        <bse/bsemain.h>


#line 27 "bsesnet.proc"


/* --- supports-user-synths --- */
static GType type_id_supports_user_synths = 0;
static void
supports_user_synths_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bsesnet.proc"
 {
#line 31 "bsesnet.proc"
  *(in_pspecs++) = bse_param_spec_object ("snet", "Synth Net", NULL,
				 BSE_TYPE_SNET, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_bool ("user_synth", "User Synth", NULL,
			  FALSE, SFI_PARAM_DEFAULT);
#line 30 "bsesnet.proc"
  proc->help = "Check whether users may edit synthesis modules of this network";
#line 25 "bsesnet.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsesnet.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 35 "bsesnet.proc"
}  }
static BseErrorType
#line 35 "bsesnet.proc"
supports_user_synths_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 38 "bsesnet.proc"
{
#line 39 "bsesnet.proc"
  
  BseSNet *snet = bse_value_get_object (in_values++);
  
#line 42 "bsesnet.proc"
  
  if (!BSE_IS_SNET (snet))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 46 "bsesnet.proc"
  
  sfi_value_set_bool (out_values++, BSE_SNET_USER_SYNTH (snet));
  
  return BSE_ERROR_NONE;
}

/* --- can-create-source --- */
static GType type_id_can_create_source = 0;
static void
can_create_source_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 52 "bsesnet.proc"
 {
#line 54 "bsesnet.proc"
  *(in_pspecs++) = bse_param_spec_object ("snet", "Synth Net", NULL,
				 BSE_TYPE_SNET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("module_type", "Module Type", NULL,
			    "", SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, 0,
				SFI_PARAM_DEFAULT);
#line 53 "bsesnet.proc"
  proc->help = "Check whether inserting a new module into a synthesis network is possible";
#line 25 "bsesnet.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsesnet.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 61 "bsesnet.proc"
}  }
static BseErrorType
#line 61 "bsesnet.proc"
can_create_source_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 64 "bsesnet.proc"
{
#line 65 "bsesnet.proc"
  
  BseSNet *snet = bse_value_get_object (in_values++);
  const gchar *type_name = sfi_value_get_string (in_values++);
  GType type = g_type_from_name (type_name);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 71 "bsesnet.proc"
  
  if (!BSE_IS_SNET (snet))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 75 "bsesnet.proc"
  
  if (!BSE_SNET_USER_SYNTH (snet) && !BSE_DVL_EXT)
    error = BSE_ERROR_NOT_OWNER;
  else if (!g_type_is_a (type, BSE_TYPE_SOURCE) ||
	   g_type_is_a (type, BSE_TYPE_CONTAINER))
    error = BSE_ERROR_SOURCE_TYPE_INVALID;
  
#line 82 "bsesnet.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- create-source --- */
static GType type_id_create_source = 0;
static void
create_source_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 88 "bsesnet.proc"
 {
#line 90 "bsesnet.proc"
  *(in_pspecs++) = bse_param_spec_object ("snet", "Synth Net", NULL,
				 BSE_TYPE_SNET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_string ("module_type", "Module Type", NULL,
			    "", SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_param_spec_object ("module", "New Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
#line 89 "bsesnet.proc"
  proc->help = "Insert a new module into a synthesis network";
#line 25 "bsesnet.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsesnet.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 96 "bsesnet.proc"
}  }
static BseErrorType
#line 96 "bsesnet.proc"
create_source_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 99 "bsesnet.proc"
{
#line 100 "bsesnet.proc"
  
  BseSNet *snet = bse_value_get_object (in_values++);
  const gchar *type_name = sfi_value_get_string (in_values++);
  BseContainer *container;
  BseSource *source;
  BseErrorType error;
  
#line 107 "bsesnet.proc"
  
  if (!BSE_IS_SNET (snet))
    return BSE_ERROR_PROC_PARAM_INVAL;
  if (bse_item_exec (snet, "can-create-source", type_name, &error) != 0 ||
      error != 0)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 114 "bsesnet.proc"
  
  container = BSE_CONTAINER (snet);
  source = g_object_new (g_type_from_name (type_name), NULL);
  bse_container_add_item (container, BSE_ITEM (source));
  
#line 119 "bsesnet.proc"
  
  bse_value_set_object (out_values++, source);
  g_object_unref (source);
  
  return BSE_ERROR_NONE;
}

/* --- remove-source --- */
static GType type_id_remove_source = 0;
static void
remove_source_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 126 "bsesnet.proc"
 {
#line 128 "bsesnet.proc"
  *(in_pspecs++) = bse_param_spec_object ("snet", "Synth Net", NULL,
				 BSE_TYPE_SNET, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, 0,
				SFI_PARAM_DEFAULT);
#line 127 "bsesnet.proc"
  proc->help = "Remove an existing module from its synthesis network";
#line 25 "bsesnet.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 26 "bsesnet.proc"
  proc->copyright = "Copyright (C) 2001-2002 Tim Janik";
#line 135 "bsesnet.proc"
}  }
static BseErrorType
#line 135 "bsesnet.proc"
remove_source_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 138 "bsesnet.proc"
{
#line 139 "bsesnet.proc"
  
  BseSNet *snet = bse_value_get_object (in_values++);
  BseSource *source = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 144 "bsesnet.proc"
  
  if (!BSE_IS_SNET (snet) || !BSE_IS_SOURCE (source) || BSE_ITEM (source)->parent != BSE_ITEM (snet) ||
      (!BSE_SNET_USER_SYNTH (snet) && !BSE_DVL_EXT))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 149 "bsesnet.proc"
  
  bse_container_remove_item (BSE_CONTAINER (snet), BSE_ITEM (source));
  
#line 152 "bsesnet.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_supports_user_synths, "BseSNet+supports-user-synths", NULL, 0, supports_user_synths_setup, supports_user_synths_exec, NULL, "/Method/BseSNet/General/Supports User Synths", { 0, }, },
  { &type_id_can_create_source, "BseSNet+can-create-source", NULL, 0, can_create_source_setup, can_create_source_exec, NULL, "/Method/BseSNet/General/Can Create Source", { 0, }, },
  { &type_id_create_source, "BseSNet+create-source", NULL, 0, create_source_setup, create_source_exec, NULL, "/Method/BseSNet/General/Create Source", { 0, }, },
  { &type_id_remove_source, "BseSNet+remove-source", NULL, 0, remove_source_setup, remove_source_exec, NULL, "/Method/BseSNet/General/Remove Source", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
