
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsepart.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsepart.h>
#include        <bse/bsesong.h>


#line 26 "bsepart.proc"


/* --- insert-note-auto --- */
static void
insert_note_auto_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsepart.proc"
 {
#line 30 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 45 "bsepart.proc"
 }
static BseErrorType
#line 45 "bsepart.proc"
insert_note_auto_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 48 "bsepart.proc"
{
#line 49 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
  
#line 59 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 63 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-note-auto");
  id = bse_part_insert_note (self, ~0, tick, duration, note, fine_tune, velocity);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);

#line 70 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- insert-note --- */
static void
insert_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 76 "bsepart.proc"
 {
#line 78 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("channel", "Channel", NULL,
			 0, 0, BSE_PART_MAX_CHANNELS, 4, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 95 "bsepart.proc"
 }
static BseErrorType
#line 95 "bsepart.proc"
insert_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 98 "bsepart.proc"
{
#line 99 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    channel   = sfi_value_get_int (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
  
#line 110 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 114 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-note");
  id = bse_part_insert_note (self, channel, tick, duration, note, fine_tune, velocity);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);

#line 121 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- insert-control --- */
static void
insert_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 127 "bsepart.proc"
 {
#line 129 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("value", "Value", NULL,
			  0.0, -1.0, +1.0, 0.1,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 142 "bsepart.proc"
 }
static BseErrorType
#line 142 "bsepart.proc"
insert_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 145 "bsepart.proc"
{
#line 146 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    ctype     = g_value_get_enum (in_values++);
  gfloat   value     = sfi_value_get_real (in_values++);
  BseUndoStack *ustack;
  guint id;
  
#line 154 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 158 "bsepart.proc"
  
  ustack = bse_item_undo_open (self, "insert-event");
  id = bse_part_insert_control (self, tick, ctype, value);
  if (id)
    bse_item_push_undo_proc (self, "delete-event", id);
  bse_item_undo_close (ustack);

#line 165 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- change-note --- */
static void
change_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 171 "bsepart.proc"
 {
#line 173 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 191 "bsepart.proc"
 }
static BseErrorType
#line 191 "bsepart.proc"
change_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 194 "bsepart.proc"
{
#line 195 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    id	     = sfi_value_get_int (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  gboolean success = FALSE;
  BsePartQueryEvent equery;

#line 206 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 210 "bsepart.proc"
  
  if (bse_part_query_event (self, id, &equery) == BSE_PART_EVENT_NOTE)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-note");
      if (equery.tick != tick || equery.duration != duration ||
          equery.note != note || equery.fine_tune != fine_tune ||
          equery.velocity != velocity)
        {
          success = bse_part_change_note (self, id, ~0, tick, duration, note, fine_tune, velocity);
          if (success)
            bse_item_push_undo_proc (self, "change-note", id, equery.tick, equery.duration,
                                     equery.note, equery.fine_tune, equery.velocity);
        }
      else
        success = TRUE;
      bse_item_undo_close (ustack);
    }

#line 228 "bsepart.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- change-control --- */
static void
change_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 234 "bsepart.proc"
 {
#line 236 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("value", "Value", NULL,
			  0.0, -1.0, +1.0, 0.1,
			  SFI_PARAM_STANDARD ":scale");
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 252 "bsepart.proc"
 }
static BseErrorType
#line 252 "bsepart.proc"
change_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 255 "bsepart.proc"
{
#line 256 "bsepart.proc"
  
  BsePart *self  = bse_value_get_object (in_values++);
  guint    id    = sfi_value_get_int (in_values++);
  guint    tick  = sfi_value_get_int (in_values++);
  guint    ctype = g_value_get_enum (in_values++);
  gfloat   value = sfi_value_get_real (in_values++);
  BsePartQueryEvent equery;
  gboolean success = FALSE;

#line 265 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 269 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_CONTROL && !BSE_PART_NOTE_CONTROL (ctype))
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-control");
      if (equery.tick != tick || equery.control_type != ctype || equery.control_value != value)
        {
          success = bse_part_change_control (self, id, tick, ctype, value);
          if (success)
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, equery.control_type, equery.control_value);
        }
      else
        success = TRUE;
      bse_item_undo_close (ustack);
    }
  else if (equery.event_type == BSE_PART_EVENT_NOTE && BSE_PART_NOTE_CONTROL (ctype))
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "change-control");
      BsePartQueryEvent xquery;
      success = bse_part_change_control (self, id, tick, ctype, value);
      if (success && bse_part_query_event (self, id, &xquery) == BSE_PART_EVENT_NOTE &&
          (equery.fine_tune_value != xquery.fine_tune_value ||
           equery.velocity_value  != xquery.velocity_value))
        switch (ctype)
          {
          case BSE_MIDI_SIGNAL_VELOCITY:
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, ctype, equery.velocity_value);
            break;
          case BSE_MIDI_SIGNAL_FINE_TUNE:
            bse_item_push_undo_proc (self, "change-control", id, equery.tick, ctype, equery.fine_tune_value);
            break;
          default: ;
          }
      bse_item_undo_close (ustack);
    }
  
#line 305 "bsepart.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- delete-event --- */
static void
delete_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 311 "bsepart.proc"
 {
#line 313 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 321 "bsepart.proc"
 }
static BseErrorType
#line 321 "bsepart.proc"
delete_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 324 "bsepart.proc"
{
#line 325 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  BsePartQueryEvent equery;
  gboolean deleted = FALSE;

#line 331 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 335 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_NOTE)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "delete-note");
      deleted = bse_part_delete_note (self, id, equery.channel);
      if (deleted)
        bse_item_push_undo_proc (self, "insert-note", equery.channel, equery.tick, equery.duration,
                                 equery.note, equery.fine_tune, equery.velocity);
      bse_item_undo_close (ustack);
    }
  else if (equery.event_type == BSE_PART_EVENT_CONTROL)
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "delete-control");
      deleted = bse_part_delete_control (self, id);
      if (deleted)
        bse_item_push_undo_proc (self, "insert-control", equery.tick, equery.control_type, equery.control_value);
      bse_item_undo_close (ustack);
    }

#line 355 "bsepart.proc"
  
  g_value_set_enum (out_values++, deleted ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- is-event-selected --- */
static void
is_event_selected_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 361 "bsepart.proc"
 {
#line 363 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("selected", "Selected", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 370 "bsepart.proc"
 }
static BseErrorType
#line 370 "bsepart.proc"
is_event_selected_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 373 "bsepart.proc"
{
#line 374 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  gboolean selected = FALSE;
  BsePartQueryEvent equery;

#line 380 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 384 "bsepart.proc"
  
  if (bse_part_query_event (self, id, &equery) != BSE_PART_EVENT_NONE)
    selected = equery.selected;

#line 388 "bsepart.proc"
  
  sfi_value_set_bool (out_values++, selected);
  
  return BSE_ERROR_NONE;
}

/* --- list-notes-crossing --- */
static void
list_notes_crossing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 394 "bsepart.proc"
 {
#line 396 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 405 "bsepart.proc"
 }
static BseErrorType
#line 405 "bsepart.proc"
list_notes_crossing_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 408 "bsepart.proc"
{
#line 409 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  
#line 414 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 418 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes_crossing (self, tick, duration, BSE_MIN_NOTE, BSE_MAX_NOTE));
  
  return BSE_ERROR_NONE;
}

/* --- list-controls --- */
static void
list_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 424 "bsepart.proc"
 {
#line 426 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 438 "bsepart.proc"
 }
static BseErrorType
#line 438 "bsepart.proc"
list_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 441 "bsepart.proc"
{
#line 442 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  guint    ctype     = g_value_get_enum (in_values++);
  
#line 448 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 452 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, tick, duration, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- queue-notes --- */
static void
queue_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 458 "bsepart.proc"
 {
#line 460 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 471 "bsepart.proc"
 }
static BseErrorType
#line 471 "bsepart.proc"
queue_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 474 "bsepart.proc"
{
#line 475 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  gint     min_note = sfi_value_get_note (in_values++);
  gint     max_note = sfi_value_get_note (in_values++);
  
#line 482 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 486 "bsepart.proc"
  
  bse_part_queue_notes_within (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- queue-controls --- */
static void
queue_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 492 "bsepart.proc"
 {
#line 494 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
}
#line 501 "bsepart.proc"
 }
static BseErrorType
#line 501 "bsepart.proc"
queue_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 504 "bsepart.proc"
{
#line 505 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  
#line 510 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 514 "bsepart.proc"
  
  bse_part_queue_controls (self, tick, duration);
  
  return BSE_ERROR_NONE;
}

/* --- list-selected-notes --- */
static void
list_selected_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 520 "bsepart.proc"
 {
#line 522 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 527 "bsepart.proc"
 }
static BseErrorType
#line 527 "bsepart.proc"
list_selected_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 530 "bsepart.proc"
{
#line 531 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 534 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 538 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_selected_notes (self));
  
  return BSE_ERROR_NONE;
}

/* --- list-selected-controls --- */
static void
list_selected_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 544 "bsepart.proc"
 {
#line 546 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 554 "bsepart.proc"
 }
static BseErrorType
#line 554 "bsepart.proc"
list_selected_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 557 "bsepart.proc"
{
#line 558 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
  
#line 562 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 566 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_selected_controls (self, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- check-overlap --- */
static void
check_overlap_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 572 "bsepart.proc"
 {
#line 574 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 584 "bsepart.proc"
 }
static BseErrorType
#line 584 "bsepart.proc"
check_overlap_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 587 "bsepart.proc"
{
#line 588 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  gint     note     = sfi_value_get_note (in_values++);
  
#line 594 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 598 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes_crossing (self, tick, duration, note, note));
  
  return BSE_ERROR_NONE;
}

/* --- get-notes --- */
static void
get_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 604 "bsepart.proc"
 {
#line 606 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_STANDARD);
}
#line 615 "bsepart.proc"
 }
static BseErrorType
#line 615 "bsepart.proc"
get_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 618 "bsepart.proc"
{
#line 619 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  gint     note     = sfi_value_get_note (in_values++);
  
#line 624 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 628 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes_crossing (self, tick, 1, note, note));
  
  return BSE_ERROR_NONE;
}

/* --- get-controls --- */
static void
get_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 634 "bsepart.proc"
 {
#line 636 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 646 "bsepart.proc"
 }
static BseErrorType
#line 646 "bsepart.proc"
get_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 649 "bsepart.proc"
{
#line 650 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
  
#line 655 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 659 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, tick, 1, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- get-range-controls --- */
static void
get_range_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 665 "bsepart.proc"
 {
#line 667 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("duration", "Tick Duration", NULL,
                         1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("control_list", "Control List", NULL,
                                BSE_TYPE_PART_CONTROL_SEQ, SFI_PARAM_STANDARD);
}
#line 679 "bsepart.proc"
 }
static BseErrorType
#line 679 "bsepart.proc"
get_range_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 682 "bsepart.proc"
{
#line 683 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  guint    ctype    = g_value_get_enum (in_values++);
  
#line 689 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 693 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_controls (self, tick, duration, ctype));
  
  return BSE_ERROR_NONE;
}

/* --- get-min-note --- */
static void
get_min_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 699 "bsepart.proc"
 {
#line 701 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 706 "bsepart.proc"
 }
static BseErrorType
#line 706 "bsepart.proc"
get_min_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 709 "bsepart.proc"
{
#line 710 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 713 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 717 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_MIN_NOTE);
  
  return BSE_ERROR_NONE;
}

/* --- get-max-note --- */
static void
get_max_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 723 "bsepart.proc"
 {
#line 725 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 730 "bsepart.proc"
 }
static BseErrorType
#line 730 "bsepart.proc"
get_max_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 733 "bsepart.proc"
{
#line 734 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 737 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 741 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_MAX_NOTE);
  
  return BSE_ERROR_NONE;
}

/* --- get-max-tick --- */
static void
get_max_tick_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 747 "bsepart.proc"
 {
#line 749 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("tick", "Tick", "Maximum Tick",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
}
#line 754 "bsepart.proc"
 }
static BseErrorType
#line 754 "bsepart.proc"
get_max_tick_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 757 "bsepart.proc"
{
#line 758 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 761 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 765 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_PART_MAX_TICK);
  
  return BSE_ERROR_NONE;
}

/* --- select-notes-exclusive --- */
static void
select_notes_exclusive_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 771 "bsepart.proc"
 {
#line 773 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 784 "bsepart.proc"
 }
static BseErrorType
#line 784 "bsepart.proc"
select_notes_exclusive_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 787 "bsepart.proc"
{
#line 788 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 795 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_notes_exclusive (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- select-controls-exclusive --- */
static void
select_controls_exclusive_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 804 "bsepart.proc"
 {
#line 806 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
}
#line 816 "bsepart.proc"
 }
static BseErrorType
#line 816 "bsepart.proc"
select_controls_exclusive_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 819 "bsepart.proc"
{
#line 820 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  guint ctype     = g_value_get_enum (in_values++);
  
#line 826 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_controls_exclusive (self, tick, duration, ctype);
  
  return BSE_ERROR_NONE;
}

/* --- select-notes --- */
static void
select_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 835 "bsepart.proc"
 {
#line 837 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 848 "bsepart.proc"
 }
static BseErrorType
#line 848 "bsepart.proc"
select_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 851 "bsepart.proc"
{
#line 852 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 859 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_notes (self, tick, duration, min_note, max_note, TRUE);
  
  return BSE_ERROR_NONE;
}

/* --- deselect-notes --- */
static void
deselect_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 868 "bsepart.proc"
 {
#line 870 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_STANDARD);
}
#line 881 "bsepart.proc"
 }
static BseErrorType
#line 881 "bsepart.proc"
deselect_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 884 "bsepart.proc"
{
#line 885 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 892 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_notes (self, tick, duration, min_note, max_note, FALSE);
  
  return BSE_ERROR_NONE;
}

/* --- deselect-controls --- */
static void
deselect_controls_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 901 "bsepart.proc"
 {
#line 903 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", "Control Type", NULL,
                                BSE_TYPE_MIDI_SIGNAL_TYPE, BSE_MIDI_SIGNAL_PITCH_BEND,
                                SFI_PARAM_STANDARD);
}
#line 913 "bsepart.proc"
 }
static BseErrorType
#line 913 "bsepart.proc"
deselect_controls_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 916 "bsepart.proc"
{
#line 917 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  guint ctype     = g_value_get_enum (in_values++);
  
#line 923 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_controls (self, tick, duration, ctype, FALSE);
  
  return BSE_ERROR_NONE;
}

/* --- select-event --- */
static void
select_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 932 "bsepart.proc"
 {
#line 934 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 939 "bsepart.proc"
 }
static BseErrorType
#line 939 "bsepart.proc"
select_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 942 "bsepart.proc"
{
#line 943 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  BsePartQueryEvent equery;
  
#line 948 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 952 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_CONTROL)
    bse_part_set_control_selected (self, id, TRUE);
  else if (equery.event_type == BSE_PART_EVENT_NOTE)
    bse_part_set_note_selected (self, id, equery.channel, TRUE);
  else
    return BSE_ERROR_PROC_PARAM_INVAL;
  return BSE_ERROR_NONE;
}

/* --- deselect-event --- */
static void
deselect_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 963 "bsepart.proc"
 {
#line 965 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 1, SFI_PARAM_STANDARD);
}
#line 970 "bsepart.proc"
 }
static BseErrorType
#line 970 "bsepart.proc"
deselect_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 973 "bsepart.proc"
{
#line 974 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  BsePartQueryEvent equery;
  
#line 979 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 983 "bsepart.proc"
  
  bse_part_query_event (self, id, &equery);
  if (equery.event_type == BSE_PART_EVENT_CONTROL)
    bse_part_set_control_selected (self, id, FALSE);
  else if (equery.event_type == BSE_PART_EVENT_NOTE)
    bse_part_set_note_selected (self, id, equery.channel, FALSE);
  else
    return BSE_ERROR_PROC_PARAM_INVAL;
  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 994 "bsepart.proc"
 {
#line 996 "bsepart.proc"
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL, BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_STANDARD);
#line 999 "bsepart.proc"
}  }
static BseErrorType
#line 999 "bsepart.proc"
get_timing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 1002 "bsepart.proc"
{
#line 1003 "bsepart.proc"
  
  BsePart *self = bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseItem *parent;
  BseSongTiming timing = { 0, };

#line 1009 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 1013 "bsepart.proc"
  
  parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent))
    bse_song_get_timing (BSE_SONG (parent), tick, &timing);
  else
    bse_song_timing_get_default (&timing);

#line 1020 "bsepart.proc"
  
  bse_value_set_boxed (out_values++, &timing);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static BseExportNodeProc __enode_insert_note_auto = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BsePart+insert-note-auto", 
    NULL,
    "/Methods/BsePart/General/Insert Note Auto",
    "Insert a new note into a part with automatic channel selection.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, insert_note_auto_setup, insert_note_auto_exec, 
};
static BseExportNodeProc __enode_insert_note = {
  { (BseExportNode*) &__enode_insert_note_auto, BSE_EXPORT_NODE_PROC,
    "BsePart+insert-note", 
    NULL,
    "/Methods/BsePart/General/Insert Note",
    "Insert a new note into a part.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, insert_note_setup, insert_note_exec, 
};
static BseExportNodeProc __enode_insert_control = {
  { (BseExportNode*) &__enode_insert_note, BSE_EXPORT_NODE_PROC,
    "BsePart+insert-control", 
    NULL,
    "/Methods/BsePart/General/Insert Control",
    "Insert a new control event into a part.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, insert_control_setup, insert_control_exec, 
};
static BseExportNodeProc __enode_change_note = {
  { (BseExportNode*) &__enode_insert_control, BSE_EXPORT_NODE_PROC,
    "BsePart+change-note", 
    NULL,
    "/Methods/BsePart/General/Change Note",
    "Change an existing note within a part.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, change_note_setup, change_note_exec, 
};
static BseExportNodeProc __enode_change_control = {
  { (BseExportNode*) &__enode_change_note, BSE_EXPORT_NODE_PROC,
    "BsePart+change-control", 
    NULL,
    "/Methods/BsePart/General/Change Control",
    "Change an existing control event within a part.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, change_control_setup, change_control_exec, 
};
static BseExportNodeProc __enode_delete_event = {
  { (BseExportNode*) &__enode_change_control, BSE_EXPORT_NODE_PROC,
    "BsePart+delete-event", 
    NULL,
    "/Methods/BsePart/General/Delete Event",
    "Delete an existing event from a part.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, delete_event_setup, delete_event_exec, 
};
static BseExportNodeProc __enode_is_event_selected = {
  { (BseExportNode*) &__enode_delete_event, BSE_EXPORT_NODE_PROC,
    "BsePart+is-event-selected", 
    NULL,
    "/Methods/BsePart/General/Is Event Selected",
    "Check whether an event is selected.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, is_event_selected_setup, is_event_selected_exec, 
};
static BseExportNodeProc __enode_list_notes_crossing = {
  { (BseExportNode*) &__enode_is_event_selected, BSE_EXPORT_NODE_PROC,
    "BsePart+list-notes-crossing", 
    NULL,
    "/Methods/BsePart/General/List Notes Crossing",
    "List all notes within or crossing a tick range.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, list_notes_crossing_setup, list_notes_crossing_exec, 
};
static BseExportNodeProc __enode_list_controls = {
  { (BseExportNode*) &__enode_list_notes_crossing, BSE_EXPORT_NODE_PROC,
    "BsePart+list-controls", 
    NULL,
    "/Methods/BsePart/General/List Controls",
    "List all control events within a tick range.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, list_controls_setup, list_controls_exec, 
};
static BseExportNodeProc __enode_queue_notes = {
  { (BseExportNode*) &__enode_list_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+queue-notes", 
    NULL,
    "/Methods/BsePart/General/Queue Notes",
    "Queue updates for all notes starting within the given rectangle.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, queue_notes_setup, queue_notes_exec, 
};
static BseExportNodeProc __enode_queue_controls = {
  { (BseExportNode*) &__enode_queue_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+queue-controls", 
    NULL,
    "/Methods/BsePart/General/Queue Controls",
    "Queue updates for all control events and notes starting within the given range.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, queue_controls_setup, queue_controls_exec, 
};
static BseExportNodeProc __enode_list_selected_notes = {
  { (BseExportNode*) &__enode_queue_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+list-selected-notes", 
    NULL,
    "/Methods/BsePart/General/List Selected Notes",
    "List all currently selected notes.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, list_selected_notes_setup, list_selected_notes_exec, 
};
static BseExportNodeProc __enode_list_selected_controls = {
  { (BseExportNode*) &__enode_list_selected_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+list-selected-controls", 
    NULL,
    "/Methods/BsePart/General/List Selected Controls",
    "List all currently selected control events of a specific type.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, list_selected_controls_setup, list_selected_controls_exec, 
};
static BseExportNodeProc __enode_check_overlap = {
  { (BseExportNode*) &__enode_list_selected_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+check-overlap", 
    NULL,
    "/Methods/BsePart/General/Check Overlap",
    "Check whether a note would overlap with neighbours.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, check_overlap_setup, check_overlap_exec, 
};
static BseExportNodeProc __enode_get_notes = {
  { (BseExportNode*) &__enode_check_overlap, BSE_EXPORT_NODE_PROC,
    "BsePart+get-notes", 
    NULL,
    "/Methods/BsePart/General/Get Notes",
    "Retrieve all notes of specific frequency at a specific tick.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_notes_setup, get_notes_exec, 
};
static BseExportNodeProc __enode_get_controls = {
  { (BseExportNode*) &__enode_get_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+get-controls", 
    NULL,
    "/Methods/BsePart/General/Get Controls",
    "Retrieve all control events of a specific type at specified tick.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_controls_setup, get_controls_exec, 
};
static BseExportNodeProc __enode_get_range_controls = {
  { (BseExportNode*) &__enode_get_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+get-range-controls", 
    NULL,
    "/Methods/BsePart/General/Get Range Controls",
    "Retrieve all control events of a specific type within range.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_range_controls_setup, get_range_controls_exec, 
};
static BseExportNodeProc __enode_get_min_note = {
  { (BseExportNode*) &__enode_get_range_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+get-min-note", 
    NULL,
    "/Methods/BsePart/General/Get Min Note",
    "Retrieve the minimum note supported in this part.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_min_note_setup, get_min_note_exec, 
};
static BseExportNodeProc __enode_get_max_note = {
  { (BseExportNode*) &__enode_get_min_note, BSE_EXPORT_NODE_PROC,
    "BsePart+get-max-note", 
    NULL,
    "/Methods/BsePart/General/Get Max Note",
    "Retrieve the maximum note supported in this part.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_max_note_setup, get_max_note_exec, 
};
static BseExportNodeProc __enode_get_max_tick = {
  { (BseExportNode*) &__enode_get_max_note, BSE_EXPORT_NODE_PROC,
    "BsePart+get-max-tick", 
    NULL,
    "/Methods/BsePart/General/Get Max Tick",
    "Retrieve the maximum tick count represented in a part.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_max_tick_setup, get_max_tick_exec, 
};
static BseExportNodeProc __enode_select_notes_exclusive = {
  { (BseExportNode*) &__enode_get_max_tick, BSE_EXPORT_NODE_PROC,
    "BsePart+select-notes-exclusive", 
    NULL,
    "/Methods/BsePart/General/Select Notes Exclusive",
    "Select all notes within rectangle and deselect all others.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, select_notes_exclusive_setup, select_notes_exclusive_exec, 
};
static BseExportNodeProc __enode_select_controls_exclusive = {
  { (BseExportNode*) &__enode_select_notes_exclusive, BSE_EXPORT_NODE_PROC,
    "BsePart+select-controls-exclusive", 
    NULL,
    "/Methods/BsePart/General/Select Controls Exclusive",
    "Select all control events within range and deselect all others.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, select_controls_exclusive_setup, select_controls_exclusive_exec, 
};
static BseExportNodeProc __enode_select_notes = {
  { (BseExportNode*) &__enode_select_controls_exclusive, BSE_EXPORT_NODE_PROC,
    "BsePart+select-notes", 
    NULL,
    "/Methods/BsePart/General/Select Notes",
    "Select all notes within rectangle.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, select_notes_setup, select_notes_exec, 
};
static BseExportNodeProc __enode_deselect_notes = {
  { (BseExportNode*) &__enode_select_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+deselect-notes", 
    NULL,
    "/Methods/BsePart/General/Deselect Notes",
    "Deselect all notes within rectangle.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, deselect_notes_setup, deselect_notes_exec, 
};
static BseExportNodeProc __enode_deselect_controls = {
  { (BseExportNode*) &__enode_deselect_notes, BSE_EXPORT_NODE_PROC,
    "BsePart+deselect-controls", 
    NULL,
    "/Methods/BsePart/General/Deselect Controls",
    "Deselect all controls within given range.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, deselect_controls_setup, deselect_controls_exec, 
};
static BseExportNodeProc __enode_select_event = {
  { (BseExportNode*) &__enode_deselect_controls, BSE_EXPORT_NODE_PROC,
    "BsePart+select-event", 
    NULL,
    "/Methods/BsePart/General/Select Event",
    "Select an existing event.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, select_event_setup, select_event_exec, 
};
static BseExportNodeProc __enode_deselect_event = {
  { (BseExportNode*) &__enode_select_event, BSE_EXPORT_NODE_PROC,
    "BsePart+deselect-event", 
    NULL,
    "/Methods/BsePart/General/Deselect Event",
    "Deselect an existing event.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, deselect_event_setup, deselect_event_exec, 
};
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_deselect_event, BSE_EXPORT_NODE_PROC,
    "BsePart+get-timing", 
    NULL,
    "/Methods/BsePart/General/Get Timing",
    "Retrieve song timing information at a specific tick.",
    "Tim Janik <timj@gtk.org>",
    "GNU General Public License",
  },
  0, get_timing_setup, get_timing_exec, 
};
BseExportNode* bse__builtin_init_bsepart_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsepart_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_get_timing;
}

/**
 ** Generated data ends here
 **/
