
/*-------- begin ../sfi/sfidl generated code --------*/



#include <bse/bsecxxplugin.h>


/* enum prototypes */
namespace Bse {
#define BSE_TYPE_MIDI_SIGNAL_TYPE		BSE_CXX_DECLARED_ENUM_TYPE (Bse, MidiSignalType)
#define BSE_TYPE_MIDI_CONTROL_TYPE		BSE_CXX_DECLARED_ENUM_TYPE (Bse, MidiControlType)
#define BSE_TYPE_USER_MSG_TYPE		BSE_CXX_DECLARED_ENUM_TYPE (Bse, UserMsgType)
#define BSE_TYPE_THREAD_STATE		BSE_CXX_DECLARED_ENUM_TYPE (Bse, ThreadState)


/* choice prototypes */
static inline SfiChoiceValues MidiSignalType_choice_values();
static inline SfiChoiceValues MidiControlType_choice_values();
static inline SfiChoiceValues UserMsgType_choice_values();
static inline SfiChoiceValues ThreadState_choice_values();


/* record prototypes */
class PropertyCandidates;
typedef Sfi::RecordHandle<PropertyCandidates> PropertyCandidatesHandle;
#define BSE_TYPE_PROPERTY_CANDIDATES		BSE_CXX_DECLARED_RECORD_TYPE (Bse, PropertyCandidates)
class PartNote;
typedef Sfi::RecordHandle<PartNote> PartNoteHandle;
#define BSE_TYPE_PART_NOTE		BSE_CXX_DECLARED_RECORD_TYPE (Bse, PartNote)
class PartControl;
typedef Sfi::RecordHandle<PartControl> PartControlHandle;
#define BSE_TYPE_PART_CONTROL		BSE_CXX_DECLARED_RECORD_TYPE (Bse, PartControl)
class NoteDescription;
typedef Sfi::RecordHandle<NoteDescription> NoteDescriptionHandle;
#define BSE_TYPE_NOTE_DESCRIPTION		BSE_CXX_DECLARED_RECORD_TYPE (Bse, NoteDescription)
class NoteSequence;
typedef Sfi::RecordHandle<NoteSequence> NoteSequenceHandle;
#define BSE_TYPE_NOTE_SEQUENCE		BSE_CXX_DECLARED_RECORD_TYPE (Bse, NoteSequence)
class Icon;
typedef Sfi::RecordHandle<Icon> IconHandle;
#define BSE_TYPE_ICON		BSE_CXX_DECLARED_RECORD_TYPE (Bse, Icon)
class Category;
typedef Sfi::RecordHandle<Category> CategoryHandle;
#define BSE_TYPE_CATEGORY		BSE_CXX_DECLARED_RECORD_TYPE (Bse, Category)
class Dot;
typedef Sfi::RecordHandle<Dot> DotHandle;
#define BSE_TYPE_DOT		BSE_CXX_DECLARED_RECORD_TYPE (Bse, Dot)
class TrackPart;
typedef Sfi::RecordHandle<TrackPart> TrackPartHandle;
#define BSE_TYPE_TRACK_PART		BSE_CXX_DECLARED_RECORD_TYPE (Bse, TrackPart)
class SongTiming;
typedef Sfi::RecordHandle<SongTiming> SongTimingHandle;
#define BSE_TYPE_SONG_TIMING		BSE_CXX_DECLARED_RECORD_TYPE (Bse, SongTiming)
class SampleFileInfo;
typedef Sfi::RecordHandle<SampleFileInfo> SampleFileInfoHandle;
#define BSE_TYPE_SAMPLE_FILE_INFO		BSE_CXX_DECLARED_RECORD_TYPE (Bse, SampleFileInfo)
class UserMsg;
typedef Sfi::RecordHandle<UserMsg> UserMsgHandle;
#define BSE_TYPE_USER_MSG		BSE_CXX_DECLARED_RECORD_TYPE (Bse, UserMsg)
class ThreadInfo;
typedef Sfi::RecordHandle<ThreadInfo> ThreadInfoHandle;
#define BSE_TYPE_THREAD_INFO		BSE_CXX_DECLARED_RECORD_TYPE (Bse, ThreadInfo)
class ThreadTotals;
typedef Sfi::RecordHandle<ThreadTotals> ThreadTotalsHandle;
#define BSE_TYPE_THREAD_TOTALS		BSE_CXX_DECLARED_RECORD_TYPE (Bse, ThreadTotals)
class GConfig;
typedef Sfi::RecordHandle<GConfig> GConfigHandle;
#define BSE_TYPE_GCONFIG		BSE_CXX_DECLARED_RECORD_TYPE (Bse, GConfig)


/* sequence prototypes */
class IntSeq;
#define BSE_TYPE_INT_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, IntSeq)
class NoteSeq;
#define BSE_TYPE_NOTE_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, NoteSeq)
class StringSeq;
#define BSE_TYPE_STRING_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, StringSeq)
class TypeSeq;
#define BSE_TYPE_TYPE_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, TypeSeq)
class ItemSeq;
#define BSE_TYPE_ITEM_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, ItemSeq)
class PartNoteSeq;
#define BSE_TYPE_PART_NOTE_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, PartNoteSeq)
class PartControlSeq;
#define BSE_TYPE_PART_CONTROL_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, PartControlSeq)
class CategorySeq;
#define BSE_TYPE_CATEGORY_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, CategorySeq)
class DotSeq;
#define BSE_TYPE_DOT_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, DotSeq)
class TrackPartSeq;
#define BSE_TYPE_TRACK_PART_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, TrackPartSeq)
class ThreadInfoSeq;
#define BSE_TYPE_THREAD_INFO_SEQ		BSE_CXX_DECLARED_SEQUENCE_TYPE (Bse, ThreadInfoSeq)


/* class prototypes */


/* enum definitions */
enum MidiSignalType {
  MIDI_SIGNAL_PROGRAM = 1,
  MIDI_SIGNAL_PRESSURE = 2,
  MIDI_SIGNAL_PITCH_BEND = 3,
  MIDI_SIGNAL_VELOCITY = 4,
  MIDI_SIGNAL_FINE_TUNE = 5,
  MIDI_SIGNAL_CONTINUOUS_0 = 64,
  MIDI_SIGNAL_CONTINUOUS_1 = 65,
  MIDI_SIGNAL_CONTINUOUS_2 = 66,
  MIDI_SIGNAL_CONTINUOUS_3 = 67,
  MIDI_SIGNAL_CONTINUOUS_4 = 68,
  MIDI_SIGNAL_CONTINUOUS_5 = 69,
  MIDI_SIGNAL_CONTINUOUS_6 = 70,
  MIDI_SIGNAL_CONTINUOUS_7 = 71,
  MIDI_SIGNAL_CONTINUOUS_8 = 72,
  MIDI_SIGNAL_CONTINUOUS_9 = 73,
  MIDI_SIGNAL_CONTINUOUS_10 = 74,
  MIDI_SIGNAL_CONTINUOUS_11 = 75,
  MIDI_SIGNAL_CONTINUOUS_12 = 76,
  MIDI_SIGNAL_CONTINUOUS_13 = 77,
  MIDI_SIGNAL_CONTINUOUS_14 = 78,
  MIDI_SIGNAL_CONTINUOUS_15 = 79,
  MIDI_SIGNAL_CONTINUOUS_16 = 80,
  MIDI_SIGNAL_CONTINUOUS_17 = 81,
  MIDI_SIGNAL_CONTINUOUS_18 = 82,
  MIDI_SIGNAL_CONTINUOUS_19 = 83,
  MIDI_SIGNAL_CONTINUOUS_20 = 84,
  MIDI_SIGNAL_CONTINUOUS_21 = 85,
  MIDI_SIGNAL_CONTINUOUS_22 = 86,
  MIDI_SIGNAL_CONTINUOUS_23 = 87,
  MIDI_SIGNAL_CONTINUOUS_24 = 88,
  MIDI_SIGNAL_CONTINUOUS_25 = 89,
  MIDI_SIGNAL_CONTINUOUS_26 = 90,
  MIDI_SIGNAL_CONTINUOUS_27 = 91,
  MIDI_SIGNAL_CONTINUOUS_28 = 92,
  MIDI_SIGNAL_CONTINUOUS_29 = 93,
  MIDI_SIGNAL_CONTINUOUS_30 = 94,
  MIDI_SIGNAL_CONTINUOUS_31 = 95,
  MIDI_SIGNAL_CONSTANT_HIGH = 96,
  MIDI_SIGNAL_CONSTANT_CENTER = 97,
  MIDI_SIGNAL_CONSTANT_LOW = 98,
  MIDI_SIGNAL_CONSTANT_NEGATIVE_CENTER = 99,
  MIDI_SIGNAL_CONSTANT_NEGATIVE_HIGH = 100,
  MIDI_SIGNAL_PARAMETER = 101,
  MIDI_SIGNAL_NON_PARAMETER = 102,
  MIDI_SIGNAL_CONTROL_0 = 128,
  MIDI_SIGNAL_CONTROL_1 = 129,
  MIDI_SIGNAL_CONTROL_2 = 130,
  MIDI_SIGNAL_CONTROL_3 = 131,
  MIDI_SIGNAL_CONTROL_4 = 132,
  MIDI_SIGNAL_CONTROL_5 = 133,
  MIDI_SIGNAL_CONTROL_6 = 134,
  MIDI_SIGNAL_CONTROL_7 = 135,
  MIDI_SIGNAL_CONTROL_8 = 136,
  MIDI_SIGNAL_CONTROL_9 = 137,
  MIDI_SIGNAL_CONTROL_10 = 138,
  MIDI_SIGNAL_CONTROL_11 = 139,
  MIDI_SIGNAL_CONTROL_12 = 140,
  MIDI_SIGNAL_CONTROL_13 = 141,
  MIDI_SIGNAL_CONTROL_14 = 142,
  MIDI_SIGNAL_CONTROL_15 = 143,
  MIDI_SIGNAL_CONTROL_16 = 144,
  MIDI_SIGNAL_CONTROL_17 = 145,
  MIDI_SIGNAL_CONTROL_18 = 146,
  MIDI_SIGNAL_CONTROL_19 = 147,
  MIDI_SIGNAL_CONTROL_20 = 148,
  MIDI_SIGNAL_CONTROL_21 = 149,
  MIDI_SIGNAL_CONTROL_22 = 150,
  MIDI_SIGNAL_CONTROL_23 = 151,
  MIDI_SIGNAL_CONTROL_24 = 152,
  MIDI_SIGNAL_CONTROL_25 = 153,
  MIDI_SIGNAL_CONTROL_26 = 154,
  MIDI_SIGNAL_CONTROL_27 = 155,
  MIDI_SIGNAL_CONTROL_28 = 156,
  MIDI_SIGNAL_CONTROL_29 = 157,
  MIDI_SIGNAL_CONTROL_30 = 158,
  MIDI_SIGNAL_CONTROL_31 = 159,
  MIDI_SIGNAL_CONTROL_32 = 160,
  MIDI_SIGNAL_CONTROL_33 = 161,
  MIDI_SIGNAL_CONTROL_34 = 162,
  MIDI_SIGNAL_CONTROL_35 = 163,
  MIDI_SIGNAL_CONTROL_36 = 164,
  MIDI_SIGNAL_CONTROL_37 = 165,
  MIDI_SIGNAL_CONTROL_38 = 166,
  MIDI_SIGNAL_CONTROL_39 = 167,
  MIDI_SIGNAL_CONTROL_40 = 168,
  MIDI_SIGNAL_CONTROL_41 = 169,
  MIDI_SIGNAL_CONTROL_42 = 170,
  MIDI_SIGNAL_CONTROL_43 = 171,
  MIDI_SIGNAL_CONTROL_44 = 172,
  MIDI_SIGNAL_CONTROL_45 = 173,
  MIDI_SIGNAL_CONTROL_46 = 174,
  MIDI_SIGNAL_CONTROL_47 = 175,
  MIDI_SIGNAL_CONTROL_48 = 176,
  MIDI_SIGNAL_CONTROL_49 = 177,
  MIDI_SIGNAL_CONTROL_50 = 178,
  MIDI_SIGNAL_CONTROL_51 = 179,
  MIDI_SIGNAL_CONTROL_52 = 180,
  MIDI_SIGNAL_CONTROL_53 = 181,
  MIDI_SIGNAL_CONTROL_54 = 182,
  MIDI_SIGNAL_CONTROL_55 = 183,
  MIDI_SIGNAL_CONTROL_56 = 184,
  MIDI_SIGNAL_CONTROL_57 = 185,
  MIDI_SIGNAL_CONTROL_58 = 186,
  MIDI_SIGNAL_CONTROL_59 = 187,
  MIDI_SIGNAL_CONTROL_60 = 188,
  MIDI_SIGNAL_CONTROL_61 = 189,
  MIDI_SIGNAL_CONTROL_62 = 190,
  MIDI_SIGNAL_CONTROL_63 = 191,
  MIDI_SIGNAL_CONTROL_64 = 192,
  MIDI_SIGNAL_CONTROL_65 = 193,
  MIDI_SIGNAL_CONTROL_66 = 194,
  MIDI_SIGNAL_CONTROL_67 = 195,
  MIDI_SIGNAL_CONTROL_68 = 196,
  MIDI_SIGNAL_CONTROL_69 = 197,
  MIDI_SIGNAL_CONTROL_70 = 198,
  MIDI_SIGNAL_CONTROL_71 = 199,
  MIDI_SIGNAL_CONTROL_72 = 200,
  MIDI_SIGNAL_CONTROL_73 = 201,
  MIDI_SIGNAL_CONTROL_74 = 202,
  MIDI_SIGNAL_CONTROL_75 = 203,
  MIDI_SIGNAL_CONTROL_76 = 204,
  MIDI_SIGNAL_CONTROL_77 = 205,
  MIDI_SIGNAL_CONTROL_78 = 206,
  MIDI_SIGNAL_CONTROL_79 = 207,
  MIDI_SIGNAL_CONTROL_80 = 208,
  MIDI_SIGNAL_CONTROL_81 = 209,
  MIDI_SIGNAL_CONTROL_82 = 210,
  MIDI_SIGNAL_CONTROL_83 = 211,
  MIDI_SIGNAL_CONTROL_84 = 212,
  MIDI_SIGNAL_CONTROL_85 = 213,
  MIDI_SIGNAL_CONTROL_86 = 214,
  MIDI_SIGNAL_CONTROL_87 = 215,
  MIDI_SIGNAL_CONTROL_88 = 216,
  MIDI_SIGNAL_CONTROL_89 = 217,
  MIDI_SIGNAL_CONTROL_90 = 218,
  MIDI_SIGNAL_CONTROL_91 = 219,
  MIDI_SIGNAL_CONTROL_92 = 220,
  MIDI_SIGNAL_CONTROL_93 = 221,
  MIDI_SIGNAL_CONTROL_94 = 222,
  MIDI_SIGNAL_CONTROL_95 = 223,
  MIDI_SIGNAL_CONTROL_96 = 224,
  MIDI_SIGNAL_CONTROL_97 = 225,
  MIDI_SIGNAL_CONTROL_98 = 226,
  MIDI_SIGNAL_CONTROL_99 = 227,
  MIDI_SIGNAL_CONTROL_100 = 228,
  MIDI_SIGNAL_CONTROL_101 = 229,
  MIDI_SIGNAL_CONTROL_102 = 230,
  MIDI_SIGNAL_CONTROL_103 = 231,
  MIDI_SIGNAL_CONTROL_104 = 232,
  MIDI_SIGNAL_CONTROL_105 = 233,
  MIDI_SIGNAL_CONTROL_106 = 234,
  MIDI_SIGNAL_CONTROL_107 = 235,
  MIDI_SIGNAL_CONTROL_108 = 236,
  MIDI_SIGNAL_CONTROL_109 = 237,
  MIDI_SIGNAL_CONTROL_110 = 238,
  MIDI_SIGNAL_CONTROL_111 = 239,
  MIDI_SIGNAL_CONTROL_112 = 240,
  MIDI_SIGNAL_CONTROL_113 = 241,
  MIDI_SIGNAL_CONTROL_114 = 242,
  MIDI_SIGNAL_CONTROL_115 = 243,
  MIDI_SIGNAL_CONTROL_116 = 244,
  MIDI_SIGNAL_CONTROL_117 = 245,
  MIDI_SIGNAL_CONTROL_118 = 246,
  MIDI_SIGNAL_CONTROL_119 = 247,
  MIDI_SIGNAL_CONTROL_120 = 248,
  MIDI_SIGNAL_CONTROL_121 = 249,
  MIDI_SIGNAL_CONTROL_122 = 250,
  MIDI_SIGNAL_CONTROL_123 = 251,
  MIDI_SIGNAL_CONTROL_124 = 252,
  MIDI_SIGNAL_CONTROL_125 = 253,
  MIDI_SIGNAL_CONTROL_126 = 254,
  MIDI_SIGNAL_CONTROL_127 = 255,
};
enum MidiControlType {
  MIDI_CONTROL_NONE = 0,
  MIDI_CONTROL_CONTINUOUS_0 = 64,
  MIDI_CONTROL_CONTINUOUS_1 = 65,
  MIDI_CONTROL_CONTINUOUS_2 = 66,
  MIDI_CONTROL_CONTINUOUS_3 = 67,
  MIDI_CONTROL_CONTINUOUS_4 = 68,
  MIDI_CONTROL_CONTINUOUS_5 = 69,
  MIDI_CONTROL_CONTINUOUS_6 = 70,
  MIDI_CONTROL_CONTINUOUS_7 = 71,
  MIDI_CONTROL_CONTINUOUS_8 = 72,
  MIDI_CONTROL_CONTINUOUS_9 = 73,
  MIDI_CONTROL_CONTINUOUS_10 = 74,
  MIDI_CONTROL_CONTINUOUS_11 = 75,
  MIDI_CONTROL_CONTINUOUS_12 = 76,
  MIDI_CONTROL_CONTINUOUS_13 = 77,
  MIDI_CONTROL_CONTINUOUS_14 = 78,
  MIDI_CONTROL_CONTINUOUS_15 = 79,
  MIDI_CONTROL_CONTINUOUS_16 = 80,
  MIDI_CONTROL_CONTINUOUS_17 = 81,
  MIDI_CONTROL_CONTINUOUS_18 = 82,
  MIDI_CONTROL_CONTINUOUS_19 = 83,
  MIDI_CONTROL_CONTINUOUS_20 = 84,
  MIDI_CONTROL_CONTINUOUS_21 = 85,
  MIDI_CONTROL_CONTINUOUS_22 = 86,
  MIDI_CONTROL_CONTINUOUS_23 = 87,
  MIDI_CONTROL_CONTINUOUS_24 = 88,
  MIDI_CONTROL_CONTINUOUS_25 = 89,
  MIDI_CONTROL_CONTINUOUS_26 = 90,
  MIDI_CONTROL_CONTINUOUS_27 = 91,
  MIDI_CONTROL_CONTINUOUS_28 = 92,
  MIDI_CONTROL_CONTINUOUS_29 = 93,
  MIDI_CONTROL_CONTINUOUS_30 = 94,
  MIDI_CONTROL_CONTINUOUS_31 = 95,
  MIDI_CONTROL_0 = 128,
  MIDI_CONTROL_1 = 129,
  MIDI_CONTROL_2 = 130,
  MIDI_CONTROL_3 = 131,
  MIDI_CONTROL_4 = 132,
  MIDI_CONTROL_5 = 133,
  MIDI_CONTROL_6 = 134,
  MIDI_CONTROL_7 = 135,
  MIDI_CONTROL_8 = 136,
  MIDI_CONTROL_9 = 137,
  MIDI_CONTROL_10 = 138,
  MIDI_CONTROL_11 = 139,
  MIDI_CONTROL_12 = 140,
  MIDI_CONTROL_13 = 141,
  MIDI_CONTROL_14 = 142,
  MIDI_CONTROL_15 = 143,
  MIDI_CONTROL_16 = 144,
  MIDI_CONTROL_17 = 145,
  MIDI_CONTROL_18 = 146,
  MIDI_CONTROL_19 = 147,
  MIDI_CONTROL_20 = 148,
  MIDI_CONTROL_21 = 149,
  MIDI_CONTROL_22 = 150,
  MIDI_CONTROL_23 = 151,
  MIDI_CONTROL_24 = 152,
  MIDI_CONTROL_25 = 153,
  MIDI_CONTROL_26 = 154,
  MIDI_CONTROL_27 = 155,
  MIDI_CONTROL_28 = 156,
  MIDI_CONTROL_29 = 157,
  MIDI_CONTROL_30 = 158,
  MIDI_CONTROL_31 = 159,
  MIDI_CONTROL_32 = 160,
  MIDI_CONTROL_33 = 161,
  MIDI_CONTROL_34 = 162,
  MIDI_CONTROL_35 = 163,
  MIDI_CONTROL_36 = 164,
  MIDI_CONTROL_37 = 165,
  MIDI_CONTROL_38 = 166,
  MIDI_CONTROL_39 = 167,
  MIDI_CONTROL_40 = 168,
  MIDI_CONTROL_41 = 169,
  MIDI_CONTROL_42 = 170,
  MIDI_CONTROL_43 = 171,
  MIDI_CONTROL_44 = 172,
  MIDI_CONTROL_45 = 173,
  MIDI_CONTROL_46 = 174,
  MIDI_CONTROL_47 = 175,
  MIDI_CONTROL_48 = 176,
  MIDI_CONTROL_49 = 177,
  MIDI_CONTROL_50 = 178,
  MIDI_CONTROL_51 = 179,
  MIDI_CONTROL_52 = 180,
  MIDI_CONTROL_53 = 181,
  MIDI_CONTROL_54 = 182,
  MIDI_CONTROL_55 = 183,
  MIDI_CONTROL_56 = 184,
  MIDI_CONTROL_57 = 185,
  MIDI_CONTROL_58 = 186,
  MIDI_CONTROL_59 = 187,
  MIDI_CONTROL_60 = 188,
  MIDI_CONTROL_61 = 189,
  MIDI_CONTROL_62 = 190,
  MIDI_CONTROL_63 = 191,
  MIDI_CONTROL_64 = 192,
  MIDI_CONTROL_65 = 193,
  MIDI_CONTROL_66 = 194,
  MIDI_CONTROL_67 = 195,
  MIDI_CONTROL_68 = 196,
  MIDI_CONTROL_69 = 197,
  MIDI_CONTROL_70 = 198,
  MIDI_CONTROL_71 = 199,
  MIDI_CONTROL_72 = 200,
  MIDI_CONTROL_73 = 201,
  MIDI_CONTROL_74 = 202,
  MIDI_CONTROL_75 = 203,
  MIDI_CONTROL_76 = 204,
  MIDI_CONTROL_77 = 205,
  MIDI_CONTROL_78 = 206,
  MIDI_CONTROL_79 = 207,
  MIDI_CONTROL_80 = 208,
  MIDI_CONTROL_81 = 209,
  MIDI_CONTROL_82 = 210,
  MIDI_CONTROL_83 = 211,
  MIDI_CONTROL_84 = 212,
  MIDI_CONTROL_85 = 213,
  MIDI_CONTROL_86 = 214,
  MIDI_CONTROL_87 = 215,
  MIDI_CONTROL_88 = 216,
  MIDI_CONTROL_89 = 217,
  MIDI_CONTROL_90 = 218,
  MIDI_CONTROL_91 = 219,
  MIDI_CONTROL_92 = 220,
  MIDI_CONTROL_93 = 221,
  MIDI_CONTROL_94 = 222,
  MIDI_CONTROL_95 = 223,
  MIDI_CONTROL_96 = 224,
  MIDI_CONTROL_97 = 225,
  MIDI_CONTROL_98 = 226,
  MIDI_CONTROL_99 = 227,
  MIDI_CONTROL_100 = 228,
  MIDI_CONTROL_101 = 229,
  MIDI_CONTROL_102 = 230,
  MIDI_CONTROL_103 = 231,
  MIDI_CONTROL_104 = 232,
  MIDI_CONTROL_105 = 233,
  MIDI_CONTROL_106 = 234,
  MIDI_CONTROL_107 = 235,
  MIDI_CONTROL_108 = 236,
  MIDI_CONTROL_109 = 237,
  MIDI_CONTROL_110 = 238,
  MIDI_CONTROL_111 = 239,
  MIDI_CONTROL_112 = 240,
  MIDI_CONTROL_113 = 241,
  MIDI_CONTROL_114 = 242,
  MIDI_CONTROL_115 = 243,
  MIDI_CONTROL_116 = 244,
  MIDI_CONTROL_117 = 245,
  MIDI_CONTROL_118 = 246,
  MIDI_CONTROL_119 = 247,
  MIDI_CONTROL_120 = 248,
  MIDI_CONTROL_121 = 249,
  MIDI_CONTROL_122 = 250,
  MIDI_CONTROL_123 = 251,
  MIDI_CONTROL_124 = 252,
  MIDI_CONTROL_125 = 253,
  MIDI_CONTROL_126 = 254,
  MIDI_CONTROL_127 = 255,
};
enum UserMsgType {
  USER_MSG_MISC = 0,
  USER_MSG_INFO = 1,
  USER_MSG_WARNING = 2,
  USER_MSG_ERROR = 3,
};
enum ThreadState {
  THREAD_STATE_UNKNOWN = 0,
  THREAD_STATE_RUNNING = 1,
  THREAD_STATE_SLEEPING = 2,
  THREAD_STATE_DISKWAIT = 3,
  THREAD_STATE_TRACED = 4,
  THREAD_STATE_PAGING = 5,
  THREAD_STATE_ZOMBIE = 6,
  THREAD_STATE_DEAD = 7,
};


/* sequence definitions */
class IntSeq : public Sfi::Sequence< Sfi::Int > {
public:
  IntSeq (unsigned int n = 0) : Sfi::Sequence< Sfi::Int > (n) {}
  static inline ::Bse::IntSeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::IntSeq & seq);
  static inline ::Bse::IntSeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::IntSeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseIntSeq"; }
  static inline GParamSpec* get_element ();
};

class NoteSeq : public Sfi::Sequence< Sfi::Int > {
public:
  NoteSeq (unsigned int n = 0) : Sfi::Sequence< Sfi::Int > (n) {}
  static inline ::Bse::NoteSeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::NoteSeq & seq);
  static inline ::Bse::NoteSeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::NoteSeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseNoteSeq"; }
  static inline GParamSpec* get_element ();
};

class StringSeq : public Sfi::Sequence< Sfi::String > {
public:
  StringSeq (unsigned int n = 0) : Sfi::Sequence< Sfi::String > (n) {}
  static inline ::Bse::StringSeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::StringSeq & seq);
  static inline ::Bse::StringSeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::StringSeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseStringSeq"; }
  static inline GParamSpec* get_element ();
};

class TypeSeq : public Sfi::Sequence< Sfi::String > {
public:
  TypeSeq (unsigned int n = 0) : Sfi::Sequence< Sfi::String > (n) {}
  static inline ::Bse::TypeSeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::TypeSeq & seq);
  static inline ::Bse::TypeSeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::TypeSeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseTypeSeq"; }
  static inline GParamSpec* get_element ();
};

class ItemSeq : public Sfi::Sequence< BseItem* > {
public:
  ItemSeq (unsigned int n = 0) : Sfi::Sequence< BseItem* > (n) {}
  static inline ::Bse::ItemSeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::ItemSeq & seq);
  static inline ::Bse::ItemSeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::ItemSeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return "A list of BSE items or derived types."; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseItemSeq"; }
  static inline GParamSpec* get_element ();
};

class PartNoteSeq : public Sfi::Sequence< ::Bse::PartNoteHandle > {
public:
  PartNoteSeq (unsigned int n = 0) : Sfi::Sequence< ::Bse::PartNoteHandle > (n) {}
  static inline ::Bse::PartNoteSeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::PartNoteSeq & seq);
  static inline ::Bse::PartNoteSeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::PartNoteSeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return "A list of part notes"; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BsePartNoteSeq"; }
  static inline GParamSpec* get_element ();
};

class PartControlSeq : public Sfi::Sequence< ::Bse::PartControlHandle > {
public:
  PartControlSeq (unsigned int n = 0) : Sfi::Sequence< ::Bse::PartControlHandle > (n) {}
  static inline ::Bse::PartControlSeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::PartControlSeq & seq);
  static inline ::Bse::PartControlSeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::PartControlSeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return "A list of part control events"; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BsePartControlSeq"; }
  static inline GParamSpec* get_element ();
};

class CategorySeq : public Sfi::Sequence< ::Bse::CategoryHandle > {
public:
  CategorySeq (unsigned int n = 0) : Sfi::Sequence< ::Bse::CategoryHandle > (n) {}
  static inline ::Bse::CategorySeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::CategorySeq & seq);
  static inline ::Bse::CategorySeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::CategorySeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseCategorySeq"; }
  static inline GParamSpec* get_element ();
};

class DotSeq : public Sfi::Sequence< ::Bse::DotHandle > {
public:
  DotSeq (unsigned int n = 0) : Sfi::Sequence< ::Bse::DotHandle > (n) {}
  static inline ::Bse::DotSeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::DotSeq & seq);
  static inline ::Bse::DotSeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::DotSeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseDotSeq"; }
  static inline GParamSpec* get_element ();
};

class TrackPartSeq : public Sfi::Sequence< ::Bse::TrackPartHandle > {
public:
  TrackPartSeq (unsigned int n = 0) : Sfi::Sequence< ::Bse::TrackPartHandle > (n) {}
  static inline ::Bse::TrackPartSeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::TrackPartSeq & seq);
  static inline ::Bse::TrackPartSeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::TrackPartSeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseTrackPartSeq"; }
  static inline GParamSpec* get_element ();
};

class ThreadInfoSeq : public Sfi::Sequence< ::Bse::ThreadInfoHandle > {
public:
  ThreadInfoSeq (unsigned int n = 0) : Sfi::Sequence< ::Bse::ThreadInfoHandle > (n) {}
  static inline ::Bse::ThreadInfoSeq from_seq (SfiSeq *seq);
  static inline SfiSeq *to_seq (const ::Bse::ThreadInfoSeq & seq);
  static inline ::Bse::ThreadInfoSeq value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::ThreadInfoSeq & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseThreadInfoSeq"; }
  static inline GParamSpec* get_element ();
};



/* record definitions */
class PropertyCandidates : public ::Sfi::GNewable {
public:
  Sfi::String label;
  Sfi::String tooltip;
  ::Bse::ItemSeq items;
  ::Bse::TypeSeq partitions;
  static inline ::Bse::PropertyCandidatesHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::PropertyCandidatesHandle & ptr);
  static inline ::Bse::PropertyCandidatesHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::PropertyCandidatesHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return "A strcuture describing tentative property values."; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BsePropertyCandidates"; }
  static inline SfiRecFields get_fields ();
};

class PartNote : public ::Sfi::GNewable {
public:
  Sfi::Int id;
  Sfi::Int channel;
  Sfi::Int tick;
  Sfi::Int duration;
  Sfi::Int note;
  Sfi::Int fine_tune;
  Sfi::Real velocity;
  bool selected;
  static inline ::Bse::PartNoteHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::PartNoteHandle & ptr);
  static inline ::Bse::PartNoteHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::PartNoteHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return "Part specific note representation"; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BsePartNote"; }
  static inline SfiRecFields get_fields ();
};

class PartControl : public ::Sfi::GNewable {
public:
  Sfi::Int id;
  Sfi::Int tick;
  ::Bse::MidiSignalType control_type;
  Sfi::Real value;
  bool selected;
  static inline ::Bse::PartControlHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::PartControlHandle & ptr);
  static inline ::Bse::PartControlHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::PartControlHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return "Part specific control event representation"; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BsePartControl"; }
  static inline SfiRecFields get_fields ();
};

class NoteDescription : public ::Sfi::GNewable {
public:
  Sfi::Int note;
  Sfi::Int octave;
  Sfi::Real freq;
  Sfi::Int fine_tune;
  Sfi::Int semitone;
  bool upshift;
  Sfi::Int letter;
  Sfi::String name;
  Sfi::Int max_fine_tune;
  Sfi::Int kammer_note;
  static inline ::Bse::NoteDescriptionHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::NoteDescriptionHandle & ptr);
  static inline ::Bse::NoteDescriptionHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::NoteDescriptionHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return "A note description provides all necessary details about a specific note. Various procedures exist to retrieve a note description; given different key values. The max_fine_tune and kammer_note fields are constants; which are provided for compatibility reasons and will vanish in future APIs."; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseNoteDescription"; }
  static inline SfiRecFields get_fields ();
};

class NoteSequence : public ::Sfi::GNewable {
public:
  Sfi::Int offset;
  ::Bse::NoteSeq notes;
  static inline ::Bse::NoteSequenceHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::NoteSequenceHandle & ptr);
  static inline ::Bse::NoteSequenceHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::NoteSequenceHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseNoteSequence"; }
  static inline SfiRecFields get_fields ();
};

class Icon : public ::Sfi::GNewable {
public:
  Sfi::Int bytes_per_pixel;
  Sfi::Int width;
  Sfi::Int height;
  Sfi::BBlock pixels;
  static inline ::Bse::IconHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::IconHandle & ptr);
  static inline ::Bse::IconHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::IconHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return "BSE icon representation."; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseIcon"; }
  static inline SfiRecFields get_fields ();
};

class Category : public ::Sfi::GNewable {
public:
  Sfi::Int category_id;
  Sfi::String category;
  Sfi::Int mindex;
  Sfi::Int lindex;
  Sfi::String type;
  ::Bse::IconHandle icon;
  static inline ::Bse::CategoryHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::CategoryHandle & ptr);
  static inline ::Bse::CategoryHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::CategoryHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseCategory"; }
  static inline SfiRecFields get_fields ();
};

class Dot : public ::Sfi::GNewable {
public:
  Sfi::Real x;
  Sfi::Real y;
  static inline ::Bse::DotHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::DotHandle & ptr);
  static inline ::Bse::DotHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::DotHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseDot"; }
  static inline SfiRecFields get_fields ();
};

class TrackPart : public ::Sfi::GNewable {
public:
  Sfi::Int tick;
  BsePart* part;
  Sfi::Int duration;
  static inline ::Bse::TrackPartHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::TrackPartHandle & ptr);
  static inline ::Bse::TrackPartHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::TrackPartHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseTrackPart"; }
  static inline SfiRecFields get_fields ();
};

class SongTiming : public ::Sfi::GNewable {
public:
  Sfi::Int tick;
  Sfi::Real bpm;
  Sfi::Int numerator;
  Sfi::Int denominator;
  Sfi::Int tpqn;
  Sfi::Int tpt;
  static inline ::Bse::SongTimingHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::SongTimingHandle & ptr);
  static inline ::Bse::SongTimingHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::SongTimingHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseSongTiming"; }
  static inline SfiRecFields get_fields ();
};

class SampleFileInfo : public ::Sfi::GNewable {
public:
  Sfi::String file;
  Sfi::Int size;
  Sfi::Num mtime;
  Sfi::String loader;
  ::Bse::StringSeq waves;
  Sfi::Int error;
  static inline ::Bse::SampleFileInfoHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::SampleFileInfoHandle & ptr);
  static inline ::Bse::SampleFileInfoHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::SampleFileInfoHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseSampleFileInfo"; }
  static inline SfiRecFields get_fields ();
};

class UserMsg : public ::Sfi::GNewable {
public:
  Sfi::String log_domain;
  ::Bse::UserMsgType msg_type;
  Sfi::String config_blurb;
  Sfi::String message;
  Sfi::Int pid;
  Sfi::String process;
  static inline ::Bse::UserMsgHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::UserMsgHandle & ptr);
  static inline ::Bse::UserMsgHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::UserMsgHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseUserMsg"; }
  static inline SfiRecFields get_fields ();
};

class ThreadInfo : public ::Sfi::GNewable {
public:
  Sfi::String name;
  ::Bse::ThreadState state;
  Sfi::Int thread_id;
  Sfi::Int priority;
  Sfi::Int processor;
  Sfi::Int utime;
  Sfi::Int stime;
  Sfi::Int cutime;
  Sfi::Int cstime;
  static inline ::Bse::ThreadInfoHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::ThreadInfoHandle & ptr);
  static inline ::Bse::ThreadInfoHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::ThreadInfoHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseThreadInfo"; }
  static inline SfiRecFields get_fields ();
};

class ThreadTotals : public ::Sfi::GNewable {
public:
  ::Bse::ThreadInfoHandle main;
  ::Bse::ThreadInfoHandle sequencer;
  ::Bse::ThreadInfoSeq synthesis;
  static inline ::Bse::ThreadTotalsHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::ThreadTotalsHandle & ptr);
  static inline ::Bse::ThreadTotalsHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::ThreadTotalsHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseThreadTotals"; }
  static inline SfiRecFields get_fields ();
};

class GConfig : public ::Sfi::GNewable {
public:
  Sfi::String sample_path;
  Sfi::String effect_path;
  Sfi::String instrument_path;
  Sfi::String script_path;
  Sfi::String plugin_path;
  Sfi::String ladspa_path;
  Sfi::Int synth_latency;
  Sfi::Int synth_mixing_freq;
  Sfi::Int synth_control_freq;
  bool invert_sustain;
  Sfi::Real step_volume_dB;
  Sfi::Int step_bpm;
  static inline ::Bse::GConfigHandle from_rec (SfiRec *rec);
  static inline SfiRec *to_rec (const ::Bse::GConfigHandle & ptr);
  static inline ::Bse::GConfigHandle value_get_boxed (const GValue *value);
  static inline void value_set_boxed (GValue *value, const ::Bse::GConfigHandle & self);
  static inline const char* options   () { return ""; }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "BseGConfig"; }
  static inline SfiRecFields get_fields ();
};



/* enum declarations */
BSE_CXX_DECLARE_ENUM (MidiSignalType, "BseMidiSignalType", 172,
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_PROGRAM, "BSE_MIDI_SIGNAL_PROGRAM", _("Program Change") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_PRESSURE, "BSE_MIDI_SIGNAL_PRESSURE", _("Channel Pressure") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_PITCH_BEND, "BSE_MIDI_SIGNAL_PITCH_BEND", _("Pitch Bend") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_VELOCITY, "BSE_MIDI_SIGNAL_VELOCITY", _("Note Velocity") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_FINE_TUNE, "BSE_MIDI_SIGNAL_FINE_TUNE", _("Note Fine Tune") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_0, "BSE_MIDI_SIGNAL_CONTINUOUS_0", _("Bank Select") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_1, "BSE_MIDI_SIGNAL_CONTINUOUS_1", _("Modulation Depth") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_2, "BSE_MIDI_SIGNAL_CONTINUOUS_2", _("Breath Control") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_3, "BSE_MIDI_SIGNAL_CONTINUOUS_3", _("Continuous 3") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_4, "BSE_MIDI_SIGNAL_CONTINUOUS_4", _("Foot Controller") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_5, "BSE_MIDI_SIGNAL_CONTINUOUS_5", _("Portamento Time") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_6, "BSE_MIDI_SIGNAL_CONTINUOUS_6", _("Data Entry") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_7, "BSE_MIDI_SIGNAL_CONTINUOUS_7", _("Volume") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_8, "BSE_MIDI_SIGNAL_CONTINUOUS_8", _("Balance") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_9, "BSE_MIDI_SIGNAL_CONTINUOUS_9", _("Continuous 9") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_10, "BSE_MIDI_SIGNAL_CONTINUOUS_10", _("Panorama") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_11, "BSE_MIDI_SIGNAL_CONTINUOUS_11", _("Expression") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_12, "BSE_MIDI_SIGNAL_CONTINUOUS_12", _("Effect Control 1") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_13, "BSE_MIDI_SIGNAL_CONTINUOUS_13", _("Effect Control 2") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_14, "BSE_MIDI_SIGNAL_CONTINUOUS_14", _("Continuous 14") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_15, "BSE_MIDI_SIGNAL_CONTINUOUS_15", _("Continuous 15") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_16, "BSE_MIDI_SIGNAL_CONTINUOUS_16", _("General Purpose Controller 1") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_17, "BSE_MIDI_SIGNAL_CONTINUOUS_17", _("General Purpose Controller 2") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_18, "BSE_MIDI_SIGNAL_CONTINUOUS_18", _("General Purpose Controller 3") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_19, "BSE_MIDI_SIGNAL_CONTINUOUS_19", _("General Purpose Controller 4") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_20, "BSE_MIDI_SIGNAL_CONTINUOUS_20", _("Continuous 20") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_21, "BSE_MIDI_SIGNAL_CONTINUOUS_21", _("Continuous 21") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_22, "BSE_MIDI_SIGNAL_CONTINUOUS_22", _("Continuous 22") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_23, "BSE_MIDI_SIGNAL_CONTINUOUS_23", _("Continuous 23") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_24, "BSE_MIDI_SIGNAL_CONTINUOUS_24", _("Continuous 24") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_25, "BSE_MIDI_SIGNAL_CONTINUOUS_25", _("Continuous 25") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_26, "BSE_MIDI_SIGNAL_CONTINUOUS_26", _("Continuous 26") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_27, "BSE_MIDI_SIGNAL_CONTINUOUS_27", _("Continuous 27") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_28, "BSE_MIDI_SIGNAL_CONTINUOUS_28", _("Continuous 28") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_29, "BSE_MIDI_SIGNAL_CONTINUOUS_29", _("Continuous 29") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_30, "BSE_MIDI_SIGNAL_CONTINUOUS_30", _("Continuous 30") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTINUOUS_31, "BSE_MIDI_SIGNAL_CONTINUOUS_31", _("Continuous 31") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONSTANT_HIGH, "BSE_MIDI_SIGNAL_CONSTANT_HIGH", _("Constant HIGH") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONSTANT_CENTER, "BSE_MIDI_SIGNAL_CONSTANT_CENTER", _("Constant CENTER") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONSTANT_LOW, "BSE_MIDI_SIGNAL_CONSTANT_LOW", _("Constant LOW") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONSTANT_NEGATIVE_CENTER, "BSE_MIDI_SIGNAL_CONSTANT_NEGATIVE_CENTER", _("Constant Negative CENTER") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONSTANT_NEGATIVE_HIGH, "BSE_MIDI_SIGNAL_CONSTANT_NEGATIVE_HIGH", _("Constant Negative HIGH") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_PARAMETER, "BSE_MIDI_SIGNAL_PARAMETER", _("Registered Parameter") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_NON_PARAMETER, "BSE_MIDI_SIGNAL_NON_PARAMETER", _("Non-Registered Parameter") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_0, "BSE_MIDI_SIGNAL_CONTROL_0", _("Control 0 Bank Select MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_1, "BSE_MIDI_SIGNAL_CONTROL_1", _("Control 1 Modulation Depth MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_2, "BSE_MIDI_SIGNAL_CONTROL_2", _("Control 2 Breath Control MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_3, "BSE_MIDI_SIGNAL_CONTROL_3", _("control-3") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_4, "BSE_MIDI_SIGNAL_CONTROL_4", _("Control 4 Foot Controller MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_5, "BSE_MIDI_SIGNAL_CONTROL_5", _("Control 5 Portamento Time MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_6, "BSE_MIDI_SIGNAL_CONTROL_6", _("Control 6 Data Entry MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_7, "BSE_MIDI_SIGNAL_CONTROL_7", _("Control 7 Volume MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_8, "BSE_MIDI_SIGNAL_CONTROL_8", _("Control 8 Balance MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_9, "BSE_MIDI_SIGNAL_CONTROL_9", _("control-9") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_10, "BSE_MIDI_SIGNAL_CONTROL_10", _("Control 10 Panorama MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_11, "BSE_MIDI_SIGNAL_CONTROL_11", _("Control 11 Expression MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_12, "BSE_MIDI_SIGNAL_CONTROL_12", _("Control 12 Effect Control 1 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_13, "BSE_MIDI_SIGNAL_CONTROL_13", _("Control 13 Effect Control 2 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_14, "BSE_MIDI_SIGNAL_CONTROL_14", _("control-14") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_15, "BSE_MIDI_SIGNAL_CONTROL_15", _("control-15") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_16, "BSE_MIDI_SIGNAL_CONTROL_16", _("Control 16 General Purpose Controller 1 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_17, "BSE_MIDI_SIGNAL_CONTROL_17", _("Control 17 General Purpose Controller 2 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_18, "BSE_MIDI_SIGNAL_CONTROL_18", _("Control 18 General Purpose Controller 3 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_19, "BSE_MIDI_SIGNAL_CONTROL_19", _("Control 19 General Purpose Controller 4 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_20, "BSE_MIDI_SIGNAL_CONTROL_20", _("control-20") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_21, "BSE_MIDI_SIGNAL_CONTROL_21", _("control-21") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_22, "BSE_MIDI_SIGNAL_CONTROL_22", _("control-22") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_23, "BSE_MIDI_SIGNAL_CONTROL_23", _("control-23") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_24, "BSE_MIDI_SIGNAL_CONTROL_24", _("control-24") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_25, "BSE_MIDI_SIGNAL_CONTROL_25", _("control-25") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_26, "BSE_MIDI_SIGNAL_CONTROL_26", _("control-26") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_27, "BSE_MIDI_SIGNAL_CONTROL_27", _("control-27") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_28, "BSE_MIDI_SIGNAL_CONTROL_28", _("control-28") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_29, "BSE_MIDI_SIGNAL_CONTROL_29", _("control-29") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_30, "BSE_MIDI_SIGNAL_CONTROL_30", _("control-30") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_31, "BSE_MIDI_SIGNAL_CONTROL_31", _("control-31") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_32, "BSE_MIDI_SIGNAL_CONTROL_32", _("Control 32 Bank Select LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_33, "BSE_MIDI_SIGNAL_CONTROL_33", _("Control 33 Modulation Depth LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_34, "BSE_MIDI_SIGNAL_CONTROL_34", _("Control 34 Breath Control LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_35, "BSE_MIDI_SIGNAL_CONTROL_35", _("control-35") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_36, "BSE_MIDI_SIGNAL_CONTROL_36", _("Control 36 Foot Controller LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_37, "BSE_MIDI_SIGNAL_CONTROL_37", _("Control 37 Portamento Time LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_38, "BSE_MIDI_SIGNAL_CONTROL_38", _("Control 38 Data Entry LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_39, "BSE_MIDI_SIGNAL_CONTROL_39", _("Control 39 Volume LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_40, "BSE_MIDI_SIGNAL_CONTROL_40", _("Control 40 Balance LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_41, "BSE_MIDI_SIGNAL_CONTROL_41", _("control-41") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_42, "BSE_MIDI_SIGNAL_CONTROL_42", _("Control 42 Panorama LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_43, "BSE_MIDI_SIGNAL_CONTROL_43", _("Control 43 Expression LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_44, "BSE_MIDI_SIGNAL_CONTROL_44", _("Control 44 Effect Control 1 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_45, "BSE_MIDI_SIGNAL_CONTROL_45", _("Control 45 Effect Control 2 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_46, "BSE_MIDI_SIGNAL_CONTROL_46", _("control-46") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_47, "BSE_MIDI_SIGNAL_CONTROL_47", _("control-47") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_48, "BSE_MIDI_SIGNAL_CONTROL_48", _("Control 48 General Purpose Controller 1 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_49, "BSE_MIDI_SIGNAL_CONTROL_49", _("Control 49 General Purpose Controller 2 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_50, "BSE_MIDI_SIGNAL_CONTROL_50", _("Control 50 General Purpose Controller 3 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_51, "BSE_MIDI_SIGNAL_CONTROL_51", _("Control 51 General Purpose Controller 4 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_52, "BSE_MIDI_SIGNAL_CONTROL_52", _("control-52") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_53, "BSE_MIDI_SIGNAL_CONTROL_53", _("control-53") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_54, "BSE_MIDI_SIGNAL_CONTROL_54", _("control-54") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_55, "BSE_MIDI_SIGNAL_CONTROL_55", _("control-55") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_56, "BSE_MIDI_SIGNAL_CONTROL_56", _("control-56") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_57, "BSE_MIDI_SIGNAL_CONTROL_57", _("control-57") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_58, "BSE_MIDI_SIGNAL_CONTROL_58", _("control-58") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_59, "BSE_MIDI_SIGNAL_CONTROL_59", _("control-59") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_60, "BSE_MIDI_SIGNAL_CONTROL_60", _("control-60") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_61, "BSE_MIDI_SIGNAL_CONTROL_61", _("control-61") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_62, "BSE_MIDI_SIGNAL_CONTROL_62", _("control-62") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_63, "BSE_MIDI_SIGNAL_CONTROL_63", _("control-63") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_64, "BSE_MIDI_SIGNAL_CONTROL_64", _("Control 64 Damper Pedal Switch (Sustain)") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_65, "BSE_MIDI_SIGNAL_CONTROL_65", _("Control 65 Portamento Switch") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_66, "BSE_MIDI_SIGNAL_CONTROL_66", _("Control 66 Sustenuto Switch") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_67, "BSE_MIDI_SIGNAL_CONTROL_67", _("Control 67 Soft Switch") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_68, "BSE_MIDI_SIGNAL_CONTROL_68", _("Control 68 Legato Pedal Switch") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_69, "BSE_MIDI_SIGNAL_CONTROL_69", _("Control 69 Hold Pedal Switch") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_70, "BSE_MIDI_SIGNAL_CONTROL_70", _("Control 70 Sound Variation") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_71, "BSE_MIDI_SIGNAL_CONTROL_71", _("Control 71 Filter Resonance (Timbre)") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_72, "BSE_MIDI_SIGNAL_CONTROL_72", _("Control 72 Sound Release Time") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_73, "BSE_MIDI_SIGNAL_CONTROL_73", _("Control 73 Sound Attack Time") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_74, "BSE_MIDI_SIGNAL_CONTROL_74", _("Control 74 Sound Brightness") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_75, "BSE_MIDI_SIGNAL_CONTROL_75", _("Control 75 Sound Decay Time") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_76, "BSE_MIDI_SIGNAL_CONTROL_76", _("Control 76 Vibrato Rate") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_77, "BSE_MIDI_SIGNAL_CONTROL_77", _("Control 77 Vibrato Depth") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_78, "BSE_MIDI_SIGNAL_CONTROL_78", _("Control 78 Vibrato Delay") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_79, "BSE_MIDI_SIGNAL_CONTROL_79", _("Control 79 Sound Control 10") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_80, "BSE_MIDI_SIGNAL_CONTROL_80", _("Control 80 General Purpose Switch 5") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_81, "BSE_MIDI_SIGNAL_CONTROL_81", _("Control 81 General Purpose Switch 6") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_82, "BSE_MIDI_SIGNAL_CONTROL_82", _("Control 82 General Purpose Switch 7") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_83, "BSE_MIDI_SIGNAL_CONTROL_83", _("Control 83 General Purpose Switch 8") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_84, "BSE_MIDI_SIGNAL_CONTROL_84", _("Control 84 Portamento Control (Note)") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_85, "BSE_MIDI_SIGNAL_CONTROL_85", _("control-85") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_86, "BSE_MIDI_SIGNAL_CONTROL_86", _("control-86") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_87, "BSE_MIDI_SIGNAL_CONTROL_87", _("control-87") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_88, "BSE_MIDI_SIGNAL_CONTROL_88", _("control-88") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_89, "BSE_MIDI_SIGNAL_CONTROL_89", _("control-89") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_90, "BSE_MIDI_SIGNAL_CONTROL_90", _("control-90") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_91, "BSE_MIDI_SIGNAL_CONTROL_91", _("Control 91 Reverb Depth") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_92, "BSE_MIDI_SIGNAL_CONTROL_92", _("Control 92 Tremolo Depth") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_93, "BSE_MIDI_SIGNAL_CONTROL_93", _("Control 93 Chorus Depth") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_94, "BSE_MIDI_SIGNAL_CONTROL_94", _("Control 93 Detune Depth") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_95, "BSE_MIDI_SIGNAL_CONTROL_95", _("Control 95 Phase Depth") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_96, "BSE_MIDI_SIGNAL_CONTROL_96", _("Control 96 Data Increment Trigger") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_97, "BSE_MIDI_SIGNAL_CONTROL_97", _("Control 97 Data Decrement Trigger") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_98, "BSE_MIDI_SIGNAL_CONTROL_98", _("Control 98 Non-Registered Parameter MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_99, "BSE_MIDI_SIGNAL_CONTROL_99", _("Control 99 Non-Registered Parameter LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_100, "BSE_MIDI_SIGNAL_CONTROL_100", _("Control 100 Registered Parameter MSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_101, "BSE_MIDI_SIGNAL_CONTROL_101", _("Control 101 Registered Parameter LSB") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_102, "BSE_MIDI_SIGNAL_CONTROL_102", _("control-102") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_103, "BSE_MIDI_SIGNAL_CONTROL_103", _("control-103") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_104, "BSE_MIDI_SIGNAL_CONTROL_104", _("control-104") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_105, "BSE_MIDI_SIGNAL_CONTROL_105", _("control-105") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_106, "BSE_MIDI_SIGNAL_CONTROL_106", _("control-106") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_107, "BSE_MIDI_SIGNAL_CONTROL_107", _("control-107") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_108, "BSE_MIDI_SIGNAL_CONTROL_108", _("control-108") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_109, "BSE_MIDI_SIGNAL_CONTROL_109", _("control-109") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_110, "BSE_MIDI_SIGNAL_CONTROL_110", _("control-110") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_111, "BSE_MIDI_SIGNAL_CONTROL_111", _("control-111") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_112, "BSE_MIDI_SIGNAL_CONTROL_112", _("control-112") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_113, "BSE_MIDI_SIGNAL_CONTROL_113", _("control-113") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_114, "BSE_MIDI_SIGNAL_CONTROL_114", _("control-114") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_115, "BSE_MIDI_SIGNAL_CONTROL_115", _("control-115") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_116, "BSE_MIDI_SIGNAL_CONTROL_116", _("control-116") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_117, "BSE_MIDI_SIGNAL_CONTROL_117", _("control-117") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_118, "BSE_MIDI_SIGNAL_CONTROL_118", _("control-118") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_119, "BSE_MIDI_SIGNAL_CONTROL_119", _("control-119") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_120, "BSE_MIDI_SIGNAL_CONTROL_120", _("Control 120 All Sound Off ITrigger") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_121, "BSE_MIDI_SIGNAL_CONTROL_121", _("Control 121 All Controllers Off ITrigger") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_122, "BSE_MIDI_SIGNAL_CONTROL_122", _("Control 122 Local Control Switch") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_123, "BSE_MIDI_SIGNAL_CONTROL_123", _("Control 123 All Notes Off ITrigger") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_124, "BSE_MIDI_SIGNAL_CONTROL_124", _("Control 124 Omni Mode Off ITrigger") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_125, "BSE_MIDI_SIGNAL_CONTROL_125", _("Control 125 Omni Mode On ITrigger") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_126, "BSE_MIDI_SIGNAL_CONTROL_126", _("Control 126 Monophonic Voices Mode") );
  *v++ = ::Bse::EnumValue (MIDI_SIGNAL_CONTROL_127, "BSE_MIDI_SIGNAL_CONTROL_127", _("Control 127 Polyphonic Mode On ITrigger") );
);
BSE_CXX_DECLARE_ENUM (MidiControlType, "BseMidiControlType", 161,
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_NONE, "BSE_MIDI_CONTROL_NONE", _("None") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_0, "BSE_MIDI_CONTROL_CONTINUOUS_0", _("Bank Select") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_1, "BSE_MIDI_CONTROL_CONTINUOUS_1", _("Modulation Depth") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_2, "BSE_MIDI_CONTROL_CONTINUOUS_2", _("Breath Control") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_3, "BSE_MIDI_CONTROL_CONTINUOUS_3", _("Continuous 3") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_4, "BSE_MIDI_CONTROL_CONTINUOUS_4", _("Foot Controller") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_5, "BSE_MIDI_CONTROL_CONTINUOUS_5", _("Portamento Time") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_6, "BSE_MIDI_CONTROL_CONTINUOUS_6", _("Data Entry") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_7, "BSE_MIDI_CONTROL_CONTINUOUS_7", _("Volume") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_8, "BSE_MIDI_CONTROL_CONTINUOUS_8", _("Balance") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_9, "BSE_MIDI_CONTROL_CONTINUOUS_9", _("Continuous 9") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_10, "BSE_MIDI_CONTROL_CONTINUOUS_10", _("Panorama") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_11, "BSE_MIDI_CONTROL_CONTINUOUS_11", _("Expression") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_12, "BSE_MIDI_CONTROL_CONTINUOUS_12", _("Effect Control 1") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_13, "BSE_MIDI_CONTROL_CONTINUOUS_13", _("Effect Control 2") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_14, "BSE_MIDI_CONTROL_CONTINUOUS_14", _("Continuous 14") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_15, "BSE_MIDI_CONTROL_CONTINUOUS_15", _("Continuous 15") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_16, "BSE_MIDI_CONTROL_CONTINUOUS_16", _("General Purpose Controller 1") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_17, "BSE_MIDI_CONTROL_CONTINUOUS_17", _("General Purpose Controller 2") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_18, "BSE_MIDI_CONTROL_CONTINUOUS_18", _("General Purpose Controller 3") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_19, "BSE_MIDI_CONTROL_CONTINUOUS_19", _("General Purpose Controller 4") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_20, "BSE_MIDI_CONTROL_CONTINUOUS_20", _("Continuous 20") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_21, "BSE_MIDI_CONTROL_CONTINUOUS_21", _("Continuous 21") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_22, "BSE_MIDI_CONTROL_CONTINUOUS_22", _("Continuous 22") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_23, "BSE_MIDI_CONTROL_CONTINUOUS_23", _("Continuous 23") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_24, "BSE_MIDI_CONTROL_CONTINUOUS_24", _("Continuous 24") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_25, "BSE_MIDI_CONTROL_CONTINUOUS_25", _("Continuous 25") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_26, "BSE_MIDI_CONTROL_CONTINUOUS_26", _("Continuous 26") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_27, "BSE_MIDI_CONTROL_CONTINUOUS_27", _("Continuous 27") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_28, "BSE_MIDI_CONTROL_CONTINUOUS_28", _("Continuous 28") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_29, "BSE_MIDI_CONTROL_CONTINUOUS_29", _("Continuous 29") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_30, "BSE_MIDI_CONTROL_CONTINUOUS_30", _("Continuous 30") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_CONTINUOUS_31, "BSE_MIDI_CONTROL_CONTINUOUS_31", _("Continuous 31") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_0, "BSE_MIDI_CONTROL_0", _("Control 0 Bank Select MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_1, "BSE_MIDI_CONTROL_1", _("Control 1 Modulation Depth MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_2, "BSE_MIDI_CONTROL_2", _("Control 2 Breath Control MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_3, "BSE_MIDI_CONTROL_3", _("control-3") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_4, "BSE_MIDI_CONTROL_4", _("Control 4 Foot Controller MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_5, "BSE_MIDI_CONTROL_5", _("Control 5 Portamento Time MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_6, "BSE_MIDI_CONTROL_6", _("Control 6 Data Entry MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_7, "BSE_MIDI_CONTROL_7", _("Control 7 Volume MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_8, "BSE_MIDI_CONTROL_8", _("Control 8 Balance MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_9, "BSE_MIDI_CONTROL_9", _("control-9") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_10, "BSE_MIDI_CONTROL_10", _("Control 10 Panorama MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_11, "BSE_MIDI_CONTROL_11", _("Control 11 Expression MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_12, "BSE_MIDI_CONTROL_12", _("Control 12 Effect Control 1 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_13, "BSE_MIDI_CONTROL_13", _("Control 13 Effect Control 2 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_14, "BSE_MIDI_CONTROL_14", _("control-14") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_15, "BSE_MIDI_CONTROL_15", _("control-15") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_16, "BSE_MIDI_CONTROL_16", _("Control 16 General Purpose Controller 1 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_17, "BSE_MIDI_CONTROL_17", _("Control 17 General Purpose Controller 2 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_18, "BSE_MIDI_CONTROL_18", _("Control 18 General Purpose Controller 3 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_19, "BSE_MIDI_CONTROL_19", _("Control 19 General Purpose Controller 4 MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_20, "BSE_MIDI_CONTROL_20", _("control-20") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_21, "BSE_MIDI_CONTROL_21", _("control-21") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_22, "BSE_MIDI_CONTROL_22", _("control-22") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_23, "BSE_MIDI_CONTROL_23", _("control-23") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_24, "BSE_MIDI_CONTROL_24", _("control-24") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_25, "BSE_MIDI_CONTROL_25", _("control-25") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_26, "BSE_MIDI_CONTROL_26", _("control-26") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_27, "BSE_MIDI_CONTROL_27", _("control-27") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_28, "BSE_MIDI_CONTROL_28", _("control-28") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_29, "BSE_MIDI_CONTROL_29", _("control-29") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_30, "BSE_MIDI_CONTROL_30", _("control-30") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_31, "BSE_MIDI_CONTROL_31", _("control-31") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_32, "BSE_MIDI_CONTROL_32", _("Control 32 Bank Select LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_33, "BSE_MIDI_CONTROL_33", _("Control 33 Modulation Depth LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_34, "BSE_MIDI_CONTROL_34", _("Control 34 Breath Control LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_35, "BSE_MIDI_CONTROL_35", _("control-35") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_36, "BSE_MIDI_CONTROL_36", _("Control 36 Foot Controller LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_37, "BSE_MIDI_CONTROL_37", _("Control 37 Portamento Time LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_38, "BSE_MIDI_CONTROL_38", _("Control 38 Data Entry LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_39, "BSE_MIDI_CONTROL_39", _("Control 39 Volume LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_40, "BSE_MIDI_CONTROL_40", _("Control 40 Balance LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_41, "BSE_MIDI_CONTROL_41", _("control-41") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_42, "BSE_MIDI_CONTROL_42", _("Control 42 Panorama LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_43, "BSE_MIDI_CONTROL_43", _("Control 43 Expression LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_44, "BSE_MIDI_CONTROL_44", _("Control 44 Effect Control 1 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_45, "BSE_MIDI_CONTROL_45", _("Control 45 Effect Control 2 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_46, "BSE_MIDI_CONTROL_46", _("control-46") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_47, "BSE_MIDI_CONTROL_47", _("control-47") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_48, "BSE_MIDI_CONTROL_48", _("Control 48 General Purpose Controller 1 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_49, "BSE_MIDI_CONTROL_49", _("Control 49 General Purpose Controller 2 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_50, "BSE_MIDI_CONTROL_50", _("Control 50 General Purpose Controller 3 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_51, "BSE_MIDI_CONTROL_51", _("Control 51 General Purpose Controller 4 LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_52, "BSE_MIDI_CONTROL_52", _("control-52") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_53, "BSE_MIDI_CONTROL_53", _("control-53") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_54, "BSE_MIDI_CONTROL_54", _("control-54") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_55, "BSE_MIDI_CONTROL_55", _("control-55") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_56, "BSE_MIDI_CONTROL_56", _("control-56") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_57, "BSE_MIDI_CONTROL_57", _("control-57") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_58, "BSE_MIDI_CONTROL_58", _("control-58") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_59, "BSE_MIDI_CONTROL_59", _("control-59") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_60, "BSE_MIDI_CONTROL_60", _("control-60") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_61, "BSE_MIDI_CONTROL_61", _("control-61") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_62, "BSE_MIDI_CONTROL_62", _("control-62") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_63, "BSE_MIDI_CONTROL_63", _("control-63") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_64, "BSE_MIDI_CONTROL_64", _("Control 64 Damper Pedal Switch (Sustain)") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_65, "BSE_MIDI_CONTROL_65", _("Control 65 Portamento Switch") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_66, "BSE_MIDI_CONTROL_66", _("Control 66 Sustenuto Switch") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_67, "BSE_MIDI_CONTROL_67", _("Control 67 Soft Switch") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_68, "BSE_MIDI_CONTROL_68", _("Control 68 Legato Pedal Switch") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_69, "BSE_MIDI_CONTROL_69", _("Control 69 Hold Pedal Switch") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_70, "BSE_MIDI_CONTROL_70", _("Control 70 Sound Variation") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_71, "BSE_MIDI_CONTROL_71", _("Control 71 Filter Resonance (Timbre)") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_72, "BSE_MIDI_CONTROL_72", _("Control 72 Sound Release Time") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_73, "BSE_MIDI_CONTROL_73", _("Control 73 Sound Attack Time") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_74, "BSE_MIDI_CONTROL_74", _("Control 74 Sound Brightness") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_75, "BSE_MIDI_CONTROL_75", _("Control 75 Sound Decay Time") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_76, "BSE_MIDI_CONTROL_76", _("Control 76 Vibrato Rate") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_77, "BSE_MIDI_CONTROL_77", _("Control 77 Vibrato Depth") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_78, "BSE_MIDI_CONTROL_78", _("Control 78 Vibrato Delay") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_79, "BSE_MIDI_CONTROL_79", _("Control 79 Sound Control 10") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_80, "BSE_MIDI_CONTROL_80", _("Control 80 General Purpose Switch 5") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_81, "BSE_MIDI_CONTROL_81", _("Control 81 General Purpose Switch 6") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_82, "BSE_MIDI_CONTROL_82", _("Control 82 General Purpose Switch 7") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_83, "BSE_MIDI_CONTROL_83", _("Control 83 General Purpose Switch 8") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_84, "BSE_MIDI_CONTROL_84", _("Control 84 Portamento Control (Note)") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_85, "BSE_MIDI_CONTROL_85", _("control-85") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_86, "BSE_MIDI_CONTROL_86", _("control-86") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_87, "BSE_MIDI_CONTROL_87", _("control-87") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_88, "BSE_MIDI_CONTROL_88", _("control-88") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_89, "BSE_MIDI_CONTROL_89", _("control-89") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_90, "BSE_MIDI_CONTROL_90", _("control-90") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_91, "BSE_MIDI_CONTROL_91", _("Control 91 Reverb Depth") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_92, "BSE_MIDI_CONTROL_92", _("Control 92 Tremolo Depth") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_93, "BSE_MIDI_CONTROL_93", _("Control 93 Chorus Depth") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_94, "BSE_MIDI_CONTROL_94", _("Control 93 Detune Depth") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_95, "BSE_MIDI_CONTROL_95", _("Control 95 Phase Depth") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_96, "BSE_MIDI_CONTROL_96", _("Control 96 Data Increment Trigger") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_97, "BSE_MIDI_CONTROL_97", _("Control 97 Data Decrement Trigger") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_98, "BSE_MIDI_CONTROL_98", _("Control 98 Non-Registered Parameter MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_99, "BSE_MIDI_CONTROL_99", _("Control 99 Non-Registered Parameter LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_100, "BSE_MIDI_CONTROL_100", _("Control 100 Registered Parameter MSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_101, "BSE_MIDI_CONTROL_101", _("Control 101 Registered Parameter LSB") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_102, "BSE_MIDI_CONTROL_102", _("control-102") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_103, "BSE_MIDI_CONTROL_103", _("control-103") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_104, "BSE_MIDI_CONTROL_104", _("control-104") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_105, "BSE_MIDI_CONTROL_105", _("control-105") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_106, "BSE_MIDI_CONTROL_106", _("control-106") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_107, "BSE_MIDI_CONTROL_107", _("control-107") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_108, "BSE_MIDI_CONTROL_108", _("control-108") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_109, "BSE_MIDI_CONTROL_109", _("control-109") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_110, "BSE_MIDI_CONTROL_110", _("control-110") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_111, "BSE_MIDI_CONTROL_111", _("control-111") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_112, "BSE_MIDI_CONTROL_112", _("control-112") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_113, "BSE_MIDI_CONTROL_113", _("control-113") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_114, "BSE_MIDI_CONTROL_114", _("control-114") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_115, "BSE_MIDI_CONTROL_115", _("control-115") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_116, "BSE_MIDI_CONTROL_116", _("control-116") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_117, "BSE_MIDI_CONTROL_117", _("control-117") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_118, "BSE_MIDI_CONTROL_118", _("control-118") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_119, "BSE_MIDI_CONTROL_119", _("control-119") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_120, "BSE_MIDI_CONTROL_120", _("Control 120 All Sound Off ITrigger") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_121, "BSE_MIDI_CONTROL_121", _("Control 121 All Controllers Off ITrigger") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_122, "BSE_MIDI_CONTROL_122", _("Control 122 Local Control Switch") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_123, "BSE_MIDI_CONTROL_123", _("Control 123 All Notes Off ITrigger") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_124, "BSE_MIDI_CONTROL_124", _("Control 124 Omni Mode Off ITrigger") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_125, "BSE_MIDI_CONTROL_125", _("Control 125 Omni Mode On ITrigger") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_126, "BSE_MIDI_CONTROL_126", _("Control 126 Monophonic Voices Mode") );
  *v++ = ::Bse::EnumValue (MIDI_CONTROL_127, "BSE_MIDI_CONTROL_127", _("Control 127 Polyphonic Mode On ITrigger") );
);
BSE_CXX_DECLARE_ENUM (UserMsgType, "BseUserMsgType", 4,
  *v++ = ::Bse::EnumValue (USER_MSG_MISC, "BSE_USER_MSG_MISC", "bse-user-msg-misc" );
  *v++ = ::Bse::EnumValue (USER_MSG_INFO, "BSE_USER_MSG_INFO", "bse-user-msg-info" );
  *v++ = ::Bse::EnumValue (USER_MSG_WARNING, "BSE_USER_MSG_WARNING", "bse-user-msg-warning" );
  *v++ = ::Bse::EnumValue (USER_MSG_ERROR, "BSE_USER_MSG_ERROR", "bse-user-msg-error" );
);
BSE_CXX_DECLARE_ENUM (ThreadState, "BseThreadState", 8,
  *v++ = ::Bse::EnumValue (THREAD_STATE_UNKNOWN, "BSE_THREAD_STATE_UNKNOWN", "bse-thread-state-unknown" );
  *v++ = ::Bse::EnumValue (THREAD_STATE_RUNNING, "BSE_THREAD_STATE_RUNNING", "bse-thread-state-running" );
  *v++ = ::Bse::EnumValue (THREAD_STATE_SLEEPING, "BSE_THREAD_STATE_SLEEPING", "bse-thread-state-sleeping" );
  *v++ = ::Bse::EnumValue (THREAD_STATE_DISKWAIT, "BSE_THREAD_STATE_DISKWAIT", "bse-thread-state-diskwait" );
  *v++ = ::Bse::EnumValue (THREAD_STATE_TRACED, "BSE_THREAD_STATE_TRACED", "bse-thread-state-traced" );
  *v++ = ::Bse::EnumValue (THREAD_STATE_PAGING, "BSE_THREAD_STATE_PAGING", "bse-thread-state-paging" );
  *v++ = ::Bse::EnumValue (THREAD_STATE_ZOMBIE, "BSE_THREAD_STATE_ZOMBIE", "bse-thread-state-zombie" );
  *v++ = ::Bse::EnumValue (THREAD_STATE_DEAD, "BSE_THREAD_STATE_DEAD", "bse-thread-state-dead" );
);


/* sequence type declarations */
BSE_CXX_DECLARE_SEQUENCE (IntSeq);

BSE_CXX_DECLARE_SEQUENCE (NoteSeq);

BSE_CXX_DECLARE_SEQUENCE (StringSeq);

BSE_CXX_DECLARE_SEQUENCE (TypeSeq);

BSE_CXX_DECLARE_SEQUENCE (ItemSeq);

BSE_CXX_DECLARE_SEQUENCE (PartNoteSeq);

BSE_CXX_DECLARE_SEQUENCE (PartControlSeq);

BSE_CXX_DECLARE_SEQUENCE (CategorySeq);

BSE_CXX_DECLARE_SEQUENCE (DotSeq);

BSE_CXX_DECLARE_SEQUENCE (TrackPartSeq);

BSE_CXX_DECLARE_SEQUENCE (ThreadInfoSeq);



/* record type declarations */
BSE_CXX_DECLARE_RECORD (PropertyCandidates);

BSE_CXX_DECLARE_RECORD (PartNote);

BSE_CXX_DECLARE_RECORD (PartControl);

BSE_CXX_DECLARE_RECORD (NoteDescription);

BSE_CXX_DECLARE_RECORD (NoteSequence);

BSE_CXX_DECLARE_RECORD (Icon);

BSE_CXX_DECLARE_RECORD (Category);

BSE_CXX_DECLARE_RECORD (Dot);

BSE_CXX_DECLARE_RECORD (TrackPart);

BSE_CXX_DECLARE_RECORD (SongTiming);

BSE_CXX_DECLARE_RECORD (SampleFileInfo);

BSE_CXX_DECLARE_RECORD (UserMsg);

BSE_CXX_DECLARE_RECORD (ThreadInfo);

BSE_CXX_DECLARE_RECORD (ThreadTotals);

BSE_CXX_DECLARE_RECORD (GConfig);



/* procedure prototypes */
namespace Procedure {
class collect_thread_totals;
#define BSE_TYPE_COLLECT_THREAD_TOTALS		BSE_CXX_DECLARED_PROC_TYPE (Bse, collect_thread_totals)
} // Procedure



/* class definitions */


/* choice implementations */
static inline SfiChoiceValues
MidiSignalType_choice_values()
{
  static SfiChoiceValue values[172];
  static const SfiChoiceValues choice_values = {
    G_N_ELEMENTS (values), values,
  };
  if (!values[0].choice_ident)
    {
      values[0].choice_ident = "BSE_MIDI_SIGNAL_PROGRAM";
      values[0].choice_label = _("Program Change");
      values[0].choice_blurb = "";
      values[1].choice_ident = "BSE_MIDI_SIGNAL_PRESSURE";
      values[1].choice_label = _("Channel Pressure");
      values[1].choice_blurb = "";
      values[2].choice_ident = "BSE_MIDI_SIGNAL_PITCH_BEND";
      values[2].choice_label = _("Pitch Bend");
      values[2].choice_blurb = "";
      values[3].choice_ident = "BSE_MIDI_SIGNAL_VELOCITY";
      values[3].choice_label = _("Note Velocity");
      values[3].choice_blurb = "";
      values[4].choice_ident = "BSE_MIDI_SIGNAL_FINE_TUNE";
      values[4].choice_label = _("Note Fine Tune");
      values[4].choice_blurb = "";
      values[5].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_0";
      values[5].choice_label = _("Bank Select");
      values[5].choice_blurb = "";
      values[6].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_1";
      values[6].choice_label = _("Modulation Depth");
      values[6].choice_blurb = "";
      values[7].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_2";
      values[7].choice_label = _("Breath Control");
      values[7].choice_blurb = "";
      values[8].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_3";
      values[8].choice_label = _("Continuous 3");
      values[8].choice_blurb = "";
      values[9].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_4";
      values[9].choice_label = _("Foot Controller");
      values[9].choice_blurb = "";
      values[10].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_5";
      values[10].choice_label = _("Portamento Time");
      values[10].choice_blurb = "";
      values[11].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_6";
      values[11].choice_label = _("Data Entry");
      values[11].choice_blurb = "";
      values[12].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_7";
      values[12].choice_label = _("Volume");
      values[12].choice_blurb = "";
      values[13].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_8";
      values[13].choice_label = _("Balance");
      values[13].choice_blurb = "";
      values[14].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_9";
      values[14].choice_label = _("Continuous 9");
      values[14].choice_blurb = "";
      values[15].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_10";
      values[15].choice_label = _("Panorama");
      values[15].choice_blurb = "";
      values[16].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_11";
      values[16].choice_label = _("Expression");
      values[16].choice_blurb = "";
      values[17].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_12";
      values[17].choice_label = _("Effect Control 1");
      values[17].choice_blurb = "";
      values[18].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_13";
      values[18].choice_label = _("Effect Control 2");
      values[18].choice_blurb = "";
      values[19].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_14";
      values[19].choice_label = _("Continuous 14");
      values[19].choice_blurb = "";
      values[20].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_15";
      values[20].choice_label = _("Continuous 15");
      values[20].choice_blurb = "";
      values[21].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_16";
      values[21].choice_label = _("General Purpose Controller 1");
      values[21].choice_blurb = "";
      values[22].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_17";
      values[22].choice_label = _("General Purpose Controller 2");
      values[22].choice_blurb = "";
      values[23].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_18";
      values[23].choice_label = _("General Purpose Controller 3");
      values[23].choice_blurb = "";
      values[24].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_19";
      values[24].choice_label = _("General Purpose Controller 4");
      values[24].choice_blurb = "";
      values[25].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_20";
      values[25].choice_label = _("Continuous 20");
      values[25].choice_blurb = "";
      values[26].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_21";
      values[26].choice_label = _("Continuous 21");
      values[26].choice_blurb = "";
      values[27].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_22";
      values[27].choice_label = _("Continuous 22");
      values[27].choice_blurb = "";
      values[28].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_23";
      values[28].choice_label = _("Continuous 23");
      values[28].choice_blurb = "";
      values[29].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_24";
      values[29].choice_label = _("Continuous 24");
      values[29].choice_blurb = "";
      values[30].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_25";
      values[30].choice_label = _("Continuous 25");
      values[30].choice_blurb = "";
      values[31].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_26";
      values[31].choice_label = _("Continuous 26");
      values[31].choice_blurb = "";
      values[32].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_27";
      values[32].choice_label = _("Continuous 27");
      values[32].choice_blurb = "";
      values[33].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_28";
      values[33].choice_label = _("Continuous 28");
      values[33].choice_blurb = "";
      values[34].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_29";
      values[34].choice_label = _("Continuous 29");
      values[34].choice_blurb = "";
      values[35].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_30";
      values[35].choice_label = _("Continuous 30");
      values[35].choice_blurb = "";
      values[36].choice_ident = "BSE_MIDI_SIGNAL_CONTINUOUS_31";
      values[36].choice_label = _("Continuous 31");
      values[36].choice_blurb = "";
      values[37].choice_ident = "BSE_MIDI_SIGNAL_CONSTANT_HIGH";
      values[37].choice_label = _("Constant HIGH");
      values[37].choice_blurb = "";
      values[38].choice_ident = "BSE_MIDI_SIGNAL_CONSTANT_CENTER";
      values[38].choice_label = _("Constant CENTER");
      values[38].choice_blurb = "";
      values[39].choice_ident = "BSE_MIDI_SIGNAL_CONSTANT_LOW";
      values[39].choice_label = _("Constant LOW");
      values[39].choice_blurb = "";
      values[40].choice_ident = "BSE_MIDI_SIGNAL_CONSTANT_NEGATIVE_CENTER";
      values[40].choice_label = _("Constant Negative CENTER");
      values[40].choice_blurb = "";
      values[41].choice_ident = "BSE_MIDI_SIGNAL_CONSTANT_NEGATIVE_HIGH";
      values[41].choice_label = _("Constant Negative HIGH");
      values[41].choice_blurb = "";
      values[42].choice_ident = "BSE_MIDI_SIGNAL_PARAMETER";
      values[42].choice_label = _("Registered Parameter");
      values[42].choice_blurb = "";
      values[43].choice_ident = "BSE_MIDI_SIGNAL_NON_PARAMETER";
      values[43].choice_label = _("Non-Registered Parameter");
      values[43].choice_blurb = "";
      values[44].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_0";
      values[44].choice_label = _("Control 0 Bank Select MSB");
      values[44].choice_blurb = "";
      values[45].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_1";
      values[45].choice_label = _("Control 1 Modulation Depth MSB");
      values[45].choice_blurb = "";
      values[46].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_2";
      values[46].choice_label = _("Control 2 Breath Control MSB");
      values[46].choice_blurb = "";
      values[47].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_3";
      values[47].choice_label = _("control-3");
      values[47].choice_blurb = "";
      values[48].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_4";
      values[48].choice_label = _("Control 4 Foot Controller MSB");
      values[48].choice_blurb = "";
      values[49].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_5";
      values[49].choice_label = _("Control 5 Portamento Time MSB");
      values[49].choice_blurb = "";
      values[50].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_6";
      values[50].choice_label = _("Control 6 Data Entry MSB");
      values[50].choice_blurb = "";
      values[51].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_7";
      values[51].choice_label = _("Control 7 Volume MSB");
      values[51].choice_blurb = "";
      values[52].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_8";
      values[52].choice_label = _("Control 8 Balance MSB");
      values[52].choice_blurb = "";
      values[53].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_9";
      values[53].choice_label = _("control-9");
      values[53].choice_blurb = "";
      values[54].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_10";
      values[54].choice_label = _("Control 10 Panorama MSB");
      values[54].choice_blurb = "";
      values[55].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_11";
      values[55].choice_label = _("Control 11 Expression MSB");
      values[55].choice_blurb = "";
      values[56].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_12";
      values[56].choice_label = _("Control 12 Effect Control 1 MSB");
      values[56].choice_blurb = "";
      values[57].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_13";
      values[57].choice_label = _("Control 13 Effect Control 2 MSB");
      values[57].choice_blurb = "";
      values[58].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_14";
      values[58].choice_label = _("control-14");
      values[58].choice_blurb = "";
      values[59].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_15";
      values[59].choice_label = _("control-15");
      values[59].choice_blurb = "";
      values[60].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_16";
      values[60].choice_label = _("Control 16 General Purpose Controller 1 MSB");
      values[60].choice_blurb = "";
      values[61].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_17";
      values[61].choice_label = _("Control 17 General Purpose Controller 2 MSB");
      values[61].choice_blurb = "";
      values[62].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_18";
      values[62].choice_label = _("Control 18 General Purpose Controller 3 MSB");
      values[62].choice_blurb = "";
      values[63].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_19";
      values[63].choice_label = _("Control 19 General Purpose Controller 4 MSB");
      values[63].choice_blurb = "";
      values[64].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_20";
      values[64].choice_label = _("control-20");
      values[64].choice_blurb = "";
      values[65].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_21";
      values[65].choice_label = _("control-21");
      values[65].choice_blurb = "";
      values[66].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_22";
      values[66].choice_label = _("control-22");
      values[66].choice_blurb = "";
      values[67].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_23";
      values[67].choice_label = _("control-23");
      values[67].choice_blurb = "";
      values[68].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_24";
      values[68].choice_label = _("control-24");
      values[68].choice_blurb = "";
      values[69].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_25";
      values[69].choice_label = _("control-25");
      values[69].choice_blurb = "";
      values[70].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_26";
      values[70].choice_label = _("control-26");
      values[70].choice_blurb = "";
      values[71].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_27";
      values[71].choice_label = _("control-27");
      values[71].choice_blurb = "";
      values[72].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_28";
      values[72].choice_label = _("control-28");
      values[72].choice_blurb = "";
      values[73].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_29";
      values[73].choice_label = _("control-29");
      values[73].choice_blurb = "";
      values[74].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_30";
      values[74].choice_label = _("control-30");
      values[74].choice_blurb = "";
      values[75].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_31";
      values[75].choice_label = _("control-31");
      values[75].choice_blurb = "";
      values[76].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_32";
      values[76].choice_label = _("Control 32 Bank Select LSB");
      values[76].choice_blurb = "";
      values[77].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_33";
      values[77].choice_label = _("Control 33 Modulation Depth LSB");
      values[77].choice_blurb = "";
      values[78].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_34";
      values[78].choice_label = _("Control 34 Breath Control LSB");
      values[78].choice_blurb = "";
      values[79].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_35";
      values[79].choice_label = _("control-35");
      values[79].choice_blurb = "";
      values[80].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_36";
      values[80].choice_label = _("Control 36 Foot Controller LSB");
      values[80].choice_blurb = "";
      values[81].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_37";
      values[81].choice_label = _("Control 37 Portamento Time LSB");
      values[81].choice_blurb = "";
      values[82].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_38";
      values[82].choice_label = _("Control 38 Data Entry LSB");
      values[82].choice_blurb = "";
      values[83].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_39";
      values[83].choice_label = _("Control 39 Volume LSB");
      values[83].choice_blurb = "";
      values[84].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_40";
      values[84].choice_label = _("Control 40 Balance LSB");
      values[84].choice_blurb = "";
      values[85].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_41";
      values[85].choice_label = _("control-41");
      values[85].choice_blurb = "";
      values[86].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_42";
      values[86].choice_label = _("Control 42 Panorama LSB");
      values[86].choice_blurb = "";
      values[87].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_43";
      values[87].choice_label = _("Control 43 Expression LSB");
      values[87].choice_blurb = "";
      values[88].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_44";
      values[88].choice_label = _("Control 44 Effect Control 1 LSB");
      values[88].choice_blurb = "";
      values[89].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_45";
      values[89].choice_label = _("Control 45 Effect Control 2 LSB");
      values[89].choice_blurb = "";
      values[90].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_46";
      values[90].choice_label = _("control-46");
      values[90].choice_blurb = "";
      values[91].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_47";
      values[91].choice_label = _("control-47");
      values[91].choice_blurb = "";
      values[92].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_48";
      values[92].choice_label = _("Control 48 General Purpose Controller 1 LSB");
      values[92].choice_blurb = "";
      values[93].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_49";
      values[93].choice_label = _("Control 49 General Purpose Controller 2 LSB");
      values[93].choice_blurb = "";
      values[94].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_50";
      values[94].choice_label = _("Control 50 General Purpose Controller 3 LSB");
      values[94].choice_blurb = "";
      values[95].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_51";
      values[95].choice_label = _("Control 51 General Purpose Controller 4 LSB");
      values[95].choice_blurb = "";
      values[96].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_52";
      values[96].choice_label = _("control-52");
      values[96].choice_blurb = "";
      values[97].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_53";
      values[97].choice_label = _("control-53");
      values[97].choice_blurb = "";
      values[98].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_54";
      values[98].choice_label = _("control-54");
      values[98].choice_blurb = "";
      values[99].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_55";
      values[99].choice_label = _("control-55");
      values[99].choice_blurb = "";
      values[100].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_56";
      values[100].choice_label = _("control-56");
      values[100].choice_blurb = "";
      values[101].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_57";
      values[101].choice_label = _("control-57");
      values[101].choice_blurb = "";
      values[102].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_58";
      values[102].choice_label = _("control-58");
      values[102].choice_blurb = "";
      values[103].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_59";
      values[103].choice_label = _("control-59");
      values[103].choice_blurb = "";
      values[104].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_60";
      values[104].choice_label = _("control-60");
      values[104].choice_blurb = "";
      values[105].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_61";
      values[105].choice_label = _("control-61");
      values[105].choice_blurb = "";
      values[106].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_62";
      values[106].choice_label = _("control-62");
      values[106].choice_blurb = "";
      values[107].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_63";
      values[107].choice_label = _("control-63");
      values[107].choice_blurb = "";
      values[108].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_64";
      values[108].choice_label = _("Control 64 Damper Pedal Switch (Sustain)");
      values[108].choice_blurb = "";
      values[109].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_65";
      values[109].choice_label = _("Control 65 Portamento Switch");
      values[109].choice_blurb = "";
      values[110].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_66";
      values[110].choice_label = _("Control 66 Sustenuto Switch");
      values[110].choice_blurb = "";
      values[111].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_67";
      values[111].choice_label = _("Control 67 Soft Switch");
      values[111].choice_blurb = "";
      values[112].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_68";
      values[112].choice_label = _("Control 68 Legato Pedal Switch");
      values[112].choice_blurb = "";
      values[113].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_69";
      values[113].choice_label = _("Control 69 Hold Pedal Switch");
      values[113].choice_blurb = "";
      values[114].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_70";
      values[114].choice_label = _("Control 70 Sound Variation");
      values[114].choice_blurb = "";
      values[115].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_71";
      values[115].choice_label = _("Control 71 Filter Resonance (Timbre)");
      values[115].choice_blurb = "";
      values[116].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_72";
      values[116].choice_label = _("Control 72 Sound Release Time");
      values[116].choice_blurb = "";
      values[117].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_73";
      values[117].choice_label = _("Control 73 Sound Attack Time");
      values[117].choice_blurb = "";
      values[118].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_74";
      values[118].choice_label = _("Control 74 Sound Brightness");
      values[118].choice_blurb = "";
      values[119].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_75";
      values[119].choice_label = _("Control 75 Sound Decay Time");
      values[119].choice_blurb = "";
      values[120].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_76";
      values[120].choice_label = _("Control 76 Vibrato Rate");
      values[120].choice_blurb = "";
      values[121].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_77";
      values[121].choice_label = _("Control 77 Vibrato Depth");
      values[121].choice_blurb = "";
      values[122].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_78";
      values[122].choice_label = _("Control 78 Vibrato Delay");
      values[122].choice_blurb = "";
      values[123].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_79";
      values[123].choice_label = _("Control 79 Sound Control 10");
      values[123].choice_blurb = "";
      values[124].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_80";
      values[124].choice_label = _("Control 80 General Purpose Switch 5");
      values[124].choice_blurb = "";
      values[125].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_81";
      values[125].choice_label = _("Control 81 General Purpose Switch 6");
      values[125].choice_blurb = "";
      values[126].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_82";
      values[126].choice_label = _("Control 82 General Purpose Switch 7");
      values[126].choice_blurb = "";
      values[127].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_83";
      values[127].choice_label = _("Control 83 General Purpose Switch 8");
      values[127].choice_blurb = "";
      values[128].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_84";
      values[128].choice_label = _("Control 84 Portamento Control (Note)");
      values[128].choice_blurb = "";
      values[129].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_85";
      values[129].choice_label = _("control-85");
      values[129].choice_blurb = "";
      values[130].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_86";
      values[130].choice_label = _("control-86");
      values[130].choice_blurb = "";
      values[131].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_87";
      values[131].choice_label = _("control-87");
      values[131].choice_blurb = "";
      values[132].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_88";
      values[132].choice_label = _("control-88");
      values[132].choice_blurb = "";
      values[133].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_89";
      values[133].choice_label = _("control-89");
      values[133].choice_blurb = "";
      values[134].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_90";
      values[134].choice_label = _("control-90");
      values[134].choice_blurb = "";
      values[135].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_91";
      values[135].choice_label = _("Control 91 Reverb Depth");
      values[135].choice_blurb = "";
      values[136].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_92";
      values[136].choice_label = _("Control 92 Tremolo Depth");
      values[136].choice_blurb = "";
      values[137].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_93";
      values[137].choice_label = _("Control 93 Chorus Depth");
      values[137].choice_blurb = "";
      values[138].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_94";
      values[138].choice_label = _("Control 93 Detune Depth");
      values[138].choice_blurb = "";
      values[139].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_95";
      values[139].choice_label = _("Control 95 Phase Depth");
      values[139].choice_blurb = "";
      values[140].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_96";
      values[140].choice_label = _("Control 96 Data Increment Trigger");
      values[140].choice_blurb = "";
      values[141].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_97";
      values[141].choice_label = _("Control 97 Data Decrement Trigger");
      values[141].choice_blurb = "";
      values[142].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_98";
      values[142].choice_label = _("Control 98 Non-Registered Parameter MSB");
      values[142].choice_blurb = "";
      values[143].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_99";
      values[143].choice_label = _("Control 99 Non-Registered Parameter LSB");
      values[143].choice_blurb = "";
      values[144].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_100";
      values[144].choice_label = _("Control 100 Registered Parameter MSB");
      values[144].choice_blurb = "";
      values[145].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_101";
      values[145].choice_label = _("Control 101 Registered Parameter LSB");
      values[145].choice_blurb = "";
      values[146].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_102";
      values[146].choice_label = _("control-102");
      values[146].choice_blurb = "";
      values[147].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_103";
      values[147].choice_label = _("control-103");
      values[147].choice_blurb = "";
      values[148].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_104";
      values[148].choice_label = _("control-104");
      values[148].choice_blurb = "";
      values[149].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_105";
      values[149].choice_label = _("control-105");
      values[149].choice_blurb = "";
      values[150].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_106";
      values[150].choice_label = _("control-106");
      values[150].choice_blurb = "";
      values[151].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_107";
      values[151].choice_label = _("control-107");
      values[151].choice_blurb = "";
      values[152].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_108";
      values[152].choice_label = _("control-108");
      values[152].choice_blurb = "";
      values[153].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_109";
      values[153].choice_label = _("control-109");
      values[153].choice_blurb = "";
      values[154].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_110";
      values[154].choice_label = _("control-110");
      values[154].choice_blurb = "";
      values[155].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_111";
      values[155].choice_label = _("control-111");
      values[155].choice_blurb = "";
      values[156].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_112";
      values[156].choice_label = _("control-112");
      values[156].choice_blurb = "";
      values[157].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_113";
      values[157].choice_label = _("control-113");
      values[157].choice_blurb = "";
      values[158].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_114";
      values[158].choice_label = _("control-114");
      values[158].choice_blurb = "";
      values[159].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_115";
      values[159].choice_label = _("control-115");
      values[159].choice_blurb = "";
      values[160].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_116";
      values[160].choice_label = _("control-116");
      values[160].choice_blurb = "";
      values[161].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_117";
      values[161].choice_label = _("control-117");
      values[161].choice_blurb = "";
      values[162].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_118";
      values[162].choice_label = _("control-118");
      values[162].choice_blurb = "";
      values[163].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_119";
      values[163].choice_label = _("control-119");
      values[163].choice_blurb = "";
      values[164].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_120";
      values[164].choice_label = _("Control 120 All Sound Off ITrigger");
      values[164].choice_blurb = "";
      values[165].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_121";
      values[165].choice_label = _("Control 121 All Controllers Off ITrigger");
      values[165].choice_blurb = "";
      values[166].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_122";
      values[166].choice_label = _("Control 122 Local Control Switch");
      values[166].choice_blurb = "";
      values[167].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_123";
      values[167].choice_label = _("Control 123 All Notes Off ITrigger");
      values[167].choice_blurb = "";
      values[168].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_124";
      values[168].choice_label = _("Control 124 Omni Mode Off ITrigger");
      values[168].choice_blurb = "";
      values[169].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_125";
      values[169].choice_label = _("Control 125 Omni Mode On ITrigger");
      values[169].choice_blurb = "";
      values[170].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_126";
      values[170].choice_label = _("Control 126 Monophonic Voices Mode");
      values[170].choice_blurb = "";
      values[171].choice_ident = "BSE_MIDI_SIGNAL_CONTROL_127";
      values[171].choice_label = _("Control 127 Polyphonic Mode On ITrigger");
      values[171].choice_blurb = "";
  }
  return choice_values;
}

static inline SfiChoiceValues
MidiControlType_choice_values()
{
  static SfiChoiceValue values[161];
  static const SfiChoiceValues choice_values = {
    G_N_ELEMENTS (values), values,
  };
  if (!values[0].choice_ident)
    {
      values[0].choice_ident = "BSE_MIDI_CONTROL_NONE";
      values[0].choice_label = _("None");
      values[0].choice_blurb = "";
      values[1].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_0";
      values[1].choice_label = _("Bank Select");
      values[1].choice_blurb = _("Continuous MIDI Control #1 - Bank Select");
      values[2].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_1";
      values[2].choice_label = _("Modulation Depth");
      values[2].choice_blurb = "";
      values[3].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_2";
      values[3].choice_label = _("Breath Control");
      values[3].choice_blurb = "";
      values[4].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_3";
      values[4].choice_label = _("Continuous 3");
      values[4].choice_blurb = "";
      values[5].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_4";
      values[5].choice_label = _("Foot Controller");
      values[5].choice_blurb = "";
      values[6].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_5";
      values[6].choice_label = _("Portamento Time");
      values[6].choice_blurb = "";
      values[7].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_6";
      values[7].choice_label = _("Data Entry");
      values[7].choice_blurb = "";
      values[8].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_7";
      values[8].choice_label = _("Volume");
      values[8].choice_blurb = "";
      values[9].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_8";
      values[9].choice_label = _("Balance");
      values[9].choice_blurb = "";
      values[10].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_9";
      values[10].choice_label = _("Continuous 9");
      values[10].choice_blurb = "";
      values[11].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_10";
      values[11].choice_label = _("Panorama");
      values[11].choice_blurb = "";
      values[12].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_11";
      values[12].choice_label = _("Expression");
      values[12].choice_blurb = "";
      values[13].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_12";
      values[13].choice_label = _("Effect Control 1");
      values[13].choice_blurb = "";
      values[14].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_13";
      values[14].choice_label = _("Effect Control 2");
      values[14].choice_blurb = "";
      values[15].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_14";
      values[15].choice_label = _("Continuous 14");
      values[15].choice_blurb = "";
      values[16].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_15";
      values[16].choice_label = _("Continuous 15");
      values[16].choice_blurb = "";
      values[17].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_16";
      values[17].choice_label = _("General Purpose Controller 1");
      values[17].choice_blurb = "";
      values[18].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_17";
      values[18].choice_label = _("General Purpose Controller 2");
      values[18].choice_blurb = "";
      values[19].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_18";
      values[19].choice_label = _("General Purpose Controller 3");
      values[19].choice_blurb = "";
      values[20].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_19";
      values[20].choice_label = _("General Purpose Controller 4");
      values[20].choice_blurb = "";
      values[21].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_20";
      values[21].choice_label = _("Continuous 20");
      values[21].choice_blurb = "";
      values[22].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_21";
      values[22].choice_label = _("Continuous 21");
      values[22].choice_blurb = "";
      values[23].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_22";
      values[23].choice_label = _("Continuous 22");
      values[23].choice_blurb = "";
      values[24].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_23";
      values[24].choice_label = _("Continuous 23");
      values[24].choice_blurb = "";
      values[25].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_24";
      values[25].choice_label = _("Continuous 24");
      values[25].choice_blurb = "";
      values[26].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_25";
      values[26].choice_label = _("Continuous 25");
      values[26].choice_blurb = "";
      values[27].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_26";
      values[27].choice_label = _("Continuous 26");
      values[27].choice_blurb = "";
      values[28].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_27";
      values[28].choice_label = _("Continuous 27");
      values[28].choice_blurb = "";
      values[29].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_28";
      values[29].choice_label = _("Continuous 28");
      values[29].choice_blurb = "";
      values[30].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_29";
      values[30].choice_label = _("Continuous 29");
      values[30].choice_blurb = "";
      values[31].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_30";
      values[31].choice_label = _("Continuous 30");
      values[31].choice_blurb = "";
      values[32].choice_ident = "BSE_MIDI_CONTROL_CONTINUOUS_31";
      values[32].choice_label = _("Continuous 31");
      values[32].choice_blurb = "";
      values[33].choice_ident = "BSE_MIDI_CONTROL_0";
      values[33].choice_label = _("Control 0 Bank Select MSB");
      values[33].choice_blurb = "";
      values[34].choice_ident = "BSE_MIDI_CONTROL_1";
      values[34].choice_label = _("Control 1 Modulation Depth MSB");
      values[34].choice_blurb = "";
      values[35].choice_ident = "BSE_MIDI_CONTROL_2";
      values[35].choice_label = _("Control 2 Breath Control MSB");
      values[35].choice_blurb = "";
      values[36].choice_ident = "BSE_MIDI_CONTROL_3";
      values[36].choice_label = _("control-3");
      values[36].choice_blurb = "";
      values[37].choice_ident = "BSE_MIDI_CONTROL_4";
      values[37].choice_label = _("Control 4 Foot Controller MSB");
      values[37].choice_blurb = "";
      values[38].choice_ident = "BSE_MIDI_CONTROL_5";
      values[38].choice_label = _("Control 5 Portamento Time MSB");
      values[38].choice_blurb = "";
      values[39].choice_ident = "BSE_MIDI_CONTROL_6";
      values[39].choice_label = _("Control 6 Data Entry MSB");
      values[39].choice_blurb = "";
      values[40].choice_ident = "BSE_MIDI_CONTROL_7";
      values[40].choice_label = _("Control 7 Volume MSB");
      values[40].choice_blurb = "";
      values[41].choice_ident = "BSE_MIDI_CONTROL_8";
      values[41].choice_label = _("Control 8 Balance MSB");
      values[41].choice_blurb = "";
      values[42].choice_ident = "BSE_MIDI_CONTROL_9";
      values[42].choice_label = _("control-9");
      values[42].choice_blurb = "";
      values[43].choice_ident = "BSE_MIDI_CONTROL_10";
      values[43].choice_label = _("Control 10 Panorama MSB");
      values[43].choice_blurb = "";
      values[44].choice_ident = "BSE_MIDI_CONTROL_11";
      values[44].choice_label = _("Control 11 Expression MSB");
      values[44].choice_blurb = "";
      values[45].choice_ident = "BSE_MIDI_CONTROL_12";
      values[45].choice_label = _("Control 12 Effect Control 1 MSB");
      values[45].choice_blurb = "";
      values[46].choice_ident = "BSE_MIDI_CONTROL_13";
      values[46].choice_label = _("Control 13 Effect Control 2 MSB");
      values[46].choice_blurb = "";
      values[47].choice_ident = "BSE_MIDI_CONTROL_14";
      values[47].choice_label = _("control-14");
      values[47].choice_blurb = "";
      values[48].choice_ident = "BSE_MIDI_CONTROL_15";
      values[48].choice_label = _("control-15");
      values[48].choice_blurb = "";
      values[49].choice_ident = "BSE_MIDI_CONTROL_16";
      values[49].choice_label = _("Control 16 General Purpose Controller 1 MSB");
      values[49].choice_blurb = "";
      values[50].choice_ident = "BSE_MIDI_CONTROL_17";
      values[50].choice_label = _("Control 17 General Purpose Controller 2 MSB");
      values[50].choice_blurb = "";
      values[51].choice_ident = "BSE_MIDI_CONTROL_18";
      values[51].choice_label = _("Control 18 General Purpose Controller 3 MSB");
      values[51].choice_blurb = "";
      values[52].choice_ident = "BSE_MIDI_CONTROL_19";
      values[52].choice_label = _("Control 19 General Purpose Controller 4 MSB");
      values[52].choice_blurb = "";
      values[53].choice_ident = "BSE_MIDI_CONTROL_20";
      values[53].choice_label = _("control-20");
      values[53].choice_blurb = "";
      values[54].choice_ident = "BSE_MIDI_CONTROL_21";
      values[54].choice_label = _("control-21");
      values[54].choice_blurb = "";
      values[55].choice_ident = "BSE_MIDI_CONTROL_22";
      values[55].choice_label = _("control-22");
      values[55].choice_blurb = "";
      values[56].choice_ident = "BSE_MIDI_CONTROL_23";
      values[56].choice_label = _("control-23");
      values[56].choice_blurb = "";
      values[57].choice_ident = "BSE_MIDI_CONTROL_24";
      values[57].choice_label = _("control-24");
      values[57].choice_blurb = "";
      values[58].choice_ident = "BSE_MIDI_CONTROL_25";
      values[58].choice_label = _("control-25");
      values[58].choice_blurb = "";
      values[59].choice_ident = "BSE_MIDI_CONTROL_26";
      values[59].choice_label = _("control-26");
      values[59].choice_blurb = "";
      values[60].choice_ident = "BSE_MIDI_CONTROL_27";
      values[60].choice_label = _("control-27");
      values[60].choice_blurb = "";
      values[61].choice_ident = "BSE_MIDI_CONTROL_28";
      values[61].choice_label = _("control-28");
      values[61].choice_blurb = "";
      values[62].choice_ident = "BSE_MIDI_CONTROL_29";
      values[62].choice_label = _("control-29");
      values[62].choice_blurb = "";
      values[63].choice_ident = "BSE_MIDI_CONTROL_30";
      values[63].choice_label = _("control-30");
      values[63].choice_blurb = "";
      values[64].choice_ident = "BSE_MIDI_CONTROL_31";
      values[64].choice_label = _("control-31");
      values[64].choice_blurb = "";
      values[65].choice_ident = "BSE_MIDI_CONTROL_32";
      values[65].choice_label = _("Control 32 Bank Select LSB");
      values[65].choice_blurb = "";
      values[66].choice_ident = "BSE_MIDI_CONTROL_33";
      values[66].choice_label = _("Control 33 Modulation Depth LSB");
      values[66].choice_blurb = "";
      values[67].choice_ident = "BSE_MIDI_CONTROL_34";
      values[67].choice_label = _("Control 34 Breath Control LSB");
      values[67].choice_blurb = "";
      values[68].choice_ident = "BSE_MIDI_CONTROL_35";
      values[68].choice_label = _("control-35");
      values[68].choice_blurb = "";
      values[69].choice_ident = "BSE_MIDI_CONTROL_36";
      values[69].choice_label = _("Control 36 Foot Controller LSB");
      values[69].choice_blurb = "";
      values[70].choice_ident = "BSE_MIDI_CONTROL_37";
      values[70].choice_label = _("Control 37 Portamento Time LSB");
      values[70].choice_blurb = "";
      values[71].choice_ident = "BSE_MIDI_CONTROL_38";
      values[71].choice_label = _("Control 38 Data Entry LSB");
      values[71].choice_blurb = "";
      values[72].choice_ident = "BSE_MIDI_CONTROL_39";
      values[72].choice_label = _("Control 39 Volume LSB");
      values[72].choice_blurb = "";
      values[73].choice_ident = "BSE_MIDI_CONTROL_40";
      values[73].choice_label = _("Control 40 Balance LSB");
      values[73].choice_blurb = "";
      values[74].choice_ident = "BSE_MIDI_CONTROL_41";
      values[74].choice_label = _("control-41");
      values[74].choice_blurb = "";
      values[75].choice_ident = "BSE_MIDI_CONTROL_42";
      values[75].choice_label = _("Control 42 Panorama LSB");
      values[75].choice_blurb = "";
      values[76].choice_ident = "BSE_MIDI_CONTROL_43";
      values[76].choice_label = _("Control 43 Expression LSB");
      values[76].choice_blurb = "";
      values[77].choice_ident = "BSE_MIDI_CONTROL_44";
      values[77].choice_label = _("Control 44 Effect Control 1 LSB");
      values[77].choice_blurb = "";
      values[78].choice_ident = "BSE_MIDI_CONTROL_45";
      values[78].choice_label = _("Control 45 Effect Control 2 LSB");
      values[78].choice_blurb = "";
      values[79].choice_ident = "BSE_MIDI_CONTROL_46";
      values[79].choice_label = _("control-46");
      values[79].choice_blurb = "";
      values[80].choice_ident = "BSE_MIDI_CONTROL_47";
      values[80].choice_label = _("control-47");
      values[80].choice_blurb = "";
      values[81].choice_ident = "BSE_MIDI_CONTROL_48";
      values[81].choice_label = _("Control 48 General Purpose Controller 1 LSB");
      values[81].choice_blurb = "";
      values[82].choice_ident = "BSE_MIDI_CONTROL_49";
      values[82].choice_label = _("Control 49 General Purpose Controller 2 LSB");
      values[82].choice_blurb = "";
      values[83].choice_ident = "BSE_MIDI_CONTROL_50";
      values[83].choice_label = _("Control 50 General Purpose Controller 3 LSB");
      values[83].choice_blurb = "";
      values[84].choice_ident = "BSE_MIDI_CONTROL_51";
      values[84].choice_label = _("Control 51 General Purpose Controller 4 LSB");
      values[84].choice_blurb = "";
      values[85].choice_ident = "BSE_MIDI_CONTROL_52";
      values[85].choice_label = _("control-52");
      values[85].choice_blurb = "";
      values[86].choice_ident = "BSE_MIDI_CONTROL_53";
      values[86].choice_label = _("control-53");
      values[86].choice_blurb = "";
      values[87].choice_ident = "BSE_MIDI_CONTROL_54";
      values[87].choice_label = _("control-54");
      values[87].choice_blurb = "";
      values[88].choice_ident = "BSE_MIDI_CONTROL_55";
      values[88].choice_label = _("control-55");
      values[88].choice_blurb = "";
      values[89].choice_ident = "BSE_MIDI_CONTROL_56";
      values[89].choice_label = _("control-56");
      values[89].choice_blurb = "";
      values[90].choice_ident = "BSE_MIDI_CONTROL_57";
      values[90].choice_label = _("control-57");
      values[90].choice_blurb = "";
      values[91].choice_ident = "BSE_MIDI_CONTROL_58";
      values[91].choice_label = _("control-58");
      values[91].choice_blurb = "";
      values[92].choice_ident = "BSE_MIDI_CONTROL_59";
      values[92].choice_label = _("control-59");
      values[92].choice_blurb = "";
      values[93].choice_ident = "BSE_MIDI_CONTROL_60";
      values[93].choice_label = _("control-60");
      values[93].choice_blurb = "";
      values[94].choice_ident = "BSE_MIDI_CONTROL_61";
      values[94].choice_label = _("control-61");
      values[94].choice_blurb = "";
      values[95].choice_ident = "BSE_MIDI_CONTROL_62";
      values[95].choice_label = _("control-62");
      values[95].choice_blurb = "";
      values[96].choice_ident = "BSE_MIDI_CONTROL_63";
      values[96].choice_label = _("control-63");
      values[96].choice_blurb = "";
      values[97].choice_ident = "BSE_MIDI_CONTROL_64";
      values[97].choice_label = _("Control 64 Damper Pedal Switch (Sustain)");
      values[97].choice_blurb = "";
      values[98].choice_ident = "BSE_MIDI_CONTROL_65";
      values[98].choice_label = _("Control 65 Portamento Switch");
      values[98].choice_blurb = "";
      values[99].choice_ident = "BSE_MIDI_CONTROL_66";
      values[99].choice_label = _("Control 66 Sustenuto Switch");
      values[99].choice_blurb = "";
      values[100].choice_ident = "BSE_MIDI_CONTROL_67";
      values[100].choice_label = _("Control 67 Soft Switch");
      values[100].choice_blurb = "";
      values[101].choice_ident = "BSE_MIDI_CONTROL_68";
      values[101].choice_label = _("Control 68 Legato Pedal Switch");
      values[101].choice_blurb = "";
      values[102].choice_ident = "BSE_MIDI_CONTROL_69";
      values[102].choice_label = _("Control 69 Hold Pedal Switch");
      values[102].choice_blurb = "";
      values[103].choice_ident = "BSE_MIDI_CONTROL_70";
      values[103].choice_label = _("Control 70 Sound Variation");
      values[103].choice_blurb = "";
      values[104].choice_ident = "BSE_MIDI_CONTROL_71";
      values[104].choice_label = _("Control 71 Filter Resonance (Timbre)");
      values[104].choice_blurb = "";
      values[105].choice_ident = "BSE_MIDI_CONTROL_72";
      values[105].choice_label = _("Control 72 Sound Release Time");
      values[105].choice_blurb = "";
      values[106].choice_ident = "BSE_MIDI_CONTROL_73";
      values[106].choice_label = _("Control 73 Sound Attack Time");
      values[106].choice_blurb = "";
      values[107].choice_ident = "BSE_MIDI_CONTROL_74";
      values[107].choice_label = _("Control 74 Sound Brightness");
      values[107].choice_blurb = "";
      values[108].choice_ident = "BSE_MIDI_CONTROL_75";
      values[108].choice_label = _("Control 75 Sound Decay Time");
      values[108].choice_blurb = "";
      values[109].choice_ident = "BSE_MIDI_CONTROL_76";
      values[109].choice_label = _("Control 76 Vibrato Rate");
      values[109].choice_blurb = "";
      values[110].choice_ident = "BSE_MIDI_CONTROL_77";
      values[110].choice_label = _("Control 77 Vibrato Depth");
      values[110].choice_blurb = "";
      values[111].choice_ident = "BSE_MIDI_CONTROL_78";
      values[111].choice_label = _("Control 78 Vibrato Delay");
      values[111].choice_blurb = "";
      values[112].choice_ident = "BSE_MIDI_CONTROL_79";
      values[112].choice_label = _("Control 79 Sound Control 10");
      values[112].choice_blurb = "";
      values[113].choice_ident = "BSE_MIDI_CONTROL_80";
      values[113].choice_label = _("Control 80 General Purpose Switch 5");
      values[113].choice_blurb = "";
      values[114].choice_ident = "BSE_MIDI_CONTROL_81";
      values[114].choice_label = _("Control 81 General Purpose Switch 6");
      values[114].choice_blurb = "";
      values[115].choice_ident = "BSE_MIDI_CONTROL_82";
      values[115].choice_label = _("Control 82 General Purpose Switch 7");
      values[115].choice_blurb = "";
      values[116].choice_ident = "BSE_MIDI_CONTROL_83";
      values[116].choice_label = _("Control 83 General Purpose Switch 8");
      values[116].choice_blurb = "";
      values[117].choice_ident = "BSE_MIDI_CONTROL_84";
      values[117].choice_label = _("Control 84 Portamento Control (Note)");
      values[117].choice_blurb = "";
      values[118].choice_ident = "BSE_MIDI_CONTROL_85";
      values[118].choice_label = _("control-85");
      values[118].choice_blurb = "";
      values[119].choice_ident = "BSE_MIDI_CONTROL_86";
      values[119].choice_label = _("control-86");
      values[119].choice_blurb = "";
      values[120].choice_ident = "BSE_MIDI_CONTROL_87";
      values[120].choice_label = _("control-87");
      values[120].choice_blurb = "";
      values[121].choice_ident = "BSE_MIDI_CONTROL_88";
      values[121].choice_label = _("control-88");
      values[121].choice_blurb = "";
      values[122].choice_ident = "BSE_MIDI_CONTROL_89";
      values[122].choice_label = _("control-89");
      values[122].choice_blurb = "";
      values[123].choice_ident = "BSE_MIDI_CONTROL_90";
      values[123].choice_label = _("control-90");
      values[123].choice_blurb = "";
      values[124].choice_ident = "BSE_MIDI_CONTROL_91";
      values[124].choice_label = _("Control 91 Reverb Depth");
      values[124].choice_blurb = "";
      values[125].choice_ident = "BSE_MIDI_CONTROL_92";
      values[125].choice_label = _("Control 92 Tremolo Depth");
      values[125].choice_blurb = "";
      values[126].choice_ident = "BSE_MIDI_CONTROL_93";
      values[126].choice_label = _("Control 93 Chorus Depth");
      values[126].choice_blurb = "";
      values[127].choice_ident = "BSE_MIDI_CONTROL_94";
      values[127].choice_label = _("Control 93 Detune Depth");
      values[127].choice_blurb = "";
      values[128].choice_ident = "BSE_MIDI_CONTROL_95";
      values[128].choice_label = _("Control 95 Phase Depth");
      values[128].choice_blurb = "";
      values[129].choice_ident = "BSE_MIDI_CONTROL_96";
      values[129].choice_label = _("Control 96 Data Increment Trigger");
      values[129].choice_blurb = "";
      values[130].choice_ident = "BSE_MIDI_CONTROL_97";
      values[130].choice_label = _("Control 97 Data Decrement Trigger");
      values[130].choice_blurb = "";
      values[131].choice_ident = "BSE_MIDI_CONTROL_98";
      values[131].choice_label = _("Control 98 Non-Registered Parameter MSB");
      values[131].choice_blurb = "";
      values[132].choice_ident = "BSE_MIDI_CONTROL_99";
      values[132].choice_label = _("Control 99 Non-Registered Parameter LSB");
      values[132].choice_blurb = "";
      values[133].choice_ident = "BSE_MIDI_CONTROL_100";
      values[133].choice_label = _("Control 100 Registered Parameter MSB");
      values[133].choice_blurb = "";
      values[134].choice_ident = "BSE_MIDI_CONTROL_101";
      values[134].choice_label = _("Control 101 Registered Parameter LSB");
      values[134].choice_blurb = "";
      values[135].choice_ident = "BSE_MIDI_CONTROL_102";
      values[135].choice_label = _("control-102");
      values[135].choice_blurb = "";
      values[136].choice_ident = "BSE_MIDI_CONTROL_103";
      values[136].choice_label = _("control-103");
      values[136].choice_blurb = "";
      values[137].choice_ident = "BSE_MIDI_CONTROL_104";
      values[137].choice_label = _("control-104");
      values[137].choice_blurb = "";
      values[138].choice_ident = "BSE_MIDI_CONTROL_105";
      values[138].choice_label = _("control-105");
      values[138].choice_blurb = "";
      values[139].choice_ident = "BSE_MIDI_CONTROL_106";
      values[139].choice_label = _("control-106");
      values[139].choice_blurb = "";
      values[140].choice_ident = "BSE_MIDI_CONTROL_107";
      values[140].choice_label = _("control-107");
      values[140].choice_blurb = "";
      values[141].choice_ident = "BSE_MIDI_CONTROL_108";
      values[141].choice_label = _("control-108");
      values[141].choice_blurb = "";
      values[142].choice_ident = "BSE_MIDI_CONTROL_109";
      values[142].choice_label = _("control-109");
      values[142].choice_blurb = "";
      values[143].choice_ident = "BSE_MIDI_CONTROL_110";
      values[143].choice_label = _("control-110");
      values[143].choice_blurb = "";
      values[144].choice_ident = "BSE_MIDI_CONTROL_111";
      values[144].choice_label = _("control-111");
      values[144].choice_blurb = "";
      values[145].choice_ident = "BSE_MIDI_CONTROL_112";
      values[145].choice_label = _("control-112");
      values[145].choice_blurb = "";
      values[146].choice_ident = "BSE_MIDI_CONTROL_113";
      values[146].choice_label = _("control-113");
      values[146].choice_blurb = "";
      values[147].choice_ident = "BSE_MIDI_CONTROL_114";
      values[147].choice_label = _("control-114");
      values[147].choice_blurb = "";
      values[148].choice_ident = "BSE_MIDI_CONTROL_115";
      values[148].choice_label = _("control-115");
      values[148].choice_blurb = "";
      values[149].choice_ident = "BSE_MIDI_CONTROL_116";
      values[149].choice_label = _("control-116");
      values[149].choice_blurb = "";
      values[150].choice_ident = "BSE_MIDI_CONTROL_117";
      values[150].choice_label = _("control-117");
      values[150].choice_blurb = "";
      values[151].choice_ident = "BSE_MIDI_CONTROL_118";
      values[151].choice_label = _("control-118");
      values[151].choice_blurb = "";
      values[152].choice_ident = "BSE_MIDI_CONTROL_119";
      values[152].choice_label = _("control-119");
      values[152].choice_blurb = "";
      values[153].choice_ident = "BSE_MIDI_CONTROL_120";
      values[153].choice_label = _("Control 120 All Sound Off ITrigger");
      values[153].choice_blurb = "";
      values[154].choice_ident = "BSE_MIDI_CONTROL_121";
      values[154].choice_label = _("Control 121 All Controllers Off ITrigger");
      values[154].choice_blurb = "";
      values[155].choice_ident = "BSE_MIDI_CONTROL_122";
      values[155].choice_label = _("Control 122 Local Control Switch");
      values[155].choice_blurb = "";
      values[156].choice_ident = "BSE_MIDI_CONTROL_123";
      values[156].choice_label = _("Control 123 All Notes Off ITrigger");
      values[156].choice_blurb = "";
      values[157].choice_ident = "BSE_MIDI_CONTROL_124";
      values[157].choice_label = _("Control 124 Omni Mode Off ITrigger");
      values[157].choice_blurb = "";
      values[158].choice_ident = "BSE_MIDI_CONTROL_125";
      values[158].choice_label = _("Control 125 Omni Mode On ITrigger");
      values[158].choice_blurb = "";
      values[159].choice_ident = "BSE_MIDI_CONTROL_126";
      values[159].choice_label = _("Control 126 Monophonic Voices Mode");
      values[159].choice_blurb = "";
      values[160].choice_ident = "BSE_MIDI_CONTROL_127";
      values[160].choice_label = _("Control 127 Polyphonic Mode On ITrigger");
      values[160].choice_blurb = "";
  }
  return choice_values;
}

static inline SfiChoiceValues
UserMsgType_choice_values()
{
  static SfiChoiceValue values[4];
  static const SfiChoiceValues choice_values = {
    G_N_ELEMENTS (values), values,
  };
  if (!values[0].choice_ident)
    {
      values[0].choice_ident = "BSE_USER_MSG_MISC";
      values[0].choice_label = "bse-user-msg-misc";
      values[0].choice_blurb = "";
      values[1].choice_ident = "BSE_USER_MSG_INFO";
      values[1].choice_label = "bse-user-msg-info";
      values[1].choice_blurb = "";
      values[2].choice_ident = "BSE_USER_MSG_WARNING";
      values[2].choice_label = "bse-user-msg-warning";
      values[2].choice_blurb = "";
      values[3].choice_ident = "BSE_USER_MSG_ERROR";
      values[3].choice_label = "bse-user-msg-error";
      values[3].choice_blurb = "";
  }
  return choice_values;
}

static inline SfiChoiceValues
ThreadState_choice_values()
{
  static SfiChoiceValue values[8];
  static const SfiChoiceValues choice_values = {
    G_N_ELEMENTS (values), values,
  };
  if (!values[0].choice_ident)
    {
      values[0].choice_ident = "BSE_THREAD_STATE_UNKNOWN";
      values[0].choice_label = "bse-thread-state-unknown";
      values[0].choice_blurb = "";
      values[1].choice_ident = "BSE_THREAD_STATE_RUNNING";
      values[1].choice_label = "bse-thread-state-running";
      values[1].choice_blurb = "";
      values[2].choice_ident = "BSE_THREAD_STATE_SLEEPING";
      values[2].choice_label = "bse-thread-state-sleeping";
      values[2].choice_blurb = "";
      values[3].choice_ident = "BSE_THREAD_STATE_DISKWAIT";
      values[3].choice_label = "bse-thread-state-diskwait";
      values[3].choice_blurb = "";
      values[4].choice_ident = "BSE_THREAD_STATE_TRACED";
      values[4].choice_label = "bse-thread-state-traced";
      values[4].choice_blurb = "";
      values[5].choice_ident = "BSE_THREAD_STATE_PAGING";
      values[5].choice_label = "bse-thread-state-paging";
      values[5].choice_blurb = "";
      values[6].choice_ident = "BSE_THREAD_STATE_ZOMBIE";
      values[6].choice_label = "bse-thread-state-zombie";
      values[6].choice_blurb = "";
      values[7].choice_ident = "BSE_THREAD_STATE_DEAD";
      values[7].choice_label = "bse-thread-state-dead";
      values[7].choice_blurb = "";
  }
  return choice_values;
}



/* record implementations */
::Bse::PropertyCandidatesHandle
PropertyCandidates::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::PropertyCandidatesHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "label");
  if (element)
    rec->label = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "tooltip");
  if (element)
    rec->tooltip = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "items");
  if (element)
    rec->items = ::Bse::ItemSeq::value_get_boxed (element);
  element = sfi_rec_get (sfi_rec, "partitions");
  if (element)
    rec->partitions = ::Bse::TypeSeq::value_get_boxed (element);
  return rec;
}

SfiRec *
PropertyCandidates::to_rec (const ::Bse::PropertyCandidatesHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "label", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->label);
  element = sfi_rec_forced_get (sfi_rec, "tooltip", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->tooltip);
  element = sfi_rec_forced_get (sfi_rec, "items", SFI_TYPE_SEQ);
  ::Bse::ItemSeq::value_set_boxed (element, rec->items);
  element = sfi_rec_forced_get (sfi_rec, "partitions", SFI_TYPE_SEQ);
  ::Bse::TypeSeq::value_set_boxed (element, rec->partitions);
  return sfi_rec;
}

::Bse::PropertyCandidatesHandle
PropertyCandidates::value_get_boxed (const GValue *value)
{
  return ::Bse::PropertyCandidatesHandle::value_get_boxed (value);
}

void
PropertyCandidates::value_set_boxed (GValue *value, const ::Bse::PropertyCandidatesHandle & self)
{
  ::Bse::PropertyCandidatesHandle::value_set_boxed (value, self);
}

SfiRecFields
PropertyCandidates::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[4 + 1];
      rfields.n_fields = 4;
      fields[0] = sfidl_pspec_String_default (NULL,"label");
      fields[1] = sfidl_pspec_String_default (NULL,"tooltip");
      fields[2] = sfidl_pspec_Sequence_default (NULL, "items", Bse::ItemSeq::get_element());
      fields[3] = sfidl_pspec_Sequence (NULL, "partitions", "Type Partitions" , "List of types which may logically partition the list of items by type discrimination" , ":r:w:S:G:", Bse::TypeSeq::get_element());
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::PartNoteHandle
PartNote::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::PartNoteHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "id");
  if (element)
    rec->id = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "channel");
  if (element)
    rec->channel = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "duration");
  if (element)
    rec->duration = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "note");
  if (element)
    rec->note = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "fine_tune");
  if (element)
    rec->fine_tune = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "velocity");
  if (element)
    rec->velocity = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "selected");
  if (element)
    rec->selected = sfi_value_get_bool (element);
  return rec;
}

SfiRec *
PartNote::to_rec (const ::Bse::PartNoteHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "id", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->id);
  element = sfi_rec_forced_get (sfi_rec, "channel", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->channel);
  element = sfi_rec_forced_get (sfi_rec, "tick", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->tick);
  element = sfi_rec_forced_get (sfi_rec, "duration", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->duration);
  element = sfi_rec_forced_get (sfi_rec, "note", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->note);
  element = sfi_rec_forced_get (sfi_rec, "fine_tune", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->fine_tune);
  element = sfi_rec_forced_get (sfi_rec, "velocity", SFI_TYPE_REAL);
  sfi_value_set_real (element, rec->velocity);
  element = sfi_rec_forced_get (sfi_rec, "selected", SFI_TYPE_BOOL);
  sfi_value_set_bool (element, rec->selected);
  return sfi_rec;
}

::Bse::PartNoteHandle
PartNote::value_get_boxed (const GValue *value)
{
  return ::Bse::PartNoteHandle::value_get_boxed (value);
}

void
PartNote::value_set_boxed (GValue *value, const ::Bse::PartNoteHandle & self)
{
  ::Bse::PartNoteHandle::value_set_boxed (value, self);
}

SfiRecFields
PartNote::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[8 + 1];
      rfields.n_fields = 8;
      fields[0] = sfidl_pspec_UInt (NULL,"id","ID" , "" , 0 , ":readwrite");
      fields[1] = sfidl_pspec_Int (NULL,"channel","Channel" , "" , 0 , 0 , 2147483647LL , 1 , ":readwrite");
      fields[2] = sfidl_pspec_Int (NULL,"tick","Tick" , "" , 0 , 0 , 2147483647LL , 1 , ":readwrite");
      fields[3] = sfidl_pspec_Int (NULL,"duration","Duration" , "Duration in number of ticks" , 0 , 0 , 2147483647LL , 1 , ":readwrite");
      fields[4] = sfidl_pspec_Note (NULL,"note","Note" , "" , KAMMER_NOTE , ":readwrite");
      fields[5] = sfidl_pspec_Int (NULL,"fine_tune","Fine Tune" , "" , 0 , MIN_FINE_TUNE , MAX_FINE_TUNE , 1 , ":readwrite");
      fields[6] = sfidl_pspec_Real (NULL,"velocity","Velocity" , "" , 1 , 0 , 1 , 0.10000000000000001 , ":readwrite");
      fields[7] = sfidl_pspec_Bool (NULL,"selected","Selected" , "" , FALSE , ":readwrite");
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::PartControlHandle
PartControl::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::PartControlHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "id");
  if (element)
    rec->id = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "control_type");
  if (element)
    rec->control_type = (::Bse::MidiSignalType) sfi_value_get_enum_auto SFI_START_ARGS() BSE_TYPE_MIDI_SIGNAL_TYPE, SFI_END_ARGS1 (element);
  element = sfi_rec_get (sfi_rec, "value");
  if (element)
    rec->value = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "selected");
  if (element)
    rec->selected = sfi_value_get_bool (element);
  return rec;
}

SfiRec *
PartControl::to_rec (const ::Bse::PartControlHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "id", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->id);
  element = sfi_rec_forced_get (sfi_rec, "tick", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->tick);
  element = sfi_rec_forced_get (sfi_rec, "control_type", SFI_TYPE_CHOICE);
  sfi_value_set_enum_auto SFI_START_ARGS() BSE_TYPE_MIDI_SIGNAL_TYPE, SFI_END_ARGS2 (element, rec->control_type);
  element = sfi_rec_forced_get (sfi_rec, "value", SFI_TYPE_REAL);
  sfi_value_set_real (element, rec->value);
  element = sfi_rec_forced_get (sfi_rec, "selected", SFI_TYPE_BOOL);
  sfi_value_set_bool (element, rec->selected);
  return sfi_rec;
}

::Bse::PartControlHandle
PartControl::value_get_boxed (const GValue *value)
{
  return ::Bse::PartControlHandle::value_get_boxed (value);
}

void
PartControl::value_set_boxed (GValue *value, const ::Bse::PartControlHandle & self)
{
  ::Bse::PartControlHandle::value_set_boxed (value, self);
}

SfiRecFields
PartControl::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[5 + 1];
      rfields.n_fields = 5;
      fields[0] = sfidl_pspec_UInt (NULL,"id","ID" , "" , 0 , ":readwrite");
      fields[1] = sfidl_pspec_Int (NULL,"tick","Tick" , "" , 0 , 0 , 2147483647LL , 1 , ":readwrite");
      fields[2] = sfidl_pspec_Choice_default (NULL, "control_type", Bse::MidiSignalType_choice_values());
      fields[3] = sfidl_pspec_Real (NULL,"value","Value" , "" , 0 , - 1 , + 1 , 0.10000000000000001 , ":readwrite");
      fields[4] = sfidl_pspec_Bool (NULL,"selected","Selected" , "" , FALSE , ":readwrite");
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::NoteDescriptionHandle
NoteDescription::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::NoteDescriptionHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "note");
  if (element)
    rec->note = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "octave");
  if (element)
    rec->octave = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "freq");
  if (element)
    rec->freq = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "fine_tune");
  if (element)
    rec->fine_tune = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "semitone");
  if (element)
    rec->semitone = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "upshift");
  if (element)
    rec->upshift = sfi_value_get_bool (element);
  element = sfi_rec_get (sfi_rec, "letter");
  if (element)
    rec->letter = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "name");
  if (element)
    rec->name = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "max_fine_tune");
  if (element)
    rec->max_fine_tune = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "kammer_note");
  if (element)
    rec->kammer_note = sfi_value_get_int (element);
  return rec;
}

SfiRec *
NoteDescription::to_rec (const ::Bse::NoteDescriptionHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "note", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->note);
  element = sfi_rec_forced_get (sfi_rec, "octave", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->octave);
  element = sfi_rec_forced_get (sfi_rec, "freq", SFI_TYPE_REAL);
  sfi_value_set_real (element, rec->freq);
  element = sfi_rec_forced_get (sfi_rec, "fine_tune", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->fine_tune);
  element = sfi_rec_forced_get (sfi_rec, "semitone", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->semitone);
  element = sfi_rec_forced_get (sfi_rec, "upshift", SFI_TYPE_BOOL);
  sfi_value_set_bool (element, rec->upshift);
  element = sfi_rec_forced_get (sfi_rec, "letter", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->letter);
  element = sfi_rec_forced_get (sfi_rec, "name", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->name);
  element = sfi_rec_forced_get (sfi_rec, "max_fine_tune", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->max_fine_tune);
  element = sfi_rec_forced_get (sfi_rec, "kammer_note", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->kammer_note);
  return sfi_rec;
}

::Bse::NoteDescriptionHandle
NoteDescription::value_get_boxed (const GValue *value)
{
  return ::Bse::NoteDescriptionHandle::value_get_boxed (value);
}

void
NoteDescription::value_set_boxed (GValue *value, const ::Bse::NoteDescriptionHandle & self)
{
  ::Bse::NoteDescriptionHandle::value_set_boxed (value, self);
}

SfiRecFields
NoteDescription::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[10 + 1];
      rfields.n_fields = 10;
      fields[0] = sfidl_pspec_Note (NULL,"note","Note" , "" , KAMMER_NOTE , ":readwrite");
      fields[1] = sfidl_pspec_Octave (NULL,"octave","Octave" , "" , KAMMER_OCTAVE , ":readwrite");
      fields[2] = sfidl_pspec_Freq (NULL,"freq","Frequency" , "" , KAMMER_FREQ , ":readwrite");
      fields[3] = sfidl_pspec_FineTune (NULL,"fine_tune","Fine Tune" , "" , ":readwrite");
      fields[4] = sfidl_pspec_Int (NULL,"semitone","Semitone" , "" , 0 , 0 , 11 , 1 , ":readwrite");
      fields[5] = sfidl_pspec_Bool_default (NULL,"upshift");
      fields[6] = sfidl_pspec_Int (NULL,"letter","Letter" , "International abbreviation letter for this note" , 64 , 32 , 126 , 1 , ":readwrite");
      fields[7] = sfidl_pspec_String (NULL,"name","Name" , "" , "" , ":readwrite");
      fields[8] = sfidl_pspec_Int (NULL,"max_fine_tune","Max Fine Tune" , "" , MAX_FINE_TUNE , MAX_FINE_TUNE , MAX_FINE_TUNE , 0 , ":readable");
      fields[9] = sfidl_pspec_Int (NULL,"kammer_note","Kammer Note" , "" , KAMMER_NOTE , KAMMER_NOTE , KAMMER_NOTE , 0 , ":readable");
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::NoteSequenceHandle
NoteSequence::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::NoteSequenceHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "offset");
  if (element)
    rec->offset = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "notes");
  if (element)
    rec->notes = ::Bse::NoteSeq::value_get_boxed (element);
  return rec;
}

SfiRec *
NoteSequence::to_rec (const ::Bse::NoteSequenceHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "offset", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->offset);
  element = sfi_rec_forced_get (sfi_rec, "notes", SFI_TYPE_SEQ);
  ::Bse::NoteSeq::value_set_boxed (element, rec->notes);
  return sfi_rec;
}

::Bse::NoteSequenceHandle
NoteSequence::value_get_boxed (const GValue *value)
{
  return ::Bse::NoteSequenceHandle::value_get_boxed (value);
}

void
NoteSequence::value_set_boxed (GValue *value, const ::Bse::NoteSequenceHandle & self)
{
  ::Bse::NoteSequenceHandle::value_set_boxed (value, self);
}

SfiRecFields
NoteSequence::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[2 + 1];
      rfields.n_fields = 2;
      fields[0] = sfidl_pspec_Note (NULL,"offset","Note Offset" , "Center/base note" , KAMMER_NOTE , ":readwrite");
      fields[1] = sfidl_pspec_Sequence (NULL, "notes", "Notes" , "Sequence of notes" , ":readwrite", Bse::NoteSeq::get_element());
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::IconHandle
Icon::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::IconHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "bytes_per_pixel");
  if (element)
    rec->bytes_per_pixel = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "width");
  if (element)
    rec->width = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "height");
  if (element)
    rec->height = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "pixels");
  if (element)
    rec->pixels = ::Sfi::BBlock::value_get_bblock (element);
  return rec;
}

SfiRec *
Icon::to_rec (const ::Bse::IconHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "bytes_per_pixel", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->bytes_per_pixel);
  element = sfi_rec_forced_get (sfi_rec, "width", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->width);
  element = sfi_rec_forced_get (sfi_rec, "height", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->height);
  element = sfi_rec_forced_get (sfi_rec, "pixels", SFI_TYPE_BBLOCK);
  ::Sfi::BBlock::value_set_bblock (element, rec->pixels);
  return sfi_rec;
}

::Bse::IconHandle
Icon::value_get_boxed (const GValue *value)
{
  return ::Bse::IconHandle::value_get_boxed (value);
}

void
Icon::value_set_boxed (GValue *value, const ::Bse::IconHandle & self)
{
  ::Bse::IconHandle::value_set_boxed (value, self);
}

SfiRecFields
Icon::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[4 + 1];
      rfields.n_fields = 4;
      fields[0] = sfidl_pspec_Int (NULL,"bytes_per_pixel","Bytes Per Pixel" , "Bytes Per Pixel (3:RGB, 4:RGBA, 0:NONE)" , 4 , 3 , 4 , 1 , ":readwrite");
      fields[1] = sfidl_pspec_Int (NULL,"width","Width" , "Width in pixels or 0 for no icon" , 0 , 0 , 2147483647LL , 1 , ":readwrite");
      fields[2] = sfidl_pspec_Int (NULL,"height","Height" , "Height in pixels or 0 for no icon" , 0 , 0 , 2147483647LL , 1 , ":readwrite");
      fields[3] = sfidl_pspec_BBlock (NULL,"pixels","Pixels" , "Pixel array of width*height*bytes_per_pixel bytes" , ":readwrite");
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::CategoryHandle
Category::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::CategoryHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "category_id");
  if (element)
    rec->category_id = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "category");
  if (element)
    rec->category = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "mindex");
  if (element)
    rec->mindex = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "lindex");
  if (element)
    rec->lindex = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "type");
  if (element)
    rec->type = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "icon");
  if (element)
    rec->icon = ::Bse::Icon::value_get_boxed (element);
  return rec;
}

SfiRec *
Category::to_rec (const ::Bse::CategoryHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "category_id", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->category_id);
  element = sfi_rec_forced_get (sfi_rec, "category", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->category);
  element = sfi_rec_forced_get (sfi_rec, "mindex", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->mindex);
  element = sfi_rec_forced_get (sfi_rec, "lindex", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->lindex);
  element = sfi_rec_forced_get (sfi_rec, "type", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->type);
  element = sfi_rec_forced_get (sfi_rec, "icon", SFI_TYPE_REC);
  ::Bse::Icon::value_set_boxed (element, rec->icon);
  return sfi_rec;
}

::Bse::CategoryHandle
Category::value_get_boxed (const GValue *value)
{
  return ::Bse::CategoryHandle::value_get_boxed (value);
}

void
Category::value_set_boxed (GValue *value, const ::Bse::CategoryHandle & self)
{
  ::Bse::CategoryHandle::value_set_boxed (value, self);
}

SfiRecFields
Category::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[6 + 1];
      rfields.n_fields = 6;
      fields[0] = sfidl_pspec_Int (NULL,"category_id","Category ID" , NULL , 1 , 1 , G_MAXINT , 1 , ":readwrite");
      fields[1] = sfidl_pspec_String_default (NULL,"category");
      fields[2] = sfidl_pspec_Int_default (NULL,"mindex");
      fields[3] = sfidl_pspec_Int_default (NULL,"lindex");
      fields[4] = sfidl_pspec_String_default (NULL,"type");
      fields[5] = sfidl_pspec_Record_default (NULL, "icon", Bse::Icon::get_fields());
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::DotHandle
Dot::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::DotHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "x");
  if (element)
    rec->x = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "y");
  if (element)
    rec->y = sfi_value_get_real (element);
  return rec;
}

SfiRec *
Dot::to_rec (const ::Bse::DotHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "x", SFI_TYPE_REAL);
  sfi_value_set_real (element, rec->x);
  element = sfi_rec_forced_get (sfi_rec, "y", SFI_TYPE_REAL);
  sfi_value_set_real (element, rec->y);
  return sfi_rec;
}

::Bse::DotHandle
Dot::value_get_boxed (const GValue *value)
{
  return ::Bse::DotHandle::value_get_boxed (value);
}

void
Dot::value_set_boxed (GValue *value, const ::Bse::DotHandle & self)
{
  ::Bse::DotHandle::value_set_boxed (value, self);
}

SfiRecFields
Dot::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[2 + 1];
      rfields.n_fields = 2;
      fields[0] = sfidl_pspec_Real_default (NULL,"x");
      fields[1] = sfidl_pspec_Real_default (NULL,"y");
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::TrackPartHandle
TrackPart::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::TrackPartHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "part");
  if (element)
    rec->part = ::Bse::CxxBase::value_get_gobject< BsePart> (element);
  element = sfi_rec_get (sfi_rec, "duration");
  if (element)
    rec->duration = sfi_value_get_int (element);
  return rec;
}

SfiRec *
TrackPart::to_rec (const ::Bse::TrackPartHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "tick", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->tick);
  element = sfi_rec_forced_get (sfi_rec, "part", SFI_TYPE_PROXY);
  ::Bse::CxxBase::value_set_gobject (element, rec->part);
  element = sfi_rec_forced_get (sfi_rec, "duration", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->duration);
  return sfi_rec;
}

::Bse::TrackPartHandle
TrackPart::value_get_boxed (const GValue *value)
{
  return ::Bse::TrackPartHandle::value_get_boxed (value);
}

void
TrackPart::value_set_boxed (GValue *value, const ::Bse::TrackPartHandle & self)
{
  ::Bse::TrackPartHandle::value_set_boxed (value, self);
}

SfiRecFields
TrackPart::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[3 + 1];
      rfields.n_fields = 3;
      fields[0] = sfidl_pspec_Int (NULL,"tick","Tick" , NULL , 0 , 0 , G_MAXINT , 384 , ":r:w:S:G:");
      fields[1] = sfidl_pspec_Object_default (NULL,"part");
      fields[2] = sfidl_pspec_Int (NULL,"duration","Duration" , NULL , 0 , 0 , G_MAXINT , 384 , ":r:w:S:G:");
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::SongTimingHandle
SongTiming::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::SongTimingHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "bpm");
  if (element)
    rec->bpm = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "numerator");
  if (element)
    rec->numerator = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "denominator");
  if (element)
    rec->denominator = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tpqn");
  if (element)
    rec->tpqn = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tpt");
  if (element)
    rec->tpt = sfi_value_get_int (element);
  return rec;
}

SfiRec *
SongTiming::to_rec (const ::Bse::SongTimingHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "tick", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->tick);
  element = sfi_rec_forced_get (sfi_rec, "bpm", SFI_TYPE_REAL);
  sfi_value_set_real (element, rec->bpm);
  element = sfi_rec_forced_get (sfi_rec, "numerator", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->numerator);
  element = sfi_rec_forced_get (sfi_rec, "denominator", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->denominator);
  element = sfi_rec_forced_get (sfi_rec, "tpqn", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->tpqn);
  element = sfi_rec_forced_get (sfi_rec, "tpt", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->tpt);
  return sfi_rec;
}

::Bse::SongTimingHandle
SongTiming::value_get_boxed (const GValue *value)
{
  return ::Bse::SongTimingHandle::value_get_boxed (value);
}

void
SongTiming::value_set_boxed (GValue *value, const ::Bse::SongTimingHandle & self)
{
  ::Bse::SongTimingHandle::value_set_boxed (value, self);
}

SfiRecFields
SongTiming::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[6 + 1];
      rfields.n_fields = 6;
      fields[0] = sfidl_pspec_Int (NULL,"tick","Current tick" , NULL , 0 , 0 , G_MAXINT , 384 , ":r:w:S:G:");
      fields[1] = sfidl_pspec_Real (NULL,"bpm","Beats per minute" , NULL , 120 , BSE_MIN_BPM , BSE_MAX_BPM , 10 , ":r:w:S:G:");
      fields[2] = sfidl_pspec_Int (NULL,"numerator","Numerator" , "Number of notes per measure" , 4 , 1 , 256 , 2 , ":r:w:S:G:");
      fields[3] = sfidl_pspec_Int (NULL,"denominator","Denominator" , "Type of notes counted per measure" , 4 , 1 , 256 , 2 , ":r:w:S:G:");
      fields[4] = sfidl_pspec_Int (NULL,"tpqn","Ticks per quarter note" , NULL , 384 , 1 , G_MAXINT , 12 , ":r:w:S:G:");
      fields[5] = sfidl_pspec_Int (NULL,"tpt","Ticks per tact" , NULL , 384 , 1 , G_MAXINT , 12 , ":r:w:S:G:");
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::SampleFileInfoHandle
SampleFileInfo::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::SampleFileInfoHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "file");
  if (element)
    rec->file = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "size");
  if (element)
    rec->size = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "mtime");
  if (element)
    rec->mtime = sfi_value_get_num (element);
  element = sfi_rec_get (sfi_rec, "loader");
  if (element)
    rec->loader = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "waves");
  if (element)
    rec->waves = ::Bse::StringSeq::value_get_boxed (element);
  element = sfi_rec_get (sfi_rec, "error");
  if (element)
    rec->error = sfi_value_get_int (element);
  return rec;
}

SfiRec *
SampleFileInfo::to_rec (const ::Bse::SampleFileInfoHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "file", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->file);
  element = sfi_rec_forced_get (sfi_rec, "size", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->size);
  element = sfi_rec_forced_get (sfi_rec, "mtime", SFI_TYPE_NUM);
  sfi_value_set_num (element, rec->mtime);
  element = sfi_rec_forced_get (sfi_rec, "loader", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->loader);
  element = sfi_rec_forced_get (sfi_rec, "waves", SFI_TYPE_SEQ);
  ::Bse::StringSeq::value_set_boxed (element, rec->waves);
  element = sfi_rec_forced_get (sfi_rec, "error", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->error);
  return sfi_rec;
}

::Bse::SampleFileInfoHandle
SampleFileInfo::value_get_boxed (const GValue *value)
{
  return ::Bse::SampleFileInfoHandle::value_get_boxed (value);
}

void
SampleFileInfo::value_set_boxed (GValue *value, const ::Bse::SampleFileInfoHandle & self)
{
  ::Bse::SampleFileInfoHandle::value_set_boxed (value, self);
}

SfiRecFields
SampleFileInfo::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[6 + 1];
      rfields.n_fields = 6;
      fields[0] = sfidl_pspec_String (NULL,"file","Filename" , NULL , NULL , ":r:w:S:G:");
      fields[1] = sfidl_pspec_Int (NULL,"size","File Size" , NULL , 0 , 0 , G_MAXINT , 0 , ":r:w:S:G:");
      fields[2] = sfidl_pspec_Num (NULL,"mtime","Modification Time" , NULL , 0 , 0 , SFI_MAXNUM , 0 , ":r:w:S:G:");
      fields[3] = sfidl_pspec_String (NULL,"loader","Loader" , NULL , NULL , ":r:w:S:G:");
      fields[4] = sfidl_pspec_Sequence (NULL, "waves", NULL , NULL , ":r:w:S:G:", Bse::StringSeq::get_element());
      fields[5] = sfidl_pspec_Int (NULL,"error","BseErrorType" , NULL , 0 , 0 , G_MAXINT , 0 , ":r:w:S:G:");
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::UserMsgHandle
UserMsg::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::UserMsgHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "log_domain");
  if (element)
    rec->log_domain = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "msg_type");
  if (element)
    rec->msg_type = (::Bse::UserMsgType) sfi_value_get_enum_auto SFI_START_ARGS() BSE_TYPE_USER_MSG_TYPE, SFI_END_ARGS1 (element);
  element = sfi_rec_get (sfi_rec, "config_blurb");
  if (element)
    rec->config_blurb = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "message");
  if (element)
    rec->message = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "pid");
  if (element)
    rec->pid = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "process");
  if (element)
    rec->process = ::Sfi::String::value_get_string (element);
  return rec;
}

SfiRec *
UserMsg::to_rec (const ::Bse::UserMsgHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "log_domain", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->log_domain);
  element = sfi_rec_forced_get (sfi_rec, "msg_type", SFI_TYPE_CHOICE);
  sfi_value_set_enum_auto SFI_START_ARGS() BSE_TYPE_USER_MSG_TYPE, SFI_END_ARGS2 (element, rec->msg_type);
  element = sfi_rec_forced_get (sfi_rec, "config_blurb", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->config_blurb);
  element = sfi_rec_forced_get (sfi_rec, "message", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->message);
  element = sfi_rec_forced_get (sfi_rec, "pid", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->pid);
  element = sfi_rec_forced_get (sfi_rec, "process", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->process);
  return sfi_rec;
}

::Bse::UserMsgHandle
UserMsg::value_get_boxed (const GValue *value)
{
  return ::Bse::UserMsgHandle::value_get_boxed (value);
}

void
UserMsg::value_set_boxed (GValue *value, const ::Bse::UserMsgHandle & self)
{
  ::Bse::UserMsgHandle::value_set_boxed (value, self);
}

SfiRecFields
UserMsg::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[6 + 1];
      rfields.n_fields = 6;
      fields[0] = sfidl_pspec_String_default (NULL,"log_domain");
      fields[1] = sfidl_pspec_Choice_default (NULL, "msg_type", Bse::UserMsgType_choice_values());
      fields[2] = sfidl_pspec_String_default (NULL,"config_blurb");
      fields[3] = sfidl_pspec_String_default (NULL,"message");
      fields[4] = sfidl_pspec_Int_default (NULL,"pid");
      fields[5] = sfidl_pspec_String_default (NULL,"process");
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::ThreadInfoHandle
ThreadInfo::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::ThreadInfoHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "name");
  if (element)
    rec->name = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "state");
  if (element)
    rec->state = (::Bse::ThreadState) sfi_value_get_enum_auto SFI_START_ARGS() BSE_TYPE_THREAD_STATE, SFI_END_ARGS1 (element);
  element = sfi_rec_get (sfi_rec, "thread_id");
  if (element)
    rec->thread_id = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "priority");
  if (element)
    rec->priority = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "processor");
  if (element)
    rec->processor = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "utime");
  if (element)
    rec->utime = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "stime");
  if (element)
    rec->stime = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "cutime");
  if (element)
    rec->cutime = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "cstime");
  if (element)
    rec->cstime = sfi_value_get_int (element);
  return rec;
}

SfiRec *
ThreadInfo::to_rec (const ::Bse::ThreadInfoHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "name", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->name);
  element = sfi_rec_forced_get (sfi_rec, "state", SFI_TYPE_CHOICE);
  sfi_value_set_enum_auto SFI_START_ARGS() BSE_TYPE_THREAD_STATE, SFI_END_ARGS2 (element, rec->state);
  element = sfi_rec_forced_get (sfi_rec, "thread_id", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->thread_id);
  element = sfi_rec_forced_get (sfi_rec, "priority", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->priority);
  element = sfi_rec_forced_get (sfi_rec, "processor", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->processor);
  element = sfi_rec_forced_get (sfi_rec, "utime", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->utime);
  element = sfi_rec_forced_get (sfi_rec, "stime", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->stime);
  element = sfi_rec_forced_get (sfi_rec, "cutime", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->cutime);
  element = sfi_rec_forced_get (sfi_rec, "cstime", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->cstime);
  return sfi_rec;
}

::Bse::ThreadInfoHandle
ThreadInfo::value_get_boxed (const GValue *value)
{
  return ::Bse::ThreadInfoHandle::value_get_boxed (value);
}

void
ThreadInfo::value_set_boxed (GValue *value, const ::Bse::ThreadInfoHandle & self)
{
  ::Bse::ThreadInfoHandle::value_set_boxed (value, self);
}

SfiRecFields
ThreadInfo::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[9 + 1];
      rfields.n_fields = 9;
      fields[0] = sfidl_pspec_String (NULL,"name",_ ( "Thread Name" ) , NULL , NULL , ":r:w:S:G:");
      fields[1] = sfidl_pspec_Choice (NULL, "state", _ ( "State" ) , _ ( "The execution state of the thread" ) , THREAD_STATE_UNKNOWN , ":r:w:S:G:", Bse::ThreadState_choice_values());
      fields[2] = sfidl_pspec_Int (NULL,"thread_id",_ ( "Thread ID" ) , _ ( "A unique number identifying this thread" ) , 0 , 0 , G_MAXINT , 1 , ":r:w:S:G:");
      fields[3] = sfidl_pspec_Int (NULL,"priority",_ ( "Priority" ) , _ ( "The nice value of a thread, -20 indicates a high priority thread and " "+19 a low priority one that is 'nice' to others" ) , 0 , - 20 , 19 , 1 , ":r:w:S:G:");
      fields[4] = sfidl_pspec_Int (NULL,"processor",_ ( "Processor" ) , _ ( "The processor that this thread is currently being executed on" ) , 0 , 0 , 2147483647LL , 1 , ":r:w:S:G:");
      fields[5] = sfidl_pspec_Int (NULL,"utime",_ ( "User Time" ) , _ ( "The CPU time spent executing instructions of this thread" ) , 0 , 0 , 2147483647LL , 1 , ":r:w:S:G:");
      fields[6] = sfidl_pspec_Int (NULL,"stime",_ ( "System Time" ) , _ ( "The CPU time spent in the system for this thread" ) , 0 , 0 , 2147483647LL , 1 , ":r:w:S:G:");
      fields[7] = sfidl_pspec_Int (NULL,"cutime",_ ( "Child User Time" ) , _ ( "The CPU time spent executing instructions of children of this thread" ) , 0 , 0 , 2147483647LL , 1 , ":r:w:S:G:");
      fields[8] = sfidl_pspec_Int (NULL,"cstime",_ ( "Child System Time" ) , _ ( "The CPU time spent in the system for children of this thread" ) , 0 , 0 , 2147483647LL , 1 , ":r:w:S:G:");
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::ThreadTotalsHandle
ThreadTotals::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::ThreadTotalsHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "main");
  if (element)
    rec->main = ::Bse::ThreadInfo::value_get_boxed (element);
  element = sfi_rec_get (sfi_rec, "sequencer");
  if (element)
    rec->sequencer = ::Bse::ThreadInfo::value_get_boxed (element);
  element = sfi_rec_get (sfi_rec, "synthesis");
  if (element)
    rec->synthesis = ::Bse::ThreadInfoSeq::value_get_boxed (element);
  return rec;
}

SfiRec *
ThreadTotals::to_rec (const ::Bse::ThreadTotalsHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "main", SFI_TYPE_REC);
  ::Bse::ThreadInfo::value_set_boxed (element, rec->main);
  element = sfi_rec_forced_get (sfi_rec, "sequencer", SFI_TYPE_REC);
  ::Bse::ThreadInfo::value_set_boxed (element, rec->sequencer);
  element = sfi_rec_forced_get (sfi_rec, "synthesis", SFI_TYPE_SEQ);
  ::Bse::ThreadInfoSeq::value_set_boxed (element, rec->synthesis);
  return sfi_rec;
}

::Bse::ThreadTotalsHandle
ThreadTotals::value_get_boxed (const GValue *value)
{
  return ::Bse::ThreadTotalsHandle::value_get_boxed (value);
}

void
ThreadTotals::value_set_boxed (GValue *value, const ::Bse::ThreadTotalsHandle & self)
{
  ::Bse::ThreadTotalsHandle::value_set_boxed (value, self);
}

SfiRecFields
ThreadTotals::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[3 + 1];
      rfields.n_fields = 3;
      fields[0] = sfidl_pspec_Record_default (NULL, "main", Bse::ThreadInfo::get_fields());
      fields[1] = sfidl_pspec_Record_default (NULL, "sequencer", Bse::ThreadInfo::get_fields());
      fields[2] = sfidl_pspec_Sequence_default (NULL, "synthesis", Bse::ThreadInfoSeq::get_element());
      rfields.fields = fields;
    }
  return rfields;
}
::Bse::GConfigHandle
GConfig::from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return Sfi::INIT_NULL;

  ::Bse::GConfigHandle rec = Sfi::INIT_DEFAULT;
  element = sfi_rec_get (sfi_rec, "sample_path");
  if (element)
    rec->sample_path = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "effect_path");
  if (element)
    rec->effect_path = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "instrument_path");
  if (element)
    rec->instrument_path = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "script_path");
  if (element)
    rec->script_path = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "plugin_path");
  if (element)
    rec->plugin_path = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "ladspa_path");
  if (element)
    rec->ladspa_path = ::Sfi::String::value_get_string (element);
  element = sfi_rec_get (sfi_rec, "synth_latency");
  if (element)
    rec->synth_latency = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "synth_mixing_freq");
  if (element)
    rec->synth_mixing_freq = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "synth_control_freq");
  if (element)
    rec->synth_control_freq = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "invert_sustain");
  if (element)
    rec->invert_sustain = sfi_value_get_bool (element);
  element = sfi_rec_get (sfi_rec, "step_volume_dB");
  if (element)
    rec->step_volume_dB = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "step_bpm");
  if (element)
    rec->step_bpm = sfi_value_get_int (element);
  return rec;
}

SfiRec *
GConfig::to_rec (const ::Bse::GConfigHandle & rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  if (!rec)
    return NULL;

  sfi_rec = sfi_rec_new ();
  element = sfi_rec_forced_get (sfi_rec, "sample_path", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->sample_path);
  element = sfi_rec_forced_get (sfi_rec, "effect_path", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->effect_path);
  element = sfi_rec_forced_get (sfi_rec, "instrument_path", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->instrument_path);
  element = sfi_rec_forced_get (sfi_rec, "script_path", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->script_path);
  element = sfi_rec_forced_get (sfi_rec, "plugin_path", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->plugin_path);
  element = sfi_rec_forced_get (sfi_rec, "ladspa_path", SFI_TYPE_STRING);
  ::Sfi::String::value_set_string (element, rec->ladspa_path);
  element = sfi_rec_forced_get (sfi_rec, "synth_latency", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->synth_latency);
  element = sfi_rec_forced_get (sfi_rec, "synth_mixing_freq", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->synth_mixing_freq);
  element = sfi_rec_forced_get (sfi_rec, "synth_control_freq", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->synth_control_freq);
  element = sfi_rec_forced_get (sfi_rec, "invert_sustain", SFI_TYPE_BOOL);
  sfi_value_set_bool (element, rec->invert_sustain);
  element = sfi_rec_forced_get (sfi_rec, "step_volume_dB", SFI_TYPE_REAL);
  sfi_value_set_real (element, rec->step_volume_dB);
  element = sfi_rec_forced_get (sfi_rec, "step_bpm", SFI_TYPE_INT);
  sfi_value_set_int (element, rec->step_bpm);
  return sfi_rec;
}

::Bse::GConfigHandle
GConfig::value_get_boxed (const GValue *value)
{
  return ::Bse::GConfigHandle::value_get_boxed (value);
}

void
GConfig::value_set_boxed (GValue *value, const ::Bse::GConfigHandle & self)
{
  ::Bse::GConfigHandle::value_set_boxed (value, self);
}

SfiRecFields
GConfig::get_fields()
{
  static SfiRecFields rfields = { 0, NULL };
  if (!rfields.n_fields)
    {
      static GParamSpec *fields[12 + 1];
      rfields.n_fields = 12;
      fields[0] = sfidl_pspec_String (_("Search Paths"),"sample_path",_ ( "Sample Path" ) , g_intern_printf ( _ ( "Search path of directories, seperated by \"%s\", used to find audio samples." ) , G_SEARCHPATH_SEPARATOR_S ) , bse_intern_path_user_data ( "/samples" ) , ":r:w:S:G:" ":searchpath");
      fields[1] = sfidl_pspec_String (_("Search Paths"),"effect_path",_ ( "Effect Path" ) , g_intern_printf ( _ ( "Search path of directories, seperated by \"%s\", used to find BSE effect files." ) , G_SEARCHPATH_SEPARATOR_S ) , bse_intern_path_user_data ( "/effects" ) , ":r:w:S:G:" ":searchpath");
      fields[2] = sfidl_pspec_String (_("Search Paths"),"instrument_path",_ ( "Instrument Path" ) , g_intern_printf ( _ ( "Search path of directories, seperated by \"%s\", used to find BSE instrument files." ) , G_SEARCHPATH_SEPARATOR_S ) , bse_intern_path_user_data ( "/instruments" ) , ":r:w:S:G:" ":searchpath");
      fields[3] = sfidl_pspec_String (_("Search Paths"),"script_path",_ ( "Script Path" ) , g_intern_printf ( _ ( "Search path of directories, seperated by \"%s\", used to find BSE scheme scripts." ) , G_SEARCHPATH_SEPARATOR_S ) , bse_intern_path_user_data ( "/scripts" ) , ":r:w:S:G:" ":searchpath");
      fields[4] = sfidl_pspec_String (_("Search Paths"),"plugin_path",_ ( "Plugin Path" ) , g_intern_printf ( _ ( "Search path of directories, seperated by \"%s\", used to find BSE plugins. This path " "is searched for in addition to the standard BSE plugin location on this system." ) , G_SEARCHPATH_SEPARATOR_S ) , NULL , ":r:w:S:G:" ":searchpath");
      fields[5] = sfidl_pspec_String (_("Search Paths"),"ladspa_path",_ ( "LADSPA Path" ) , g_intern_printf ( _ ( "Search path of directories, seperated by \"%s\", used to find LADSPA plugins. This " "path is searched for in addition to the standard LADSPA location on this system. " "LADSPA is the Linux Audio Developer's Simple Plugin API, more informations about " "LADSPA plugins can be found at http://www.ladspa.org/." ) , G_SEARCHPATH_SEPARATOR_S ) , NULL , ":r:w:S:G:" ":searchpath");
      fields[6] = sfidl_pspec_Int (_("Synthesis Settings"),"synth_latency",_ ( "Latency [ms]" ) , _ ( "Processing duration between input and output of a single sample, smaller values increase CPU load" ) , 50 , 1 , 2000 , 5 , ":r:w:S:G:");
      fields[7] = sfidl_pspec_Int (_("Synthesis Settings"),"synth_mixing_freq",_ ( "Synth Mixing Frequency" ) , _ ( "Synthesis mixing frequency, common values are: 22050, 44100, 48000" ) , 44100 , 8000 , 192000 , 0 , ":r:w:S:G:");
      fields[8] = sfidl_pspec_Int (_("Synthesis Settings"),"synth_control_freq",_ ( "Synth Control Frequency" ) , _ ( "Frequency at which control values are evaluated, " "should be much smaller than Synth Mixing Frequency to reduce CPU load" ) , 1000 , 1 , 192000 , 0 , ":r:w:S:G:");
      fields[9] = sfidl_pspec_Bool (_("MIDI"),"invert_sustain",_ ( "Invert Sustain Pedal" ) , _ ( "Invert the state of sustain (damper) pedal so on/off meanings are reversed" ) , FALSE , ":r:w:S:G:");
      fields[10] = sfidl_pspec_Real (_("Stepping Rates"),"step_volume_dB",_ ( "Volume [dB] Steps" ) , _ ( "Step width for volume in decibel" ) , 0.10000000000000001 , 0.001 , 5 , 0.01 , ":r:w:S:G:");
      fields[11] = sfidl_pspec_Int (_("Stepping Rates"),"step_bpm",_ ( "BPM Steps" ) , _ ( "Step width for beats per minute" ) , 10 , 1 , 50 , 1 , ":r:w:S:G:");
      rfields.fields = fields;
    }
  return rfields;
}


/* sequence implementations */
::Bse::IntSeq
IntSeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::IntSeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = sfi_value_get_int (element);
    }
  return cseq;
}

SfiSeq *
IntSeq::to_seq (const ::Bse::IntSeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_INT);
      sfi_value_set_int (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::IntSeq
IntSeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< IntSeq> (value);
}

void
IntSeq::value_set_boxed (GValue *value, const ::Bse::IntSeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< IntSeq> (value, self);
}

GParamSpec*
IntSeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_Int_default (NULL,"ints");
  return element;
}

::Bse::NoteSeq
NoteSeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::NoteSeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = sfi_value_get_int (element);
    }
  return cseq;
}

SfiSeq *
NoteSeq::to_seq (const ::Bse::NoteSeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_INT);
      sfi_value_set_int (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::NoteSeq
NoteSeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< NoteSeq> (value);
}

void
NoteSeq::value_set_boxed (GValue *value, const ::Bse::NoteSeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< NoteSeq> (value, self);
}

GParamSpec*
NoteSeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_Note (NULL,"notes","Note" , "" , KAMMER_NOTE , ":readwrite");
  return element;
}

::Bse::StringSeq
StringSeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::StringSeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = ::Sfi::String::value_get_string (element);
    }
  return cseq;
}

SfiSeq *
StringSeq::to_seq (const ::Bse::StringSeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_STRING);
      ::Sfi::String::value_set_string (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::StringSeq
StringSeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< StringSeq> (value);
}

void
StringSeq::value_set_boxed (GValue *value, const ::Bse::StringSeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< StringSeq> (value, self);
}

GParamSpec*
StringSeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_String_default (NULL,"strings");
  return element;
}

::Bse::TypeSeq
TypeSeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::TypeSeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = ::Sfi::String::value_get_string (element);
    }
  return cseq;
}

SfiSeq *
TypeSeq::to_seq (const ::Bse::TypeSeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_STRING);
      ::Sfi::String::value_set_string (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::TypeSeq
TypeSeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< TypeSeq> (value);
}

void
TypeSeq::value_set_boxed (GValue *value, const ::Bse::TypeSeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< TypeSeq> (value, self);
}

GParamSpec*
TypeSeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_String_default (NULL,"types");
  return element;
}

::Bse::ItemSeq
ItemSeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::ItemSeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = ::Bse::CxxBase::value_get_gobject< BseItem> (element);
    }
  return cseq;
}

SfiSeq *
ItemSeq::to_seq (const ::Bse::ItemSeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_PROXY);
      ::Bse::CxxBase::value_set_gobject (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::ItemSeq
ItemSeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< ItemSeq> (value);
}

void
ItemSeq::value_set_boxed (GValue *value, const ::Bse::ItemSeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< ItemSeq> (value, self);
}

GParamSpec*
ItemSeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_Object_default (NULL,"items");
  return element;
}

::Bse::PartNoteSeq
PartNoteSeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::PartNoteSeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = ::Bse::PartNote::value_get_boxed (element);
    }
  return cseq;
}

SfiSeq *
PartNoteSeq::to_seq (const ::Bse::PartNoteSeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_REC);
      ::Bse::PartNote::value_set_boxed (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::PartNoteSeq
PartNoteSeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< PartNoteSeq> (value);
}

void
PartNoteSeq::value_set_boxed (GValue *value, const ::Bse::PartNoteSeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< PartNoteSeq> (value, self);
}

GParamSpec*
PartNoteSeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_Record_default (NULL, "pnotes", Bse::PartNote::get_fields());
  return element;
}

::Bse::PartControlSeq
PartControlSeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::PartControlSeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = ::Bse::PartControl::value_get_boxed (element);
    }
  return cseq;
}

SfiSeq *
PartControlSeq::to_seq (const ::Bse::PartControlSeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_REC);
      ::Bse::PartControl::value_set_boxed (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::PartControlSeq
PartControlSeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< PartControlSeq> (value);
}

void
PartControlSeq::value_set_boxed (GValue *value, const ::Bse::PartControlSeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< PartControlSeq> (value, self);
}

GParamSpec*
PartControlSeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_Record_default (NULL, "pcontrols", Bse::PartControl::get_fields());
  return element;
}

::Bse::CategorySeq
CategorySeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::CategorySeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = ::Bse::Category::value_get_boxed (element);
    }
  return cseq;
}

SfiSeq *
CategorySeq::to_seq (const ::Bse::CategorySeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_REC);
      ::Bse::Category::value_set_boxed (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::CategorySeq
CategorySeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< CategorySeq> (value);
}

void
CategorySeq::value_set_boxed (GValue *value, const ::Bse::CategorySeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< CategorySeq> (value, self);
}

GParamSpec*
CategorySeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_Record_default (NULL, "cats", Bse::Category::get_fields());
  return element;
}

::Bse::DotSeq
DotSeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::DotSeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = ::Bse::Dot::value_get_boxed (element);
    }
  return cseq;
}

SfiSeq *
DotSeq::to_seq (const ::Bse::DotSeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_REC);
      ::Bse::Dot::value_set_boxed (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::DotSeq
DotSeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< DotSeq> (value);
}

void
DotSeq::value_set_boxed (GValue *value, const ::Bse::DotSeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< DotSeq> (value, self);
}

GParamSpec*
DotSeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_Record_default (NULL, "dots", Bse::Dot::get_fields());
  return element;
}

::Bse::TrackPartSeq
TrackPartSeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::TrackPartSeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = ::Bse::TrackPart::value_get_boxed (element);
    }
  return cseq;
}

SfiSeq *
TrackPartSeq::to_seq (const ::Bse::TrackPartSeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_REC);
      ::Bse::TrackPart::value_set_boxed (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::TrackPartSeq
TrackPartSeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< TrackPartSeq> (value);
}

void
TrackPartSeq::value_set_boxed (GValue *value, const ::Bse::TrackPartSeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< TrackPartSeq> (value, self);
}

GParamSpec*
TrackPartSeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_Record_default (NULL, "tparts", Bse::TrackPart::get_fields());
  return element;
}

::Bse::ThreadInfoSeq
ThreadInfoSeq::from_seq (SfiSeq *sfi_seq)
{
  ::Bse::ThreadInfoSeq cseq;
  guint i, length;

  if (!sfi_seq)
    return cseq;

  length = sfi_seq_length (sfi_seq);
  cseq.resize (length);
  for (i = 0; i < length; i++)
    {
      GValue *element = sfi_seq_get (sfi_seq, i);
      cseq[i] = ::Bse::ThreadInfo::value_get_boxed (element);
    }
  return cseq;
}

SfiSeq *
ThreadInfoSeq::to_seq (const ::Bse::ThreadInfoSeq & cseq)
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < cseq.length(); i++)
    {
      GValue *element = sfi_seq_append_empty (sfi_seq, SFI_TYPE_REC);
      ::Bse::ThreadInfo::value_set_boxed (element, cseq[i]);
    }
  return sfi_seq;
}

::Bse::ThreadInfoSeq
ThreadInfoSeq::value_get_boxed (const GValue *value)
{
  return ::Sfi::cxx_value_get_boxed_sequence< ThreadInfoSeq> (value);
}

void
ThreadInfoSeq::value_set_boxed (GValue *value, const ::Bse::ThreadInfoSeq & self)
{
  ::Sfi::cxx_value_set_boxed_sequence< ThreadInfoSeq> (value, self);
}

GParamSpec*
ThreadInfoSeq::get_element()
{
  static GParamSpec *element = NULL;
  if (!element)
    element = sfidl_pspec_Record_default (NULL, "thread_infos", Bse::ThreadInfo::get_fields());
  return element;
}



/* class implementations */


/* procedure implementations */
namespace Procedure {
BSE_CXX_DECLARE_PROC (collect_thread_totals);
class collect_thread_totals {
public:
  static inline const unsigned char* pixstream () { return NULL; }
  static inline const char* options   () { return ""; }
  static inline const char* category  () { static const char *c = NULL;
    return c ? c : c = sfi_category_concat ("/Proc", ""); }
  static inline const char* i18n_category  () { static const char *c = NULL;
    return c ? c : c = sfi_category_concat ("/Proc", ""); }
  static inline const char* blurb     () { return ""; }
  static inline const char* authors   () { return ""; }
  static inline const char* license   () { return ""; }
  static inline const char* type_name () { return "bse-collect-thread-totals"; }
  static ::Bse::ThreadTotalsHandle exec ();
  static BseErrorType marshal (BseProcedureClass *procedure,
                               const GValue      *in_values,
                               GValue            *out_values)
  {
    try {
      ::Bse::ThreadTotalsHandle __return_value =
        exec (
             );
      ::Bse::ThreadTotals::value_set_boxed (out_values, __return_value);
    } catch (std::exception &e) {
      sfi_diag ("%s: %s", "collect_thread_totals", e.what());
      return BSE_ERROR_PROC_EXECUTION;
    } catch (...) {
      sfi_diag ("%s: %s", "collect_thread_totals", "uncaught exception");
      return BSE_ERROR_PROC_EXECUTION;
    }
    return BSE_ERROR_NONE;
  }
  static void init (BseProcedureClass *proc,
                    GParamSpec       **in_pspecs,
                    GParamSpec       **out_pspecs)
  {
    *(out_pspecs++) = sfidl_pspec_BoxedRec_default (NULL, "result", BSE_TYPE_THREAD_TOTALS);
  }
};
} // Procedure



/* bsecore.idl type registrations */
#define BSE_CXX_REGISTER_ALL_TYPES_FROM_BSECORE_IDL() \
  BSE_CXX_REGISTER_ENUM (MidiSignalType); \
  BSE_CXX_REGISTER_ENUM (MidiControlType); \
  BSE_CXX_REGISTER_ENUM (UserMsgType); \
  BSE_CXX_REGISTER_ENUM (ThreadState); \
  BSE_CXX_REGISTER_RECORD (PropertyCandidates); \
  BSE_CXX_REGISTER_RECORD (PartNote); \
  BSE_CXX_REGISTER_RECORD (PartControl); \
  BSE_CXX_REGISTER_RECORD (NoteDescription); \
  BSE_CXX_REGISTER_RECORD (NoteSequence); \
  BSE_CXX_REGISTER_RECORD (Icon); \
  BSE_CXX_REGISTER_RECORD (Category); \
  BSE_CXX_REGISTER_RECORD (Dot); \
  BSE_CXX_REGISTER_RECORD (TrackPart); \
  BSE_CXX_REGISTER_RECORD (SongTiming); \
  BSE_CXX_REGISTER_RECORD (SampleFileInfo); \
  BSE_CXX_REGISTER_RECORD (UserMsg); \
  BSE_CXX_REGISTER_RECORD (ThreadInfo); \
  BSE_CXX_REGISTER_RECORD (ThreadTotals); \
  BSE_CXX_REGISTER_RECORD (GConfig); \
  BSE_CXX_REGISTER_SEQUENCE (IntSeq); \
  BSE_CXX_REGISTER_SEQUENCE (NoteSeq); \
  BSE_CXX_REGISTER_SEQUENCE (StringSeq); \
  BSE_CXX_REGISTER_SEQUENCE (TypeSeq); \
  BSE_CXX_REGISTER_SEQUENCE (ItemSeq); \
  BSE_CXX_REGISTER_SEQUENCE (PartNoteSeq); \
  BSE_CXX_REGISTER_SEQUENCE (PartControlSeq); \
  BSE_CXX_REGISTER_SEQUENCE (CategorySeq); \
  BSE_CXX_REGISTER_SEQUENCE (DotSeq); \
  BSE_CXX_REGISTER_SEQUENCE (TrackPartSeq); \
  BSE_CXX_REGISTER_SEQUENCE (ThreadInfoSeq); \
  BSE_CXX_REGISTER_PROCEDURE (collect_thread_totals); \
  /* bsecore.idl type registrations done */
} // Bse

/*-------- end ../sfi/sfidl generated code --------*/


