
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsebus.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsebus.h>
#include <bse/bsetrack.h>
#include <bse/bsesong.h>
#include <bse/bseundostack.h>


#line 29 "bsebus.proc"


/* --- connect-track --- */
static void
connect_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 31 "bsebus.proc"
 {
#line 33 "bsebus.proc"
  *(in_pspecs++)    = bse_param_spec_object ("sbus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", NULL, NULL, BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 38 "bsebus.proc"
 }
static BseErrorType
#line 38 "bsebus.proc"
connect_track_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 41 "bsebus.proc"
{
#line 42 "bsebus.proc"
  
  BseBus *self = bse_value_get_object (in_values++);
  BseTrack   *track = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 47 "bsebus.proc"
  
  if (!BSE_IS_BUS (self) || !BSE_IS_TRACK (track))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 51 "bsebus.proc"
  
  if (!BSE_ITEM (self)->parent || BSE_ITEM (self)->parent != BSE_ITEM (track)->parent)
    error = BSE_ERROR_SOURCE_PARENT_MISMATCH;
  else
    {
      error = bse_bus_connect (self, BSE_ITEM (track));
      if (!error)
        bse_item_push_undo_proc (self, "disconnect-track", track);
    }

#line 61 "bsebus.proc"
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- disconnect-track --- */
static void
disconnect_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 67 "bsebus.proc"
 {
#line 69 "bsebus.proc"
  *(in_pspecs++)    = bse_param_spec_object ("sbus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", NULL, NULL, BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 74 "bsebus.proc"
 }
static BseErrorType
#line 74 "bsebus.proc"
disconnect_track_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 77 "bsebus.proc"
{
#line 78 "bsebus.proc"
  
  BseBus *self = bse_value_get_object (in_values++);
  BseTrack   *track = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 83 "bsebus.proc"
  
  if (!BSE_IS_BUS (self) || !BSE_IS_TRACK (track))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 87 "bsebus.proc"
  
  if (!BSE_ITEM (self)->parent || BSE_ITEM (self)->parent != BSE_ITEM (track)->parent)
    error = BSE_ERROR_SOURCE_PARENT_MISMATCH;
  else
    {
      error = bse_bus_disconnect (self, BSE_ITEM (track));
      if (!error)
        bse_item_push_undo_proc (self, "connect-track", track);
    }

#line 97 "bsebus.proc"
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- connect-bus --- */
static void
connect_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 103 "bsebus.proc"
 {
#line 105 "bsebus.proc"
  *(in_pspecs++)    = bse_param_spec_object ("sbus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("bus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 110 "bsebus.proc"
 }
static BseErrorType
#line 110 "bsebus.proc"
connect_bus_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 113 "bsebus.proc"
{
#line 114 "bsebus.proc"
  
  BseBus *self = bse_value_get_object (in_values++);
  BseBus *bus = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 119 "bsebus.proc"
  
  if (!BSE_IS_BUS (self) || !BSE_IS_BUS (bus))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 123 "bsebus.proc"
  
  if (!BSE_ITEM (self)->parent || BSE_ITEM (self)->parent != BSE_ITEM (bus)->parent)
    error = BSE_ERROR_SOURCE_PARENT_MISMATCH;
  else
    {
      error = bse_bus_connect (self, BSE_ITEM (bus));
      if (!error)
        bse_item_push_undo_proc (self, "disconnect-bus", bus);
    }

#line 133 "bsebus.proc"
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- disconnect-bus --- */
static void
disconnect_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 139 "bsebus.proc"
 {
#line 141 "bsebus.proc"
  *(in_pspecs++)    = bse_param_spec_object ("sbus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("bus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 146 "bsebus.proc"
 }
static BseErrorType
#line 146 "bsebus.proc"
disconnect_bus_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 149 "bsebus.proc"
{
#line 150 "bsebus.proc"
  
  BseBus *self = bse_value_get_object (in_values++);
  BseBus     *bus = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 155 "bsebus.proc"
  
  if (!BSE_IS_BUS (self) || !BSE_IS_BUS (bus))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 159 "bsebus.proc"
  
  if (!BSE_ITEM (self)->parent || BSE_ITEM (self)->parent != BSE_ITEM (bus)->parent)
    error = BSE_ERROR_SOURCE_PARENT_MISMATCH;
  else
    {
      error = bse_bus_disconnect (self, BSE_ITEM (bus));
      if (!error)
        bse_item_push_undo_proc (self, "connect-bus", bus);
    }
  
#line 169 "bsebus.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- ensure-output --- */
static void
ensure_output_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 175 "bsebus.proc"
 {
#line 177 "bsebus.proc"
  *(in_pspecs++)    = bse_param_spec_object ("bus", NULL, NULL, BSE_TYPE_BUS, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", NULL, NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 181 "bsebus.proc"
 }
static BseErrorType
#line 181 "bsebus.proc"
ensure_output_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 184 "bsebus.proc"
{
#line 185 "bsebus.proc"
  
  BseBus *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 189 "bsebus.proc"
  
  if (!BSE_IS_BUS (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 193 "bsebus.proc"
  
  BseItem *parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent) && !self->bus_outputs)
    {
      BseSong *song = BSE_SONG (parent);
      BseBus *master = bse_song_find_master (song);
      if (master && self != master)
        {
          error = bse_bus_connect (master, BSE_ITEM (self));
          if (!error)
            bse_item_push_undo_proc (master, "disconnect-bus", self);
        }
    }

#line 207 "bsebus.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_connect_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Add a track to the input list of a bus.");
  es->file = "/opt/src/beast/bse/bsebus.proc";
  es->line = 32;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2004 Tim Janik";
}
static BseExportNodeProc __enode_connect_track = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseBus+connect-track", 
    NULL,
    "/Methods/BseBus/General/Connect Track",
    NULL,
    __enode_connect_track__fill_strings,
  },
  0, connect_track_setup, connect_track_exec, 
};
static void
__enode_disconnect_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Remove a track from the input list of a bus.");
  es->file = "/opt/src/beast/bse/bsebus.proc";
  es->line = 68;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2004 Tim Janik";
}
static BseExportNodeProc __enode_disconnect_track = {
  { (BseExportNode*) &__enode_connect_track, BSE_EXPORT_NODE_PROC,
    "BseBus+disconnect-track", 
    NULL,
    "/Methods/BseBus/General/Disconnect Track",
    NULL,
    __enode_disconnect_track__fill_strings,
  },
  0, disconnect_track_setup, disconnect_track_exec, 
};
static void
__enode_connect_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Add a bus to the input list of a bus.");
  es->file = "/opt/src/beast/bse/bsebus.proc";
  es->line = 104;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2004 Tim Janik";
}
static BseExportNodeProc __enode_connect_bus = {
  { (BseExportNode*) &__enode_disconnect_track, BSE_EXPORT_NODE_PROC,
    "BseBus+connect-bus", 
    NULL,
    "/Methods/BseBus/General/Connect Bus",
    NULL,
    __enode_connect_bus__fill_strings,
  },
  0, connect_bus_setup, connect_bus_exec, 
};
static void
__enode_disconnect_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Remove a bus from the input list of a bus.");
  es->file = "/opt/src/beast/bse/bsebus.proc";
  es->line = 140;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2004 Tim Janik";
}
static BseExportNodeProc __enode_disconnect_bus = {
  { (BseExportNode*) &__enode_connect_bus, BSE_EXPORT_NODE_PROC,
    "BseBus+disconnect-bus", 
    NULL,
    "/Methods/BseBus/General/Disconnect Bus",
    NULL,
    __enode_disconnect_bus__fill_strings,
  },
  0, disconnect_bus_setup, disconnect_bus_exec, 
};
static void
__enode_ensure_output__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Ensure that a bus has an output connection.");
  es->file = "/opt/src/beast/bse/bsebus.proc";
  es->line = 176;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "Copyright (C) 2004 Tim Janik";
}
static BseExportNodeProc __enode_ensure_output = {
  { (BseExportNode*) &__enode_disconnect_bus, BSE_EXPORT_NODE_PROC,
    "BseBus+ensure-output", 
    NULL,
    "/Methods/BseBus/General/Ensure Output",
    NULL,
    __enode_ensure_output__fill_strings,
  },
  0, ensure_output_setup, ensure_output_exec, 
};
BseExportNode* bse__builtin_init_bsebus_genprc_c (void);
BseExportNode* bse__builtin_init_bsebus_genprc_c (void)
{
  return (BseExportNode*) &__enode_ensure_output;
}

/*
 * Generated data ends here
 */
