static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_pointer (buffer, _(\"Buffer location\"),                             \n"
"                    _(\"The location where to store the output GeglBuffer\")) \n"
"property_pointer (format, _(\"babl format\"),                                 \n"
"                    _(\"The babl format of the output GeglBuffer, NULL to use input buffer format\"))\n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_NAME     buffer_sink                                          \n"
"#define GEGL_OP_C_SOURCE buffer-sink.c                                        \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->buffer != NULL &&                                                    \n"
"      (o->format == NULL || o->format == gegl_buffer_get_format (input)))     \n"
"    {                                                                         \n"
"      GeglBuffer **output = o->buffer;                                        \n"
"                                                                              \n"
"      *output = gegl_buffer_create_sub_buffer (input, result);                \n"
"    }                                                                         \n"
"  else if (o->buffer != NULL &&                                               \n"
"           o->format != NULL)                                                 \n"
"    {                                                                         \n"
"      GeglBuffer **output = o->buffer;                                        \n"
"                                                                              \n"
"      *output = gegl_buffer_new (gegl_buffer_get_extent (input),              \n"
"                                 o->format);                                  \n"
"                                                                              \n"
"      gegl_buffer_copy (input, NULL, GEGL_ABYSS_NONE,                         \n"
"                        *output, NULL);                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process = process;                                              \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",       \"gegl:buffer-sink\",                                   \n"
"      \"title\",      _(\"Buffer Sink\"),                                     \n"
"      \"categories\", \"programming:output\",                                 \n"
"      \"description\", _(\"Create a new GEGL buffer to write the resulting rendering.\"),\n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
