static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Polarize plug-in --- maps a rectangle to a circle or vice-versa            \n"
" * Copyright (C) 1997 Daniel Dunbar                                           \n"
" * Email: ddunbar@diads.com                                                   \n"
" * WWW:   http://millennium.diads.com/gimp/                                   \n"
" * Copyright (C) 1997 Federico Mena Quintero                                  \n"
" * federico@nuclecu.unam.mx                                                   \n"
" * Copyright (C) 1996 Marc Bless                                              \n"
" * E-mail: bless@ai-lab.fh-furtwangen.de                                      \n"
" * WWW:    www.ai-lab.fh-furtwangen.de/~bless                                 \n"
" *                                                                            \n"
" * Copyright (C) 2011 Robert Sasu <sasu.robert@gmail.com>                     \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (depth, _(\"Circle depth in percent\"), 100.0)                \n"
"  value_range (0.0, 100.0)                                                    \n"
"  ui_meta     (\"unit\", \"percent\")                                         \n"
"                                                                              \n"
"property_double (angle, _(\"Offset angle\"), 0.0)                             \n"
"  value_range   (0.0, 360.0)                                                  \n"
"  ui_meta       (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_boolean (bw, _(\"Map backwards\"), FALSE)                            \n"
"  description    (_(\"Start from the right instead of the left\"))            \n"
"                                                                              \n"
"property_boolean (top, _(\"Map from top\"), TRUE)                             \n"
"  description    (_(\"Put the top row in the middle and the bottom row on the outside\"))\n"
"                                                                              \n"
"property_boolean (polar, _(\"To polar\"), TRUE)                               \n"
"  description    (_(\"Map the image to a circle\"))                           \n"
"                                                                              \n"
"property_int  (pole_x, _(\"X\"), 0)                                           \n"
"  description (_(\"Origin point for the polar coordinates\"))                 \n"
"  value_range (0, G_MAXINT)                                                   \n"
"  ui_meta     (\"unit\", \"pixel-coordinate\")                                \n"
"  ui_meta     (\"axis\", \"x\")                                               \n"
"                                                                              \n"
"property_int  (pole_y, _(\"Y\"), 0)                                           \n"
"  description (_(\"Origin point for the polar coordinates\"))                 \n"
"  value_range (0, G_MAXINT)                                                   \n"
"  ui_meta     (\"unit\", \"pixel-coordinate\")                                \n"
"  ui_meta     (\"axis\", \"y\")                                               \n"
"                                                                              \n"
"property_boolean (middle, _(\"Choose middle\"), TRUE)                         \n"
"  description(_(\"Let origin point to be the middle one\"))                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     polar_coordinates                                    \n"
"#define GEGL_OP_C_SOURCE polar-coordinates.c                                  \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define WITHIN(a, b, c) ((((a) <= (b)) && ((b) <= (c))) ? 1 : 0)              \n"
"#define SQR(x) (x)*(x)                                                        \n"
"                                                                              \n"
"#define SCALE_WIDTH     200                                                   \n"
"#define ENTRY_WIDTH      60                                                   \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",                            \n"
"                             babl_format (\"RGBA float\"));                   \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                             babl_format (\"RGBA float\"));                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"calc_undistorted_coords (gdouble        wx,                                   \n"
"                         gdouble        wy,                                   \n"
"                         gdouble       *x,                                    \n"
"                         gdouble       *y,                                    \n"
"                         GeglProperties    *o,                                \n"
"                         GeglRectangle  boundary)                             \n"
"{                                                                             \n"
"  gboolean inside;                                                            \n"
"  gdouble  phi, phi2;                                                         \n"
"  gdouble  xx, xm, ym, yy;                                                    \n"
"  gint     xdiff, ydiff;                                                      \n"
"  gdouble  r;                                                                 \n"
"  gdouble  m;                                                                 \n"
"  gdouble  xmax, ymax, rmax;                                                  \n"
"  gdouble  x_calc, y_calc;                                                    \n"
"  gdouble  xi, yi, cen_x, cen_y;                                              \n"
"  gdouble  circle, angl, t, angle;                                            \n"
"  gint     x1, x2, y1, y2;                                                    \n"
"                                                                              \n"
"  /* initialize */                                                            \n"
"                                                                              \n"
"  phi = 0.0;                                                                  \n"
"  r   = 0.0;                                                                  \n"
"                                                                              \n"
"  x1     = 0;                                                                 \n"
"  y1     = 0;                                                                 \n"
"  x2     = boundary.width;                                                    \n"
"  y2     = boundary.height;                                                   \n"
"  xdiff  = x2 - x1;                                                           \n"
"  ydiff  = y2 - y1;                                                           \n"
"  xm     = xdiff / 2.0;                                                       \n"
"  ym     = ydiff / 2.0;                                                       \n"
"  circle = o->depth;                                                          \n"
"  angle  = o->angle;                                                          \n"
"  angl   = (gdouble) angle / 180.0 * G_PI;                                    \n"
"  cen_x  = o->pole_x;                                                         \n"
"  cen_y  = o->pole_y;                                                         \n"
"                                                                              \n"
"                                                                              \n"
"  if (o->polar)                                                               \n"
"    {                                                                         \n"
"      if (wx >= cen_x)                                                        \n"
"        {                                                                     \n"
"          if (wy > cen_y)                                                     \n"
"            {                                                                 \n"
"              phi = G_PI - atan (((double)(wx - cen_x))/                      \n"
"                                 ((double)(wy - cen_y)));                     \n"
"            }                                                                 \n"
"          else if (wy < cen_y)                                                \n"
"            {                                                                 \n"
"              phi = atan (((double)(wx - cen_x))/((double)(cen_y - wy)));     \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              phi = G_PI / 2;                                                 \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else if (wx < cen_x)                                                    \n"
"        {                                                                     \n"
"          if (wy < cen_y)                                                     \n"
"            {                                                                 \n"
"              phi = 2 * G_PI - atan (((double)(cen_x -wx)) /                  \n"
"                                     ((double)(cen_y - wy)));                 \n"
"            }                                                                 \n"
"          else if (wy > cen_y)                                                \n"
"            {                                                                 \n"
"              phi = G_PI + atan (((double)(cen_x - wx))/                      \n"
"                                 ((double)(wy - cen_y)));                     \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              phi = 1.5 * G_PI;                                               \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      r   = sqrt (SQR (wx - cen_x) + SQR (wy - cen_y));                       \n"
"                                                                              \n"
"      if (wx != cen_x)                                                        \n"
"        {                                                                     \n"
"          m = fabs (((double)(wy - cen_y)) / ((double)(wx - cen_x)));         \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          m = 0;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (m <= ((double)(y2 - y1) / (double)(x2 - x1)))                       \n"
"        {                                                                     \n"
"          if (wx == cen_x)                                                    \n"
"            {                                                                 \n"
"              xmax = 0;                                                       \n"
"              ymax = cen_y - y1;                                              \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              xmax = cen_x - x1;                                              \n"
"              ymax = m * xmax;                                                \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          ymax = cen_y - y1;                                                  \n"
"          xmax = ymax / m;                                                    \n"
"        }                                                                     \n"
"                                                                              \n"
"      rmax = sqrt ( (double)(SQR (xmax) + SQR (ymax)) );                      \n"
"                                                                              \n"
"      t = ((cen_y - y1) < (cen_x - x1)) ? (cen_y - y1) : (cen_x - x1);        \n"
"      rmax = (rmax - t) / 100 * (100 - circle) + t;                           \n"
"                                                                              \n"
"      phi = fmod (phi + angl, 2*G_PI);                                        \n"
"                                                                              \n"
"      if (o->bw)                                                              \n"
"        x_calc = x2 - 1 - (x2 - x1 - 1)/(2*G_PI) * phi;                       \n"
"      else                                                                    \n"
"        x_calc = (x2 - x1 - 1)/(2*G_PI) * phi + x1;                           \n"
"                                                                              \n"
"      if (o->top)                                                             \n"
"        y_calc = (y2 - y1)/rmax   * r   + y1;                                 \n"
"      else                                                                    \n"
"        y_calc = y2 - (y2 - y1)/rmax * r;                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      if (o->bw)                                                              \n"
"        phi = (2 * G_PI) * (x2 - wx) / xdiff;                                 \n"
"      else                                                                    \n"
"        phi = (2 * G_PI) * (wx - x1) / xdiff;                                 \n"
"                                                                              \n"
"      phi = fmod (phi + angl, 2 * G_PI);                                      \n"
"                                                                              \n"
"      if (phi >= 1.5 * G_PI)                                                  \n"
"        phi2 = 2 * G_PI - phi;                                                \n"
"      else if (phi >= G_PI)                                                   \n"
"        phi2 = phi - G_PI;                                                    \n"
"      else if (phi >= 0.5 * G_PI)                                             \n"
"        phi2 = G_PI - phi;                                                    \n"
"      else                                                                    \n"
"        phi2 = phi;                                                           \n"
"                                                                              \n"
"      xx = tan (phi2);                                                        \n"
"      if (xx != 0)                                                            \n"
"        m = (double) 1.0 / xx;                                                \n"
"      else                                                                    \n"
"        m = 0;                                                                \n"
"                                                                              \n"
"      if (m <= ((double)(ydiff) / (double)(xdiff)))                           \n"
"        {                                                                     \n"
"          if (phi2 == 0)                                                      \n"
"            {                                                                 \n"
"              xmax = 0;                                                       \n"
"              ymax = ym - y1;                                                 \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              xmax = xm - x1;                                                 \n"
"              ymax = m * xmax;                                                \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          ymax = ym - y1;                                                     \n"
"          xmax = ymax / m;                                                    \n"
"        }                                                                     \n"
"                                                                              \n"
"      rmax = sqrt ((double)(SQR (xmax) + SQR (ymax)));                        \n"
"                                                                              \n"
"      t = ((ym - y1) < (xm - x1)) ? (ym - y1) : (xm - x1);                    \n"
"                                                                              \n"
"      rmax = (rmax - t) / 100.0 * (100 - circle) + t;                         \n"
"                                                                              \n"
"      if (o->top)                                                             \n"
"        r = rmax * (double)((wy - y1) / (double)(ydiff));                     \n"
"      else                                                                    \n"
"        r = rmax * (double)((y2 - wy) / (double)(ydiff));                     \n"
"                                                                              \n"
"      xx = r * sin (phi2);                                                    \n"
"      yy = r * cos (phi2);                                                    \n"
"                                                                              \n"
"      if (phi >= 1.5 * G_PI)                                                  \n"
"        {                                                                     \n"
"          x_calc = (double)xm - xx;                                           \n"
"          y_calc = (double)ym - yy;                                           \n"
"        }                                                                     \n"
"      else if (phi >= G_PI)                                                   \n"
"        {                                                                     \n"
"          x_calc = (double)xm - xx;                                           \n"
"          y_calc = (double)ym + yy;                                           \n"
"        }                                                                     \n"
"      else if (phi >= 0.5 * G_PI)                                             \n"
"        {                                                                     \n"
"          x_calc = (double)xm + xx;                                           \n"
"          y_calc = (double)ym + yy;                                           \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          x_calc = (double)xm + xx;                                           \n"
"          y_calc = (double)ym - yy;                                           \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  xi = (int) (x_calc + 0.5);                                                  \n"
"  yi = (int) (y_calc + 0.5);                                                  \n"
"                                                                              \n"
"  inside = (WITHIN (0, xi, boundary.width - 1) && WITHIN (0, yi, boundary.height - 1));\n"
"  if (inside)                                                                 \n"
"    {                                                                         \n"
"      *x = x_calc;                                                            \n"
"      *y = y_calc;                                                            \n"
"    }                                                                         \n"
"  return inside;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_effective_area (GeglOperation *operation)                                 \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  gegl_rectangle_copy(&result, in_rect);                                      \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties          *o            = GEGL_PROPERTIES (operation);        \n"
"  GeglRectangle            boundary     = get_effective_area (operation);     \n"
"  const Babl              *format       = babl_format (\"RGBA float\");       \n"
"  GeglSampler             *sampler      = gegl_buffer_sampler_new_at_level (  \n"
"                                    input, format, GEGL_SAMPLER_NOHALO,       \n"
"                                    level);                                   \n"
"                                                                              \n"
"  gint      x,y;                                                              \n"
"  gfloat   *src_buf, *dst_buf;                                                \n"
"  gfloat    dest[4];                                                          \n"
"  gint      i, offset = 0;                                                    \n"
"  gboolean  inside;                                                           \n"
"  gdouble   px, py;                                                           \n"
"                                                                              \n"
"  GeglMatrix2  scale;        /* a matrix indicating scaling factors around the\n"
"                                current center pixel.                         \n"
"                             */                                               \n"
"                                                                              \n"
"  src_buf = g_new0 (gfloat, result->width * result->height * 4);              \n"
"  dst_buf = g_new0 (gfloat, result->width * result->height * 4);              \n"
"                                                                              \n"
"  gegl_buffer_get (input, result, 1.0, format, src_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"                                                                              \n"
"  if (o->middle)                                                              \n"
"    {                                                                         \n"
"      o->pole_x = boundary.width / 2;                                         \n"
"      o->pole_y = boundary.height / 2;                                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  for (y = result->y; y < result->y + result->height; y++)                    \n"
"    for (x = result->x; x < result->x + result->width; x++)                   \n"
"      {                                                                       \n"
"#define gegl_unmap(u,v,ud,vd) {                                         \\    \n"
"          gdouble rx = 0.0, ry = 0.0;                                   \\    \n"
"          inside = calc_undistorted_coords ((gdouble)x, (gdouble)y,     \\    \n"
"                                            &rx, &ry, o, boundary);     \\    \n"
"          ud = rx;                                                      \\    \n"
"          vd = ry;                                                      \\    \n"
"        }                                                                     \n"
"        gegl_sampler_compute_scale (scale, x, y);                             \n"
"        gegl_unmap(x,y,px,py);                                                \n"
"#undef gegl_unmap                                                             \n"
"                                                                              \n"
"        if (inside)                                                           \n"
"          gegl_sampler_get (sampler, px, py, &scale, dest,                    \n"
"                            GEGL_ABYSS_NONE);                                 \n"
"        else                                                                  \n"
"          for (i=0; i<4; i++)                                                 \n"
"            dest[i] = 0.0;                                                    \n"
"                                                                              \n"
"        for (i=0; i<4; i++)                                                   \n"
"          dst_buf[offset++] = dest[i];                                        \n"
"      }                                                                       \n"
"                                                                              \n"
"  gegl_buffer_set (output, result, 0, format, dst_buf, GEGL_AUTO_ROWSTRIDE);  \n"
"                                                                              \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"                                                                              \n"
"  g_object_unref (sampler);                                                   \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"                                                                              \n"
"  return *in_rect;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_bounding_box        = get_bounding_box;                \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  filter_class->process                    = process;                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:polar-coordinates\",                       \n"
"    \"title\",              _(\"Polar Coordinates\"),                         \n"
"    \"categories\",         \"transform:map\",                                \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"description\", _(\"Convert image to or from polar coordinates\"),       \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
