static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright (C) 2013 Marek Dvoroznak <dvoromar@gmail.com>                    \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"property_pointer (model, _(\"Model\"), NULL)                                  \n"
"description (_(\"Model - basic element we operate on\"))                      \n"
"                                                                              \n"
"property_int  (square_size, _(\"Square Size\"), 20)                           \n"
"value_range (5, 1000)                                                         \n"
"description(_(\"Size of an edge of square the mesh consists of\"))            \n"
"                                                                              \n"
"property_int (rigidity,    _(\"Rigidity\"), 100)                              \n"
"value_range (0, 10000)                                                        \n"
"description(_(\"The number of deformation iterations\"))                      \n"
"                                                                              \n"
"property_boolean (asap_deformation, _(\"ASAP Deformation\"), FALSE)           \n"
"description(_(\"ASAP deformation is performed when TRUE, ARAP deformation otherwise\"))\n"
"                                                                              \n"
"property_boolean (mls_weights, _(\"MLS Weights\"), FALSE)                     \n"
"description(_(\"Use MLS weights\"))                                           \n"
"                                                                              \n"
"property_double  (mls_weights_alpha, _(\"MLS Weights Alpha\"), 1.0)           \n"
"value_range (0.1, 2.0)                                                        \n"
"description(_(\"Alpha parameter of MLS weights\"))                            \n"
"                                                                              \n"
"property_boolean (preserve_model, _(\"Preserve Model\"), FALSE)               \n"
"description(_(\"When TRUE the model will not be freed\"))                     \n"
"                                                                              \n"
"property_enum (sampler_type, _(\"Sampler\"),                                  \n"
"                    GeglSamplerType, gegl_sampler_type,                       \n"
"                    GEGL_SAMPLER_CUBIC)                                       \n"
"description(_(\"Sampler used internally\"))                                   \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     npd                                                  \n"
"#define GEGL_OP_C_SOURCE npd.c                                                \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <math.h>                                                             \n"
"#include <npd/npd.h>                                                          \n"
"#include <npd/npd_gegl.h>                                                     \n"
"                                                                              \n"
"struct _NPDDisplay                                                            \n"
"{                                                                             \n"
"  NPDImage  image;                                                            \n"
"};                                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gboolean  first_run;                                                        \n"
"  NPDModel *model;                                                            \n"
"} NPDProperties;                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  NPDProperties *props;                                                       \n"
"  if (o->user_data == NULL)                                                   \n"
"    {                                                                         \n"
"      props = g_new (NPDProperties, 1);                                       \n"
"      props->first_run      = TRUE;                                           \n"
"      props->model          = o->model;                                       \n"
"      o->user_data         = props;                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"#define NPD_BLEND_BAND(src,dst,src_alpha,dst_alpha,out_alpha_recip) \\        \n"
"(src * src_alpha + dst * dst_alpha * (1 - src_alpha)) * out_alpha_recip;      \n"
"                                                                              \n"
"static void                                                                   \n"
"npd_gegl_process_pixel (NPDImage *input_image,                                \n"
"                        gfloat    ix,                                         \n"
"                        gfloat    iy,                                         \n"
"                        NPDImage *output_image,                               \n"
"                        gfloat    ox,                                         \n"
"                        gfloat    oy,                                         \n"
"                        NPDSettings settings)                                 \n"
"{                                                                             \n"
"  if (ox > -1 && ox < output_image->width &&                                  \n"
"      oy > -1 && oy < output_image->height)                                   \n"
"    {                                                                         \n"
"      gint    position = 4 * (((gint) oy) * output_image->width + ((gint) ox));\n"
"      gfloat  sample_color[4];                                                \n"
"      gfloat *dst_color = &output_image->buffer_f[position];                  \n"
"      gfloat  src_A, dst_A, out_alpha, out_alpha_recip;                       \n"
"      gegl_buffer_sample (input_image->gegl_buffer, ix, iy, NULL,             \n"
"                          sample_color, output_image->format,                 \n"
"                          output_image->sampler_type, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"      /* suppose that output_image has RGBA float pixel format - and what about endianness? */\n"
"      src_A = sample_color[3];                                                \n"
"      dst_A = dst_color[3];                                                   \n"
"      out_alpha = src_A + dst_A * (1 - src_A);                                \n"
"      if (out_alpha > 0)                                                      \n"
"        {                                                                     \n"
"          out_alpha_recip = 1 / out_alpha;                                    \n"
"          dst_color[0] = NPD_BLEND_BAND (sample_color[0], dst_color[0], src_A, dst_A, out_alpha_recip);\n"
"          dst_color[1] = NPD_BLEND_BAND (sample_color[1], dst_color[1], src_A, dst_A, out_alpha_recip);\n"
"          dst_color[2] = NPD_BLEND_BAND (sample_color[2], dst_color[2], src_A, dst_A, out_alpha_recip);\n"
"        }                                                                     \n"
"      dst_color[3] = out_alpha;                                               \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"#undef NPD_BLEND_BAND                                                         \n"
"                                                                              \n"
"static void                                                                   \n"
"npd_gegl_get_pixel_color_f (NPDImage *image,                                  \n"
"                            gint      x,                                      \n"
"                            gint      y,                                      \n"
"                            NPDColor *color)                                  \n"
"{                                                                             \n"
"  gegl_buffer_sample (image->gegl_buffer, x, y, NULL,                         \n"
"                      &color->color, babl_format (\"RGBA u8\"),               \n"
"                      GEGL_SAMPLER_NEAREST, GEGL_ABYSS_NONE);                 \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties*o          = GEGL_PROPERTIES (operation);                    \n"
"  const Babl    *format_f   = babl_format (\"RGBA float\");                   \n"
"  NPDProperties *props      = o->user_data;                                   \n"
"  NPDModel      *model      = props->model;                                   \n"
"  gboolean       have_model = model != NULL;                                  \n"
"  NPDDisplay    *display    = NULL;                                           \n"
"                                                                              \n"
"  if (props->first_run)                                                       \n"
"    {                                                                         \n"
"      NPDImage *input_image = g_new (NPDImage, 1);                            \n"
"      display = g_new (NPDDisplay, 1);                                        \n"
"                                                                              \n"
"      npd_init (NULL,                                                         \n"
"                npd_gegl_get_pixel_color_f,                                   \n"
"                npd_gegl_process_pixel, NULL);                                \n"
"                                                                              \n"
"      npd_gegl_init_image (&display->image, output, format_f);                \n"
"      display->image.sampler_type = o->sampler_type;                          \n"
"      npd_gegl_init_image (input_image, input, gegl_buffer_get_format (output));\n"
"                                                                              \n"
"      if (!have_model)                                                        \n"
"        {                                                                     \n"
"          model = props->model = o->model = g_new (NPDModel, 1);              \n"
"          gegl_buffer_copy (input, NULL, GEGL_ABYSS_NONE,                     \n"
"                            output, NULL);                                    \n"
"          display->image.buffer_f = (gfloat*) gegl_buffer_linear_open (display->image.gegl_buffer,\n"
"                                                                       NULL,  \n"
"                                                                      &display->image.rowstride,\n"
"                                                                       format_f);\n"
"          npd_create_model_from_image (model, input_image,                    \n"
"                                       input_image->width, input_image->height,\n"
"                                       0, 0, o->square_size);                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      model->reference_image = input_image;                                   \n"
"      model->display = display;                                               \n"
"      props->first_run = FALSE;                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (have_model)                                                             \n"
"    {                                                                         \n"
"      display = model->display;                                               \n"
"                                                                              \n"
"      npd_set_deformation_type (model, o->asap_deformation, o->mls_weights);  \n"
"                                                                              \n"
"      if (o->mls_weights &&                                                   \n"
"          model->hidden_model->MLS_weights_alpha != o->mls_weights_alpha)     \n"
"        {                                                                     \n"
"          model->hidden_model->MLS_weights_alpha = o->mls_weights_alpha;      \n"
"          npd_compute_MLS_weights (model);                                    \n"
"        }                                                                     \n"
"                                                                              \n"
"      gegl_buffer_clear (display->image.gegl_buffer, NULL);                   \n"
"      display->image.buffer_f = (gfloat*) gegl_buffer_linear_open (display->image.gegl_buffer,\n"
"                                                                   NULL,      \n"
"                                                                  &display->image.rowstride,\n"
"                                                                   format_f); \n"
"                                                                              \n"
"      npd_deform_model (model, o->rigidity);                                  \n"
"      npd_draw_model_into_image (model, &display->image);                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_linear_close (display->image.gegl_buffer, display->image.buffer_f);\n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      NPDProperties *props   = o->user_data;                                  \n"
"      NPDModel      *model   = props->model;                                  \n"
"      NPDDisplay    *display = model->display;                                \n"
"                                                                              \n"
"      g_free (display);                                                       \n"
"      g_free (model->reference_image);                                        \n"
"      if (!o->preserve_model)                                                 \n"
"        {                                                                     \n"
"          npd_destroy_model (model);                                          \n"
"          g_free (model);                                                     \n"
"        }                                                                     \n"
"                                                                              \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  operation_class->prepare = prepare;                                         \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"categories\"  , \"transform\",                                          \n"
"    \"name\"        , \"gegl:npd\",                                           \n"
"    \"description\" , _(\"Performs n-point image deformation\"),              \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
