static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2013 Michael Henning <drawoc@darkrefraction.com>                 \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Target path and filename, use '-' for stdout\"))           \n"
"                                                                              \n"
"property_int (quality, _(\"Quality\"), 90)                                    \n"
"  description (_(\"WebP compression quality\"))                               \n"
"  value_range (1, 100)                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_NAME webp_save                                                \n"
"#define GEGL_OP_C_SOURCE webp-save.c                                          \n"
"                                                                              \n"
"#include <gegl-op.h>                                                          \n"
"#include <gegl-gio-private.h>                                                 \n"
"#include <webp/encode.h>                                                      \n"
"                                                                              \n"
"static int                                                                    \n"
"write_to_stream (const uint8_t*     data,                                     \n"
"                 size_t             size,                                     \n"
"                 const WebPPicture* picture)                                  \n"
"{                                                                             \n"
"  GOutputStream *stream = (GOutputStream *) picture->custom_ptr;              \n"
"  GError *error = NULL;                                                       \n"
"  gboolean success;                                                           \n"
"  gsize written;                                                              \n"
"                                                                              \n"
"  g_assert (stream);                                                          \n"
"                                                                              \n"
"  success = g_output_stream_write_all (G_OUTPUT_STREAM (stream),              \n"
"                                       (const void *) data, size, &written,   \n"
"                                       NULL, &error);                         \n"
"  if (!success || error != NULL)                                              \n"
"    {                                                                         \n"
"      g_warning (\"%s\", error->message);                                     \n"
"      g_error_free (error);                                                   \n"
"      return 0;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  return 1;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"save_RGBA (WebPPicture         *picture,                                      \n"
"           GeglBuffer          *input,                                        \n"
"           const GeglRectangle *result,                                       \n"
"           const Babl          *format)                                       \n"
"{                                                                             \n"
"  gint bytes_per_pixel, bytes_per_row;                                        \n"
"  uint8_t *buffer;                                                            \n"
"                                                                              \n"
"  bytes_per_pixel = babl_format_get_bytes_per_pixel (format);                 \n"
"  bytes_per_row = bytes_per_pixel * result->width;                            \n"
"                                                                              \n"
"  buffer = g_try_new (uint8_t, bytes_per_row * result->height);               \n"
"                                                                              \n"
"  g_assert (buffer != NULL);                                                  \n"
"                                                                              \n"
"  gegl_buffer_get (input, result, 1.0, format, buffer,                        \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                     \n"
"                                                                              \n"
"  WebPPictureImportRGBA (picture, buffer, bytes_per_row);                     \n"
"                                                                              \n"
"  g_free (buffer);                                                            \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"export_webp (GeglOperation       *operation,                                  \n"
"             GeglBuffer          *input,                                      \n"
"             const GeglRectangle *result,                                     \n"
"             GOutputStream       *stream)                                     \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  WebPConfig config;                                                          \n"
"  WebPPicture picture;                                                        \n"
"  const Babl *format;                                                         \n"
"  gint status;                                                                \n"
"                                                                              \n"
"  g_return_val_if_fail (stream != NULL, FALSE);                               \n"
"                                                                              \n"
"  if (!WebPConfigInit (&config) || !WebPPictureInit (&picture))               \n"
"    {                                                                         \n"
"      g_warning (\"could not initialize WebP encoder\");                      \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!WebPConfigPreset (&config, WEBP_PRESET_DEFAULT, o->quality))           \n"
"    {                                                                         \n"
"      g_warning(\"could not load WebP default preset\");                      \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  picture.width = result->width;                                              \n"
"  picture.height = result->height;                                            \n"
"                                                                              \n"
"  format = babl_format (\"R'G'B'A u8\");                                      \n"
"                                                                              \n"
"  if (!WebPValidateConfig (&config))                                          \n"
"    {                                                                         \n"
"      g_warning (\"WebP encoder configuration is invalid\");                  \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  picture.writer = write_to_stream;                                           \n"
"  picture.custom_ptr = stream;                                                \n"
"                                                                              \n"
"  if (save_RGBA (&picture, input, result, format))                            \n"
"    {                                                                         \n"
"      g_warning (\"could not pass pixels data to WebP encoder\");             \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  status = WebPEncode (&config, &picture);                                    \n"
"                                                                              \n"
"  WebPPictureFree (&picture);                                                 \n"
"                                                                              \n"
"  return status ? TRUE : FALSE;                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GOutputStream *stream;                                                      \n"
"  GFile *file = NULL;                                                         \n"
"  GError *error = NULL;                                                       \n"
"  gboolean status = TRUE;                                                     \n"
"                                                                              \n"
"  stream = gegl_gio_open_output_stream (NULL, o->path, &file, &error);        \n"
"  if (stream == NULL)                                                         \n"
"    {                                                                         \n"
"      status = FALSE;                                                         \n"
"      g_warning (\"%s\", error->message);                                     \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!export_webp (operation, input, result, stream))                        \n"
"    {                                                                         \n"
"      status = FALSE;                                                         \n"
"      g_warning (\"could not export WebP file\");                             \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"cleanup:                                                                      \n"
"  if (stream != NULL)                                                         \n"
"    g_object_unref (stream);                                                  \n"
"                                                                              \n"
"  if (file != NULL)                                                           \n"
"    g_object_unref (file);                                                    \n"
"                                                                              \n"
"  return status;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process    = process;                                           \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",          \"gegl:webp-save\",                                    \n"
"    \"title\",       _(\"WebP File Saver\"),                                  \n"
"    \"categories\",    \"output\",                                            \n"
"    \"description\", _(\"WebP image saver\"),                                 \n"
"     NULL);                                                                   \n"
"                                                                              \n"
"  gegl_operation_handlers_register_saver (                                    \n"
"    \".webp\", \"gegl:webp-save\");                                           \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
