static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2016 Red Hat, Inc.                                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (scale, _(\"Scale\"), 1.0)                                    \n"
"    description(_(\"Scale, strength of effect\"))                             \n"
"    value_range (0.0, 10.0)                                                   \n"
"    ui_range (0.0, 2.0)                                                       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     saturation                                           \n"
"#define GEGL_OP_C_SOURCE saturation.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"typedef void (*ProcessFunc) (GeglOperation       *operation,                  \n"
"                             void                *in_buf,                     \n"
"                             void                *out_buf,                    \n"
"                             glong                n_pixels,                   \n"
"                             const GeglRectangle *roi,                        \n"
"                             gint                 level);                     \n"
"                                                                              \n"
"static void                                                                   \n"
"process_lab (GeglOperation       *operation,                                  \n"
"             void                *in_buf,                                     \n"
"             void                *out_buf,                                    \n"
"             glong                n_pixels,                                   \n"
"             const GeglRectangle *roi,                                        \n"
"             gint                 level)                                      \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat *in = in_buf;                                                        \n"
"  gfloat *out = out_buf;                                                      \n"
"  glong i;                                                                    \n"
"                                                                              \n"
"  for (i = 0; i < n_pixels; i++)                                              \n"
"    {                                                                         \n"
"      out[0] = in[0];                                                         \n"
"      out[1] = in[1] * o->scale;                                              \n"
"      out[2] = in[2] * o->scale;                                              \n"
"                                                                              \n"
"      in += 3;                                                                \n"
"      out += 3;                                                               \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"process_lab_alpha (GeglOperation       *operation,                            \n"
"                   void                *in_buf,                               \n"
"                   void                *out_buf,                              \n"
"                   glong                n_pixels,                             \n"
"                   const GeglRectangle *roi,                                  \n"
"                   gint                 level)                                \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat *in = in_buf;                                                        \n"
"  gfloat *out = out_buf;                                                      \n"
"  glong i;                                                                    \n"
"                                                                              \n"
"  for (i = 0; i < n_pixels; i++)                                              \n"
"    {                                                                         \n"
"      out[0] = in[0];                                                         \n"
"      out[1] = in[1] * o->scale;                                              \n"
"      out[2] = in[2] * o->scale;                                              \n"
"      out[3] = in[3];                                                         \n"
"                                                                              \n"
"      in += 4;                                                                \n"
"      out += 4;                                                               \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"process_lch (GeglOperation       *operation,                                  \n"
"             void                *in_buf,                                     \n"
"             void                *out_buf,                                    \n"
"             glong                n_pixels,                                   \n"
"             const GeglRectangle *roi,                                        \n"
"             gint                 level)                                      \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat *in = in_buf;                                                        \n"
"  gfloat *out = out_buf;                                                      \n"
"  glong i;                                                                    \n"
"                                                                              \n"
"  for (i = 0; i < n_pixels; i++)                                              \n"
"    {                                                                         \n"
"      out[0] = in[0];                                                         \n"
"      out[1] = in[1] * o->scale;                                              \n"
"      out[2] = in[2];                                                         \n"
"                                                                              \n"
"      in += 3;                                                                \n"
"      out += 3;                                                               \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"process_lch_alpha (GeglOperation       *operation,                            \n"
"                   void                *in_buf,                               \n"
"                   void                *out_buf,                              \n"
"                   glong                n_pixels,                             \n"
"                   const GeglRectangle *roi,                                  \n"
"                   gint                 level)                                \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat *in = in_buf;                                                        \n"
"  gfloat *out = out_buf;                                                      \n"
"  glong i;                                                                    \n"
"                                                                              \n"
"  for (i = 0; i < n_pixels; i++)                                              \n"
"    {                                                                         \n"
"      out[0] = in[0];                                                         \n"
"      out[1] = in[1] * o->scale;                                              \n"
"      out[2] = in[2];                                                         \n"
"      out[3] = in[3];                                                         \n"
"                                                                              \n"
"      in += 4;                                                                \n"
"      out += 4;                                                               \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl *format;                                                         \n"
"  const Babl *input_format;                                                   \n"
"  const Babl *input_model;                                                    \n"
"  const Babl *lch_model;                                                      \n"
"                                                                              \n"
"  input_format = gegl_operation_get_source_format (operation, \"input\");     \n"
"  if (input_format == NULL)                                                   \n"
"    return;                                                                   \n"
"                                                                              \n"
"  input_model = babl_format_get_model (input_format);                         \n"
"                                                                              \n"
"  if (babl_format_has_alpha (input_format))                                   \n"
"    {                                                                         \n"
"      lch_model = babl_model (\"CIE LCH(ab) alpha\");                         \n"
"      if (input_model == lch_model)                                           \n"
"        {                                                                     \n"
"          format = babl_format (\"CIE LCH(ab) alpha float\");                 \n"
"          o->user_data = process_lch_alpha;                                   \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          format = babl_format (\"CIE Lab alpha float\");                     \n"
"          o->user_data = process_lab_alpha;                                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      lch_model = babl_model (\"CIE LCH(ab)\");                               \n"
"      if (input_model == lch_model)                                           \n"
"        {                                                                     \n"
"          format = babl_format (\"CIE LCH(ab) float\");                       \n"
"          o->user_data = process_lch;                                         \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          format = babl_format (\"CIE Lab float\");                           \n"
"          o->user_data = process_lab;                                         \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  ProcessFunc real_process = (ProcessFunc) o->user_data;                      \n"
"                                                                              \n"
"  real_process (operation, in_buf, out_buf, n_pixels, roi, level);            \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_CLASS (klass);         \n"
"  GeglOperationPointFilterClass *point_filter_class =                         \n"
"    GEGL_OPERATION_POINT_FILTER_CLASS (klass);                                \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:saturation\",                                     \n"
"    \"title\",       _(\"Saturation\"),                                       \n"
"    \"categories\" , \"color\",                                               \n"
"    \"description\", _(\"Changes the saturation\"),                           \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
