static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright (C) 1996 Stephen Norris  (srn@flibble.cs.su.oz.au)               \n"
" * Copyright (C) 1996 Eiichi Takamori (taka@ma1.seikyou.ne.jp)                \n"
" * Copyright (C) 2000 Tim Copperfield (timecop@japan.co.jp)                   \n"
" * Copyright (C) 2011 Robert Sasu     (sasu.robert@gmail.com)                 \n"
" * Copyright (C) 2013 Téo Mazars      (teo.mazars@ensimag.fr)                \n"
" */                                                                           \n"
"                                                                              \n"
"/*                                                                            \n"
" * This plug-in produces plasma fractal images. The algorithm is losely       \n"
" * based on a description of the fractint algorithm, but completely           \n"
" * re-implemented because the fractint code was too ugly to read :). It       \n"
" * was written by Stephen Norris for GIMP, and was ported to GEGL in          \n"
" * 2011 by Robert Sasu.                                                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (turbulence, _(\"Turbulence\"), 1.0)                          \n"
"    description (_(\"High values give more variation in details\"))           \n"
"    value_range (0.0, 7.0)                                                    \n"
"                                                                              \n"
"property_int   (x, _(\"X\"), 0)                                               \n"
"    description(_(\"X start of the generated buffer\"))                       \n"
"    ui_range   (-4096, 4096)                                                  \n"
"    ui_meta    (\"unit\", \"pixel-coordinate\")                               \n"
"    ui_meta    (\"axis\", \"x\")                                              \n"
"    ui_meta    (\"role\", \"output-extent\")                                  \n"
"                                                                              \n"
"property_int   (y, _(\"Y\"), 0)                                               \n"
"    description(_(\"Y start of the generated buffer\"))                       \n"
"    ui_range   (-4096, 4096)                                                  \n"
"    ui_meta    (\"unit\", \"pixel-coordinate\")                               \n"
"    ui_meta    (\"axis\", \"y\")                                              \n"
"    ui_meta    (\"role\", \"output-extent\")                                  \n"
"                                                                              \n"
"property_int    (width, _(\"Width\"), 1024)                                   \n"
"    description (_(\"Width of the generated buffer\"))                        \n"
"    value_range (0, G_MAXINT)                                                 \n"
"    ui_range    (0, 4096)                                                     \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"    ui_meta     (\"role\", \"output-extent\")                                 \n"
"                                                                              \n"
"property_int (height, _(\"Height\"), 768)                                     \n"
"    description(_(\"Height of the generated buffer\"))                        \n"
"    value_range (0, G_MAXINT)                                                 \n"
"    ui_range    (0, 4096)                                                     \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"    ui_meta     (\"role\", \"output-extent\")                                 \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_NAME     plasma                                               \n"
"#define GEGL_OP_C_SOURCE plasma.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define TILE_SIZE 512                                                         \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglBuffer     *output;                                                     \n"
"  GRand          *gr;                                                         \n"
"  GeglProperties *o;                                                          \n"
"  float          *buffer;                                                     \n"
"  gboolean        using_buffer;                                               \n"
"  gint            buffer_x;                                                   \n"
"  gint            buffer_y;                                                   \n"
"  gint            buffer_width;                                               \n"
"} PlasmaContext;                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"average_pixel (gfloat *dst_buf,                                               \n"
"               gfloat *src_buf1,                                              \n"
"               gfloat *src_buf2)                                              \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    *dst_buf++ = (*src_buf1++ + *src_buf2++) / 2.0;                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"random_rgba (GRand  *gr,                                                      \n"
"             gfloat *dest)                                                    \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    dest[i] = (gfloat) g_rand_double_range (gr, 0.0, 1.0);                    \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"add_random (GRand  *gr,                                                       \n"
"            gfloat *dest,                                                     \n"
"            gfloat  amount)                                                   \n"
"{                                                                             \n"
"  gint    i;                                                                  \n"
"  gfloat  tmp;                                                                \n"
"                                                                              \n"
"  amount /= 2.0;                                                              \n"
"                                                                              \n"
"  if (amount > 0)                                                             \n"
"    for (i = 0; i < 3; i++)                                                   \n"
"      {                                                                       \n"
"        tmp = dest[i] + (gfloat) g_rand_double_range (gr, -amount, amount);   \n"
"        dest[i] = CLAMP (tmp, 0.0, 1.0);                                      \n"
"      }                                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"put_pixel (PlasmaContext *context,                                            \n"
"           gfloat        *pixel,                                              \n"
"           gint           x,                                                  \n"
"           gint           y)                                                  \n"
"{                                                                             \n"
"  if (G_UNLIKELY (!context->using_buffer))                                    \n"
"    {                                                                         \n"
"      GeglRectangle rect;                                                     \n"
"                                                                              \n"
"      rect.x = x;                                                             \n"
"      rect.y = y;                                                             \n"
"      rect.width = 1;                                                         \n"
"      rect.height = 1;                                                        \n"
"                                                                              \n"
"      gegl_buffer_set (context->output, &rect, 0, babl_format (\"R'G'B' float\"),\n"
"                       pixel, GEGL_AUTO_ROWSTRIDE);                           \n"
"      return;                                                                 \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      float *ptr;                                                             \n"
"      gint index;                                                             \n"
"                                                                              \n"
"      index = ((y - context->buffer_y) * context->buffer_width +              \n"
"               x - context->buffer_x);                                        \n"
"                                                                              \n"
"      ptr = context->buffer + index * 3;                                      \n"
"                                                                              \n"
"      *ptr++ = *pixel++;                                                      \n"
"      *ptr++ = *pixel++;                                                      \n"
"      *ptr++ = *pixel++;                                                      \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"do_plasma (PlasmaContext *context,                                            \n"
"           gint           x1,                                                 \n"
"           gint           y1,                                                 \n"
"           gint           x2,                                                 \n"
"           gint           y2,                                                 \n"
"           gint           plasma_depth,                                       \n"
"           gint           recursion_depth,                                    \n"
"           gint           level)                                              \n"
"{                                                                             \n"
"  gfloat tl[3], ml[3], bl[3], mt[3], mm[3], mb[3], tr[3], mr[3], br[3];       \n"
"  gfloat tmp[3];                                                              \n"
"  gint    xm, ym;                                                             \n"
"  gfloat  ran;                                                                \n"
"                                                                              \n"
"  if (G_UNLIKELY ((!context->using_buffer) &&                                 \n"
"                  ((x2 - x1 + 1) <= TILE_SIZE) &&                             \n"
"                  ((y2 - y1 + 1) <= TILE_SIZE)))                              \n"
"    {                                                                         \n"
"      gboolean ret;                                                           \n"
"      GeglRectangle rect;                                                     \n"
"                                                                              \n"
"      rect.x = x1;                                                            \n"
"      rect.y = y1;                                                            \n"
"      rect.width = x2 - x1 + 1;                                               \n"
"      rect.height = y2 - y1 + 1;                                              \n"
"                                                                              \n"
"      gegl_buffer_get (context->output, &rect, 1.0, babl_format (\"R'G'B' float\"),\n"
"                       context->buffer, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);\n"
"                                                                              \n"
"      context->using_buffer = TRUE;                                           \n"
"      context->buffer_x = x1;                                                 \n"
"      context->buffer_y = y1;                                                 \n"
"      context->buffer_width = x2 - x1 + 1;                                    \n"
"                                                                              \n"
"      ret = do_plasma (context, x1, y1, x2, y2, plasma_depth, recursion_depth, level);\n"
"                                                                              \n"
"      context->using_buffer = FALSE;                                          \n"
"                                                                              \n"
"      gegl_buffer_set (context->output, &rect, 0, babl_format (\"R'G'B' float\"),\n"
"                       context->buffer, GEGL_AUTO_ROWSTRIDE);                 \n"
"                                                                              \n"
"      return ret;                                                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  xm = (x1 + x2) / 2;                                                         \n"
"  ym = (y1 + y2) / 2;                                                         \n"
"                                                                              \n"
"  if (plasma_depth == -1)                                                     \n"
"    {                                                                         \n"
"      random_rgba (context->gr, tl);                                          \n"
"      put_pixel (context, tl, x1, y1);                                        \n"
"                                                                              \n"
"      random_rgba (context->gr, tr);                                          \n"
"      put_pixel (context, tr, x2, y1);                                        \n"
"                                                                              \n"
"      random_rgba (context->gr, bl);                                          \n"
"      put_pixel (context, bl, x1, y2);                                        \n"
"                                                                              \n"
"      random_rgba (context->gr, br);                                          \n"
"      put_pixel (context, br, x2, y2);                                        \n"
"                                                                              \n"
"      random_rgba (context->gr, mm);                                          \n"
"      put_pixel (context, mm, xm, ym);                                        \n"
"                                                                              \n"
"      random_rgba (context->gr, ml);                                          \n"
"      put_pixel (context, ml, x1, ym);                                        \n"
"                                                                              \n"
"      random_rgba (context->gr, mr);                                          \n"
"      put_pixel (context, mr, x2, ym);                                        \n"
"                                                                              \n"
"      random_rgba (context->gr, mt);                                          \n"
"      put_pixel (context, mt, xm, y1);                                        \n"
"                                                                              \n"
"      random_rgba (context->gr, mb);                                          \n"
"      put_pixel (context, mb, xm, y2);                                        \n"
"                                                                              \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!plasma_depth)                                                          \n"
"    {                                                                         \n"
"      if (x1 == x2 && y1 == y2)                                               \n"
"        return FALSE;                                                         \n"
"                                                                              \n"
"      gegl_buffer_sample_at_level (context->output, x1, y1, NULL, tl,         \n"
"                          babl_format (\"R'G'B' float\"), level,              \n"
"                          GEGL_SAMPLER_NEAREST, GEGL_ABYSS_NONE);             \n"
"      gegl_buffer_sample_at_level (context->output, x1, y2, NULL, bl,         \n"
"                          babl_format (\"R'G'B' float\"), level,              \n"
"                          GEGL_SAMPLER_NEAREST, GEGL_ABYSS_NONE);             \n"
"      gegl_buffer_sample_at_level (context->output, x2, y1, NULL, tr,         \n"
"                          babl_format (\"R'G'B' float\"), level,              \n"
"                          GEGL_SAMPLER_NEAREST, GEGL_ABYSS_NONE);             \n"
"      gegl_buffer_sample_at_level (context->output, x2, y2, NULL, br,         \n"
"                          babl_format (\"R'G'B' float\"), level,              \n"
"                          GEGL_SAMPLER_NEAREST, GEGL_ABYSS_NONE);             \n"
"                                                                              \n"
"      ran = context->o->turbulence / (2.0 * recursion_depth);                 \n"
"                                                                              \n"
"      if (xm != x1 || xm != x2)                                               \n"
"        {                                                                     \n"
"          /* Left. */                                                         \n"
"          average_pixel (ml, tl, bl);                                         \n"
"          add_random (context->gr, ml, ran);                                  \n"
"          put_pixel (context, ml, x1, ym);                                    \n"
"                                                                              \n"
"          /* Right. */                                                        \n"
"          if (x1 != x2)                                                       \n"
"            {                                                                 \n"
"              average_pixel (mr, tr, br);                                     \n"
"              add_random (context->gr, mr, ran);                              \n"
"              put_pixel (context, mr, x2, ym);                                \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"                                                                              \n"
"      if (ym != y1 || ym != x2)                                               \n"
"        {                                                                     \n"
"          /* Bottom. */                                                       \n"
"          if (x1 != xm || ym != y2)                                           \n"
"            {                                                                 \n"
"              average_pixel (mb, bl, br);                                     \n"
"              add_random (context->gr, mb, ran);                              \n"
"              put_pixel (context, mb, xm, y2);                                \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (y1 != y2)                                                       \n"
"            {                                                                 \n"
"              /* Top. */                                                      \n"
"              average_pixel (mt, tl, tr);                                     \n"
"              add_random (context->gr, mt, ran);                              \n"
"              put_pixel (context, mt, xm, y1);                                \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (y1 != y2 || x1 != x2)                                               \n"
"        {                                                                     \n"
"          /* Middle pixel. */                                                 \n"
"          average_pixel (mm, tl, br);                                         \n"
"          average_pixel (tmp, bl, tr);                                        \n"
"          average_pixel (mm, mm, tmp);                                        \n"
"                                                                              \n"
"          add_random (context->gr, mm, ran);                                  \n"
"          put_pixel (context, mm, xm, ym);                                    \n"
"        }                                                                     \n"
"                                                                              \n"
"      return x2 - x1 < 3 && y2 - y1 < 3;                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (x1 < x2 || y1 < y2)                                                     \n"
"    {                                                                         \n"
"      /* Top left. */                                                         \n"
"      do_plasma (context, x1, y1, xm, ym, plasma_depth - 1, recursion_depth + 1, level);\n"
"      /* Bottom left. */                                                      \n"
"      do_plasma (context, x1, ym, xm, y2, plasma_depth - 1, recursion_depth + 1, level);\n"
"      /* Top right. */                                                        \n"
"      do_plasma (context, xm, y1, x2, ym, plasma_depth - 1, recursion_depth + 1, level);\n"
"      /* Bottom right. */                                                     \n"
"      return do_plasma (context, xm, ym, x2, y2,                              \n"
"                        plasma_depth - 1, recursion_depth + 1, level);        \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B' float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  PlasmaContext *context;                                                     \n"
"  gint           depth;                                                       \n"
"  gint           x, y;                                                        \n"
"                                                                              \n"
"  context = g_new (PlasmaContext, 1);                                         \n"
"  context->o = GEGL_PROPERTIES (operation);                                   \n"
"  context->output = output;                                                   \n"
"  context->buffer = g_malloc (TILE_SIZE * TILE_SIZE * 3 * sizeof (gfloat));   \n"
"  context->using_buffer = FALSE;                                              \n"
"                                                                              \n"
"  /*                                                                          \n"
"   * The first time only puts seed pixels (corners, center of edges,          \n"
"   * center of image)                                                         \n"
"   */                                                                         \n"
"  x = result->x + result->width;                                              \n"
"  y = result->y + result->height;                                             \n"
"                                                                              \n"
"  context->gr = g_rand_new_with_seed (context->o->seed);                      \n"
"                                                                              \n"
"  do_plasma (context, result->x, result->y, x-1, y-1, -1, 0, level);          \n"
"                                                                              \n"
"  /*                                                                          \n"
"   * Now we recurse through the images, going deeper each time                \n"
"   */                                                                         \n"
"  depth = 1;                                                                  \n"
"  while (!do_plasma (context, result->x, result->y, x-1, y-1, depth, 0, level))\n"
"    depth++;                                                                  \n"
"                                                                              \n"
"  gegl_buffer_sample_cleanup (context->output);                               \n"
"  g_rand_free (context->gr);                                                  \n"
"  g_free (context->buffer);                                                   \n"
"  g_free (context);                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  return *GEGL_RECTANGLE (o->x, o->y, o->width, o->height);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process                    = process;                         \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_bounding_box        = get_bounding_box;                \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:plasma\",                                  \n"
"    \"title\",              _(\"Plasma\"),                                    \n"
"    \"categories\",         \"render\",                                       \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"description\", _(\"Creates an image filled with a plasma effect.\"),    \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
