static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"/* FIXME: need to make this OpenRaster inspired layer integrate better        \n"
" * with the newer caching system                                              \n"
" */                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_string(composite_op, _(\"Operation\"), \"gegl:over\")                \n"
"    description (_(\"Composite operation to use\"))                           \n"
"                                                                              \n"
"property_double(opacity, _(\"Opacity\"), 1.0)                                 \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_double(x, _(\"X\"), 0.0)                                             \n"
"    description (_(\"Horizontal position in pixels\"))                        \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"    ui_meta     (\"unit\", \"pixel-coordinate\")                              \n"
"                                                                              \n"
"property_double(y, _(\"Y\"), 0.0)                                             \n"
"    description (_(\"Vertical position in pixels\"))                          \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"    ui_meta     (\"unit\", \"pixel-coordinate\")                              \n"
"                                                                              \n"
"property_double(scale, _(\"Scale\"), 1.0)                                     \n"
"    description (_(\"Scale 1:1 size\"))                                       \n"
"                                                                              \n"
"property_file_path(src, _(\"Source\"), \"\")                                  \n"
"    description (_(\"Source image file path (png, jpg, raw, svg, bmp, tif, ...)\"))\n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#include <gegl-plugin.h>                                                      \n"
"struct _GeglOp                                                                \n"
"{                                                                             \n"
"  GeglOperationMeta parent_instance;                                          \n"
"  gpointer          properties;                                               \n"
"                                                                              \n"
"  GeglNode *self;                                                             \n"
"  GeglNode *input;                                                            \n"
"  GeglNode *aux;                                                              \n"
"  GeglNode *output;                                                           \n"
"                                                                              \n"
"  GeglNode *composite_op;                                                     \n"
"  GeglNode *translate;                                                        \n"
"  GeglNode *opacity;                                                          \n"
"  GeglNode *scale;                                                            \n"
"  GeglNode *load;                                                             \n"
"                                                                              \n"
"  gchar *cached_path;                                                         \n"
"                                                                              \n"
"  gdouble p_opacity;                                                          \n"
"  gdouble p_scale;                                                            \n"
"  gdouble p_x;                                                                \n"
"  gdouble p_y;                                                                \n"
"  gchar  *p_composite_op;                                                     \n"
"};                                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglOperationMetaClass parent_class;                                        \n"
"} GeglOpClass;                                                                \n"
"                                                                              \n"
"#define GEGL_OP_NAME     layer                                                \n"
"#define GEGL_OP_C_SOURCE layer.c                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"GEGL_DEFINE_DYNAMIC_OPERATION(GEGL_TYPE_OPERATION_META)                       \n"
"                                                                              \n"
"#include <glib/gprintf.h>                                                     \n"
"                                                                              \n"
"static void                                                                   \n"
"do_setup (GeglOperation *operation)                                           \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglOp         *self = GEGL_OP (operation);                                 \n"
"                                                                              \n"
"  /* If the src is NULL, and we previously used a source, clear what we have  \n"
"   * cached and directly link the input and output. We don't need a composite \n"
"   * operation if we don't have a source, so don't continue preparing.        \n"
"   */                                                                         \n"
"  if (o->src[0] == 0)                                                         \n"
"    {                                                                         \n"
"      if (self->cached_path != NULL)                                          \n"
"        {                                                                     \n"
"          gegl_node_link (self->input, self->output);                         \n"
"          g_free (self->cached_path);                                         \n"
"          self->cached_path = NULL;                                           \n"
"        }                                                                     \n"
"                                                                              \n"
"      return;                                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* Check if the composite operation we're using has changed from that which \n"
"   * is already in use.                                                       \n"
"   */                                                                         \n"
"  if (!self->p_composite_op || strcmp (self->p_composite_op, o->composite_op))\n"
"    {                                                                         \n"
"      gegl_node_set (self->composite_op,                                      \n"
"                     \"operation\", o->composite_op,                          \n"
"                     NULL);                                                   \n"
"      if (self->p_composite_op)                                               \n"
"        g_free (self->p_composite_op);                                        \n"
"      self->p_composite_op = g_strdup (o->composite_op);                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* Load a src image, and relink the input/composite/output chain, as it     \n"
"   * will currently be set to an input/output chain without a composite       \n"
"   * source.                                                                  \n"
"   */                                                                         \n"
"                                                                              \n"
"  if (self->cached_path == NULL || strcmp (o->src, self->cached_path))        \n"
"    {                                                                         \n"
"      gegl_node_set (self->load,                                              \n"
"          \"operation\", \"gegl:load\",                                       \n"
"          NULL);                                                              \n"
"      gegl_node_set (self->load,                                              \n"
"          \"path\",  o->src,                                                  \n"
"          NULL);                                                              \n"
"                                                                              \n"
"      /* Currently not using the composite op, reinsert it */                 \n"
"      if (!self->cached_path)                                                 \n"
"        gegl_node_link_many (self->input, self->composite_op, self->output, NULL);\n"
"                                                                              \n"
"      if (self->cached_path)                                                  \n"
"        g_free (self->cached_path);                                           \n"
"      self->cached_path = g_strdup (o->src);                                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (o->scale != self->p_scale)                                              \n"
"    {                                                                         \n"
"      gegl_node_set (self->scale,                                             \n"
"                     \"x\",  o->scale,                                        \n"
"                     \"y\",  o->scale,                                        \n"
"                     NULL);                                                   \n"
"      self->p_scale= o->scale;                                                \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (o->opacity != self->p_opacity)                                          \n"
"    {                                                                         \n"
"      gegl_node_set (self->opacity,                                           \n"
"                     \"value\",  o->opacity,                                  \n"
"                     NULL);                                                   \n"
"      self->p_opacity = o->opacity;                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (o->x != self->p_x ||                                                    \n"
"      o->y != self->p_y)                                                      \n"
"    {                                                                         \n"
"      gegl_node_set (self->translate,                                         \n"
"                     \"x\",  o->x,                                            \n"
"                     \"y\",  o->y,                                            \n"
"                     NULL);                                                   \n"
"      self->p_x = o->x;                                                       \n"
"      self->p_y = o->y;                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"my_set_property (GObject      *gobject,                                       \n"
"                 guint         property_id,                                   \n"
"                 const GValue *value,                                         \n"
"                 GParamSpec   *pspec)                                         \n"
"{                                                                             \n"
"  GeglOperation *operation = GEGL_OPERATION (gobject);                        \n"
"  GeglOp        *self      = GEGL_OP (operation);                             \n"
"                                                                              \n"
"  /* The set_property provided by the chant system does the                   \n"
"   * storing and reffing/unreffing of the input properties */                 \n"
"  set_property(gobject, property_id, value, pspec);                           \n"
"                                                                              \n"
"  if (self->load)                                                             \n"
"    do_setup (operation);                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void attach (GeglOperation *operation)                                 \n"
"{                                                                             \n"
"  GeglOp         *self = GEGL_OP (operation);                                 \n"
"  GeglProperties *o    = GEGL_PROPERTIES (operation);                         \n"
"  GeglNode *gegl;                                                             \n"
"                                                                              \n"
"  self->self = GEGL_OPERATION (self)->node;                                   \n"
"  gegl = self->self;                                                          \n"
"                                                                              \n"
"  self->input = gegl_node_get_input_proxy (gegl, \"input\");                  \n"
"  self->aux = gegl_node_get_input_proxy (gegl, \"aux\");                      \n"
"  self->output = gegl_node_get_output_proxy (gegl, \"output\");               \n"
"                                                                              \n"
"  self->composite_op = gegl_node_new_child (gegl,                             \n"
"                                         \"operation\", o->composite_op,      \n"
"                                         NULL);                               \n"
"                                                                              \n"
"  self->translate = gegl_node_new_child (gegl, \"operation\", \"gegl:translate\", NULL);\n"
"  self->scale = gegl_node_new_child (gegl, \"operation\", \"gegl:scale-ratio\", NULL);\n"
"  self->opacity = gegl_node_new_child (gegl, \"operation\", \"gegl:opacity\", NULL);\n"
"                                                                              \n"
"  self->load = gegl_node_new_child (gegl,                                     \n"
"                                    \"operation\", \"gegl:text\",             \n"
"                                    \"string\", \"Load operation placeholder\",\n"
"                                    NULL);                                    \n"
"                                                                              \n"
"  gegl_node_link_many (self->load, self->scale, self->opacity, self->translate,\n"
"                       NULL);                                                 \n"
"  gegl_node_link_many (self->input, self->composite_op, self->output, NULL);  \n"
"  gegl_node_connect_from (self->composite_op, \"aux\", self->translate, \"output\");\n"
"                                                                              \n"
"  gegl_operation_meta_watch_nodes (operation,                                 \n"
"                                   self->composite_op,                        \n"
"                                   self->translate,                           \n"
"                                   self->scale,                               \n"
"                                   self->opacity,                             \n"
"                                   self->load,                                \n"
"                                   NULL);                                     \n"
"                                                                              \n"
"  do_setup (operation);                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglOp *self = GEGL_OP (object);                                            \n"
"                                                                              \n"
"  if (self->cached_path)                                                      \n"
"    g_free (self->cached_path);                                               \n"
"  if (self->p_composite_op)                                                   \n"
"    g_free (self->p_composite_op);                                            \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass       *object_class;                                           \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  object_class->finalize     = finalize;                                      \n"
"  object_class->set_property = my_set_property;                               \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:layer\",                                          \n"
"    \"categories\" , \"meta\",                                                \n"
"    \"description\", _(\"A layer in the traditional sense\"),                 \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
