static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2010 Barak Itkin <lightningismyname@gmail.org>                   \n"
" *                                                                            \n"
" * Based on \"Whirl and Pinch\" GIMP plugin                                   \n"
" * Copyright (C) 1997 Federico Mena Quintero                                  \n"
" * Copyright (C) 1997 Scott Goehring                                          \n"
" *                                                                            \n"
" * The workshop/mirrors.c operation by Alexia Death and Øyvind Kolås        \n"
" * was used as a template for this op file.                                   \n"
" */                                                                           \n"
"                                                                              \n"
"/* TODO: Find some better algorithm to calculate the roi for each dest        \n"
" *       rectangle. Right now it simply asks for the entire image...          \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (whirl, _(\"Whirl\"), 90.0)                                   \n"
"    description (_(\"Whirl angle (degrees)\"))                                \n"
"    ui_range    (-720, 720)                                                   \n"
"    ui_meta     (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_double (pinch, _(\"Pinch\"), 0.0)                                    \n"
"    description (_(\"Pinch amount\"))                                         \n"
"    value_range (-1.0, 1.0)                                                   \n"
"                                                                              \n"
"property_double (radius, _(\"Radius\"), 1.0)                                  \n"
"    description(_(\"Radius (1.0 is the largest circle that fits in the \"     \n"
"               \"image, and 2.0 goes all the way to the corners)\"))          \n"
"    value_range (0.0, 2.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE whirl-pinch.c                                        \n"
"#define GEGL_OP_NAME     whirl_pinch                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"/* This function is a slightly modified version from the one in the           \n"
" * original plugin                                                            \n"
" */                                                                           \n"
"static gboolean                                                               \n"
"calc_undistorted_coords (gdouble  wx,                                         \n"
"                         gdouble  wy,                                         \n"
"                         gdouble  cen_x,                                      \n"
"                         gdouble  cen_y,                                      \n"
"                         gdouble  scale_x,                                    \n"
"                         gdouble  scale_y,                                    \n"
"                         gdouble  whirl,                                      \n"
"                         gdouble  pinch,                                      \n"
"                         gdouble  wpradius,                                   \n"
"                         gdouble *x,                                          \n"
"                         gdouble *y)                                          \n"
"{                                                                             \n"
"  gdouble  dx, dy;                                                            \n"
"  gdouble  d, factor;                                                         \n"
"  gdouble  dist;                                                              \n"
"  gdouble  ang, sina, cosa;                                                   \n"
"  gboolean inside;                                                            \n"
"                                                                              \n"
"  gdouble  radius = MAX(cen_x, cen_y);                                        \n"
"  gdouble  radius2 = radius * radius * wpradius;                              \n"
"  /* Distances to center, scaled */                                           \n"
"                                                                              \n"
"  dx = (wx - cen_x) * scale_x;                                                \n"
"  dy = (wy - cen_y) * scale_y;                                                \n"
"                                                                              \n"
"  /* Distance^2 to center of *circle* (scaled ellipse) */                     \n"
"                                                                              \n"
"  d = dx * dx + dy * dy;                                                      \n"
"                                                                              \n"
"  /*  If we are inside circle, then distort.                                  \n"
"   *  Else, just return the same position                                     \n"
"   */                                                                         \n"
"                                                                              \n"
"  inside = (d < radius2);                                                     \n"
"                                                                              \n"
"  /* If d is 0, then we are exactly at the center, so the transform has       \n"
"   * no effect. The original version of the gimp plugin simply created        \n"
"   * an offset of the original points to avoid this issue, but that is        \n"
"   * less accurate...                                                         \n"
"   */                                                                         \n"
"  if (inside && d > 0)                                                        \n"
"    {                                                                         \n"
"      dist = sqrt(d / wpradius) / radius;                                     \n"
"                                                                              \n"
"      /* Pinch */                                                             \n"
"                                                                              \n"
"      factor = pow (sin (G_PI_2 * dist), -pinch);                             \n"
"                                                                              \n"
"      dx *= factor;                                                           \n"
"      dy *= factor;                                                           \n"
"                                                                              \n"
"      /* Whirl */                                                             \n"
"                                                                              \n"
"      factor = 1.0 - dist;                                                    \n"
"                                                                              \n"
"      ang = whirl * factor * factor;                                          \n"
"                                                                              \n"
"      sina = sin (ang);                                                       \n"
"      cosa = cos (ang);                                                       \n"
"                                                                              \n"
"      *x = (cosa * dx - sina * dy) / scale_x + cen_x;                         \n"
"      *y = (sina * dx + cosa * dy) / scale_y + cen_y;                         \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      *x = wx;                                                                \n"
"      *y = wy;                                                                \n"
"    }                                                                         \n"
"                                                                              \n"
"  return inside;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"/* Apply the actual transform */                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"apply_whirl_pinch (gdouble              whirl,                                \n"
"                   gdouble              pinch,                                \n"
"                   gdouble              radius,                               \n"
"                   gdouble              cen_x,                                \n"
"                   gdouble              cen_y,                                \n"
"                   const Babl          *format,                               \n"
"                   GeglBuffer          *src,                                  \n"
"                   GeglRectangle       *in_boundary,                          \n"
"                   GeglBuffer          *dst,                                  \n"
"                   GeglRectangle       *boundary,                             \n"
"                   const GeglRectangle *roi,                                  \n"
"                   gint                 level)                                \n"
"{                                                                             \n"
"  gfloat *dst_buf;                                                            \n"
"  gint row, col;                                                              \n"
"  gdouble scale_x, scale_y;                                                   \n"
"  gdouble cx, cy;                                                             \n"
"  GeglSampler *sampler;                                                       \n"
"                                                                              \n"
"  /* Get buffer in which to place dst pixels. */                              \n"
"  dst_buf = g_new0 (gfloat, roi->width * roi->height * 4);                    \n"
"                                                                              \n"
"  whirl = whirl * G_PI / 180;                                                 \n"
"                                                                              \n"
"  scale_x = 1.0;                                                              \n"
"  scale_y = (gdouble) in_boundary->width / in_boundary->height;               \n"
"  sampler = gegl_buffer_sampler_new_at_level (src, babl_format (\"RaGaBaA float\"),\n"
"                                     GEGL_SAMPLER_NOHALO, level);             \n"
"                                                                              \n"
"  for (row = 0; row < roi->height; row++) {                                   \n"
"    for (col = 0; col < roi->width; col++) {                                  \n"
"        GeglMatrix2 scale;                                                    \n"
"#define gegl_unmap(u,v,du,dv) \\                                              \n"
"        { \\                                                                  \n"
"          calc_undistorted_coords (u, v,\\                                    \n"
"                                   cen_x, cen_y,\\                            \n"
"                                   scale_x, scale_y,\\                        \n"
"                                   whirl, pinch, radius,\\                    \n"
"                                   &cx, &cy);\\                               \n"
"          du=cx;dv=cy;\\                                                      \n"
"        }                                                                     \n"
"        gegl_sampler_compute_scale (scale, roi->x + col, roi->y + row);       \n"
"        gegl_unmap (roi->x + col, roi->y + row, cx, cy);                      \n"
"                                                                              \n"
"        gegl_sampler_get (sampler, cx, cy, &scale, &dst_buf[(row * roi->width + col) * 4], GEGL_ABYSS_NONE);\n"
"    } /* for */                                                               \n"
"  } /* for */                                                                 \n"
"                                                                              \n"
"  /* Store dst pixels. */                                                     \n"
"  gegl_buffer_set (dst, roi, 0, format, dst_buf, GEGL_AUTO_ROWSTRIDE);        \n"
"                                                                              \n"
"  g_free (dst_buf);                                                           \n"
"  g_object_unref (sampler);                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"/*****************************************************************************/\n"
"                                                                              \n"
"/* Compute the region for which this operation is defined.                    \n"
" */                                                                           \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"  else                                                                        \n"
"    return *in_rect;                                                          \n"
"}                                                                             \n"
"                                                                              \n"
"/* Compute the input rectangle required to compute the specified region of interest (roi).\n"
" */                                                                           \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle *result = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  return *result;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"/* Specify the input and output buffer formats.                               \n"
" */                                                                           \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RaGaBaA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RaGaBaA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"/* Perform the specified operation.                                           \n"
" */                                                                           \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o        = GEGL_PROPERTIES (operation);                     \n"
"  GeglRectangle   boundary = gegl_operation_get_bounding_box (operation);     \n"
"  const Babl     *format   = babl_format (\"RaGaBaA float\");                 \n"
"                                                                              \n"
"  apply_whirl_pinch (o->whirl,                                                \n"
"                     o->pinch,                                                \n"
"                     o->radius,                                               \n"
"                     boundary.width / 2.0,                                    \n"
"                     boundary.height / 2.0,                                   \n"
"                     format,                                                  \n"
"                     input,                                                   \n"
"                     &boundary,                                               \n"
"                     output,                                                  \n"
"                     &boundary,                                               \n"
"                     result,                                                  \n"
"                     level);                                                  \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:whirl-pinch\",                             \n"
"    \"title\",              _(\"Whirl Pinch\"),                               \n"
"    \"categories\",         \"distort:map\",                                  \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"description\", _(\"Distort an image by whirling and pinching\"),        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
