static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2007 Étienne Bersac <bersace03@laposte.net>                     \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"#include <babl/babl.h>                                                        \n"
"                                                                              \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_pointer (pixbuf, _(\"Pixbuf location\"),                             \n"
"                    _(\"The location where to store the output GdkPixbuf.\")) \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_NAME save_pixbuf                                              \n"
"#define GEGL_OP_C_SOURCE save-pixbuf.c                                        \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <gdk-pixbuf/gdk-pixbuf.h>                                            \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->pixbuf)                                                              \n"
"    {                                                                         \n"
"      GdkPixbuf       **pixbuf = o->pixbuf;                                   \n"
"      const Babl       *babl;                                                 \n"
"      const Babl       *format;                                               \n"
"      guchar           *temp;                                                 \n"
"      GeglRectangle *rect = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"      gchar *name;                                                            \n"
"      gboolean has_alpha;                                                     \n"
"      gint bpp;                                                               \n"
"      gint bps;                                                               \n"
"      gint stride;                                                            \n"
"                                                                              \n"
"      g_object_get (input, \"format\", &format, NULL);                        \n"
"                                                                              \n"
"      has_alpha = babl_format_has_alpha (format);                             \n"
"                                                                              \n"
"      /* pixbuf from data only support 8bit bps */                            \n"
"      bps = 8;                                                                \n"
"      name = g_strdup_printf (\"R'G'B'%s u%i\",                               \n"
"                  has_alpha ? \"A\" : \"\",                                   \n"
"                  bps);                                                       \n"
"      babl = babl_format (name);                                              \n"
"                                                                              \n"
"      bpp = babl_format_get_bytes_per_pixel (babl);                           \n"
"      stride = bpp * rect->width;                                             \n"
"                                                                              \n"
"      temp = g_malloc0_n (stride, rect->height);                              \n"
"      gegl_buffer_get (input, rect, 1.0, babl, temp, stride,                  \n"
"                       GEGL_ABYSS_NONE);                                      \n"
"      if (temp) {                                                             \n"
"    *pixbuf = gdk_pixbuf_new_from_data (temp,                                 \n"
"                        GDK_COLORSPACE_RGB,                                   \n"
"                        has_alpha,                                            \n"
"                        bps,                                                  \n"
"                        rect->width, rect->height,                            \n"
"                        stride,                                               \n"
"                        (GdkPixbufDestroyNotify) g_free, NULL);               \n"
"      }                                                                       \n"
"      else {                                                                  \n"
"    g_warning (G_STRLOC \": inexistant data, unable to create GdkPixbuf.\");  \n"
"      }                                                                       \n"
"                                                                              \n"
"      g_free (name);                                                          \n"
"    }                                                                         \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process = process;                                              \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:save-pixbuf\",                                   \n"
"    \"title\",        _(\"Store in GdkPixbuf\"),                              \n"
"    \"categories\"  , \"programming:output\",                                 \n"
"    \"description\" , _(\"Store image in a GdkPixbuf.\"),                     \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
