static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Original authors:                                                          \n"
" *                                                                            \n"
" *      Daniel Cotting <cotting@mygale.org>                                   \n"
" *      Martin Weber   <martweb@gmx.net>                                      \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_alien_map_color_model)                                       \n"
"  enum_value (GEGL_ALIEN_MAP_COLOR_MODEL_RGB, \"rgb\", N_(\"RGB\"))           \n"
"  enum_value (GEGL_ALIEN_MAP_COLOR_MODEL_HSL, \"hsl\", N_(\"HSL\"))           \n"
"enum_end (GeglAlienMapColorModel)                                             \n"
"                                                                              \n"
"property_enum (color_model, _(\"Color model\"),                               \n"
"               GeglAlienMapColorModel, gegl_alien_map_color_model,            \n"
"               GEGL_ALIEN_MAP_COLOR_MODEL_RGB)                                \n"
"  description (_(\"What color model used for the transformation\"))           \n"
"                                                                              \n"
"property_double (cpn_1_frequency, _(\"Component 1 frequency\"), 1)            \n"
"  value_range (0, 20)                                                         \n"
"  ui_meta     (\"sensitive\", \"! cpn-1-keep\")                               \n"
"  ui_meta     (\"label\", \"[color-model {rgb} : rgb-label,\"                 \n"
"                        \" color-model {hsl} : hsl-label]\")                  \n"
"  ui_meta     (\"rgb-label\", _(\"Red frequency\"))                           \n"
"  ui_meta     (\"hsl-label\", _(\"Hue frequency\"))                           \n"
"                                                                              \n"
"property_double  (cpn_2_frequency, _(\"Component 2 frequency\"), 1)           \n"
"  value_range (0, 20)                                                         \n"
"  ui_meta     (\"sensitive\", \"! cpn-2-keep\")                               \n"
"  ui_meta     (\"label\", \"[color-model {rgb} : rgb-label,\"                 \n"
"                        \" color-model {hsl} : hsl-label]\")                  \n"
"  ui_meta     (\"rgb-label\", _(\"Green frequency\"))                         \n"
"  ui_meta     (\"hsl-label\", _(\"Saturation frequency\"))                    \n"
"                                                                              \n"
"property_double  (cpn_3_frequency, _(\"Component 3 frequency\"), 1)           \n"
"  value_range (0, 20)                                                         \n"
"  ui_meta     (\"sensitive\", \"! cpn-3-keep\")                               \n"
"  ui_meta     (\"label\", \"[color-model {rgb} : rgb-label,\"                 \n"
"                        \" color-model {hsl} : hsl-label]\")                  \n"
"  ui_meta     (\"rgb-label\", _(\"Blue frequency\"))                          \n"
"  ui_meta     (\"hsl-label\", _(\"Lightness frequency\"))                     \n"
"                                                                              \n"
"property_double  (cpn_1_phaseshift, _(\"Component 1 phase shift\"), 0)        \n"
"  value_range (0, 360)                                                        \n"
"  ui_meta     (\"unit\", \"degree\")                                          \n"
"  ui_meta     (\"sensitive\", \"! cpn-1-keep\")                               \n"
"  ui_meta     (\"label\", \"[color-model {rgb} : rgb-label,\"                 \n"
"                        \" color-model {hsl} : hsl-label]\")                  \n"
"  ui_meta     (\"rgb-label\", _(\"Red phase shift\"))                         \n"
"  ui_meta     (\"hsl-label\", _(\"Hue phase shift\"))                         \n"
"                                                                              \n"
"property_double  (cpn_2_phaseshift, _(\"Component 2 phase shift\"), 0)        \n"
"  value_range (0, 360)                                                        \n"
"  ui_meta     (\"unit\", \"degree\")                                          \n"
"  ui_meta     (\"sensitive\", \"! cpn-2-keep\")                               \n"
"  ui_meta     (\"label\", \"[color-model {rgb} : rgb-label,\"                 \n"
"                        \" color-model {hsl} : hsl-label]\")                  \n"
"  ui_meta     (\"rgb-label\", _(\"Green phase shift\"))                       \n"
"  ui_meta     (\"hsl-label\", _(\"Saturation phase shift\"))                  \n"
"                                                                              \n"
"property_double  (cpn_3_phaseshift, _(\"Component 3 phase shift\"), 0)        \n"
"  value_range (0, 360)                                                        \n"
"  ui_meta     (\"unit\", \"degree\")                                          \n"
"  ui_meta     (\"sensitive\", \"! cpn-3-keep\")                               \n"
"  ui_meta     (\"label\", \"[color-model {rgb} : rgb-label,\"                 \n"
"                        \" color-model {hsl} : hsl-label]\")                  \n"
"  ui_meta     (\"rgb-label\", _(\"Blue phase shift\"))                        \n"
"  ui_meta     (\"hsl-label\", _(\"Lightness phase shift\"))                   \n"
"                                                                              \n"
"property_boolean (cpn_1_keep, _(\"Keep component 1\"), FALSE)                 \n"
"  ui_meta     (\"label\", \"[color-model {rgb} : rgb-label,\"                 \n"
"                        \" color-model {hsl} : hsl-label]\")                  \n"
"  ui_meta     (\"rgb-label\", _(\"Keep red component\"))                      \n"
"  ui_meta     (\"hsl-label\", _(\"Keep hue component\"))                      \n"
"                                                                              \n"
"property_boolean (cpn_2_keep, _(\"Keep component 2\"), FALSE)                 \n"
"  ui_meta     (\"label\", \"[color-model {rgb} : rgb-label,\"                 \n"
"                        \" color-model {hsl} : hsl-label]\")                  \n"
"  ui_meta     (\"rgb-label\", _(\"Keep green component\"))                    \n"
"  ui_meta     (\"hsl-label\", _(\"Keep saturation component\"))               \n"
"                                                                              \n"
"property_boolean (cpn_3_keep, _(\"Keep component 3\"), FALSE)                 \n"
"  ui_meta     (\"label\", \"[color-model {rgb} : rgb-label,\"                 \n"
"                        \" color-model {hsl} : hsl-label]\")                  \n"
"  ui_meta     (\"rgb-label\", _(\"Keep blue component\"))                     \n"
"  ui_meta     (\"hsl-label\", _(\"Keep lightness component\"))                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     alien_map                                            \n"
"#define GEGL_OP_C_SOURCE alien-map.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->color_model == GEGL_ALIEN_MAP_COLOR_MODEL_RGB)                       \n"
"    {                                                                         \n"
"      gegl_operation_set_format (operation, \"input\",                        \n"
"                                 babl_format (\"R'G'B'A float\"));            \n"
"      gegl_operation_set_format (operation, \"output\",                       \n"
"                                 babl_format (\"R'G'B'A float\"));            \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_operation_set_format (operation, \"input\",                        \n"
"                                 babl_format (\"HSLA float\"));               \n"
"      gegl_operation_set_format (operation, \"output\",                       \n"
"                                 babl_format (\"HSLA float\"));               \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                samples,                                        \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"  gfloat     *in  = in_buf;                                                   \n"
"  gfloat     *out = out_buf;                                                  \n"
"  gfloat      freq[3];                                                        \n"
"  gfloat      phaseshift[3];                                                  \n"
"  gboolean    keep[3];                                                        \n"
"                                                                              \n"
"  freq[0] = o->cpn_1_frequency * G_PI;                                        \n"
"  freq[1] = o->cpn_2_frequency * G_PI;                                        \n"
"  freq[2] = o->cpn_3_frequency * G_PI;                                        \n"
"                                                                              \n"
"  phaseshift[0] = G_PI * o->cpn_1_phaseshift / 180.0;                         \n"
"  phaseshift[1] = G_PI * o->cpn_2_phaseshift / 180.0;                         \n"
"  phaseshift[2] = G_PI * o->cpn_3_phaseshift / 180.0;                         \n"
"                                                                              \n"
"  keep[0] = o->cpn_1_keep;                                                    \n"
"  keep[1] = o->cpn_2_keep;                                                    \n"
"  keep[2] = o->cpn_3_keep;                                                    \n"
"                                                                              \n"
"  while (samples--)                                                           \n"
"    {                                                                         \n"
"      gint i;                                                                 \n"
"      for (i = 0; i < 3; i++)                                                 \n"
"        {                                                                     \n"
"          out[i] = keep[i] ?                                                  \n"
"            in[i] :                                                           \n"
"            0.5 * (1.0 + sin ((2 * in[i] - 1.0) * freq[i] + phaseshift[i]));  \n"
"        }                                                                     \n"
"                                                                              \n"
"      out[3] = in[3];                                                         \n"
"                                                                              \n"
"      in  += 4;                                                               \n"
"      out += 4;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"opencl/alien-map.cl.h\"                                            \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            cl_mem              in,                                           \n"
"            cl_mem              out,                                          \n"
"            size_t              global_worksize,                              \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                level)                                        \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  cl_float3   freq;                                                           \n"
"  cl_float3   phaseshift;                                                     \n"
"  cl_int3     keep;                                                           \n"
"  cl_int      cl_err = 0;                                                     \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"cl_alien_map\",                          \n"
"                                   NULL};                                     \n"
"      cl_data = gegl_cl_compile_and_build (alien_map_cl_source, kernel_name); \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  freq.s[0] = o->cpn_1_frequency * G_PI;                                      \n"
"  freq.s[1] = o->cpn_2_frequency * G_PI;                                      \n"
"  freq.s[2] = o->cpn_3_frequency * G_PI;                                      \n"
"                                                                              \n"
"  phaseshift.s[0] = G_PI * o->cpn_1_phaseshift / 180.0;                       \n"
"  phaseshift.s[1] = G_PI * o->cpn_2_phaseshift / 180.0;                       \n"
"  phaseshift.s[2] = G_PI * o->cpn_3_phaseshift / 180.0;                       \n"
"                                                                              \n"
"  keep.s[0] = (cl_int)o->cpn_1_keep;                                          \n"
"  keep.s[1] = (cl_int)o->cpn_2_keep;                                          \n"
"  keep.s[2] = (cl_int)o->cpn_3_keep;                                          \n"
"                                                                              \n"
"  cl_err = gegl_cl_set_kernel_args (cl_data->kernel[0],                       \n"
"                                    sizeof(cl_mem),    &in,                   \n"
"                                    sizeof(cl_mem),    &out,                  \n"
"                                    sizeof(cl_float3), &freq,                 \n"
"                                    sizeof(cl_float3), &phaseshift,           \n"
"                                    sizeof(cl_int3),   &keep,                 \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 1,                \n"
"                                        NULL, &global_worksize, NULL,         \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return  FALSE;                                                              \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->prepare        = prepare;                                  \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"  point_filter_class->process     = process;                                  \n"
"  point_filter_class->cl_process  = cl_process;                               \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:alien-map\",                                      \n"
"    \"title\",       _(\"Alien Map\"),                                        \n"
"    \"categories\",  \"artistic\",                                            \n"
"    \"reference-hash\", \"48146706af798ef888ba571ce89c1589\",                 \n"
"    \"description\", _(\"Heavily distort images colors by applying trigonometric functions to map color values.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
