static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2014 Dimitris Papavasiliou <dpapavas@google.com>                 \n"
" */                                                                           \n"
"                                                                              \n"
"/* This plug-in generates noise textures originally presented by Ken          \n"
" * Perlin during a SIGGRAPH 2002 course and further explained in the          \n"
" * paper \"Simplex noise demystified\" by Stefan Gustavson.                   \n"
" *                                                                            \n"
" * Comments and improvements for this code are welcome.                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (scale, _(\"Scale\"), 1.0)                                    \n"
"    description (_(\"The scale of the noise function\"))                      \n"
"    value_range (0.0, 20.0)                                                   \n"
"                                                                              \n"
"property_int    (iterations, _(\"Iterations\"), 1)                            \n"
"    description (_(\"The number of noise octaves.\"))                         \n"
"    value_range (1, 20)                                                       \n"
"                                                                              \n"
"property_seed   (seed, _(\"Random seed\"), rand)                              \n"
"    description (_(\"The random seed for the noise function\"))               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_RENDER                                                  \n"
"#define GEGL_OP_NAME     noise_simplex                                        \n"
"#define GEGL_OP_C_SOURCE noise-simplex.c                                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <gegl-buffer-cl-iterator.h>                                          \n"
"#include <gegl-debug.h>                                                       \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#include \"opencl/noise-simplex.cl.h\"                                        \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  guint seed;                                                                 \n"
"} Context;                                                                    \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static inline gdouble                                                         \n"
"dot_2(gdouble *p,                                                             \n"
"      gdouble *q)                                                             \n"
"{                                                                             \n"
"  return p[0] * q[0] + p[1] * q[1];                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"philox (guint    s,                                                           \n"
"        guint    t,                                                           \n"
"        guint    k,                                                           \n"
"        gdouble *h)                                                           \n"
"{                                                                             \n"
"  guint64 p;                                                                  \n"
"  gint    i;                                                                  \n"
"                                                                              \n"
"  /* For details regarding this hash function consult:                        \n"
"                                                                              \n"
"     Salmon, J.K.; Moraes, M.A.; Dror, R.O.; Shaw, D.E., \"Parallel           \n"
"     random numbers: As easy as 1, 2, 3,\" High Performance Computing,        \n"
"     Networking, Storage and Analysis (SC), 2011 International                \n"
"     Conference for , vol., no., pp.1,12, 12-18 Nov. 2011 */\\                \n"
"                                                                              \n"
"  for (i = 0 ; i < 3 ; i += 1)                                                \n"
"    {                                                                         \n"
"      p = s * (guint64)0xcd9e8d57;                                            \n"
"                                                                              \n"
"      s = ((guint)(p >> 32)) ^ t ^ k;                                         \n"
"      t = (guint)p;                                                           \n"
"                                                                              \n"
"      k += 0x9e3779b9;                                                        \n"
"    }                                                                         \n"
"                                                                              \n"
"  h[0] = s / 2147483648.0 - 1.0;                                              \n"
"  h[1] = t / 2147483648.0 - 1.0;                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gdouble                                                                \n"
"noise2 (gdouble  x,                                                           \n"
"        gdouble  y,                                                           \n"
"        Context *context)                                                     \n"
"{                                                                             \n"
"  gdouble s, t, n;                                                            \n"
"  gdouble g[3][2], u[3][2];                                                   \n"
"  gint i, j, di, k;                                                           \n"
"                                                                              \n"
"  /* Skew the input point and find the lowest corner of the containing        \n"
"     simplex. */                                                              \n"
"                                                                              \n"
"  s = (x + y) * (sqrt(3) - 1) / 2;                                            \n"
"  i = (gint)floor(x + s);                                                     \n"
"  j = (gint)floor(y + s);                                                     \n"
"                                                                              \n"
"  /* Calculate the (unskewed) distance between the input point and all        \n"
"     simplex corners. */                                                      \n"
"                                                                              \n"
"  s = (i + j) * (3 - sqrt(3)) / 6;                                            \n"
"  u[0][0] = x - i + s;                                                        \n"
"  u[0][1] = y - j + s;                                                        \n"
"                                                                              \n"
"  di = (u[0][0] >= u[0][1]);                                                  \n"
"                                                                              \n"
"  u[1][0] = u[0][0] - di + (3 - sqrt(3)) / 6;                                 \n"
"  u[1][1] = u[0][1] - !di + (3 - sqrt(3)) / 6;                                \n"
"                                                                              \n"
"  u[2][0] = u[0][0] - 1 + (3 - sqrt(3)) / 3;                                  \n"
"  u[2][1] = u[0][1] - 1 + (3 - sqrt(3)) / 3;                                  \n"
"                                                                              \n"
"  /* Calculate gradients for each corner vertex. */                           \n"
"                                                                              \n"
"  philox(i, j, context->seed, g[0]);                                          \n"
"  philox(i + di, j + !di, context->seed, g[1]);                               \n"
"  philox(i + 1, j + 1, context->seed, g[2]);                                  \n"
"                                                                              \n"
"  /* Finally accumulate the contribution of each vertex to the current        \n"
"   * pixel. */                                                                \n"
"                                                                              \n"
"  for (k = 0, n = 0 ; k < 3 ; k += 1)                                         \n"
"    {                                                                         \n"
"      t = 0.5 - dot_2(u[k], u[k]);                                            \n"
"                                                                              \n"
"      if (t > 0)                                                              \n"
"        {                                                                     \n"
"          t *= t;                                                             \n"
"          n += t * t * dot_2(g[k], u[k]);                                     \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  /* Normalize result to lie in [-1, 1]. */                                   \n"
"                                                                              \n"
"  return 70 * n;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"Y float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  return gegl_rectangle_infinite_plane ();                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            cl_mem               out_tex,                                     \n"
"            const GeglRectangle *roi)                                         \n"
"{                                                                             \n"
"  GeglProperties   *o      = GEGL_PROPERTIES (operation);                     \n"
"  const size_t  gbl_size[] = {roi->width, roi->height};                       \n"
"  size_t        work_group_size;                                              \n"
"  cl_uint       cl_iterations   = o->iterations;                              \n"
"  cl_int        cl_err          = 0;                                          \n"
"  cl_int        cl_x_0          = roi->x;                                     \n"
"  cl_int        cl_y_0          = roi->y;                                     \n"
"  cl_float      cl_scale        = o->scale / 50.0;                            \n"
"  cl_uint       cl_seed         = o->seed;                                    \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"kernel_noise\", NULL};                   \n"
"      cl_data = gegl_cl_compile_and_build (noise_simplex_cl_source,           \n"
"                                           kernel_name);                      \n"
"                                                                              \n"
"      if (!cl_data)                                                           \n"
"        return TRUE;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  cl_err = gegl_cl_set_kernel_args (cl_data->kernel[0],                       \n"
"                                    sizeof(cl_mem), &out_tex,                 \n"
"                                    sizeof(cl_int), &cl_x_0,                  \n"
"                                    sizeof(cl_int), &cl_y_0,                  \n"
"                                    sizeof(cl_uint), &cl_iterations,          \n"
"                                    sizeof(cl_float), &cl_scale,              \n"
"                                    sizeof(cl_uint), &cl_seed,                \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clGetKernelWorkGroupInfo (cl_data->kernel[0],                 \n"
"                                          gegl_cl_get_device (),              \n"
"                                          CL_KERNEL_WORK_GROUP_SIZE,          \n"
"                                          sizeof (size_t), &work_group_size,  \n"
"                                          NULL);                              \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        NULL, gbl_size, NULL,                 \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clFinish (gegl_cl_get_command_queue ());                      \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"c_process (GeglOperation       *operation,                                    \n"
"           void                *out_buf,                                      \n"
"           glong                n_pixels,                                     \n"
"           const GeglRectangle *roi,                                          \n"
"           gint                 level)                                        \n"
"{                                                                             \n"
"  gint factor = 1 << level;                                                   \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Context     context;                                                        \n"
"  gfloat     *pixel = out_buf;                                                \n"
"                                                                              \n"
"  gint x = roi->x;                                                            \n"
"  gint y = roi->y;                                                            \n"
"                                                                              \n"
"  context.seed = o->seed;                                                     \n"
"                                                                              \n"
"  while (n_pixels --)                                                         \n"
"  {                                                                           \n"
"    gint    i;                                                                \n"
"    gdouble c, d;                                                             \n"
"                                                                              \n"
"    /* Pile up noise octaves onto the output value. */                        \n"
"                                                                              \n"
"    for (i = 0, c = 1, d = o->scale / 50.0, *pixel = 0;                       \n"
"         i < o->iterations;                                                   \n"
"         c *= 2, d *= 2, i += 1)                                              \n"
"      {                                                                       \n"
"        *pixel += noise2 ((double) (x) * d * factor, (double) (y) * d * factor, &context) / c;\n"
"      }                                                                       \n"
"                                                                              \n"
"    pixel += 1;                                                               \n"
"                                                                              \n"
"    x++;                                                                      \n"
"    if (x>=roi->x + roi->width)                                               \n"
"      {                                                                       \n"
"        x=roi->x;                                                             \n"
"        y++;                                                                  \n"
"      }                                                                       \n"
"  }                                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *out_buf,                                        \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglBufferIterator *iter;                                                   \n"
"  const Babl         *out_format = gegl_operation_get_format (operation,      \n"
"                                                              \"output\");    \n"
"                                                                              \n"
"  g_assert(babl_format_get_n_components (out_format) == 1 &&                  \n"
"           babl_format_get_type (out_format, 0) == babl_type (\"float\"));    \n"
"                                                                              \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    {                                                                         \n"
"      GeglBufferClIterator *cl_iter;                                          \n"
"      gboolean              err;                                              \n"
"                                                                              \n"
"      GEGL_NOTE (GEGL_DEBUG_OPENCL, \"GEGL_OPERATION_POINT_RENDER: %s\", GEGL_OPERATION_GET_CLASS (operation)->name);\n"
"                                                                              \n"
"      cl_iter = gegl_buffer_cl_iterator_new (out_buf, roi, out_format, GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"      while (gegl_buffer_cl_iterator_next (cl_iter, &err) && !err)            \n"
"        {                                                                     \n"
"          err = cl_process (operation, cl_iter->tex[0], cl_iter->roi);        \n"
"                                                                              \n"
"          if (err)                                                            \n"
"            {                                                                 \n"
"              gegl_buffer_cl_iterator_stop (cl_iter);                         \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (err)                                                                \n"
"        GEGL_NOTE (GEGL_DEBUG_OPENCL, \"Error: %s\", GEGL_OPERATION_GET_CLASS (operation)->name);\n"
"      else                                                                    \n"
"        return TRUE;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  iter = gegl_buffer_iterator_new (out_buf, roi, level, out_format,           \n"
"                                   GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);       \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (iter))                                    \n"
"    c_process (operation, iter->data[0], iter->length, &iter->roi[0], level); \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class = GEGL_OPERATION_SOURCE_CLASS (klass);                         \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:simplex-noise\",                           \n"
"    \"title\",              _(\"Simplex Noise\"),                             \n"
"    \"categories\",         \"render\",                                       \n"
"    \"reference-hash\",     \"d6c535d254ebf7cb3213fdb26527f16b\",             \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"description\", _(\"Generates a solid noise texture.\"),                 \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
