static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Authors:   1995 Spencer Kimball and Peter Mattis                           \n"
" *            1999 Thom van Os <thom@vanos.com>                               \n"
" *            2006 Loren Merritt                                              \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (blur_radius, _(\"Blur radius\"), 5.0)                        \n"
"  description(_(\"Radius of square pixel region, (width and height will be radius*2+1).\"))\n"
"  value_range   (1.0, 1000.0)                                                 \n"
"  ui_range      (1.0, 100.0)                                                  \n"
"                                                                              \n"
"property_double (max_delta, _(\"Max. delta\"), 0.2)                           \n"
"  description   (_(\"Maximum delta\"))                                        \n"
"  value_range   (0.0, 1.0)                                                    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_COMPOSER                                                      \n"
"#define GEGL_OP_NAME     gaussian_blur_selective                              \n"
"#define GEGL_OP_C_SOURCE gaussian-blur-selective.c                            \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"R'G'B'A float\");                       \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  format);                  \n"
"  gegl_operation_set_format (operation, \"aux\",    format);                  \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_enlarged_input (GeglOperation       *operation,                           \n"
"                    const GeglRectangle *input_region)                        \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle   rect;                                                       \n"
"                                                                              \n"
"  gint radius  = o->blur_radius;                                              \n"
"  rect.x       = input_region->x - radius;                                    \n"
"  rect.y       = input_region->y - radius;                                    \n"
"  rect.width   = input_region->width  + 2 * radius;                           \n"
"  rect.height  = input_region->height + 2 * radius;                           \n"
"                                                                              \n"
"  return rect;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *region)                         \n"
"{                                                                             \n"
"  GeglRectangle   rect;                                                       \n"
"  GeglRectangle   defined;                                                    \n"
"                                                                              \n"
"  defined = gegl_operation_get_bounding_box (operation);                      \n"
"  gegl_rectangle_intersect (&rect, region, &defined);                         \n"
"                                                                              \n"
"  if (rect.width  != 0 && rect.height != 0)                                   \n"
"    {                                                                         \n"
"      rect = get_enlarged_input (operation, &rect);                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  return rect;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_invalidated_by_change (GeglOperation       *operation,                    \n"
"                           const gchar         *input_pad,                    \n"
"                           const GeglRectangle *input_region)                 \n"
"{                                                                             \n"
"  return get_enlarged_input (operation, input_region);                        \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gblur_selective (GeglBuffer          *input,                                  \n"
"                 const GeglRectangle *src_rect,                               \n"
"                 GeglBuffer          *aux,                                    \n"
"                 GeglBuffer          *output,                                 \n"
"                 const GeglRectangle *dst_rect,                               \n"
"                 gdouble              radius,                                 \n"
"                 gdouble              max_delta)                              \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"R'G'B'A float\");                       \n"
"  gfloat *gauss;                                                              \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *delta_buf;                                                          \n"
"  gfloat *dst_buf;                                                            \n"
"                                                                              \n"
"  gint    x, y, dst_offset;                                                   \n"
"  gint    width = (int) radius * 2 + 1;                                       \n"
"  gint    iradius = radius;                                                   \n"
"  gint    src_width = src_rect->width;                                        \n"
"  gint    src_height = src_rect->height;                                      \n"
"                                                                              \n"
"  gauss   = g_newa (gfloat, width * width);                                   \n"
"  src_buf = g_new (gfloat, src_rect->width * src_rect->height * 4);           \n"
"  dst_buf = g_new (gfloat, dst_rect->width * dst_rect->height * 4);           \n"
"                                                                              \n"
"  if (!aux)                                                                   \n"
"    delta_buf = src_buf;                                                      \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      delta_buf = g_new (gfloat, src_rect->width * src_rect->height * 4);     \n"
"      gegl_buffer_get (aux, src_rect, 1.0, format, delta_buf,                 \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);                \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_get (input, src_rect, 1.0, format, src_buf,                     \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);                    \n"
"                                                                              \n"
"  dst_offset = 0;                                                             \n"
"                                                                              \n"
"#define POW2(a) ((a)*(a))                                                     \n"
"                                                                              \n"
"  for (y = -iradius; y <= iradius; y++)                                       \n"
"    for (x = -iradius; x <= iradius; x++)                                     \n"
"      {                                                                       \n"
"        gauss[x + iradius + (y + iradius) * width] =                          \n"
"            exp(- 0.5 * (POW2(x) + POW2(y)) / radius);                        \n"
"      }                                                                       \n"
"                                                                              \n"
"  for (y = 0; y < dst_rect->height; y++)                                      \n"
"    for (x = 0; x < dst_rect->width; x++)                                     \n"
"      {                                                                       \n"
"        gint u, v, b, src_offset;                                             \n"
"        gfloat *center_src;                                                   \n"
"        gfloat *center_delta;                                                 \n"
"                                                                              \n"
"        gfloat  accumulated[3] = {0.0, };                                     \n"
"        gfloat  count[3] = {0.0, };                                           \n"
"                                                                              \n"
"        src_offset = (x + iradius + (y + iradius) * src_width) * 4;           \n"
"        center_src   = src_buf + src_offset;                                  \n"
"        center_delta = delta_buf + src_offset;                                \n"
"                                                                              \n"
"        for (v = -iradius; v <= iradius; v++)                                 \n"
"          for (u = -iradius; u <= iradius; u++)                               \n"
"            {                                                                 \n"
"              gint i,j;                                                       \n"
"              i = x + radius + u;                                             \n"
"              j = y + radius + v;                                             \n"
"              if (i >= 0 && i < src_width &&                                  \n"
"                  j >= 0 && j < src_height)                                   \n"
"                {                                                             \n"
"                  gfloat *src_pix;                                            \n"
"                  gfloat *delta_pix;                                          \n"
"                  gfloat  diff[3];                                            \n"
"                  gfloat  weight;                                             \n"
"                  gint    offset;                                             \n"
"                                                                              \n"
"                  offset = (i + j * src_width) * 4;                           \n"
"                  src_pix   = src_buf + offset;                               \n"
"                  delta_pix = delta_buf + offset;                             \n"
"                                                                              \n"
"                  weight = gauss[u + iradius + (v + iradius) * width];        \n"
"                  weight *= src_pix[3];                                       \n"
"                                                                              \n"
"                  for (b = 0; b < 3; b++)                                     \n"
"                    {                                                         \n"
"                      diff[b] = center_delta[b] - delta_pix[b];               \n"
"                                                                              \n"
"                      if (diff[b] > max_delta || diff[b] < -max_delta)        \n"
"                        continue;                                             \n"
"                                                                              \n"
"                      accumulated[b] += weight * src_pix[b];                  \n"
"                      count[b] += weight;                                     \n"
"                    }                                                         \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"        for (b = 0; b < 3; b++)                                               \n"
"          {                                                                   \n"
"            if (count[b] != 0.0)                                              \n"
"              dst_buf[dst_offset * 4 + b] = accumulated[b] / count[b];        \n"
"            else                                                              \n"
"              dst_buf[dst_offset * 4 + b] = center_src[b];                    \n"
"          }                                                                   \n"
"                                                                              \n"
"        dst_buf[dst_offset * 4 + 3] = center_src[3];                          \n"
"        dst_offset++;                                                         \n"
"      }                                                                       \n"
"                                                                              \n"
"  gegl_buffer_set (output, dst_rect, 0, format, dst_buf,                      \n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"                                                                              \n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"                                                                              \n"
"  if (aux)                                                                    \n"
"    g_free (delta_buf);                                                       \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"gegl-buffer-cl-iterator.h\"                                        \n"
"                                                                              \n"
"#include \"opencl/gaussian-blur-selective.cl.h\"                              \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_gblur_selective (cl_mem                in,                                 \n"
"                    cl_mem                delta,                              \n"
"                    cl_mem                out,                                \n"
"                    size_t                global_worksize,                    \n"
"                    const GeglRectangle  *roi,                                \n"
"                    gfloat                radius,                             \n"
"                    gfloat                max_delta)                          \n"
"{                                                                             \n"
"  cl_int cl_err = 0;                                                          \n"
"  size_t global_ws[2];                                                        \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = { \"cl_gblur_selective\", NULL };           \n"
"      cl_data = gegl_cl_compile_and_build (gaussian_blur_selective_cl_source, \n"
"                                           kernel_name);                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    return TRUE;                                                              \n"
"                                                                              \n"
"  global_ws[0] = roi->width;                                                  \n"
"  global_ws[1] = roi->height;                                                 \n"
"                                                                              \n"
"  gegl_cl_set_kernel_args (cl_data->kernel[0],                                \n"
"                           sizeof(cl_mem),     &in,                           \n"
"                           sizeof(cl_mem),     &delta,                        \n"
"                           sizeof(cl_mem),     &out,                          \n"
"                           sizeof(cl_float),   &radius,                       \n"
"                           sizeof(cl_float),   &max_delta,                    \n"
"                           NULL);                                             \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        NULL, global_ws, NULL,                \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            GeglBuffer          *input,                                       \n"
"            GeglBuffer          *aux,                                         \n"
"            GeglBuffer          *output,                                      \n"
"            const GeglRectangle *result)                                      \n"
"{                                                                             \n"
"  const Babl *in_format  = gegl_operation_get_format (operation, \"input\");  \n"
"  const Babl *aux_format = gegl_operation_get_format (operation, \"aux\");    \n"
"  const Babl *out_format = gegl_operation_get_format (operation, \"output\"); \n"
"  gint err;                                                                   \n"
"                                                                              \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  GeglBufferClIterator *i = gegl_buffer_cl_iterator_new (output,              \n"
"                                                         result,              \n"
"                                                         out_format,          \n"
"                                                         GEGL_CL_BUFFER_WRITE);\n"
"                                                                              \n"
"  gint radius  = o->blur_radius;                                              \n"
"                                                                              \n"
"  gint read = gegl_buffer_cl_iterator_add_2 (i,                               \n"
"                                             input,                           \n"
"                                             result,                          \n"
"                                             in_format,                       \n"
"                                             GEGL_CL_BUFFER_READ,             \n"
"                                             radius, radius, radius, radius,  \n"
"                                             GEGL_ABYSS_CLAMP);               \n"
"                                                                              \n"
"  gint delta = !aux ?                                                         \n"
"               read :                                                         \n"
"               gegl_buffer_cl_iterator_add_2 (i,                              \n"
"                                              aux,                            \n"
"                                              result,                         \n"
"                                              aux_format,                     \n"
"                                              GEGL_CL_BUFFER_READ,            \n"
"                                              radius, radius, radius, radius, \n"
"                                              GEGL_ABYSS_CLAMP);              \n"
"                                                                              \n"
"  while (gegl_buffer_cl_iterator_next (i, &err))                              \n"
"    {                                                                         \n"
"      if (err)                                                                \n"
"        return FALSE;                                                         \n"
"                                                                              \n"
"      err = cl_gblur_selective(i->tex[read],                                  \n"
"                               i->tex[delta],                                 \n"
"                               i->tex[0],                                     \n"
"                               i->size[0],                                    \n"
"                               &i->roi[0],                                    \n"
"                               o->blur_radius,                                \n"
"                               o->max_delta);                                 \n"
"                                                                              \n"
"      if (err)                                                                \n"
"        return FALSE;                                                         \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *aux,                                            \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gboolean        success;                                                    \n"
"  GeglRectangle   compute;                                                    \n"
"                                                                              \n"
"  compute = get_required_for_output (operation, \"input\", result);           \n"
"                                                                              \n"
"  if (gegl_operation_use_opencl (operation))                                  \n"
"    if (cl_process (operation, input, aux, output, result))                   \n"
"      return TRUE;                                                            \n"
"                                                                              \n"
"  success = gblur_selective (input, &compute,                                 \n"
"                             aux,                                             \n"
"                             output, result,                                  \n"
"                             o->blur_radius, o->max_delta);                   \n"
"  return success;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass         *operation_class;                                \n"
"  GeglOperationComposerClass *composer_class;                                 \n"
"                                                                              \n"
"  operation_class  = GEGL_OPERATION_CLASS (klass);                            \n"
"  composer_class   = GEGL_OPERATION_COMPOSER_CLASS (klass);                   \n"
"                                                                              \n"
"  operation_class->prepare                   = prepare;                       \n"
"  operation_class->get_required_for_output   = get_required_for_output;       \n"
"  operation_class->get_invalidated_by_change = get_invalidated_by_change;     \n"
"  operation_class->opencl_support            = TRUE;                          \n"
"                                                                              \n"
"  composer_class->process = process;                                          \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"   \"name\",        \"gegl:gaussian-blur-selective\",                         \n"
"   \"title\",       _(\"Selective Gaussian Blur\"),                           \n"
"   \"categories\",  \"enhance:noise-reduction\",                              \n"
"   \"reference-hash\", \"5af7851bcc4c6b9276c105fb6a6b6742\",                  \n"
"   \"license\",     \"GPL3+\",                                                \n"
"   \"description\", _(\"Blur neighboring pixels, but only in low-contrast areas\"),\n"
"   NULL);                                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
