static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2003, 2006, 2015 Øyvind Kolås <pippin@gimp.org>                \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"   description (_(\"Path of video file to load\"))                            \n"
"                                                                              \n"
"property_int (frame, _(\"Frame number\"), 0)                                  \n"
"   value_range (0, G_MAXINT)                                                  \n"
"   ui_range (0, 10000)                                                        \n"
"                                                                              \n"
"property_int (frames, _(\"frames\"), 0)                                       \n"
"   description (_(\"Number of frames in video, updates at least when first frame has been decoded.\"))\n"
"   value_range (0, G_MAXINT)                                                  \n"
"   ui_range (0, 10000)                                                        \n"
"                                                                              \n"
"property_int (audio_sample_rate, _(\"audio_sample_rate\"), 0)                 \n"
"property_int (audio_channels, _(\"audio_channels\"), 0)                       \n"
"                                                                              \n"
"property_double (frame_rate, _(\"frame-rate\"), 0)                            \n"
"   description (_(\"Frames per second, permits computing time vs frame\"))    \n"
"   value_range (0, G_MAXINT)                                                  \n"
"   ui_range (0, 10000)                                                        \n"
"                                                                              \n"
"property_string (video_codec, _(\"video-codec\"), \"\")                       \n"
"property_string (audio_codec, _(\"audio-codec\"), \"\")                       \n"
"                                                                              \n"
"property_audio_fragment (audio, _(\"audio\"), 0)                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE ff-load.c                                            \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <errno.h>                                                            \n"
"                                                                              \n"
"#include <libavformat/avformat.h>                                             \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gint             width;                                                     \n"
"  gint             height;                                                    \n"
"  gdouble          fps;                                                       \n"
"                                                                              \n"
"  gchar           *loadedfilename; /* to remember which file is \"cached\"     */\n"
"                                                                              \n"
"  AVFormatContext *audio_fcontext;                                            \n"
"  AVCodec         *audio_codec;                                               \n"
"  int              audio_index;                                               \n"
"  GList           *audio_track;                                               \n"
"  long             audio_cursor_pos;                                          \n"
"  long             audio_pos;                                                 \n"
"  gdouble          prevapts;                                                  \n"
"  glong            a_prevframe;   /* previously decoded a_frame in loadedfile */\n"
"                                                                              \n"
"                                                                              \n"
"  AVFormatContext *video_fcontext;                                            \n"
"  int              video_index;                                               \n"
"  AVStream        *video_stream;                                              \n"
"  AVStream        *audio_stream;                                              \n"
"  AVCodec         *video_codec;                                               \n"
"  AVFrame         *lavc_frame;                                                \n"
"  glong            prevframe;      /* previously decoded frame number */      \n"
"  gdouble          prevpts;        /* timestamp in seconds of last decoded frame */\n"
"                                                                              \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"static void                                                                   \n"
"print_error (const char *filename, int err)                                   \n"
"{                                                                             \n"
"  switch (err)                                                                \n"
"    {                                                                         \n"
"    case AVERROR(EINVAL):                                                     \n"
"      g_warning (\"%s: Incorrect image filename syntax.\\n\"                  \n"
"                 \"Use '%%d' to specify the image number:\\n\"                \n"
"                 \"  for img1.jpg, img2.jpg, ..., use 'img%%d.jpg';\\n\"      \n"
"                 \"  for img001.jpg, img002.jpg, ..., use 'img%%03d.jpg'.\\n\",\n"
"                 filename);                                                   \n"
"      break;                                                                  \n"
"    case AVERROR_INVALIDDATA:                                                 \n"
"      g_warning (\"%s: Error while parsing header or unknown format\\n\", filename);\n"
"      break;                                                                  \n"
"    default:                                                                  \n"
"      g_warning (\"%s: Error while opening file\\n\", filename);              \n"
"      break;                                                                  \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"clear_audio_track (GeglProperties *o)                                         \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"  while (p->audio_track)                                                      \n"
"    {                                                                         \n"
"      g_object_unref (p->audio_track->data);                                  \n"
"      p->audio_track = g_list_remove (p->audio_track, p->audio_track->data);  \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"ff_cleanup (GeglProperties *o)                                                \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"  if (p)                                                                      \n"
"    {                                                                         \n"
"      clear_audio_track (o);                                                  \n"
"      if (p->loadedfilename)                                                  \n"
"        g_free (p->loadedfilename);                                           \n"
"      if (p->video_stream && p->video_stream->codec)                          \n"
"        avcodec_close (p->video_stream->codec);                               \n"
"      if (p->audio_stream && p->audio_stream->codec)                          \n"
"        avcodec_close (p->audio_stream->codec);                               \n"
"      if (p->video_fcontext)                                                  \n"
"        avformat_close_input(&p->video_fcontext);                             \n"
"      if (p->audio_fcontext)                                                  \n"
"        avformat_close_input(&p->audio_fcontext);                             \n"
"      if (p->lavc_frame)                                                      \n"
"        av_free (p->lavc_frame);                                              \n"
"                                                                              \n"
"      p->video_fcontext = NULL;                                               \n"
"      p->audio_fcontext = NULL;                                               \n"
"      p->lavc_frame = NULL;                                                   \n"
"      p->loadedfilename = NULL;                                               \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"init (GeglProperties *o)                                                      \n"
"{                                                                             \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"  static gint av_inited = 0;                                                  \n"
"  if (av_inited == 0)                                                         \n"
"    {                                                                         \n"
"      av_register_all ();                                                     \n"
"      av_inited = 1;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    {                                                                         \n"
"      p = g_new0 (Priv, 1);                                                   \n"
"      o->user_data = (void*) p;                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->width = 320;                                                             \n"
"  p->height = 200;                                                            \n"
"                                                                              \n"
"  clear_audio_track (o);                                                      \n"
"  p->loadedfilename = g_strdup (\"\");                                        \n"
"                                                                              \n"
"  ff_cleanup (o);                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"/* maintain list of audio samples */                                          \n"
"static int                                                                    \n"
"decode_audio (GeglOperation *operation,                                       \n"
"              gdouble        pts1,                                            \n"
"              gdouble        pts2)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"                                                                              \n"
"  pts1 -= 15.0;                                                               \n"
"  if (pts1 < 0.0)pts1 = 0.0;                                                  \n"
"                                                                              \n"
"  /* figure out which frame we should start decoding at */                    \n"
"  //fprintf (stderr, \"%f %f\\n\", p->prevapts, pts2);                        \n"
"  if(0){                                                                      \n"
"  //int64_t seek_target = av_rescale_q ((pts1) * AV_TIME_BASE, AV_TIME_BASE_Q, p->audio_stream->time_base);\n"
"  int64_t seek_target = pts1 * AV_TIME_BASE;                                  \n"
"                                                                              \n"
"#if 0                                                                         \n"
"  clear_audio_track (o);                                                      \n"
"#endif                                                                        \n"
"  p->prevapts = 0.0;                                                          \n"
"                                                                              \n"
"    if (av_seek_frame (p->audio_fcontext, -1, seek_target, (AVSEEK_FLAG_BACKWARD)) < 0)\n"
"      fprintf (stderr, \"audio seek error!\\n\");                             \n"
"  }                                                                           \n"
"                                                                              \n"
"  while (p->prevapts <= pts2)                                                 \n"
"    {                                                                         \n"
"      AVPacket  pkt = {0,};                                                   \n"
"      int       decoded_bytes;                                                \n"
"                                                                              \n"
"      if (av_read_frame (p->audio_fcontext, &pkt) < 0)                        \n"
"         {                                                                    \n"
"           av_free_packet (&pkt);                                             \n"
"           return -1;                                                         \n"
"         }                                                                    \n"
"      if (pkt.stream_index==p->audio_index && p->audio_stream)                \n"
"        {                                                                     \n"
"          static AVFrame frame;                                               \n"
"          int got_frame;                                                      \n"
"                                                                              \n"
"          decoded_bytes = avcodec_decode_audio4(p->audio_stream->codec,       \n"
"                                     &frame, &got_frame, &pkt);               \n"
"                                                                              \n"
"          if (decoded_bytes < 0)                                              \n"
"            {                                                                 \n"
"              fprintf (stderr, \"avcodec_decode_audio4 failed for %s\\n\",    \n"
"                                o->path);                                     \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (got_frame) {                                                    \n"
"            int samples_left = frame.nb_samples;                              \n"
"            int si = 0;                                                       \n"
"                                                                              \n"
"            while (samples_left)                                              \n"
"            {                                                                 \n"
"               int sample_count = samples_left;                               \n"
"               int channels = MIN(p->audio_stream->codec->channels, GEGL_MAX_AUDIO_CHANNELS);\n"
"               GeglAudioFragment *af = gegl_audio_fragment_new (o->audio_sample_rate, channels,\n"
"                          AV_CH_LAYOUT_STEREO, samples_left);                 \n"
"//);                                                                          \n"
"               //af->channels = MIN(p->audio_stream->codec->channels, GEGL_MAX_AUDIO_CHANNELS);\n"
"                                                                              \n"
"               switch (p->audio_stream->codec->sample_fmt)                    \n"
"               {                                                              \n"
"                 case AV_SAMPLE_FMT_FLT:                                      \n"
"                   for (gint i = 0; i < sample_count; i++)                    \n"
"                     for (gint c = 0; c < channels; c++)                      \n"
"                       af->data[c][i] = ((int16_t *)frame.data[0])[(i + si) * channels + c];\n"
"                   break;                                                     \n"
"                 case AV_SAMPLE_FMT_FLTP:                                     \n"
"                   for (gint i = 0; i < sample_count; i++)                    \n"
"                     for (gint c = 0; c < channels; c++)                      \n"
"                       {                                                      \n"
"                         af->data[c][i] = ((float *)frame.data[c])[i + si];   \n"
"                       }                                                      \n"
"                   break;                                                     \n"
"                 case AV_SAMPLE_FMT_S16:                                      \n"
"                   for (gint i = 0; i < sample_count; i++)                    \n"
"                     for (gint c = 0; c < channels; c++)                      \n"
"                       af->data[c][i] = ((int16_t *)frame.data[0])[(i + si) * channels + c] / 32768.0;\n"
"                   break;                                                     \n"
"                 case AV_SAMPLE_FMT_S16P:                                     \n"
"                   for (gint i = 0; i < sample_count; i++)                    \n"
"                     for (gint c = 0; c < channels; c++)                      \n"
"                       af->data[c][i] = ((int16_t *)frame.data[c])[i + si] / 32768.0;\n"
"                   break;                                                     \n"
"                 case AV_SAMPLE_FMT_S32:                                      \n"
"                   for (gint i = 0; i < sample_count; i++)                    \n"
"                     for (gint c = 0; c < channels; c++)                      \n"
"                       af->data[c][i] = ((int32_t *)frame.data[0])[(i + si) * channels + c] / 2147483648.0;\n"
"                  break;                                                      \n"
"                case AV_SAMPLE_FMT_S32P:                                      \n"
"                   for (gint i = 0; i < sample_count; i++)                    \n"
"                    for (gint c = 0; c < channels; c++)                       \n"
"                      af->data[c][i] = ((int32_t *)frame.data[c])[i + si] / 2147483648.0;\n"
"                  break;                                                      \n"
"                default:                                                      \n"
"                  g_warning (\"undealt with sample format\\n\");              \n"
"                }                                                             \n"
"                gegl_audio_fragment_set_sample_count (af, sample_count);      \n"
"                gegl_audio_fragment_set_pos (af, p->audio_pos);               \n"
"                                                                              \n"
"                p->audio_pos += sample_count;                                 \n"
"                p->audio_track = g_list_append (p->audio_track, af);          \n"
"                                                                              \n"
"                samples_left -= sample_count;                                 \n"
"                si += sample_count;                                           \n"
"              }                                                               \n"
"                                                                              \n"
"            p->prevapts = pkt.pts * av_q2d (p->audio_stream->time_base);      \n"
"          }                                                                   \n"
"        }                                                                     \n"
"      av_free_packet (&pkt);                                                  \n"
"    }                                                                         \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static int                                                                    \n"
"decode_frame (GeglOperation *operation,                                       \n"
"              glong          frame)                                           \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"  glong       prevframe = p->prevframe;                                       \n"
"  glong       decodeframe = prevframe;                                        \n"
"                                                                              \n"
"  if (frame < 0)                                                              \n"
"    {                                                                         \n"
"      frame = 0;                                                              \n"
"    }                                                                         \n"
"  else if (frame >= o->frames)                                                \n"
"    {                                                                         \n"
"      frame = o->frames - 1;                                                  \n"
"    }                                                                         \n"
"  if (frame == prevframe)                                                     \n"
"    {                                                                         \n"
"      return 0;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  decodeframe = frame;                                                        \n"
"  if (frame > prevframe + 20 || frame < prevframe )                           \n"
"  {                                                                           \n"
"    int64_t seek_target = av_rescale_q ((frame - 16) / o->frame_rate * AV_TIME_BASE, AV_TIME_BASE_Q, p->video_stream->time_base);\n"
"    if (av_seek_frame (p->video_fcontext, p->video_index, seek_target, (AVSEEK_FLAG_BACKWARD )) < 0)\n"
"      fprintf (stderr, \"video seek error!\\n\");                             \n"
"   else                                                                       \n"
"      avcodec_flush_buffers (p->video_stream->codec);                         \n"
"  }                                                                           \n"
"                                                                              \n"
"  do                                                                          \n"
"    {                                                                         \n"
"      int       got_picture = 0;                                              \n"
"      do                                                                      \n"
"        {                                                                     \n"
"          int       decoded_bytes;                                            \n"
"          AVPacket  pkt = {0,};                                               \n"
"                                                                              \n"
"          do                                                                  \n"
"          {                                                                   \n"
"            av_free_packet (&pkt);                                            \n"
"            if (av_read_frame (p->video_fcontext, &pkt) < 0)                  \n"
"            {                                                                 \n"
"              av_free_packet (&pkt);                                          \n"
"              return -1;                                                      \n"
"            }                                                                 \n"
"          }                                                                   \n"
"          while (pkt.stream_index != p->video_index);                         \n"
"                                                                              \n"
"          decoded_bytes = avcodec_decode_video2 (p->video_stream->codec, p->lavc_frame,\n"
"                                                 &got_picture, &pkt);         \n"
"          if (decoded_bytes < 0)                                              \n"
"            {                                                                 \n"
"              fprintf (stderr, \"avcodec_decode_video failed for %s\\n\",     \n"
"                       o->path);                                              \n"
"              return -1;                                                      \n"
"            }                                                                 \n"
"                                                                              \n"
"          if(got_picture)                                                     \n"
"          {                                                                   \n"
"             p->prevpts = av_frame_get_best_effort_timestamp (p->lavc_frame) * av_q2d (p->video_stream->time_base);\n"
"             decodeframe = roundf (av_frame_get_best_effort_timestamp (p->lavc_frame) * av_q2d (p->video_stream->time_base) * o->frame_rate) - 1;\n"
"          }                                                                   \n"
"                                                                              \n"
"          if (decoded_bytes != pkt.size)                                      \n"
"            fprintf (stderr, \"bytes left!\\n\");                             \n"
"          av_free_packet (&pkt);                                              \n"
"        }                                                                     \n"
"      while (!got_picture);                                                   \n"
"    }                                                                         \n"
"    while (decodeframe < frame);                                              \n"
"                                                                              \n"
"  p->prevframe = frame;                                                       \n"
"  return 0;                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    init (o);                                                                 \n"
"  p = (Priv*)o->user_data;                                                    \n"
"                                                                              \n"
"  g_assert (o->user_data != NULL);                                            \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A u8\"));\n"
"                                                                              \n"
"                                                                              \n"
"  if (!p->loadedfilename ||                                                   \n"
"      strcmp (p->loadedfilename, o->path))                                    \n"
"    {                                                                         \n"
"      gint i;                                                                 \n"
"      gint err;                                                               \n"
"                                                                              \n"
"      ff_cleanup (o);                                                         \n"
"      err = avformat_open_input(&p->video_fcontext, o->path, NULL, 0);        \n"
"      if (err < 0)                                                            \n"
"        {                                                                     \n"
"          print_error (o->path, err);                                         \n"
"        }                                                                     \n"
"      fprintf (stderr, \"[%lu]\\n\", p->video_fcontext->start_time_realtime); \n"
"      err = avformat_find_stream_info (p->video_fcontext, NULL);              \n"
"      if (err < 0)                                                            \n"
"        {                                                                     \n"
"          g_warning (\"ff-load: error finding stream info for %s\", o->path); \n"
"                                                                              \n"
"          return;                                                             \n"
"        }                                                                     \n"
"      err = avformat_open_input(&p->audio_fcontext, o->path, NULL, 0);        \n"
"      if (err < 0)                                                            \n"
"        {                                                                     \n"
"          print_error (o->path, err);                                         \n"
"        }                                                                     \n"
"      err = avformat_find_stream_info (p->audio_fcontext, NULL);              \n"
"      if (err < 0)                                                            \n"
"        {                                                                     \n"
"          g_warning (\"ff-load: error finding stream info for %s\", o->path); \n"
"                                                                              \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      for (i = 0; i< p->video_fcontext->nb_streams; i++)                      \n"
"        {                                                                     \n"
"          AVCodecContext *c = p->video_fcontext->streams[i]->codec;           \n"
"          if (c->codec_type == AVMEDIA_TYPE_VIDEO)                            \n"
"            {                                                                 \n"
"              p->video_stream = p->video_fcontext->streams[i];                \n"
"              p->video_index = i;                                             \n"
"            }                                                                 \n"
"          if (c->codec_type == AVMEDIA_TYPE_AUDIO)                            \n"
"            {                                                                 \n"
"              p->audio_stream = p->audio_fcontext->streams[i];                \n"
"              p->audio_index = i;                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      p->video_codec = avcodec_find_decoder (p->video_stream->codec->codec_id);\n"
"                                                                              \n"
"      if (p->audio_stream)                                                    \n"
"        {                                                                     \n"
"	  p->audio_codec = avcodec_find_decoder (p->audio_stream->codec->codec_id);  \n"
"	  if (p->audio_codec == NULL)                                                \n"
"            g_warning (\"audio codec not found\");                            \n"
"          else                                                                \n"
"	    if (avcodec_open2 (p->audio_stream->codec, p->audio_codec, NULL) < 0)    \n"
"              {                                                               \n"
"                 g_warning (\"error opening codec %s\", p->audio_stream->codec->codec->name);\n"
"              }                                                               \n"
"            else                                                              \n"
"              {                                                               \n"
"                 o->audio_sample_rate = p->audio_stream->codec->sample_rate;  \n"
"                 o->audio_channels = MIN(p->audio_stream->codec->channels, GEGL_MAX_AUDIO_CHANNELS);\n"
"              }                                                               \n"
"        }                                                                     \n"
"                                                                              \n"
"      p->video_stream->codec->err_recognition = AV_EF_IGNORE_ERR | AV_EF_BITSTREAM | AV_EF_BUFFER;\n"
"      p->video_stream->codec->workaround_bugs = FF_BUG_AUTODETECT;            \n"
"                                                                              \n"
"#if 1                                                                         \n"
" //     p->video_stream->codec->error_concealment = 0;                        \n"
"#else                                                                         \n"
"      p->video_stream->codec->error_concealment = FF_EC_DEBLOCK | FF_EC_GUESS_MVS | FF_EC_FAVOR_INTER;\n"
"                                                                              \n"
"#endif                                                                        \n"
"                                                                              \n"
"      p->video_stream->codec->idct_algo = FF_IDCT_SIMPLEAUTO;                 \n"
"                                                                              \n"
"      p->video_stream->codec->thread_count = 0;                               \n"
"      p->video_stream->codec->thread_type = FF_THREAD_SLICE;                  \n"
"      /* XXX: permits slice parallell decode, at expense of h264 compliance of output */\n"
"      p->video_stream->codec->flags2 = AV_CODEC_FLAG2_FAST;                   \n"
"                                                                              \n"
"      if (p->video_codec == NULL)                                             \n"
"          g_warning (\"video codec not found\");                              \n"
"                                                                              \n"
"      if (avcodec_open2 (p->video_stream->codec, p->video_codec, NULL) < 0)   \n"
"        {                                                                     \n"
"          g_warning (\"error opening codec %s\", p->video_stream->codec->codec->name);\n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      p->width = p->video_stream->codec->width;                               \n"
"      p->height = p->video_stream->codec->height;                             \n"
"      p->lavc_frame = av_frame_alloc ();                                      \n"
"                                                                              \n"
"      if (o->video_codec)                                                     \n"
"        g_free (o->video_codec);                                              \n"
"      if (p->video_codec->name)                                               \n"
"        o->video_codec = g_strdup (p->video_codec->name);                     \n"
"      else                                                                    \n"
"        o->video_codec = g_strdup (\"\");                                     \n"
"                                                                              \n"
"      if (o->audio_codec)                                                     \n"
"        g_free (o->audio_codec);                                              \n"
"      if (p->audio_codec && p->audio_codec->name)                             \n"
"        o->audio_codec = g_strdup (p->audio_codec->name);                     \n"
"      else                                                                    \n"
"        o->audio_codec = g_strdup (\"\");                                     \n"
"                                                                              \n"
"      if (p->loadedfilename)                                                  \n"
"        g_free (p->loadedfilename);                                           \n"
"      p->loadedfilename = g_strdup (o->path);                                 \n"
"      p->prevframe = -1;                                                      \n"
"      p->a_prevframe = -1;                                                    \n"
"                                                                              \n"
"      o->frames = p->video_stream->nb_frames;                                 \n"
"      o->frame_rate = av_q2d (av_guess_frame_rate (p->video_fcontext, p->video_stream, NULL));\n"
"      if (!o->frames)                                                         \n"
"      {                                                                       \n"
"        /* this is a guesstimate of frame-count */                            \n"
"	o->frames = p->video_fcontext->duration * o->frame_rate / AV_TIME_BASE;      \n"
"        /* make second guess for things like luxo */                          \n"
"	if (o->frames < 1)                                                           \n"
"          o->frames = 1000;                                                   \n"
"      }                                                                       \n"
"#if 0                                                                         \n"
"      {                                                                       \n"
"        int m ,h;                                                             \n"
"        int s = o->frames / o->frame_rate;                                    \n"
"        m = s / 60;                                                           \n"
"        s -= m * 60;                                                          \n"
"        h = m / 60;                                                           \n"
"        m -= h * 60;                                                          \n"
"        fprintf (stdout, \"duration: %02i:%02i:%02i\\n\", h, m, s);           \n"
"      }                                                                       \n"
"#endif                                                                        \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle result = {0, 0, 320, 200};                                    \n"
"  Priv *p = (Priv*)GEGL_PROPERTIES (operation)->user_data;                    \n"
"  result.width = p->width;                                                    \n"
"  result.height = p->height;                                                  \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static int                                                                    \n"
"samples_per_frame (int    frame,                                              \n"
"                   double frame_rate,                                         \n"
"                   int    sample_rate,                                        \n"
"                   long  *start)                                              \n"
"{                                                                             \n"
"  double osamples;                                                            \n"
"  double samples = 0;                                                         \n"
"  int f = 0;                                                                  \n"
"                                                                              \n"
"  if (fabs(fmod (sample_rate, frame_rate)) < 0.0001)                          \n"
"  {                                                                           \n"
"    *start = (sample_rate / frame_rate) * frame;                              \n"
"    return sample_rate / frame_rate;                                          \n"
"  }                                                                           \n"
"                                                                              \n"
"  for (f = 0; f < frame; f++)                                                 \n"
"  {                                                                           \n"
"    samples += sample_rate / frame_rate;                                      \n"
"  }                                                                           \n"
"  osamples = samples;                                                         \n"
"  samples += sample_rate / frame_rate;                                        \n"
"  (*start) = ceil(osamples);                                                  \n"
"  return ceil(samples)-ceil(osamples);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void get_sample_data (Priv *p, long sample_no, float *left, float *right)\n"
"{                                                                             \n"
"  int to_remove = 0;                                                          \n"
"  GList *l;                                                                   \n"
"  l = p->audio_track;                                                         \n"
"  if (sample_no < 0)                                                          \n"
"    return;                                                                   \n"
"  for (; l; l = l->next)                                                      \n"
"  {                                                                           \n"
"    GeglAudioFragment *af = l->data;                                          \n"
"    int channels = gegl_audio_fragment_get_channels (af);                     \n"
"    int pos = gegl_audio_fragment_get_pos (af);                               \n"
"    int sample_count = gegl_audio_fragment_get_sample_count (af);             \n"
"    if (sample_no > pos + sample_count)                                       \n"
"    {                                                                         \n"
"      to_remove ++;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"    if (pos <= sample_no &&                                                   \n"
"        sample_no < pos + sample_count)                                       \n"
"      {                                                                       \n"
"        int i = sample_no - pos;                                              \n"
"        *left  = af->data[0][i];                                              \n"
"        if (channels == 1)                                                    \n"
"          *right = af->data[0][i];                                            \n"
"        else                                                                  \n"
"          *right = af->data[1][i];                                            \n"
"                                                                              \n"
"	if (to_remove)  /* consuming audiotrack */                                   \n"
"        {                                                                     \n"
"          again:                                                              \n"
"          for (l = p->audio_track; l; l = l->next)                            \n"
"          {                                                                   \n"
"            GeglAudioFragment *af = l->data;                                  \n"
"            int pos = gegl_audio_fragment_get_pos (af);                       \n"
"            int sample_count = gegl_audio_fragment_get_sample_count (af);     \n"
"            if (sample_no > pos + sample_count)                               \n"
"            {                                                                 \n"
"              p->audio_track = g_list_remove (p->audio_track, af);            \n"
"              g_object_unref (af);                                            \n"
"              goto again;                                                     \n"
"            }                                                                 \n"
"          }                                                                   \n"
"        }                                                                     \n"
"        return;                                                               \n"
"      }                                                                       \n"
"  }                                                                           \n"
"  //fprintf (stderr, \"didn't find audio sample\\n\");                        \n"
"  *left  = 0;                                                                 \n"
"  *right = 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"                                                                              \n"
"  {                                                                           \n"
"    if (p->video_fcontext && !decode_frame (operation, o->frame))             \n"
"      {                                                                       \n"
"        guchar *buf;                                                          \n"
"        gint    pxsize = 4;                                                   \n"
"        gint    x,y;                                                          \n"
"                                                                              \n"
"        long sample_start = 0;                                                \n"
"                                                                              \n"
"	if (p->audio_stream && p->audio_stream->codec) // XXX: remove second clause  \n"
"        {                                                                     \n"
"          int sample_count;                                                   \n"
"          gegl_audio_fragment_set_sample_rate (o->audio, p->audio_stream->codec->sample_rate);\n"
"          gegl_audio_fragment_set_channels    (o->audio, 2);                  \n"
"          gegl_audio_fragment_set_channel_layout    (o->audio, GEGL_CH_LAYOUT_STEREO);\n"
"                                                                              \n"
"          sample_count = samples_per_frame (o->frame,                         \n"
"               o->frame_rate, p->audio_stream->codec->sample_rate,            \n"
"               &sample_start);                                                \n"
"          gegl_audio_fragment_set_sample_count (o->audio, sample_count);      \n"
"                                                                              \n"
"	  decode_audio (operation, p->prevpts, p->prevpts + 5.0);                    \n"
"          {                                                                   \n"
"            int i;                                                            \n"
"            for (i = 0; i < sample_count; i++)                                \n"
"            {                                                                 \n"
"              get_sample_data (p, sample_start + i, &o->audio->data[0][i],    \n"
"                                  &o->audio->data[1][i]);                     \n"
"            }                                                                 \n"
"          }                                                                   \n"
"        }                                                                     \n"
"                                                                              \n"
"        buf = g_new (guchar, p->width * p->height * pxsize);                  \n"
"                                                                              \n"
"        for (y=0; y < p->height; y++)                                         \n"
"          {                                                                   \n"
"            guchar       *dst  = buf                    + y     * p->width * 4;\n"
"            const guchar *ysrc = p->lavc_frame->data[0] + y     * p->lavc_frame->linesize[0];\n"
"            const guchar *usrc = p->lavc_frame->data[1] + y / 2 * p->lavc_frame->linesize[1];\n"
"            const guchar *vsrc = p->lavc_frame->data[2] + y / 2 * p->lavc_frame->linesize[2];\n"
"                                                                              \n"
"            for (x=0;x < p->width; x++)                                       \n"
"              {                                                               \n"
"                gint R,G,B;                                                   \n"
"#ifndef byteclamp                                                             \n"
"#define byteclamp(j) j=j<0?0:j>255?255:j                                      \n"
"#endif                                                                        \n"
"#define YUV82RGB8(Y,U,V,R,G,B)do{\\                                           \n"
"                R= ((Y<<15)                 + 37355*(V-128))>>15;\\           \n"
"                G= ((Y<<15) -12911* (U-128) - 19038*(V-128))>>15;\\           \n"
"                B= ((Y<<15) +66454* (U-128)                )>>15;\\           \n"
"                byteclamp(R);\\                                               \n"
"                byteclamp(G);\\                                               \n"
"                byteclamp(B);\\                                               \n"
"              } while(0)                                                      \n"
"              YUV82RGB8 (*ysrc, *usrc, *vsrc, R, G, B);                       \n"
"              *(unsigned int *) dst = R + G * 256 + B * 256 * 256 + 0xff000000;\n"
"              dst  += 4;                                                      \n"
"              usrc += x%2;                                                    \n"
"              vsrc += x%2;                                                    \n"
"              ysrc ++;                                                        \n"
"              }                                                               \n"
"          }                                                                   \n"
"        {                                                                     \n"
"          GeglRectangle extent = {0,0,p->width,p->height};                    \n"
"          gegl_buffer_set (output, &extent, 0, NULL, buf, GEGL_AUTO_ROWSTRIDE);\n"
"        }                                                                     \n"
"        g_free (buf);                                                         \n"
"      }                                                                       \n"
"  }                                                                           \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      Priv *p = (Priv*)o->user_data;                                          \n"
"      ff_cleanup (o);                                                         \n"
"      g_free (p->loadedfilename);                                             \n"
"                                                                              \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:ff-load\",                                       \n"
"    \"title\",        _(\"FFmpeg Frame Loader\"),                             \n"
"    \"categories\"  , \"input:video\",                                        \n"
"    \"description\" , _(\"FFmpeg video frame importer.\"),                    \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
