static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2013 Michael Henning <drawoc@darkrefraction.com>                 \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Target file path.\"))                                      \n"
"                                                                              \n"
"property_int (quality, _(\"Quality\"), 90)                                    \n"
"  description (_(\"WebP compression quality\"))                               \n"
"  value_range (1, 100)                                                        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SINK                                                          \n"
"#define GEGL_OP_C_SOURCE webp-save.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <webp/encode.h>                                                      \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"static int                                                                    \n"
"write_func (const uint8_t* data, size_t data_size, const WebPPicture* const pic)\n"
"{                                                                             \n"
"  FILE* const out = (FILE*) pic->custom_ptr;                                  \n"
"                                                                              \n"
"  if (!data_size) return 1;                                                   \n"
"  return fwrite (data, data_size, 1, out) == 1;                               \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const GeglRectangle *bounds = gegl_buffer_get_extent (input);               \n"
"                                                                              \n"
"  FILE* file;                                                                 \n"
"  int status;                                                                 \n"
"                                                                              \n"
"  WebPConfig config;                                                          \n"
"  WebPPicture pic;                                                            \n"
"                                                                              \n"
"  if (!WebPConfigPreset (&config, WEBP_PRESET_DEFAULT, o->quality))           \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  if (!WebPValidateConfig (&config))                                          \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  if (!WebPPictureInit (&pic))                                                \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  pic.width = bounds->width;                                                  \n"
"  pic.height = bounds->height;                                                \n"
"                                                                              \n"
"  file = fopen (o->path, \"wb\");                                             \n"
"  pic.writer = write_func;                                                    \n"
"  pic.custom_ptr = file;                                                      \n"
"                                                                              \n"
"  {                                                                           \n"
"    gint rowstride = bounds->width * sizeof (char) * 4;                       \n"
"    gpointer temp = g_malloc (rowstride * bounds->height);                    \n"
"                                                                              \n"
"    gegl_buffer_get (input, bounds, 1.0, babl_format (\"R'G'B'A u8\"), temp,  \n"
"                     rowstride, GEGL_ABYSS_NONE);                             \n"
"                                                                              \n"
"    WebPPictureImportRGBA (&pic, temp, rowstride);                            \n"
"                                                                              \n"
"    g_free (temp);                                                            \n"
"  }                                                                           \n"
"                                                                              \n"
"  status = WebPEncode (&config, &pic);                                        \n"
"  WebPPictureFree (&pic);                                                     \n"
"  fclose (file);                                                              \n"
"                                                                              \n"
"  return status ? TRUE : FALSE;                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass     *operation_class;                                    \n"
"  GeglOperationSinkClass *sink_class;                                         \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  sink_class      = GEGL_OPERATION_SINK_CLASS (klass);                        \n"
"                                                                              \n"
"  sink_class->process    = process;                                           \n"
"  sink_class->needs_full = TRUE;                                              \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"  \"name\",        \"gegl:webp-save\",                                        \n"
"  \"title\",       _(\"WebP File Saver\"),                                    \n"
"  \"categories\" , \"output\",                                                \n"
"  \"description\", _(\"WebP image saver.\"),                                  \n"
"   NULL);                                                                     \n"
"                                                                              \n"
"  gegl_extension_handler_register_saver (\".webp\", \"gegl:webp-save\");      \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
