static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright (c) 2010, 2011 Mukund Sivaraman <muks@banu.com>                  \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"  description (_(\"Path of file to load\"))                                   \n"
"property_uri (uri, _(\"URI\"), \"\")                                          \n"
"  description (_(\"URI for file to load\"))                                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE jp2-load.c                                           \n"
"                                                                              \n"
"#include <gegl-op.h>                                                          \n"
"#include <gegl-gio-private.h>                                                 \n"
"#include <jasper/jasper.h>                                                    \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GFile *file;                                                                \n"
"                                                                              \n"
"  jas_image_t *image;                                                         \n"
"                                                                              \n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  gint width;                                                                 \n"
"  gint height;                                                                \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"static void                                                                   \n"
"cleanup(GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES(operation);                             \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"                                                                              \n"
"  if (p != NULL)                                                              \n"
"    {                                                                         \n"
"      if (p->image != NULL)                                                   \n"
"        jas_image_destroy(p->image);                                          \n"
"      p->image = NULL;                                                        \n"
"                                                                              \n"
"      if (p->file != NULL)                                                    \n"
"        g_clear_object(&p->file);                                             \n"
"                                                                              \n"
"      p->width = p->height = 0;                                               \n"
"      p->format = NULL;                                                       \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gssize                                                                 \n"
"read_from_stream(GInputStream *stream,                                        \n"
"                 jas_stream_t *jasper)                                        \n"
"{                                                                             \n"
"  GError *error = NULL;                                                       \n"
"  gchar *buffer;                                                              \n"
"  const gsize size = 4096;                                                    \n"
"  gssize read = -1;                                                           \n"
"                                                                              \n"
"  buffer = g_try_new(gchar, size);                                            \n"
"                                                                              \n"
"  g_assert(buffer != NULL);                                                   \n"
"                                                                              \n"
"  do                                                                          \n"
"    {                                                                         \n"
"      read = g_input_stream_read(G_INPUT_STREAM(stream),                      \n"
"                                 (void *) buffer, size,                       \n"
"                                 NULL, &error);                               \n"
"      if (read < 0)                                                           \n"
"        {                                                                     \n"
"          g_warning(error->message);                                          \n"
"          g_error_free(error);                                                \n"
"          break;                                                              \n"
"        }                                                                     \n"
"      else if (read > 0)                                                      \n"
"        jas_stream_write(jasper, buffer, read);                               \n"
"      else                                                                    \n"
"        jas_stream_rewind(jasper);                                            \n"
"    }                                                                         \n"
"  while (read != 0);                                                          \n"
"                                                                              \n"
"  return read;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"query_jp2(GeglOperation *operation,                                           \n"
"          jas_stream_t *jasper)                                               \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES(operation);                             \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"  gboolean ret;                                                               \n"
"  int image_fmt;                                                              \n"
"  jas_image_t *image;                                                         \n"
"  jas_cmprof_t *output_profile;                                               \n"
"  gint depth;                                                                 \n"
"  int numcmpts;                                                               \n"
"  int i;                                                                      \n"
"  gboolean b;                                                                 \n"
"                                                                              \n"
"  g_return_val_if_fail(jasper != NULL, FALSE);                                \n"
"                                                                              \n"
"  image = NULL;                                                               \n"
"  output_profile = NULL;                                                      \n"
"  ret = FALSE;                                                                \n"
"                                                                              \n"
"  do                                                                          \n"
"    {                                                                         \n"
"      image_fmt = jas_image_getfmt (jasper);                                  \n"
"      if (image_fmt < 0)                                                      \n"
"        {                                                                     \n"
"          g_warning (_(\"Unknown JPEG 2000 image format\"));                  \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      image = jas_image_decode (jasper, image_fmt, NULL);                     \n"
"      if (!image)                                                             \n"
"        {                                                                     \n"
"          g_warning (_(\"Unable to open JPEG 2000 image\"));                  \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      output_profile = jas_cmprof_createfromclrspc (JAS_CLRSPC_SRGB);         \n"
"      if (!output_profile)                                                    \n"
"        {                                                                     \n"
"          g_warning (_(\"Unable to create output color profile\"));           \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      p->image = jas_image_chclrspc (image, output_profile,                   \n"
"                                     JAS_CMXFORM_INTENT_PER);                 \n"
"      if (!p->image)                                                          \n"
"        {                                                                     \n"
"          g_warning (_(\"Unable to convert image to sRGB color space\"));     \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      numcmpts = jas_image_numcmpts (p->image);                               \n"
"      if (numcmpts != 3)                                                      \n"
"        {                                                                     \n"
"          g_warning (_(\"Unsupported non-RGB JPEG 2000 file with \"           \n"
"                       \"%d components\"), numcmpts);                         \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      p->width = jas_image_cmptwidth (p->image, 0);                           \n"
"      p->height = jas_image_cmptheight (p->image, 0);                         \n"
"                                                                              \n"
"      depth = jas_image_cmptprec (p->image, 0);                               \n"
"                                                                              \n"
"      if ((depth != 8) && (depth != 16))                                      \n"
"        {                                                                     \n"
"          g_warning (_(\"Unsupported JPEG 2000 file with depth %d\"), depth); \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      switch (depth)                                                          \n"
"        {                                                                     \n"
"        case 16:                                                              \n"
"          p->format = babl_format(\"R'G'B' u16\");                            \n"
"          break;                                                              \n"
"                                                                              \n"
"        case 8:                                                               \n"
"          p->format = babl_format(\"R'G'B' u8\");                             \n"
"          break;                                                              \n"
"                                                                              \n"
"        default:                                                              \n"
"          g_warning (\"%s: Programmer stupidity error\", G_STRLOC);           \n"
"        }                                                                     \n"
"                                                                              \n"
"      b = FALSE;                                                              \n"
"                                                                              \n"
"      for (i = 1; i < 3; i++)                                                 \n"
"        {                                                                     \n"
"          if ((jas_image_cmptprec (p->image, i) != depth) ||                  \n"
"              (jas_image_cmptwidth (p->image, i) != p->width) ||              \n"
"              (jas_image_cmptheight (p->image, i) != p->height))              \n"
"            {                                                                 \n"
"              g_warning (_(\"Components of JPEG 2000 input don't match\"));   \n"
"              b = TRUE;                                                       \n"
"              break;                                                          \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (b)                                                                  \n"
"        break;                                                                \n"
"                                                                              \n"
"      ret = TRUE;                                                             \n"
"    }                                                                         \n"
"  while (FALSE); /* structured goto */                                        \n"
"                                                                              \n"
"  if (image)                                                                  \n"
"    jas_image_destroy (image);                                                \n"
"                                                                              \n"
"  if (output_profile)                                                         \n"
"    jas_cmprof_destroy (output_profile);                                      \n"
"                                                                              \n"
"  return ret;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES(operation);                             \n"
"  Priv *p = (o->user_data) ? o->user_data : g_new0(Priv, 1);                  \n"
"  static gboolean initialized = FALSE;                                        \n"
"  jas_stream_t *jasper;                                                       \n"
"  GInputStream *stream;                                                       \n"
"  GError *error = NULL;                                                       \n"
"  GFile *file = NULL;                                                         \n"
"                                                                              \n"
"  g_assert(p != NULL);                                                        \n"
"                                                                              \n"
"  if (!initialized)                                                           \n"
"    {                                                                         \n"
"      jas_init ();                                                            \n"
"      initialized = TRUE;                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (p->file != NULL && (o->uri || o->path))                                 \n"
"    {                                                                         \n"
"      if (o->uri && strlen(o->uri) > 0)                                       \n"
"        file = g_file_new_for_uri(o->uri);                                    \n"
"      else if (o->path && strlen(o->path) > 0)                                \n"
"        file = g_file_new_for_path(o->path);                                  \n"
"      if (file != NULL)                                                       \n"
"        {                                                                     \n"
"          if (!g_file_equal(p->file, file))                                   \n"
"            cleanup(operation);                                               \n"
"          g_object_unref(file);                                               \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  o->user_data = (void*) p;                                                   \n"
"                                                                              \n"
"  if (p->image == NULL)                                                       \n"
"    {                                                                         \n"
"      jasper = jas_stream_memopen(NULL, -1);                                  \n"
"      if (jasper == NULL)                                                     \n"
"        {                                                                     \n"
"          g_warning(_(\"could not create a new Jasper stream\"));             \n"
"          cleanup(operation);                                                 \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      stream = gegl_gio_open_input_stream(o->uri, o->path, &p->file, &error); \n"
"      if (stream == NULL)                                                     \n"
"        {                                                                     \n"
"          g_warning(error->message);                                          \n"
"          g_error_free(error);                                                \n"
"          cleanup(operation);                                                 \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (read_from_stream(stream, jasper) < 0)                               \n"
"        {                                                                     \n"
"          if (o->uri != NULL && strlen(o->uri) > 0)                           \n"
"            g_warning(_(\"failed to open JPEG 2000 from %s\"), o->uri);       \n"
"          else                                                                \n"
"            g_warning(_(\"failed to open JPEG 2000 from %s\"), o->path);      \n"
"          g_input_stream_close(G_INPUT_STREAM(stream), NULL, NULL);           \n"
"          jas_stream_close(jasper);                                           \n"
"                                                                              \n"
"          g_object_unref(stream);                                             \n"
"          cleanup(operation);                                                 \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      g_input_stream_close(G_INPUT_STREAM(stream), NULL, NULL);               \n"
"      g_object_unref(stream);                                                 \n"
"                                                                              \n"
"      if (!query_jp2(operation, jasper))                                      \n"
"        {                                                                     \n"
"          g_warning(_(\"could not query JPEG 2000 file\"));                   \n"
"          cleanup(operation);                                                 \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      jas_stream_close(jasper);                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format(operation, \"output\", p->format);                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES(operation);                             \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"  GeglRectangle rect = {0,0,0,0};                                             \n"
"  const Babl *type;                                                           \n"
"  gint depth;                                                                 \n"
"  guchar *data_b;                                                             \n"
"  gushort *data_s;                                                            \n"
"  gboolean ret;                                                               \n"
"  int components[3];                                                          \n"
"  jas_matrix_t *matrices[3] = {NULL, NULL, NULL};                             \n"
"  gint i;                                                                     \n"
"  gint row;                                                                   \n"
"  gboolean b;                                                                 \n"
"                                                                              \n"
"  data_b = NULL;                                                              \n"
"  data_s = NULL;                                                              \n"
"                                                                              \n"
"  depth = 0;                                                                  \n"
"                                                                              \n"
"  type = babl_format_get_type(p->format, 0);                                  \n"
"  if (type == babl_type(\"u8\"))                                              \n"
"    depth = 8;                                                                \n"
"  else if (type == babl_type(\"u16\"))                                        \n"
"    depth = 16;                                                               \n"
"                                                                              \n"
"  ret = FALSE;                                                                \n"
"  b = FALSE;                                                                  \n"
"                                                                              \n"
"  do                                                                          \n"
"    {                                                                         \n"
"      components[0] = jas_image_getcmptbytype                                 \n"
"        (p->image, JAS_IMAGE_CT_COLOR(JAS_IMAGE_CT_RGB_R));                   \n"
"      components[1] = jas_image_getcmptbytype                                 \n"
"        (p->image, JAS_IMAGE_CT_COLOR(JAS_IMAGE_CT_RGB_G));                   \n"
"      components[2] = jas_image_getcmptbytype                                 \n"
"        (p->image, JAS_IMAGE_CT_COLOR(JAS_IMAGE_CT_RGB_B));                   \n"
"                                                                              \n"
"      if ((components[0] < 0) || (components[1] < 0) || (components[2] < 0))  \n"
"        {                                                                     \n"
"          g_warning (_(\"One or more of R, G, B components are missing\"));   \n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (jas_image_cmptsgnd (p->image, components[0]) ||                     \n"
"          jas_image_cmptsgnd (p->image, components[1]) ||                     \n"
"          jas_image_cmptsgnd (p->image, components[2]))                       \n"
"        {                                                                     \n"
"          g_warning (_(\"One or more of R, G, B components have signed data\"));\n"
"          break;                                                              \n"
"        }                                                                     \n"
"                                                                              \n"
"      for (i = 0; i < 3; i++)                                                 \n"
"        matrices[i] = jas_matrix_create(1, p->width);                         \n"
"                                                                              \n"
"      switch (depth)                                                          \n"
"        {                                                                     \n"
"        case 16:                                                              \n"
"          data_s = (gushort *) g_malloc (p->width * 3 * sizeof (gushort));    \n"
"          break;                                                              \n"
"                                                                              \n"
"        case 8:                                                               \n"
"          data_b = (guchar *) g_malloc (p->width * 3 * sizeof (guchar));      \n"
"          break;                                                              \n"
"                                                                              \n"
"        default:                                                              \n"
"          g_warning (\"%s: Programmer stupidity error\", G_STRLOC);           \n"
"          return FALSE;                                                       \n"
"        }                                                                     \n"
"                                                                              \n"
"      for (row = 0; row < p->height; row++)                                   \n"
"        {                                                                     \n"
"          gint plane, col;                                                    \n"
"          jas_seqent_t *jrow[3] = {NULL, NULL, NULL};                         \n"
"                                                                              \n"
"          for (plane = 0; plane < 3; plane++)                                 \n"
"            {                                                                 \n"
"              int r = jas_image_readcmpt (p->image, components[plane], 0, row,\n"
"                                          p->width, 1, matrices[plane]);      \n"
"              if (r)                                                          \n"
"                {                                                             \n"
"                  g_warning (_(\"Error reading row %d component %d\"), row, plane);\n"
"                  b = TRUE;                                                   \n"
"                  break;                                                      \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (b)                                                              \n"
"            break;                                                            \n"
"                                                                              \n"
"          for (plane = 0; plane < 3; plane++)                                 \n"
"            jrow[plane] = jas_matrix_getref (matrices[plane], 0, 0);          \n"
"                                                                              \n"
"          switch (depth)                                                      \n"
"            {                                                                 \n"
"            case 16:                                                          \n"
"              for (col = 0; col < p->width; col++)                            \n"
"                {                                                             \n"
"                  data_s[col * 3]     = (gushort) jrow[0][col];               \n"
"                  data_s[col * 3 + 1] = (gushort) jrow[1][col];               \n"
"                  data_s[col * 3 + 2] = (gushort) jrow[2][col];               \n"
"                }                                                             \n"
"              break;                                                          \n"
"                                                                              \n"
"            case 8:                                                           \n"
"              for (col = 0; col < p->width; col++)                            \n"
"                {                                                             \n"
"                  data_b[col * 3]     = (guchar) jrow[0][col];                \n"
"                  data_b[col * 3 + 1] = (guchar) jrow[1][col];                \n"
"                  data_b[col * 3 + 2] = (guchar) jrow[2][col];                \n"
"                }                                                             \n"
"              break;                                                          \n"
"                                                                              \n"
"            default:                                                          \n"
"              g_warning (\"%s: Programmer stupidity error\", G_STRLOC);       \n"
"              b = TRUE;                                                       \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (b)                                                              \n"
"            break;                                                            \n"
"                                                                              \n"
"          rect.x = 0;                                                         \n"
"          rect.y = row;                                                       \n"
"          rect.width = p->width;                                              \n"
"          rect.height = 1;                                                    \n"
"                                                                              \n"
"          switch (depth)                                                      \n"
"            {                                                                 \n"
"            case 16:                                                          \n"
"              gegl_buffer_set (output, &rect, 0, babl_format (\"R'G'B' u16\"),\n"
"                               data_s, GEGL_AUTO_ROWSTRIDE);                  \n"
"              break;                                                          \n"
"                                                                              \n"
"            case 8:                                                           \n"
"              gegl_buffer_set (output, &rect, 0, babl_format (\"R'G'B' u8\"), \n"
"                               data_b, GEGL_AUTO_ROWSTRIDE);                  \n"
"	      break;                                                                 \n"
"                                                                              \n"
"            default:                                                          \n"
"              g_warning (\"%s: Programmer stupidity error\", G_STRLOC);       \n"
"              b = TRUE;                                                       \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      if (b)                                                                  \n"
"        break;                                                                \n"
"                                                                              \n"
"      ret = TRUE;                                                             \n"
"    }                                                                         \n"
"  while (FALSE); /* structured goto */                                        \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    if (matrices[i])                                                          \n"
"      jas_matrix_destroy (matrices[i]);                                       \n"
"                                                                              \n"
"  if (data_b)                                                                 \n"
"    g_free (data_b);                                                          \n"
"                                                                              \n"
"  if (data_s)                                                                 \n"
"    g_free (data_s);                                                          \n"
"                                                                              \n"
"  return ret;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation * operation)                                  \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES(operation);                             \n"
"  GeglRectangle result = { 0, 0, 0, 0 };                                      \n"
"  Priv *p = (Priv*) o->user_data;                                             \n"
"                                                                              \n"
"  if (p->image != NULL)                                                       \n"
"    {                                                                         \n"
"      result.width = p->width;                                                \n"
"      result.height = p->height;                                              \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize(GObject *object)                                                     \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES(object);                                \n"
"                                                                              \n"
"  if (o->user_data != NULL)                                                   \n"
"    {                                                                         \n"
"      cleanup(GEGL_OPERATION(object));                                        \n"
"      if (o->user_data != NULL)                                               \n"
"        g_free(o->user_data);                                                 \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS(gegl_op_parent_class)->finalize(object);                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:jp2-load\",                                       \n"
"    \"title\",       _(\"JPEG 2000 File Loader\"),                            \n"
"    \"categories\",  \"hidden\",                                              \n"
"    \"description\", _(\"JPEG 2000 image loader using jasper.\"),             \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_extension_handler_register_loader (\".jp2\", \"gegl:jp2-load\");       \n"
"  gegl_extension_handler_register_loader (\".jpx\", \"gegl:jp2-load\");       \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
