static const char* alien_map_cl_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <https://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Copyright 2013 Carlos Zubieta <czubieta.dev@gmail.com>                     \n"
" */                                                                           \n"
"                                                                              \n"
"__kernel void cl_alien_map(__global const float4 *in,                         \n"
"                           __global       float4 *out,                        \n"
"                                          float3 freq,                        \n"
"                                          float3 phaseshift,                  \n"
"                                          int3   keep)                        \n"
"{                                                                             \n"
"  int gid     = get_global_id(0);                                             \n"
"  float4 in_v = in[gid];                                                      \n"
"  float3 unit = (float3) (1.0f, 1.0f, 1.0f);                                  \n"
"  float3 tmp  = 0.5f * (unit                                                  \n"
"                        + sin((2.0f * in_v.xyz - unit) * freq.xyz + phaseshift.xyz));\n"
"  float4 out_v;                                                               \n"
"                                                                              \n"
"  out_v.xyz = keep.xyz ? in_v.xyz : tmp;                                      \n"
"  out_v.w   = in_v.w;                                                         \n"
"  out[gid]  = out_v;                                                          \n"
"}                                                                             \n"
;
