static const char* motion_blur_circular_cl_source =
"float4                                                                        \n"
"get_pixel_color (__global const float4 *in,                                   \n"
"                          const int     rect_width,                           \n"
"                          const int     rect_height,                          \n"
"                          const int     rect_x,                               \n"
"                          const int     rect_y,                               \n"
"                          const int     x,                                    \n"
"                          const int     y)                                    \n"
"{                                                                             \n"
"  const int ix = clamp (x - rect_x, 0, rect_width - 1);                       \n"
"  const int iy = clamp (y - rect_y, 0, rect_height - 1);                      \n"
"  return in[iy * rect_width + ix];                                            \n"
"}                                                                             \n"
"                                                                              \n"
"float4                                                                        \n"
"bilinear_mix (const float4 p00,                                               \n"
"              const float4 p01,                                               \n"
"              const float4 p10,                                               \n"
"              const float4 p11,                                               \n"
"              const float dx,                                                 \n"
"              const float dy)                                                 \n"
"{                                                                             \n"
"  return mix (mix (p00, p10, dy), mix (p01, p11, dy), dx);                    \n"
"}                                                                             \n"
"                                                                              \n"
"float                                                                         \n"
"compute_phi (float xr,                                                        \n"
"             float yr)                                                        \n"
"{                                                                             \n"
"  return atan2 (yr, xr);                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"#define NOMINAL_NUM_IT 100                                                    \n"
"                                                                              \n"
"kernel void                                                                   \n"
"cl_motion_blur_circular (__global const float4 *in,                           \n"
"                         __global       float4 *out,                          \n"
"                                  const int     src_width,                    \n"
"                                  const int     src_height,                   \n"
"                                  const int     src_x,                        \n"
"                                  const int     src_y,                        \n"
"                                  const int     dst_x,                        \n"
"                                  const int     dst_y,                        \n"
"                                  const int     whole_region_width,           \n"
"                                  const int     whole_region_height,          \n"
"                                  const int     whole_region_x,               \n"
"                                  const int     whole_region_y,               \n"
"                                  const float   angle,                        \n"
"                                  const float   center_x,                     \n"
"                                  const float   center_y)                     \n"
"{                                                                             \n"
"  const int gidx = get_global_id(0);                                          \n"
"  const int gidy = get_global_id(1);                                          \n"
"                                                                              \n"
"  const int x = gidx + dst_x;                                                 \n"
"  const int y = gidy + dst_y;                                                 \n"
"                                                                              \n"
"  const float xr = x - center_x;                                              \n"
"  const float yr = y - center_y;                                              \n"
"  const float radius = hypot (xr, yr);                                        \n"
"                                                                              \n"
"  /* This is not the \042real\042 length, a bit shorter */                    \n"
"  const float arc_length = radius * angle * M_SQRT2_F;                        \n"
"                                                                              \n"
"  /* ensure quality with small angles */                                      \n"
"  int n = max ((int)ceil (arc_length), 3);                                    \n"
"                                                                              \n"
"  /* performance concern */                                                   \n"
"  if (n > NOMINAL_NUM_IT)                                                     \n"
"    n = NOMINAL_NUM_IT + (int) sqrt ((float)(n - NOMINAL_NUM_IT));            \n"
"                                                                              \n"
"  const float phi_base = compute_phi (xr, yr);                                \n"
"  const float phi_start = phi_base + angle / 2.0f;                            \n"
"  const float phi_step = angle / (float)n;                                    \n"
"                                                                              \n"
"  float4 sum = (float4)0.0f;                                                  \n"
"  int count = 0;                                                              \n"
"                                                                              \n"
"  /* Iterate over the arc */                                                  \n"
"  for (int i = 0; i < n; i++)                                                 \n"
"    {                                                                         \n"
"      float s_val, c_val;                                                     \n"
"      s_val = sincos (phi_start - i * phi_step, &c_val);                      \n"
"                                                                              \n"
"      const float fx = center_x + radius * c_val;                             \n"
"      const float fy = center_y + radius * s_val;                             \n"
"      const int ix = (int)floor (fx);                                         \n"
"      const int iy = (int)floor (fy);                                         \n"
"                                                                              \n"
"      if (ix >= whole_region_x && ix < whole_region_x + whole_region_width && \n"
"          iy >= whole_region_y && iy < whole_region_y + whole_region_height)  \n"
"        {                                                                     \n"
"          /* do bilinear interpolation to get a nice smooth result */         \n"
"          const float4 p00 = get_pixel_color (                                \n"
"            in, src_width, src_height, src_x, src_y, ix, iy);                 \n"
"          const float4 p01 = get_pixel_color (                                \n"
"            in, src_width, src_height, src_x, src_y, ix + 1, iy);             \n"
"          const float4 p10 = get_pixel_color (                                \n"
"            in, src_width, src_height, src_x, src_y, ix, iy + 1);             \n"
"          const float4 p11 = get_pixel_color (                                \n"
"            in, src_width, src_height, src_x, src_y, ix + 1, iy + 1);         \n"
"          sum += bilinear_mix(p00, p01, p10, p11, fx - ix, fy - iy);          \n"
"          count++;                                                            \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  float4 out_v;                                                               \n"
"  if (count == 0)                                                             \n"
"    out_v = get_pixel_color (in, src_width, src_height, src_x, src_y, x, y);  \n"
"  else                                                                        \n"
"    out_v = sum / (float) count;                                              \n"
"  out[gidy * get_global_size(0) + gidx] = out_v;                              \n"
"}                                                                             \n"
;
